/*
 * s51dude - A Downloader/Uploader for 8051 device programmers
 * Copyright (C) 2008 Lucas Chiesa.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <getopt.h>
#include <libintl.h>

#include "s51dude.h"
#include "usbtiny.h"

void get_params (int argc, char *argv[])
{

	int short_option;
	int option_index;
	
	
	struct option long_options[] = {
		{LC_LONG_VERBOSE,	no_argument,			&verbose_flag, 1},
		{LC_LONG_VERIFY,	no_argument,			&verify_flag, 0},
		{LC_LONG_DRY_RUN,	no_argument,			&dry_run_flag, 1},
		{LC_LONG_DEBUG,		no_argument,			&debug_flag, 1},
		{LC_LONG_DEV,		required_argument,		NULL, LC_DEV},
		{LC_LONG_ERASE,		no_argument,			NULL, LC_ERASE},
		{LC_LONG_HELP,		no_argument,			NULL, LC_HELP},
		{LC_LONG_VERSION,	no_argument,			NULL, LC_VERSION},
		{LC_LONG_UPLOAD,	required_argument,		NULL, LC_UPLOAD},
		{LC_LONG_READ,		required_argument,		NULL, LC_READ},
		{0,0,0,0}
	};

	while (1) {
		short_option = getopt_long (argc, argv, ALLOWED_SHORT_ARGUMENTS, long_options, &option_index);
		
		if(short_option==-1) break;
		
		switch (short_option) {
			case LC_DEV:
				load_dev(optarg);
				break;
			case LC_UPLOAD:
				load_action(UPLOAD, optarg);
				break;
			case LC_READ:
				load_action(READ, optarg);
				break;
			case LC_ERASE:
				load_action(ERASE, optarg);
				break;
			case LC_HELP:
				print_help();
				exit(0);
				break;				
			case LC_VERSION:
				print_version();
				exit(0);
				break;
			case '?':
				exit_nice();
				break;
		}
	}
}

void print_help (void)
{
	printf("%s\n",_("s51dude [options] <target> <action>\n \
	target: --part (-p) <part>\n \
		supported part list:\n \
			s8253\n \
			s8252\n \
			s52\n \
			s53\n \
	action: --upload (-u) <in-file>\n \
		--read (-r) <out-file>\n \
		--erase (-e)\n \
	Options:\n \
		--no-verify: Disable verify.\n \
		--dry-run: Test the action but don't do nothing.\n \
		--verbose: Enable verbose output.\n \
		--debug: Enable debug output.\n \
		--help (-h): This help."));
}

void print_version (void)
{
	printf("%s: %s\n",APPNAME,VERSION_STRING);
}

void load_action (actions modo, char archivo[])
{
	if (options.operation != NAA) {
		print_error(_("You can't do more than one action at the same time!"));
		exit (1);
	}

	options.operation = modo;
	if (archivo)
		options.path=(char *) malloc ((strlen(archivo)+1)*sizeof(char));

	if (archivo && !options.path) {
		print_error (_("ERROR: Not enough memory."));
		exit_nice();
	} else if (options.path)
		strcpy(options.path,archivo);
}
