/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_rap.h"

_PUBLIC_ enum ndr_err_code ndr_push_rap_status(struct ndr_push *ndr, int ndr_flags, enum rap_status r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_status(struct ndr_pull *ndr, int ndr_flags, enum rap_status *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_push_rap_share_info_0(struct ndr_push *ndr, int ndr_flags, const struct rap_share_info_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->share_name, 13));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_share_info_0(struct ndr_pull *ndr, int ndr_flags, struct rap_share_info_0 *r)
{
	uint32_t size_share_name_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		size_share_name_0 = 13;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->share_name, size_share_name_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_share_info_0(struct ndr_print *ndr, const char *name, const struct rap_share_info_0 *r)
{
	ndr_print_struct(ndr, name, "rap_share_info_0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "share_name", r->share_name, 13);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_share_info_1(struct ndr_push *ndr, int ndr_flags, const struct rap_share_info_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->share_name, 13));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->reserved1));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->share_type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->comment));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_share_info_1(struct ndr_pull *ndr, int ndr_flags, struct rap_share_info_1 *r)
{
	uint32_t size_share_name_0 = 0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_share_name_0 = 13;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->share_name, size_share_name_0));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->reserved1));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->share_type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
			if (_ptr_comment) {
				NDR_PULL_ALLOC(ndr, r->comment);
			} else {
				r->comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_share_info_1(struct ndr_print *ndr, const char *name, const struct rap_share_info_1 *r)
{
	ndr_print_struct(ndr, name, "rap_share_info_1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "share_name", r->share_name, 13);
	ndr_print_uint8(ndr, "reserved1", r->reserved1);
	ndr_print_uint16(ndr, "share_type", r->share_type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_share_info_2(struct ndr_push *ndr, int ndr_flags, const struct rap_share_info_2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->share_name, 13));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->reserved1));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->share_type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->perms));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->maximum_users));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->active_users));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->password, 9));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->reserved2));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->comment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->path) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->path));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_share_info_2(struct ndr_pull *ndr, int ndr_flags, struct rap_share_info_2 *r)
{
	uint32_t size_share_name_0 = 0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_path;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t size_password_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_share_name_0 = 13;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->share_name, size_share_name_0));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->reserved1));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->share_type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
			if (_ptr_comment) {
				NDR_PULL_ALLOC(ndr, r->comment);
			} else {
				r->comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->perms));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->maximum_users));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->active_users));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
			if (_ptr_path) {
				NDR_PULL_ALLOC(ndr, r->path);
			} else {
				r->path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		size_password_0 = 9;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->password, size_password_0));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->reserved2));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->path) {
				_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_share_info_2(struct ndr_print *ndr, const char *name, const struct rap_share_info_2 *r)
{
	ndr_print_struct(ndr, name, "rap_share_info_2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "share_name", r->share_name, 13);
	ndr_print_uint8(ndr, "reserved1", r->reserved1);
	ndr_print_uint16(ndr, "share_type", r->share_type);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "perms", r->perms);
	ndr_print_uint16(ndr, "maximum_users", r->maximum_users);
	ndr_print_uint16(ndr, "active_users", r->active_users);
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_array_uint8(ndr, "password", r->password, 9);
	ndr_print_uint8(ndr, "reserved2", r->reserved2);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_share_info(struct ndr_push *ndr, int ndr_flags, const union rap_share_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_rap_share_info_0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_rap_share_info_1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_rap_share_info_2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_push_rap_share_info_1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_rap_share_info_2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_share_info(struct ndr_pull *ndr, int ndr_flags, union rap_share_info *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_rap_share_info_0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_rap_share_info_1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_rap_share_info_2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_pull_rap_share_info_1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_rap_share_info_2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_share_info(struct ndr_print *ndr, const char *name, const union rap_share_info *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_share_info");
	switch (level) {
		case 0:
			ndr_print_rap_share_info_0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_rap_share_info_1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_rap_share_info_2(ndr, "info2", &r->info2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_rap_server_info_0(struct ndr_push *ndr, int ndr_flags, const struct rap_server_info_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->name, 16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_server_info_0(struct ndr_pull *ndr, int ndr_flags, struct rap_server_info_0 *r)
{
	uint32_t size_name_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		size_name_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->name, size_name_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_server_info_0(struct ndr_print *ndr, const char *name, const struct rap_server_info_0 *r)
{
	ndr_print_struct(ndr, name, "rap_server_info_0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "name", r->name, 16);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_server_info_1(struct ndr_push *ndr, int ndr_flags, const struct rap_server_info_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->name, 16));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->version_major));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->version_minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->servertype));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->comment));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_server_info_1(struct ndr_pull *ndr, int ndr_flags, struct rap_server_info_1 *r)
{
	uint32_t size_name_0 = 0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_name_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->name, size_name_0));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->version_major));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->version_minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->servertype));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
			if (_ptr_comment) {
				NDR_PULL_ALLOC(ndr, r->comment);
			} else {
				r->comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_server_info_1(struct ndr_print *ndr, const char *name, const struct rap_server_info_1 *r)
{
	ndr_print_struct(ndr, name, "rap_server_info_1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "name", r->name, 16);
	ndr_print_uint8(ndr, "version_major", r->version_major);
	ndr_print_uint8(ndr, "version_minor", r->version_minor);
	ndr_print_uint32(ndr, "servertype", r->servertype);
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_server_info(struct ndr_push *ndr, int ndr_flags, const union rap_server_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_rap_server_info_0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_rap_server_info_1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_push_rap_server_info_1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_server_info(struct ndr_pull *ndr, int ndr_flags, union rap_server_info *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_rap_server_info_0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_rap_server_info_1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_pull_rap_server_info_1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_server_info(struct ndr_print *ndr, const char *name, const union rap_server_info *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_server_info");
	switch (level) {
		case 0:
			ndr_print_rap_server_info_0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_rap_server_info_1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_PrintJStatusCode(struct ndr_push *ndr, int ndr_flags, enum rap_PrintJStatusCode r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_PrintJStatusCode(struct ndr_pull *ndr, int ndr_flags, enum rap_PrintJStatusCode *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintJStatusCode(struct ndr_print *ndr, const char *name, enum rap_PrintJStatusCode r)
{
	const char *val = NULL;

	switch (r) {
		case PRJ_QS_QUEUED: val = "PRJ_QS_QUEUED"; break;
		case PRJ_QS_PAUSED: val = "PRJ_QS_PAUSED"; break;
		case PRJ_QS_SPOOLING: val = "PRJ_QS_SPOOLING"; break;
		case PRJ_QS_PRINTING: val = "PRJ_QS_PRINTING"; break;
		case PRJ_QS_ERROR: val = "PRJ_QS_ERROR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_rap_PrintJobInfo0(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintJobInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobID));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintJobInfo0(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintJobInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobID));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintJobInfo0(struct ndr_print *ndr, const char *name, const struct rap_PrintJobInfo0 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintJobInfo0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "JobID", r->JobID);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintJobInfo1(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintJobInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobID));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->UserName, 21, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Pad));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->NotifyName, 16, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->DataType, 10, sizeof(uint8_t), CH_DOS));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintParameterString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintParameterStringHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobPosition));
		NDR_CHECK(ndr_push_rap_PrintJStatusCode(ndr, NDR_SCALARS, r->JobStatus));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->JobStatusString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobStatusStringHigh));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->TimeSubmitted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->JobSize));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->JobCommentString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobCommentStringHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintParameterString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintParameterString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobStatusString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->JobStatusString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->JobStatusString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobCommentString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->JobCommentString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->JobCommentString));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintJobInfo1(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintJobInfo1 *r)
{
	uint32_t size_UserName_0 = 0;
	uint32_t size_NotifyName_0 = 0;
	uint32_t size_DataType_0 = 0;
	uint16_t _ptr_PrintParameterString;
	TALLOC_CTX *_mem_save_PrintParameterString_0;
	uint16_t _ptr_JobStatusString;
	TALLOC_CTX *_mem_save_JobStatusString_0;
	uint16_t _ptr_JobCommentString;
	TALLOC_CTX *_mem_save_JobCommentString_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobID));
		size_UserName_0 = 21;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->UserName, size_UserName_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Pad));
		size_NotifyName_0 = 16;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->NotifyName, size_NotifyName_0, sizeof(uint8_t), CH_DOS));
		size_DataType_0 = 10;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->DataType, size_DataType_0, sizeof(uint8_t), CH_DOS));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintParameterString));
			if (_ptr_PrintParameterString) {
				NDR_PULL_ALLOC(ndr, r->PrintParameterString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintParameterString, _ptr_PrintParameterString));
			} else {
				r->PrintParameterString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintParameterStringHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobPosition));
		NDR_CHECK(ndr_pull_rap_PrintJStatusCode(ndr, NDR_SCALARS, &r->JobStatus));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_JobStatusString));
			if (_ptr_JobStatusString) {
				NDR_PULL_ALLOC(ndr, r->JobStatusString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->JobStatusString, _ptr_JobStatusString));
			} else {
				r->JobStatusString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobStatusStringHigh));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->TimeSubmitted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->JobSize));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_JobCommentString));
			if (_ptr_JobCommentString) {
				NDR_PULL_ALLOC(ndr, r->JobCommentString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->JobCommentString, _ptr_JobCommentString));
			} else {
				r->JobCommentString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobCommentStringHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintParameterString));
				_mem_save_PrintParameterString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintParameterString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintParameterString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintParameterString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobStatusString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->JobStatusString));
				_mem_save_JobStatusString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->JobStatusString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->JobStatusString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_JobStatusString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobCommentString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->JobCommentString));
				_mem_save_JobCommentString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->JobCommentString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->JobCommentString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_JobCommentString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintJobInfo1(struct ndr_print *ndr, const char *name, const struct rap_PrintJobInfo1 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintJobInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "JobID", r->JobID);
	ndr_print_string(ndr, "UserName", r->UserName);
	ndr_print_uint8(ndr, "Pad", r->Pad);
	ndr_print_string(ndr, "NotifyName", r->NotifyName);
	ndr_print_string(ndr, "DataType", r->DataType);
	ndr_print_ptr(ndr, "PrintParameterString", r->PrintParameterString);
	ndr->depth++;
	if (r->PrintParameterString) {
		ndr_print_string(ndr, "PrintParameterString", r->PrintParameterString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintParameterStringHigh", r->PrintParameterStringHigh);
	ndr_print_uint16(ndr, "JobPosition", r->JobPosition);
	ndr_print_rap_PrintJStatusCode(ndr, "JobStatus", r->JobStatus);
	ndr_print_ptr(ndr, "JobStatusString", r->JobStatusString);
	ndr->depth++;
	if (r->JobStatusString) {
		ndr_print_string(ndr, "JobStatusString", r->JobStatusString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "JobStatusStringHigh", r->JobStatusStringHigh);
	ndr_print_time_t(ndr, "TimeSubmitted", r->TimeSubmitted);
	ndr_print_uint32(ndr, "JobSize", r->JobSize);
	ndr_print_ptr(ndr, "JobCommentString", r->JobCommentString);
	ndr->depth++;
	if (r->JobCommentString) {
		ndr_print_string(ndr, "JobCommentString", r->JobCommentString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "JobCommentStringHigh", r->JobCommentStringHigh);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintJobInfo2(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintJobInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobID));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Priority));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UserNameHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobPosition));
		NDR_CHECK(ndr_push_rap_PrintJStatusCode(ndr, NDR_SCALARS, r->JobStatus));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->TimeSubmitted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->JobSize));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->JobCommentString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobCommentStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DocumentName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DocumentNameHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->UserName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->UserName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobCommentString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->JobCommentString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->JobCommentString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DocumentName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DocumentName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DocumentName));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintJobInfo2(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintJobInfo2 *r)
{
	uint16_t _ptr_UserName;
	TALLOC_CTX *_mem_save_UserName_0;
	uint16_t _ptr_JobCommentString;
	TALLOC_CTX *_mem_save_JobCommentString_0;
	uint16_t _ptr_DocumentName;
	TALLOC_CTX *_mem_save_DocumentName_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobID));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Priority));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_UserName));
			if (_ptr_UserName) {
				NDR_PULL_ALLOC(ndr, r->UserName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UserName, _ptr_UserName));
			} else {
				r->UserName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UserNameHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobPosition));
		NDR_CHECK(ndr_pull_rap_PrintJStatusCode(ndr, NDR_SCALARS, &r->JobStatus));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->TimeSubmitted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->JobSize));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_JobCommentString));
			if (_ptr_JobCommentString) {
				NDR_PULL_ALLOC(ndr, r->JobCommentString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->JobCommentString, _ptr_JobCommentString));
			} else {
				r->JobCommentString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobCommentStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DocumentName));
			if (_ptr_DocumentName) {
				NDR_PULL_ALLOC(ndr, r->DocumentName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DocumentName, _ptr_DocumentName));
			} else {
				r->DocumentName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DocumentNameHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UserName));
				_mem_save_UserName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->UserName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->UserName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UserName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobCommentString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->JobCommentString));
				_mem_save_JobCommentString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->JobCommentString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->JobCommentString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_JobCommentString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DocumentName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DocumentName));
				_mem_save_DocumentName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DocumentName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DocumentName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DocumentName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintJobInfo2(struct ndr_print *ndr, const char *name, const struct rap_PrintJobInfo2 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintJobInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "JobID", r->JobID);
	ndr_print_uint16(ndr, "Priority", r->Priority);
	ndr_print_ptr(ndr, "UserName", r->UserName);
	ndr->depth++;
	if (r->UserName) {
		ndr_print_string(ndr, "UserName", r->UserName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "UserNameHigh", r->UserNameHigh);
	ndr_print_uint16(ndr, "JobPosition", r->JobPosition);
	ndr_print_rap_PrintJStatusCode(ndr, "JobStatus", r->JobStatus);
	ndr_print_time_t(ndr, "TimeSubmitted", r->TimeSubmitted);
	ndr_print_uint32(ndr, "JobSize", r->JobSize);
	ndr_print_ptr(ndr, "JobCommentString", r->JobCommentString);
	ndr->depth++;
	if (r->JobCommentString) {
		ndr_print_string(ndr, "JobCommentString", r->JobCommentString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "JobCommentStringHigh", r->JobCommentStringHigh);
	ndr_print_ptr(ndr, "DocumentName", r->DocumentName);
	ndr->depth++;
	if (r->DocumentName) {
		ndr_print_string(ndr, "DocumentName", r->DocumentName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "DocumentNameHigh", r->DocumentNameHigh);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintJobInfo3(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintJobInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobID));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Priority));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UserNameHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobPosition));
		NDR_CHECK(ndr_push_rap_PrintJStatusCode(ndr, NDR_SCALARS, r->JobStatus));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->TimeSubmitted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->JobSize));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->JobCommentString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobCommentStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DocumentName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DocumentNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->NotifyName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->NotifyNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DataType));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DataTypeHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintParameterString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintParameterStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->StatusString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->StatusStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->QueueName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->QueueNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintProcessorName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintProcessorNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintProcessorParams));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintProcessorParamsHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DriverName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DriverNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DriverDataOffset));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DriverDataOffsetHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrinterNameOffset));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrinterNameOffsetHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->UserName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->UserName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobCommentString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->JobCommentString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->JobCommentString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DocumentName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DocumentName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DocumentName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->NotifyName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->NotifyName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->NotifyName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DataType) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DataType));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DataType));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintParameterString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintParameterString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->StatusString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->StatusString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->StatusString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->QueueName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->QueueName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->QueueName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintProcessorName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintProcessorName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorParams) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintProcessorParams));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintProcessorParams));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DriverName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DriverName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DriverName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DriverDataOffset) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DriverDataOffset));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DriverDataOffset));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrinterNameOffset) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrinterNameOffset));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrinterNameOffset));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintJobInfo3(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintJobInfo3 *r)
{
	uint16_t _ptr_UserName;
	TALLOC_CTX *_mem_save_UserName_0;
	uint16_t _ptr_JobCommentString;
	TALLOC_CTX *_mem_save_JobCommentString_0;
	uint16_t _ptr_DocumentName;
	TALLOC_CTX *_mem_save_DocumentName_0;
	uint16_t _ptr_NotifyName;
	TALLOC_CTX *_mem_save_NotifyName_0;
	uint16_t _ptr_DataType;
	TALLOC_CTX *_mem_save_DataType_0;
	uint16_t _ptr_PrintParameterString;
	TALLOC_CTX *_mem_save_PrintParameterString_0;
	uint16_t _ptr_StatusString;
	TALLOC_CTX *_mem_save_StatusString_0;
	uint16_t _ptr_QueueName;
	TALLOC_CTX *_mem_save_QueueName_0;
	uint16_t _ptr_PrintProcessorName;
	TALLOC_CTX *_mem_save_PrintProcessorName_0;
	uint16_t _ptr_PrintProcessorParams;
	TALLOC_CTX *_mem_save_PrintProcessorParams_0;
	uint16_t _ptr_DriverName;
	TALLOC_CTX *_mem_save_DriverName_0;
	uint16_t _ptr_DriverDataOffset;
	TALLOC_CTX *_mem_save_DriverDataOffset_0;
	uint16_t _ptr_PrinterNameOffset;
	TALLOC_CTX *_mem_save_PrinterNameOffset_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobID));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Priority));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_UserName));
			if (_ptr_UserName) {
				NDR_PULL_ALLOC(ndr, r->UserName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UserName, _ptr_UserName));
			} else {
				r->UserName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UserNameHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobPosition));
		NDR_CHECK(ndr_pull_rap_PrintJStatusCode(ndr, NDR_SCALARS, &r->JobStatus));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->TimeSubmitted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->JobSize));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_JobCommentString));
			if (_ptr_JobCommentString) {
				NDR_PULL_ALLOC(ndr, r->JobCommentString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->JobCommentString, _ptr_JobCommentString));
			} else {
				r->JobCommentString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobCommentStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DocumentName));
			if (_ptr_DocumentName) {
				NDR_PULL_ALLOC(ndr, r->DocumentName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DocumentName, _ptr_DocumentName));
			} else {
				r->DocumentName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DocumentNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_NotifyName));
			if (_ptr_NotifyName) {
				NDR_PULL_ALLOC(ndr, r->NotifyName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->NotifyName, _ptr_NotifyName));
			} else {
				r->NotifyName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->NotifyNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DataType));
			if (_ptr_DataType) {
				NDR_PULL_ALLOC(ndr, r->DataType);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DataType, _ptr_DataType));
			} else {
				r->DataType = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DataTypeHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintParameterString));
			if (_ptr_PrintParameterString) {
				NDR_PULL_ALLOC(ndr, r->PrintParameterString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintParameterString, _ptr_PrintParameterString));
			} else {
				r->PrintParameterString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintParameterStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_StatusString));
			if (_ptr_StatusString) {
				NDR_PULL_ALLOC(ndr, r->StatusString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->StatusString, _ptr_StatusString));
			} else {
				r->StatusString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->StatusStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_QueueName));
			if (_ptr_QueueName) {
				NDR_PULL_ALLOC(ndr, r->QueueName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->QueueName, _ptr_QueueName));
			} else {
				r->QueueName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->QueueNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintProcessorName));
			if (_ptr_PrintProcessorName) {
				NDR_PULL_ALLOC(ndr, r->PrintProcessorName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintProcessorName, _ptr_PrintProcessorName));
			} else {
				r->PrintProcessorName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintProcessorNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintProcessorParams));
			if (_ptr_PrintProcessorParams) {
				NDR_PULL_ALLOC(ndr, r->PrintProcessorParams);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintProcessorParams, _ptr_PrintProcessorParams));
			} else {
				r->PrintProcessorParams = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintProcessorParamsHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DriverName));
			if (_ptr_DriverName) {
				NDR_PULL_ALLOC(ndr, r->DriverName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DriverName, _ptr_DriverName));
			} else {
				r->DriverName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DriverNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DriverDataOffset));
			if (_ptr_DriverDataOffset) {
				NDR_PULL_ALLOC(ndr, r->DriverDataOffset);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DriverDataOffset, _ptr_DriverDataOffset));
			} else {
				r->DriverDataOffset = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DriverDataOffsetHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrinterNameOffset));
			if (_ptr_PrinterNameOffset) {
				NDR_PULL_ALLOC(ndr, r->PrinterNameOffset);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrinterNameOffset, _ptr_PrinterNameOffset));
			} else {
				r->PrinterNameOffset = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrinterNameOffsetHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UserName));
				_mem_save_UserName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->UserName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->UserName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UserName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->JobCommentString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->JobCommentString));
				_mem_save_JobCommentString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->JobCommentString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->JobCommentString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_JobCommentString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DocumentName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DocumentName));
				_mem_save_DocumentName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DocumentName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DocumentName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DocumentName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->NotifyName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->NotifyName));
				_mem_save_NotifyName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->NotifyName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->NotifyName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NotifyName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DataType) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DataType));
				_mem_save_DataType_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DataType, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DataType));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DataType_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintParameterString));
				_mem_save_PrintParameterString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintParameterString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintParameterString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintParameterString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->StatusString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->StatusString));
				_mem_save_StatusString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->StatusString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->StatusString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_StatusString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->QueueName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->QueueName));
				_mem_save_QueueName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->QueueName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->QueueName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_QueueName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintProcessorName));
				_mem_save_PrintProcessorName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintProcessorName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintProcessorName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintProcessorName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorParams) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintProcessorParams));
				_mem_save_PrintProcessorParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintProcessorParams, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintProcessorParams));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintProcessorParams_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DriverName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DriverName));
				_mem_save_DriverName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DriverName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DriverName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DriverName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DriverDataOffset) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DriverDataOffset));
				_mem_save_DriverDataOffset_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DriverDataOffset, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DriverDataOffset));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DriverDataOffset_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrinterNameOffset) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrinterNameOffset));
				_mem_save_PrinterNameOffset_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrinterNameOffset, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrinterNameOffset));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrinterNameOffset_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintJobInfo3(struct ndr_print *ndr, const char *name, const struct rap_PrintJobInfo3 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintJobInfo3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "JobID", r->JobID);
	ndr_print_uint16(ndr, "Priority", r->Priority);
	ndr_print_ptr(ndr, "UserName", r->UserName);
	ndr->depth++;
	if (r->UserName) {
		ndr_print_string(ndr, "UserName", r->UserName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "UserNameHigh", r->UserNameHigh);
	ndr_print_uint16(ndr, "JobPosition", r->JobPosition);
	ndr_print_rap_PrintJStatusCode(ndr, "JobStatus", r->JobStatus);
	ndr_print_time_t(ndr, "TimeSubmitted", r->TimeSubmitted);
	ndr_print_uint32(ndr, "JobSize", r->JobSize);
	ndr_print_ptr(ndr, "JobCommentString", r->JobCommentString);
	ndr->depth++;
	if (r->JobCommentString) {
		ndr_print_string(ndr, "JobCommentString", r->JobCommentString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "JobCommentStringHigh", r->JobCommentStringHigh);
	ndr_print_ptr(ndr, "DocumentName", r->DocumentName);
	ndr->depth++;
	if (r->DocumentName) {
		ndr_print_string(ndr, "DocumentName", r->DocumentName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "DocumentNameHigh", r->DocumentNameHigh);
	ndr_print_ptr(ndr, "NotifyName", r->NotifyName);
	ndr->depth++;
	if (r->NotifyName) {
		ndr_print_string(ndr, "NotifyName", r->NotifyName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "NotifyNameHigh", r->NotifyNameHigh);
	ndr_print_ptr(ndr, "DataType", r->DataType);
	ndr->depth++;
	if (r->DataType) {
		ndr_print_string(ndr, "DataType", r->DataType);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "DataTypeHigh", r->DataTypeHigh);
	ndr_print_ptr(ndr, "PrintParameterString", r->PrintParameterString);
	ndr->depth++;
	if (r->PrintParameterString) {
		ndr_print_string(ndr, "PrintParameterString", r->PrintParameterString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintParameterStringHigh", r->PrintParameterStringHigh);
	ndr_print_ptr(ndr, "StatusString", r->StatusString);
	ndr->depth++;
	if (r->StatusString) {
		ndr_print_string(ndr, "StatusString", r->StatusString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "StatusStringHigh", r->StatusStringHigh);
	ndr_print_ptr(ndr, "QueueName", r->QueueName);
	ndr->depth++;
	if (r->QueueName) {
		ndr_print_string(ndr, "QueueName", r->QueueName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "QueueNameHigh", r->QueueNameHigh);
	ndr_print_ptr(ndr, "PrintProcessorName", r->PrintProcessorName);
	ndr->depth++;
	if (r->PrintProcessorName) {
		ndr_print_string(ndr, "PrintProcessorName", r->PrintProcessorName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintProcessorNameHigh", r->PrintProcessorNameHigh);
	ndr_print_ptr(ndr, "PrintProcessorParams", r->PrintProcessorParams);
	ndr->depth++;
	if (r->PrintProcessorParams) {
		ndr_print_string(ndr, "PrintProcessorParams", r->PrintProcessorParams);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintProcessorParamsHigh", r->PrintProcessorParamsHigh);
	ndr_print_ptr(ndr, "DriverName", r->DriverName);
	ndr->depth++;
	if (r->DriverName) {
		ndr_print_string(ndr, "DriverName", r->DriverName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "DriverNameHigh", r->DriverNameHigh);
	ndr_print_ptr(ndr, "DriverDataOffset", r->DriverDataOffset);
	ndr->depth++;
	if (r->DriverDataOffset) {
		ndr_print_string(ndr, "DriverDataOffset", r->DriverDataOffset);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "DriverDataOffsetHigh", r->DriverDataOffsetHigh);
	ndr_print_ptr(ndr, "PrinterNameOffset", r->PrinterNameOffset);
	ndr->depth++;
	if (r->PrinterNameOffset) {
		ndr_print_string(ndr, "PrinterNameOffset", r->PrinterNameOffset);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrinterNameOffsetHigh", r->PrinterNameOffsetHigh);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_printj_info(struct ndr_push *ndr, int ndr_flags, const union rap_printj_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_rap_PrintJobInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_rap_PrintJobInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_rap_PrintJobInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_rap_PrintJobInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_push_rap_PrintJobInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_rap_PrintJobInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_rap_PrintJobInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_printj_info(struct ndr_pull *ndr, int ndr_flags, union rap_printj_info *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_rap_PrintJobInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_rap_PrintJobInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_rap_PrintJobInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_rap_PrintJobInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_pull_rap_PrintJobInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_rap_PrintJobInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_rap_PrintJobInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_printj_info(struct ndr_print *ndr, const char *name, const union rap_printj_info *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_printj_info");
	switch (level) {
		case 0:
			ndr_print_rap_PrintJobInfo0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_rap_PrintJobInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_rap_PrintJobInfo2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_rap_PrintJobInfo3(ndr, "info3", &r->info3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_PrintQStatusCode(struct ndr_push *ndr, int ndr_flags, enum rap_PrintQStatusCode r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_PrintQStatusCode(struct ndr_pull *ndr, int ndr_flags, enum rap_PrintQStatusCode *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintQStatusCode(struct ndr_print *ndr, const char *name, enum rap_PrintQStatusCode r)
{
	const char *val = NULL;

	switch (r) {
		case PRQ_ACTIVE: val = "PRQ_ACTIVE"; break;
		case PRQ_PAUSE: val = "PRQ_PAUSE"; break;
		case PRQ_ERROR: val = "PRQ_ERROR"; break;
		case PRQ_PENDING: val = "PRQ_PENDING"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_rap_PrintQueue0(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintQueue0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->PrintQName, 13, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintQueue0(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintQueue0 *r)
{
	uint32_t size_PrintQName_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		size_PrintQName_0 = 13;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->PrintQName, size_PrintQName_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintQueue0(struct ndr_print *ndr, const char *name, const struct rap_PrintQueue0 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintQueue0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "PrintQName", r->PrintQName);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintQueue1(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintQueue1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->PrintQName, 13, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Pad1));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Priority));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->StartTime));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UntilTime));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->SeparatorPageFilename));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->SeparatorPageFilenameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintProcessorDllName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintProcessorDllNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintDestinationsName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintDestinationsNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintParameterString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintParameterStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->CommentString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CommentStringHigh));
		NDR_CHECK(ndr_push_rap_PrintQStatusCode(ndr, NDR_SCALARS, r->PrintQStatus));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintJobCount));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->SeparatorPageFilename) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->SeparatorPageFilename));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->SeparatorPageFilename));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorDllName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintProcessorDllName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintProcessorDllName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintDestinationsName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintDestinationsName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintDestinationsName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintParameterString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintParameterString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->CommentString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->CommentString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->CommentString));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintQueue1(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintQueue1 *r)
{
	uint32_t size_PrintQName_0 = 0;
	uint16_t _ptr_SeparatorPageFilename;
	TALLOC_CTX *_mem_save_SeparatorPageFilename_0;
	uint16_t _ptr_PrintProcessorDllName;
	TALLOC_CTX *_mem_save_PrintProcessorDllName_0;
	uint16_t _ptr_PrintDestinationsName;
	TALLOC_CTX *_mem_save_PrintDestinationsName_0;
	uint16_t _ptr_PrintParameterString;
	TALLOC_CTX *_mem_save_PrintParameterString_0;
	uint16_t _ptr_CommentString;
	TALLOC_CTX *_mem_save_CommentString_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_PrintQName_0 = 13;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->PrintQName, size_PrintQName_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Pad1));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Priority));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->StartTime));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UntilTime));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_SeparatorPageFilename));
			if (_ptr_SeparatorPageFilename) {
				NDR_PULL_ALLOC(ndr, r->SeparatorPageFilename);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->SeparatorPageFilename, _ptr_SeparatorPageFilename));
			} else {
				r->SeparatorPageFilename = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->SeparatorPageFilenameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintProcessorDllName));
			if (_ptr_PrintProcessorDllName) {
				NDR_PULL_ALLOC(ndr, r->PrintProcessorDllName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintProcessorDllName, _ptr_PrintProcessorDllName));
			} else {
				r->PrintProcessorDllName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintProcessorDllNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintDestinationsName));
			if (_ptr_PrintDestinationsName) {
				NDR_PULL_ALLOC(ndr, r->PrintDestinationsName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintDestinationsName, _ptr_PrintDestinationsName));
			} else {
				r->PrintDestinationsName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintDestinationsNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintParameterString));
			if (_ptr_PrintParameterString) {
				NDR_PULL_ALLOC(ndr, r->PrintParameterString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintParameterString, _ptr_PrintParameterString));
			} else {
				r->PrintParameterString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintParameterStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_CommentString));
			if (_ptr_CommentString) {
				NDR_PULL_ALLOC(ndr, r->CommentString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->CommentString, _ptr_CommentString));
			} else {
				r->CommentString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CommentStringHigh));
		NDR_CHECK(ndr_pull_rap_PrintQStatusCode(ndr, NDR_SCALARS, &r->PrintQStatus));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintJobCount));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->SeparatorPageFilename) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->SeparatorPageFilename));
				_mem_save_SeparatorPageFilename_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->SeparatorPageFilename, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->SeparatorPageFilename));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_SeparatorPageFilename_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorDllName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintProcessorDllName));
				_mem_save_PrintProcessorDllName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintProcessorDllName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintProcessorDllName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintProcessorDllName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintDestinationsName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintDestinationsName));
				_mem_save_PrintDestinationsName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintDestinationsName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintDestinationsName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintDestinationsName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintParameterString));
				_mem_save_PrintParameterString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintParameterString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintParameterString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintParameterString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->CommentString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->CommentString));
				_mem_save_CommentString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->CommentString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->CommentString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_CommentString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintQueue1(struct ndr_print *ndr, const char *name, const struct rap_PrintQueue1 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintQueue1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "PrintQName", r->PrintQName);
	ndr_print_uint8(ndr, "Pad1", r->Pad1);
	ndr_print_uint16(ndr, "Priority", r->Priority);
	ndr_print_uint16(ndr, "StartTime", r->StartTime);
	ndr_print_uint16(ndr, "UntilTime", r->UntilTime);
	ndr_print_ptr(ndr, "SeparatorPageFilename", r->SeparatorPageFilename);
	ndr->depth++;
	if (r->SeparatorPageFilename) {
		ndr_print_string(ndr, "SeparatorPageFilename", r->SeparatorPageFilename);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "SeparatorPageFilenameHigh", r->SeparatorPageFilenameHigh);
	ndr_print_ptr(ndr, "PrintProcessorDllName", r->PrintProcessorDllName);
	ndr->depth++;
	if (r->PrintProcessorDllName) {
		ndr_print_string(ndr, "PrintProcessorDllName", r->PrintProcessorDllName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintProcessorDllNameHigh", r->PrintProcessorDllNameHigh);
	ndr_print_ptr(ndr, "PrintDestinationsName", r->PrintDestinationsName);
	ndr->depth++;
	if (r->PrintDestinationsName) {
		ndr_print_string(ndr, "PrintDestinationsName", r->PrintDestinationsName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintDestinationsNameHigh", r->PrintDestinationsNameHigh);
	ndr_print_ptr(ndr, "PrintParameterString", r->PrintParameterString);
	ndr->depth++;
	if (r->PrintParameterString) {
		ndr_print_string(ndr, "PrintParameterString", r->PrintParameterString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintParameterStringHigh", r->PrintParameterStringHigh);
	ndr_print_ptr(ndr, "CommentString", r->CommentString);
	ndr->depth++;
	if (r->CommentString) {
		ndr_print_string(ndr, "CommentString", r->CommentString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CommentStringHigh", r->CommentStringHigh);
	ndr_print_rap_PrintQStatusCode(ndr, "PrintQStatus", r->PrintQStatus);
	ndr_print_uint16(ndr, "PrintJobCount", r->PrintJobCount);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintQueue2(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintQueue2 *r)
{
	uint32_t cntr_job_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_rap_PrintQueue1(ndr, NDR_SCALARS, &r->queue));
		for (cntr_job_0 = 0; cntr_job_0 < r->queue.PrintJobCount; cntr_job_0++) {
			NDR_CHECK(ndr_push_rap_PrintJobInfo1(ndr, NDR_SCALARS, &r->job[cntr_job_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_rap_PrintQueue1(ndr, NDR_BUFFERS, &r->queue));
		for (cntr_job_0 = 0; cntr_job_0 < r->queue.PrintJobCount; cntr_job_0++) {
			NDR_CHECK(ndr_push_rap_PrintJobInfo1(ndr, NDR_BUFFERS, &r->job[cntr_job_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintQueue2(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintQueue2 *r)
{
	uint32_t size_job_0 = 0;
	uint32_t cntr_job_0;
	TALLOC_CTX *_mem_save_job_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_rap_PrintQueue1(ndr, NDR_SCALARS, &r->queue));
		size_job_0 = r->queue.PrintJobCount;
		NDR_PULL_ALLOC_N(ndr, r->job, size_job_0);
		_mem_save_job_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->job, 0);
		for (cntr_job_0 = 0; cntr_job_0 < size_job_0; cntr_job_0++) {
			NDR_CHECK(ndr_pull_rap_PrintJobInfo1(ndr, NDR_SCALARS, &r->job[cntr_job_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_job_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_rap_PrintQueue1(ndr, NDR_BUFFERS, &r->queue));
		size_job_0 = r->queue.PrintJobCount;
		_mem_save_job_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->job, 0);
		for (cntr_job_0 = 0; cntr_job_0 < size_job_0; cntr_job_0++) {
			NDR_CHECK(ndr_pull_rap_PrintJobInfo1(ndr, NDR_BUFFERS, &r->job[cntr_job_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_job_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintQueue2(struct ndr_print *ndr, const char *name, const struct rap_PrintQueue2 *r)
{
	uint32_t cntr_job_0;
	ndr_print_struct(ndr, name, "rap_PrintQueue2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_rap_PrintQueue1(ndr, "queue", &r->queue);
	ndr->print(ndr, "%s: ARRAY(%d)", "job", (int)r->queue.PrintJobCount);
	ndr->depth++;
	for (cntr_job_0=0;cntr_job_0<r->queue.PrintJobCount;cntr_job_0++) {
		ndr_print_rap_PrintJobInfo1(ndr, "job", &r->job[cntr_job_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_PrintQueue3(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintQueue3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintQueueName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintQueueNameHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Priority));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->StartTime));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UntilTime));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Pad));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->SeparatorPageFilename));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->SeparatorPageFilenameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintProcessorDllName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintProcessorDllNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintParameterString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintParameterStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->CommentString));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CommentStringHigh));
		NDR_CHECK(ndr_push_rap_PrintQStatusCode(ndr, NDR_SCALARS, r->PrintQStatus));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintJobCount));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Printers));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintersHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DriverName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DriverNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintDriverData));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintDriverDataHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintQueueName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintQueueName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintQueueName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->SeparatorPageFilename) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->SeparatorPageFilename));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->SeparatorPageFilename));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorDllName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintProcessorDllName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintProcessorDllName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintParameterString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintParameterString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->CommentString) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->CommentString));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->CommentString));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Printers) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Printers));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Printers));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DriverName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DriverName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DriverName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintDriverData) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintDriverData));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintDriverData));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_PrintQueue3(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintQueue3 *r)
{
	uint16_t _ptr_PrintQueueName;
	TALLOC_CTX *_mem_save_PrintQueueName_0;
	uint16_t _ptr_SeparatorPageFilename;
	TALLOC_CTX *_mem_save_SeparatorPageFilename_0;
	uint16_t _ptr_PrintProcessorDllName;
	TALLOC_CTX *_mem_save_PrintProcessorDllName_0;
	uint16_t _ptr_PrintParameterString;
	TALLOC_CTX *_mem_save_PrintParameterString_0;
	uint16_t _ptr_CommentString;
	TALLOC_CTX *_mem_save_CommentString_0;
	uint16_t _ptr_Printers;
	TALLOC_CTX *_mem_save_Printers_0;
	uint16_t _ptr_DriverName;
	TALLOC_CTX *_mem_save_DriverName_0;
	uint16_t _ptr_PrintDriverData;
	TALLOC_CTX *_mem_save_PrintDriverData_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintQueueName));
			if (_ptr_PrintQueueName) {
				NDR_PULL_ALLOC(ndr, r->PrintQueueName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintQueueName, _ptr_PrintQueueName));
			} else {
				r->PrintQueueName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintQueueNameHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Priority));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->StartTime));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UntilTime));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Pad));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_SeparatorPageFilename));
			if (_ptr_SeparatorPageFilename) {
				NDR_PULL_ALLOC(ndr, r->SeparatorPageFilename);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->SeparatorPageFilename, _ptr_SeparatorPageFilename));
			} else {
				r->SeparatorPageFilename = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->SeparatorPageFilenameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintProcessorDllName));
			if (_ptr_PrintProcessorDllName) {
				NDR_PULL_ALLOC(ndr, r->PrintProcessorDllName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintProcessorDllName, _ptr_PrintProcessorDllName));
			} else {
				r->PrintProcessorDllName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintProcessorDllNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintParameterString));
			if (_ptr_PrintParameterString) {
				NDR_PULL_ALLOC(ndr, r->PrintParameterString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintParameterString, _ptr_PrintParameterString));
			} else {
				r->PrintParameterString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintParameterStringHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_CommentString));
			if (_ptr_CommentString) {
				NDR_PULL_ALLOC(ndr, r->CommentString);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->CommentString, _ptr_CommentString));
			} else {
				r->CommentString = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CommentStringHigh));
		NDR_CHECK(ndr_pull_rap_PrintQStatusCode(ndr, NDR_SCALARS, &r->PrintQStatus));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintJobCount));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Printers));
			if (_ptr_Printers) {
				NDR_PULL_ALLOC(ndr, r->Printers);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Printers, _ptr_Printers));
			} else {
				r->Printers = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintersHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DriverName));
			if (_ptr_DriverName) {
				NDR_PULL_ALLOC(ndr, r->DriverName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DriverName, _ptr_DriverName));
			} else {
				r->DriverName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DriverNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintDriverData));
			if (_ptr_PrintDriverData) {
				NDR_PULL_ALLOC(ndr, r->PrintDriverData);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintDriverData, _ptr_PrintDriverData));
			} else {
				r->PrintDriverData = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintDriverDataHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintQueueName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintQueueName));
				_mem_save_PrintQueueName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintQueueName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintQueueName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintQueueName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->SeparatorPageFilename) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->SeparatorPageFilename));
				_mem_save_SeparatorPageFilename_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->SeparatorPageFilename, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->SeparatorPageFilename));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_SeparatorPageFilename_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintProcessorDllName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintProcessorDllName));
				_mem_save_PrintProcessorDllName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintProcessorDllName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintProcessorDllName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintProcessorDllName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintParameterString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintParameterString));
				_mem_save_PrintParameterString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintParameterString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintParameterString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintParameterString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->CommentString) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->CommentString));
				_mem_save_CommentString_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->CommentString, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->CommentString));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_CommentString_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Printers) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Printers));
				_mem_save_Printers_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Printers, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Printers));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Printers_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->DriverName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DriverName));
				_mem_save_DriverName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DriverName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DriverName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DriverName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintDriverData) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintDriverData));
				_mem_save_PrintDriverData_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintDriverData, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintDriverData));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintDriverData_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintQueue3(struct ndr_print *ndr, const char *name, const struct rap_PrintQueue3 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintQueue3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "PrintQueueName", r->PrintQueueName);
	ndr->depth++;
	if (r->PrintQueueName) {
		ndr_print_string(ndr, "PrintQueueName", r->PrintQueueName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintQueueNameHigh", r->PrintQueueNameHigh);
	ndr_print_uint16(ndr, "Priority", r->Priority);
	ndr_print_uint16(ndr, "StartTime", r->StartTime);
	ndr_print_uint16(ndr, "UntilTime", r->UntilTime);
	ndr_print_uint16(ndr, "Pad", r->Pad);
	ndr_print_ptr(ndr, "SeparatorPageFilename", r->SeparatorPageFilename);
	ndr->depth++;
	if (r->SeparatorPageFilename) {
		ndr_print_string(ndr, "SeparatorPageFilename", r->SeparatorPageFilename);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "SeparatorPageFilenameHigh", r->SeparatorPageFilenameHigh);
	ndr_print_ptr(ndr, "PrintProcessorDllName", r->PrintProcessorDllName);
	ndr->depth++;
	if (r->PrintProcessorDllName) {
		ndr_print_string(ndr, "PrintProcessorDllName", r->PrintProcessorDllName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintProcessorDllNameHigh", r->PrintProcessorDllNameHigh);
	ndr_print_ptr(ndr, "PrintParameterString", r->PrintParameterString);
	ndr->depth++;
	if (r->PrintParameterString) {
		ndr_print_string(ndr, "PrintParameterString", r->PrintParameterString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintParameterStringHigh", r->PrintParameterStringHigh);
	ndr_print_ptr(ndr, "CommentString", r->CommentString);
	ndr->depth++;
	if (r->CommentString) {
		ndr_print_string(ndr, "CommentString", r->CommentString);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CommentStringHigh", r->CommentStringHigh);
	ndr_print_rap_PrintQStatusCode(ndr, "PrintQStatus", r->PrintQStatus);
	ndr_print_uint16(ndr, "PrintJobCount", r->PrintJobCount);
	ndr_print_ptr(ndr, "Printers", r->Printers);
	ndr->depth++;
	if (r->Printers) {
		ndr_print_string(ndr, "Printers", r->Printers);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintersHigh", r->PrintersHigh);
	ndr_print_ptr(ndr, "DriverName", r->DriverName);
	ndr->depth++;
	if (r->DriverName) {
		ndr_print_string(ndr, "DriverName", r->DriverName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "DriverNameHigh", r->DriverNameHigh);
	ndr_print_ptr(ndr, "PrintDriverData", r->PrintDriverData);
	ndr->depth++;
	if (r->PrintDriverData) {
		ndr_print_string(ndr, "PrintDriverData", r->PrintDriverData);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintDriverDataHigh", r->PrintDriverDataHigh);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintQueue4(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintQueue4 *r)
{
	uint32_t cntr_job_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_rap_PrintQueue3(ndr, NDR_SCALARS, &r->queue));
		for (cntr_job_0 = 0; cntr_job_0 < r->queue.PrintJobCount; cntr_job_0++) {
			NDR_CHECK(ndr_push_rap_PrintJobInfo2(ndr, NDR_SCALARS, &r->job[cntr_job_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_rap_PrintQueue3(ndr, NDR_BUFFERS, &r->queue));
		for (cntr_job_0 = 0; cntr_job_0 < r->queue.PrintJobCount; cntr_job_0++) {
			NDR_CHECK(ndr_push_rap_PrintJobInfo2(ndr, NDR_BUFFERS, &r->job[cntr_job_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintQueue4(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintQueue4 *r)
{
	uint32_t size_job_0 = 0;
	uint32_t cntr_job_0;
	TALLOC_CTX *_mem_save_job_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_rap_PrintQueue3(ndr, NDR_SCALARS, &r->queue));
		size_job_0 = r->queue.PrintJobCount;
		NDR_PULL_ALLOC_N(ndr, r->job, size_job_0);
		_mem_save_job_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->job, 0);
		for (cntr_job_0 = 0; cntr_job_0 < size_job_0; cntr_job_0++) {
			NDR_CHECK(ndr_pull_rap_PrintJobInfo2(ndr, NDR_SCALARS, &r->job[cntr_job_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_job_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_rap_PrintQueue3(ndr, NDR_BUFFERS, &r->queue));
		size_job_0 = r->queue.PrintJobCount;
		_mem_save_job_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->job, 0);
		for (cntr_job_0 = 0; cntr_job_0 < size_job_0; cntr_job_0++) {
			NDR_CHECK(ndr_pull_rap_PrintJobInfo2(ndr, NDR_BUFFERS, &r->job[cntr_job_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_job_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintQueue4(struct ndr_print *ndr, const char *name, const struct rap_PrintQueue4 *r)
{
	uint32_t cntr_job_0;
	ndr_print_struct(ndr, name, "rap_PrintQueue4");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_rap_PrintQueue3(ndr, "queue", &r->queue);
	ndr->print(ndr, "%s: ARRAY(%d)", "job", (int)r->queue.PrintJobCount);
	ndr->depth++;
	for (cntr_job_0=0;cntr_job_0<r->queue.PrintJobCount;cntr_job_0++) {
		ndr_print_rap_PrintJobInfo2(ndr, "job", &r->job[cntr_job_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintQueue5(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintQueue5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrintQueueName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintQueueNameHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintQueueName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrintQueueName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrintQueueName));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintQueue5(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintQueue5 *r)
{
	uint16_t _ptr_PrintQueueName;
	TALLOC_CTX *_mem_save_PrintQueueName_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrintQueueName));
			if (_ptr_PrintQueueName) {
				NDR_PULL_ALLOC(ndr, r->PrintQueueName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrintQueueName, _ptr_PrintQueueName));
			} else {
				r->PrintQueueName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintQueueNameHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrintQueueName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrintQueueName));
				_mem_save_PrintQueueName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrintQueueName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrintQueueName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrintQueueName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintQueue5(struct ndr_print *ndr, const char *name, const struct rap_PrintQueue5 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintQueue5");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "PrintQueueName", r->PrintQueueName);
	ndr->depth++;
	if (r->PrintQueueName) {
		ndr_print_string(ndr, "PrintQueueName", r->PrintQueueName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintQueueNameHigh", r->PrintQueueNameHigh);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_printq_info(struct ndr_push *ndr, int ndr_flags, const union rap_printq_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_rap_PrintQueue0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_rap_PrintQueue1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_rap_PrintQueue2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_rap_PrintQueue3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_rap_PrintQueue4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_rap_PrintQueue5(ndr, NDR_SCALARS, &r->info5));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_push_rap_PrintQueue1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_rap_PrintQueue2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_rap_PrintQueue3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_push_rap_PrintQueue4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_push_rap_PrintQueue5(ndr, NDR_BUFFERS, &r->info5));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_printq_info(struct ndr_pull *ndr, int ndr_flags, union rap_printq_info *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_rap_PrintQueue0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_rap_PrintQueue1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_rap_PrintQueue2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_rap_PrintQueue3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_rap_PrintQueue4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_rap_PrintQueue5(ndr, NDR_SCALARS, &r->info5));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_pull_rap_PrintQueue1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_rap_PrintQueue2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_rap_PrintQueue3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_pull_rap_PrintQueue4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_pull_rap_PrintQueue5(ndr, NDR_BUFFERS, &r->info5));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_printq_info(struct ndr_print *ndr, const char *name, const union rap_printq_info *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_printq_info");
	switch (level) {
		case 0:
			ndr_print_rap_PrintQueue0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_rap_PrintQueue1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_rap_PrintQueue2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_rap_PrintQueue3(ndr, "info3", &r->info3);
		break;

		case 4:
			ndr_print_rap_PrintQueue4(ndr, "info4", &r->info4);
		break;

		case 5:
			ndr_print_rap_PrintQueue5(ndr, "info5", &r->info5);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_rap_JobInfoParamNum(struct ndr_push *ndr, int ndr_flags, enum rap_JobInfoParamNum r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_JobInfoParamNum(struct ndr_pull *ndr, int ndr_flags, enum rap_JobInfoParamNum *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_JobInfoParamNum(struct ndr_print *ndr, const char *name, enum rap_JobInfoParamNum r)
{
	const char *val = NULL;

	switch (r) {
		case RAP_PARAM_JOBNUM: val = "RAP_PARAM_JOBNUM"; break;
		case RAP_PARAM_USERNAME: val = "RAP_PARAM_USERNAME"; break;
		case RAP_PARAM_NOTIFYNAME: val = "RAP_PARAM_NOTIFYNAME"; break;
		case RAP_PARAM_DATATYPE: val = "RAP_PARAM_DATATYPE"; break;
		case RAP_PARAM_PARAMETERS_STRING: val = "RAP_PARAM_PARAMETERS_STRING"; break;
		case RAP_PARAM_JOBPOSITION: val = "RAP_PARAM_JOBPOSITION"; break;
		case RAP_PARAM_JOBSTATUS: val = "RAP_PARAM_JOBSTATUS"; break;
		case RAP_PARAM_JOBSTATUSSTR: val = "RAP_PARAM_JOBSTATUSSTR"; break;
		case RAP_PARAM_TIMESUBMITTED: val = "RAP_PARAM_TIMESUBMITTED"; break;
		case RAP_PARAM_JOBSIZE: val = "RAP_PARAM_JOBSIZE"; break;
		case RAP_PARAM_JOBCOMMENT: val = "RAP_PARAM_JOBCOMMENT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_rap_JobInfoParam(struct ndr_push *ndr, int ndr_flags, const union rap_JobInfoParam *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case RAP_PARAM_JOBNUM: {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->value));
			break; }

			case RAP_PARAM_USERNAME: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_NOTIFYNAME: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_DATATYPE: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_PARAMETERS_STRING: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_JOBPOSITION: {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->value));
			break; }

			case RAP_PARAM_JOBSTATUS: {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->value));
			break; }

			case RAP_PARAM_JOBSTATUSSTR: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_TIMESUBMITTED: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value4));
			break; }

			case RAP_PARAM_JOBSIZE: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value4));
			break; }

			case RAP_PARAM_JOBCOMMENT: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case RAP_PARAM_JOBNUM:
			break;

			case RAP_PARAM_USERNAME:
			break;

			case RAP_PARAM_NOTIFYNAME:
			break;

			case RAP_PARAM_DATATYPE:
			break;

			case RAP_PARAM_PARAMETERS_STRING:
			break;

			case RAP_PARAM_JOBPOSITION:
			break;

			case RAP_PARAM_JOBSTATUS:
			break;

			case RAP_PARAM_JOBSTATUSSTR:
			break;

			case RAP_PARAM_TIMESUBMITTED:
			break;

			case RAP_PARAM_JOBSIZE:
			break;

			case RAP_PARAM_JOBCOMMENT:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_JobInfoParam(struct ndr_pull *ndr, int ndr_flags, union rap_JobInfoParam *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case RAP_PARAM_JOBNUM: {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->value));
			break; }

			case RAP_PARAM_USERNAME: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_NOTIFYNAME: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_DATATYPE: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_PARAMETERS_STRING: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_JOBPOSITION: {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->value));
			break; }

			case RAP_PARAM_JOBSTATUS: {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->value));
			break; }

			case RAP_PARAM_JOBSTATUSSTR: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case RAP_PARAM_TIMESUBMITTED: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value4));
			break; }

			case RAP_PARAM_JOBSIZE: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value4));
			break; }

			case RAP_PARAM_JOBCOMMENT: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case RAP_PARAM_JOBNUM:
			break;

			case RAP_PARAM_USERNAME:
			break;

			case RAP_PARAM_NOTIFYNAME:
			break;

			case RAP_PARAM_DATATYPE:
			break;

			case RAP_PARAM_PARAMETERS_STRING:
			break;

			case RAP_PARAM_JOBPOSITION:
			break;

			case RAP_PARAM_JOBSTATUS:
			break;

			case RAP_PARAM_JOBSTATUSSTR:
			break;

			case RAP_PARAM_TIMESUBMITTED:
			break;

			case RAP_PARAM_JOBSIZE:
			break;

			case RAP_PARAM_JOBCOMMENT:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_JobInfoParam(struct ndr_print *ndr, const char *name, const union rap_JobInfoParam *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_JobInfoParam");
	switch (level) {
		case RAP_PARAM_JOBNUM:
			ndr_print_uint16(ndr, "value", r->value);
		break;

		case RAP_PARAM_USERNAME:
			ndr_print_string(ndr, "string", r->string);
		break;

		case RAP_PARAM_NOTIFYNAME:
			ndr_print_string(ndr, "string", r->string);
		break;

		case RAP_PARAM_DATATYPE:
			ndr_print_string(ndr, "string", r->string);
		break;

		case RAP_PARAM_PARAMETERS_STRING:
			ndr_print_string(ndr, "string", r->string);
		break;

		case RAP_PARAM_JOBPOSITION:
			ndr_print_uint16(ndr, "value", r->value);
		break;

		case RAP_PARAM_JOBSTATUS:
			ndr_print_uint16(ndr, "value", r->value);
		break;

		case RAP_PARAM_JOBSTATUSSTR:
			ndr_print_string(ndr, "string", r->string);
		break;

		case RAP_PARAM_TIMESUBMITTED:
			ndr_print_uint32(ndr, "value4", r->value4);
		break;

		case RAP_PARAM_JOBSIZE:
			ndr_print_uint32(ndr, "value4", r->value4);
		break;

		case RAP_PARAM_JOBCOMMENT:
			ndr_print_string(ndr, "string", r->string);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_rap_PrintDest0(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintDest0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->PrintDestName, 9, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintDest0(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintDest0 *r)
{
	uint32_t size_PrintDestName_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		size_PrintDestName_0 = 9;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->PrintDestName, size_PrintDestName_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintDest0(struct ndr_print *ndr, const char *name, const struct rap_PrintDest0 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintDest0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "PrintDestName", r->PrintDestName);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintDest1(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintDest1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->PrintDestName, 9, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->UserName, 21, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobId));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Status));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->StatusStringName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintQueueNameHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Time));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->StatusStringName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->StatusStringName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->StatusStringName));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintDest1(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintDest1 *r)
{
	uint32_t size_PrintDestName_0 = 0;
	uint32_t size_UserName_0 = 0;
	uint16_t _ptr_StatusStringName;
	TALLOC_CTX *_mem_save_StatusStringName_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_PrintDestName_0 = 9;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->PrintDestName, size_PrintDestName_0, sizeof(uint8_t), CH_DOS));
		size_UserName_0 = 21;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->UserName, size_UserName_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobId));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Status));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_StatusStringName));
			if (_ptr_StatusStringName) {
				NDR_PULL_ALLOC(ndr, r->StatusStringName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->StatusStringName, _ptr_StatusStringName));
			} else {
				r->StatusStringName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintQueueNameHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Time));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->StatusStringName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->StatusStringName));
				_mem_save_StatusStringName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->StatusStringName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->StatusStringName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_StatusStringName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintDest1(struct ndr_print *ndr, const char *name, const struct rap_PrintDest1 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintDest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "PrintDestName", r->PrintDestName);
	ndr_print_string(ndr, "UserName", r->UserName);
	ndr_print_uint16(ndr, "JobId", r->JobId);
	ndr_print_uint16(ndr, "Status", r->Status);
	ndr_print_ptr(ndr, "StatusStringName", r->StatusStringName);
	ndr->depth++;
	if (r->StatusStringName) {
		ndr_print_string(ndr, "StatusStringName", r->StatusStringName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintQueueNameHigh", r->PrintQueueNameHigh);
	ndr_print_uint16(ndr, "Time", r->Time);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintDest2(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintDest2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrinterName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrinterNameHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrinterName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrinterName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrinterName));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintDest2(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintDest2 *r)
{
	uint16_t _ptr_PrinterName;
	TALLOC_CTX *_mem_save_PrinterName_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrinterName));
			if (_ptr_PrinterName) {
				NDR_PULL_ALLOC(ndr, r->PrinterName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrinterName, _ptr_PrinterName));
			} else {
				r->PrinterName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrinterNameHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrinterName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrinterName));
				_mem_save_PrinterName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrinterName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrinterName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrinterName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintDest2(struct ndr_print *ndr, const char *name, const struct rap_PrintDest2 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintDest2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "PrinterName", r->PrinterName);
	ndr->depth++;
	if (r->PrinterName) {
		ndr_print_string(ndr, "PrinterName", r->PrinterName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrinterNameHigh", r->PrinterNameHigh);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_PrintDest3(struct ndr_push *ndr, int ndr_flags, const struct rap_PrintDest3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->PrinterName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrinterNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UserNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->LogAddr));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->LogAddrHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->JobId));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Status));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->StatusStringName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->PrintQueueNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Drivers));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DriversHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Time));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Pad1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrinterName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->PrinterName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->PrinterName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->UserName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->UserName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->LogAddr) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->LogAddr));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->LogAddr));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->StatusStringName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->StatusStringName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->StatusStringName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Comment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Drivers) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Drivers));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Drivers));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_PrintDest3(struct ndr_pull *ndr, int ndr_flags, struct rap_PrintDest3 *r)
{
	uint16_t _ptr_PrinterName;
	TALLOC_CTX *_mem_save_PrinterName_0;
	uint16_t _ptr_UserName;
	TALLOC_CTX *_mem_save_UserName_0;
	uint16_t _ptr_LogAddr;
	TALLOC_CTX *_mem_save_LogAddr_0;
	uint16_t _ptr_StatusStringName;
	TALLOC_CTX *_mem_save_StatusStringName_0;
	uint16_t _ptr_Comment;
	TALLOC_CTX *_mem_save_Comment_0;
	uint16_t _ptr_Drivers;
	TALLOC_CTX *_mem_save_Drivers_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_PrinterName));
			if (_ptr_PrinterName) {
				NDR_PULL_ALLOC(ndr, r->PrinterName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->PrinterName, _ptr_PrinterName));
			} else {
				r->PrinterName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrinterNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_UserName));
			if (_ptr_UserName) {
				NDR_PULL_ALLOC(ndr, r->UserName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UserName, _ptr_UserName));
			} else {
				r->UserName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UserNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_LogAddr));
			if (_ptr_LogAddr) {
				NDR_PULL_ALLOC(ndr, r->LogAddr);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->LogAddr, _ptr_LogAddr));
			} else {
				r->LogAddr = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->LogAddrHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->JobId));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Status));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_StatusStringName));
			if (_ptr_StatusStringName) {
				NDR_PULL_ALLOC(ndr, r->StatusStringName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->StatusStringName, _ptr_StatusStringName));
			} else {
				r->StatusStringName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->PrintQueueNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Comment));
			if (_ptr_Comment) {
				NDR_PULL_ALLOC(ndr, r->Comment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Comment, _ptr_Comment));
			} else {
				r->Comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Drivers));
			if (_ptr_Drivers) {
				NDR_PULL_ALLOC(ndr, r->Drivers);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Drivers, _ptr_Drivers));
			} else {
				r->Drivers = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DriversHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Time));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Pad1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->PrinterName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->PrinterName));
				_mem_save_PrinterName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->PrinterName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->PrinterName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_PrinterName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UserName));
				_mem_save_UserName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->UserName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->UserName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UserName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->LogAddr) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->LogAddr));
				_mem_save_LogAddr_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->LogAddr, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->LogAddr));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LogAddr_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->StatusStringName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->StatusStringName));
				_mem_save_StatusStringName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->StatusStringName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->StatusStringName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_StatusStringName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Comment));
				_mem_save_Comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Drivers) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Drivers));
				_mem_save_Drivers_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Drivers, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Drivers));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Drivers_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_PrintDest3(struct ndr_print *ndr, const char *name, const struct rap_PrintDest3 *r)
{
	ndr_print_struct(ndr, name, "rap_PrintDest3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "PrinterName", r->PrinterName);
	ndr->depth++;
	if (r->PrinterName) {
		ndr_print_string(ndr, "PrinterName", r->PrinterName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrinterNameHigh", r->PrinterNameHigh);
	ndr_print_ptr(ndr, "UserName", r->UserName);
	ndr->depth++;
	if (r->UserName) {
		ndr_print_string(ndr, "UserName", r->UserName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "UserNameHigh", r->UserNameHigh);
	ndr_print_ptr(ndr, "LogAddr", r->LogAddr);
	ndr->depth++;
	if (r->LogAddr) {
		ndr_print_string(ndr, "LogAddr", r->LogAddr);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "LogAddrHigh", r->LogAddrHigh);
	ndr_print_uint16(ndr, "JobId", r->JobId);
	ndr_print_uint16(ndr, "Status", r->Status);
	ndr_print_ptr(ndr, "StatusStringName", r->StatusStringName);
	ndr->depth++;
	if (r->StatusStringName) {
		ndr_print_string(ndr, "StatusStringName", r->StatusStringName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "PrintQueueNameHigh", r->PrintQueueNameHigh);
	ndr_print_ptr(ndr, "Comment", r->Comment);
	ndr->depth++;
	if (r->Comment) {
		ndr_print_string(ndr, "Comment", r->Comment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CommentHigh", r->CommentHigh);
	ndr_print_ptr(ndr, "Drivers", r->Drivers);
	ndr->depth++;
	if (r->Drivers) {
		ndr_print_string(ndr, "Drivers", r->Drivers);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "DriversHigh", r->DriversHigh);
	ndr_print_uint16(ndr, "Time", r->Time);
	ndr_print_uint16(ndr, "Pad1", r->Pad1);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_printdest_info(struct ndr_push *ndr, int ndr_flags, const union rap_printdest_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_rap_PrintDest0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_rap_PrintDest1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_rap_PrintDest2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_rap_PrintDest3(ndr, NDR_SCALARS, &r->info3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_push_rap_PrintDest1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_rap_PrintDest2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_rap_PrintDest3(ndr, NDR_BUFFERS, &r->info3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_printdest_info(struct ndr_pull *ndr, int ndr_flags, union rap_printdest_info *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_rap_PrintDest0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_rap_PrintDest1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_rap_PrintDest2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_rap_PrintDest3(ndr, NDR_SCALARS, &r->info3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_pull_rap_PrintDest1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_rap_PrintDest2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_rap_PrintDest3(ndr, NDR_BUFFERS, &r->info3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_printdest_info(struct ndr_print *ndr, const char *name, const union rap_printdest_info *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_printdest_info");
	switch (level) {
		case 0:
			ndr_print_rap_PrintDest0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_rap_PrintDest1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_rap_PrintDest2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_rap_PrintDest3(ndr, "info3", &r->info3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_rap_NetUserInfo0(struct ndr_push *ndr, int ndr_flags, const struct rap_NetUserInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, 21, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_NetUserInfo0(struct ndr_pull *ndr, int ndr_flags, struct rap_NetUserInfo0 *r)
{
	uint32_t size_Name_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		size_Name_0 = 21;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, size_Name_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserInfo0(struct ndr_print *ndr, const char *name, const struct rap_NetUserInfo0 *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserInfo0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "Name", r->Name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_UserPriv(struct ndr_push *ndr, int ndr_flags, enum rap_UserPriv r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_UserPriv(struct ndr_pull *ndr, int ndr_flags, enum rap_UserPriv *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_UserPriv(struct ndr_print *ndr, const char *name, enum rap_UserPriv r)
{
	const char *val = NULL;

	switch (r) {
		case USER_PRIV_GUEST: val = "USER_PRIV_GUEST"; break;
		case USER_PRIV_USER: val = "USER_PRIV_USER"; break;
		case USER_PRIV_ADMIN: val = "USER_PRIV_ADMIN"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_rap_NetUserInfo1(struct ndr_push *ndr, int ndr_flags, const struct rap_NetUserInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, 21, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Pad));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Password, 16));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->PasswordAge));
		NDR_CHECK(ndr_push_rap_UserPriv(ndr, NDR_SCALARS, r->Priv));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->HomeDir));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->HomeDirHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CommentHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->ScriptPath));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ScriptPathHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->HomeDir) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->HomeDir));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->HomeDir));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Comment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->ScriptPath) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->ScriptPath));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->ScriptPath));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_NetUserInfo1(struct ndr_pull *ndr, int ndr_flags, struct rap_NetUserInfo1 *r)
{
	uint32_t size_Name_0 = 0;
	uint32_t size_Password_0 = 0;
	uint16_t _ptr_HomeDir;
	TALLOC_CTX *_mem_save_HomeDir_0;
	uint16_t _ptr_Comment;
	TALLOC_CTX *_mem_save_Comment_0;
	uint16_t _ptr_ScriptPath;
	TALLOC_CTX *_mem_save_ScriptPath_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_Name_0 = 21;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, size_Name_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Pad));
		size_Password_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Password, size_Password_0));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->PasswordAge));
		NDR_CHECK(ndr_pull_rap_UserPriv(ndr, NDR_SCALARS, &r->Priv));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_HomeDir));
			if (_ptr_HomeDir) {
				NDR_PULL_ALLOC(ndr, r->HomeDir);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->HomeDir, _ptr_HomeDir));
			} else {
				r->HomeDir = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->HomeDirHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Comment));
			if (_ptr_Comment) {
				NDR_PULL_ALLOC(ndr, r->Comment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Comment, _ptr_Comment));
			} else {
				r->Comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CommentHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_ScriptPath));
			if (_ptr_ScriptPath) {
				NDR_PULL_ALLOC(ndr, r->ScriptPath);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->ScriptPath, _ptr_ScriptPath));
			} else {
				r->ScriptPath = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ScriptPathHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->HomeDir) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->HomeDir));
				_mem_save_HomeDir_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->HomeDir, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->HomeDir));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_HomeDir_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Comment));
				_mem_save_Comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->ScriptPath) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->ScriptPath));
				_mem_save_ScriptPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->ScriptPath, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->ScriptPath));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ScriptPath_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserInfo1(struct ndr_print *ndr, const char *name, const struct rap_NetUserInfo1 *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "Name", r->Name);
	ndr_print_uint8(ndr, "Pad", r->Pad);
	ndr_print_array_uint8(ndr, "Password", r->Password, 16);
	ndr_print_time_t(ndr, "PasswordAge", r->PasswordAge);
	ndr_print_rap_UserPriv(ndr, "Priv", r->Priv);
	ndr_print_ptr(ndr, "HomeDir", r->HomeDir);
	ndr->depth++;
	if (r->HomeDir) {
		ndr_print_string(ndr, "HomeDir", r->HomeDir);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "HomeDirHigh", r->HomeDirHigh);
	ndr_print_ptr(ndr, "Comment", r->Comment);
	ndr->depth++;
	if (r->Comment) {
		ndr_print_string(ndr, "Comment", r->Comment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CommentHigh", r->CommentHigh);
	ndr_print_uint16(ndr, "Flags", r->Flags);
	ndr_print_ptr(ndr, "ScriptPath", r->ScriptPath);
	ndr->depth++;
	if (r->ScriptPath) {
		ndr_print_string(ndr, "ScriptPath", r->ScriptPath);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "ScriptPathHigh", r->ScriptPathHigh);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_AuthFlags(struct ndr_push *ndr, int ndr_flags, enum rap_AuthFlags r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_AuthFlags(struct ndr_pull *ndr, int ndr_flags, enum rap_AuthFlags *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_AuthFlags(struct ndr_print *ndr, const char *name, enum rap_AuthFlags r)
{
	const char *val = NULL;

	switch (r) {
		case AF_OP_PRINT: val = "AF_OP_PRINT"; break;
		case AF_OP_COMM: val = "AF_OP_COMM"; break;
		case AF_OP_SERVER: val = "AF_OP_SERVER"; break;
		case AF_OP_ACCOUNTS: val = "AF_OP_ACCOUNTS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_LogonHours(struct ndr_push *ndr, int ndr_flags, const struct rap_LogonHours *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->LogonHours, 21));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_LogonHours(struct ndr_pull *ndr, int ndr_flags, struct rap_LogonHours *r)
{
	uint32_t size_LogonHours_0 = 0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		size_LogonHours_0 = 21;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->LogonHours, size_LogonHours_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_LogonHours(struct ndr_print *ndr, const char *name, const struct rap_LogonHours *r)
{
	ndr_print_struct(ndr, name, "rap_LogonHours");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "LogonHours", r->LogonHours, 21);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_NetUserInfo2(struct ndr_push *ndr, int ndr_flags, const struct rap_NetUserInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, 21, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Pad));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Password, 16));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->PasswordAge));
		NDR_CHECK(ndr_push_rap_UserPriv(ndr, NDR_SCALARS, r->Priv));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->HomeDir));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->HomeDirHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CommentHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->ScriptPath));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ScriptPathHigh));
		NDR_CHECK(ndr_push_rap_AuthFlags(ndr, NDR_SCALARS, r->AuthFlags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->FullName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->FullNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->UsrComment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UsrCommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->pParms));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->pParmsHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->WorkStations));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->WorkStationsHigh));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->LastLogon));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->LastLogOff));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->AcctExpires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MaxStorage));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UnitsPerWeek));
		NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->LogonHours));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->LogonHoursHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->BadPwCount));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->NumLogons));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->LogonServer));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->LogonServerHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CountryCode));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CodePage));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->HomeDir) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->HomeDir));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->HomeDir));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Comment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->ScriptPath) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->ScriptPath));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->ScriptPath));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->FullName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->FullName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->FullName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UsrComment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->UsrComment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->UsrComment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->pParms) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->pParms));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->pParms));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->WorkStations) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->WorkStations));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->WorkStations));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->LogonHours) {
			NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->LogonHours));
			NDR_CHECK(ndr_push_rap_LogonHours(ndr, NDR_SCALARS, r->LogonHours));
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->LogonServer) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->LogonServer));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->LogonServer));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_NetUserInfo2(struct ndr_pull *ndr, int ndr_flags, struct rap_NetUserInfo2 *r)
{
	uint32_t size_Name_0 = 0;
	uint32_t size_Password_0 = 0;
	uint16_t _ptr_HomeDir;
	TALLOC_CTX *_mem_save_HomeDir_0;
	uint16_t _ptr_Comment;
	TALLOC_CTX *_mem_save_Comment_0;
	uint16_t _ptr_ScriptPath;
	TALLOC_CTX *_mem_save_ScriptPath_0;
	uint16_t _ptr_FullName;
	TALLOC_CTX *_mem_save_FullName_0;
	uint16_t _ptr_UsrComment;
	TALLOC_CTX *_mem_save_UsrComment_0;
	uint16_t _ptr_pParms;
	TALLOC_CTX *_mem_save_pParms_0;
	uint16_t _ptr_WorkStations;
	TALLOC_CTX *_mem_save_WorkStations_0;
	uint16_t _ptr_LogonHours;
	TALLOC_CTX *_mem_save_LogonHours_0;
	uint16_t _ptr_LogonServer;
	TALLOC_CTX *_mem_save_LogonServer_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_Name_0 = 21;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, size_Name_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Pad));
		size_Password_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Password, size_Password_0));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->PasswordAge));
		NDR_CHECK(ndr_pull_rap_UserPriv(ndr, NDR_SCALARS, &r->Priv));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_HomeDir));
			if (_ptr_HomeDir) {
				NDR_PULL_ALLOC(ndr, r->HomeDir);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->HomeDir, _ptr_HomeDir));
			} else {
				r->HomeDir = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->HomeDirHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Comment));
			if (_ptr_Comment) {
				NDR_PULL_ALLOC(ndr, r->Comment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Comment, _ptr_Comment));
			} else {
				r->Comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CommentHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_ScriptPath));
			if (_ptr_ScriptPath) {
				NDR_PULL_ALLOC(ndr, r->ScriptPath);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->ScriptPath, _ptr_ScriptPath));
			} else {
				r->ScriptPath = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ScriptPathHigh));
		NDR_CHECK(ndr_pull_rap_AuthFlags(ndr, NDR_SCALARS, &r->AuthFlags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_FullName));
			if (_ptr_FullName) {
				NDR_PULL_ALLOC(ndr, r->FullName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->FullName, _ptr_FullName));
			} else {
				r->FullName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->FullNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_UsrComment));
			if (_ptr_UsrComment) {
				NDR_PULL_ALLOC(ndr, r->UsrComment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UsrComment, _ptr_UsrComment));
			} else {
				r->UsrComment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UsrCommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_pParms));
			if (_ptr_pParms) {
				NDR_PULL_ALLOC(ndr, r->pParms);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->pParms, _ptr_pParms));
			} else {
				r->pParms = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->pParmsHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_WorkStations));
			if (_ptr_WorkStations) {
				NDR_PULL_ALLOC(ndr, r->WorkStations);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->WorkStations, _ptr_WorkStations));
			} else {
				r->WorkStations = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->WorkStationsHigh));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->LastLogon));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->LastLogOff));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->AcctExpires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MaxStorage));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UnitsPerWeek));
		NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_LogonHours));
		if (_ptr_LogonHours) {
			NDR_PULL_ALLOC(ndr, r->LogonHours);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->LogonHours, _ptr_LogonHours));
		} else {
			r->LogonHours = NULL;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->LogonHoursHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->BadPwCount));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->NumLogons));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_LogonServer));
			if (_ptr_LogonServer) {
				NDR_PULL_ALLOC(ndr, r->LogonServer);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->LogonServer, _ptr_LogonServer));
			} else {
				r->LogonServer = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->LogonServerHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CountryCode));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CodePage));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->HomeDir) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->HomeDir));
				_mem_save_HomeDir_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->HomeDir, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->HomeDir));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_HomeDir_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Comment));
				_mem_save_Comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->ScriptPath) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->ScriptPath));
				_mem_save_ScriptPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->ScriptPath, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->ScriptPath));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ScriptPath_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->FullName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->FullName));
				_mem_save_FullName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->FullName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->FullName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_FullName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UsrComment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UsrComment));
				_mem_save_UsrComment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->UsrComment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->UsrComment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UsrComment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->pParms) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->pParms));
				_mem_save_pParms_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->pParms, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->pParms));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pParms_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->WorkStations) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->WorkStations));
				_mem_save_WorkStations_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->WorkStations, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->WorkStations));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_WorkStations_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		if (r->LogonHours) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->LogonHours));
			_mem_save_LogonHours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->LogonHours, 0);
			NDR_CHECK(ndr_pull_rap_LogonHours(ndr, NDR_SCALARS, r->LogonHours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LogonHours_0, 0);
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->LogonServer) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->LogonServer));
				_mem_save_LogonServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->LogonServer, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->LogonServer));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LogonServer_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserInfo2(struct ndr_print *ndr, const char *name, const struct rap_NetUserInfo2 *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "Name", r->Name);
	ndr_print_uint8(ndr, "Pad", r->Pad);
	ndr_print_array_uint8(ndr, "Password", r->Password, 16);
	ndr_print_time_t(ndr, "PasswordAge", r->PasswordAge);
	ndr_print_rap_UserPriv(ndr, "Priv", r->Priv);
	ndr_print_ptr(ndr, "HomeDir", r->HomeDir);
	ndr->depth++;
	if (r->HomeDir) {
		ndr_print_string(ndr, "HomeDir", r->HomeDir);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "HomeDirHigh", r->HomeDirHigh);
	ndr_print_ptr(ndr, "Comment", r->Comment);
	ndr->depth++;
	if (r->Comment) {
		ndr_print_string(ndr, "Comment", r->Comment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CommentHigh", r->CommentHigh);
	ndr_print_uint16(ndr, "Flags", r->Flags);
	ndr_print_ptr(ndr, "ScriptPath", r->ScriptPath);
	ndr->depth++;
	if (r->ScriptPath) {
		ndr_print_string(ndr, "ScriptPath", r->ScriptPath);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "ScriptPathHigh", r->ScriptPathHigh);
	ndr_print_rap_AuthFlags(ndr, "AuthFlags", r->AuthFlags);
	ndr_print_ptr(ndr, "FullName", r->FullName);
	ndr->depth++;
	if (r->FullName) {
		ndr_print_string(ndr, "FullName", r->FullName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "FullNameHigh", r->FullNameHigh);
	ndr_print_ptr(ndr, "UsrComment", r->UsrComment);
	ndr->depth++;
	if (r->UsrComment) {
		ndr_print_string(ndr, "UsrComment", r->UsrComment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "UsrCommentHigh", r->UsrCommentHigh);
	ndr_print_ptr(ndr, "pParms", r->pParms);
	ndr->depth++;
	if (r->pParms) {
		ndr_print_string(ndr, "pParms", r->pParms);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "pParmsHigh", r->pParmsHigh);
	ndr_print_ptr(ndr, "WorkStations", r->WorkStations);
	ndr->depth++;
	if (r->WorkStations) {
		ndr_print_string(ndr, "WorkStations", r->WorkStations);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "WorkStationsHigh", r->WorkStationsHigh);
	ndr_print_time_t(ndr, "LastLogon", r->LastLogon);
	ndr_print_time_t(ndr, "LastLogOff", r->LastLogOff);
	ndr_print_time_t(ndr, "AcctExpires", r->AcctExpires);
	ndr_print_uint32(ndr, "MaxStorage", r->MaxStorage);
	ndr_print_uint16(ndr, "UnitsPerWeek", r->UnitsPerWeek);
	ndr_print_ptr(ndr, "LogonHours", r->LogonHours);
	ndr->depth++;
	if (r->LogonHours) {
		ndr_print_rap_LogonHours(ndr, "LogonHours", r->LogonHours);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "LogonHoursHigh", r->LogonHoursHigh);
	ndr_print_uint16(ndr, "BadPwCount", r->BadPwCount);
	ndr_print_uint16(ndr, "NumLogons", r->NumLogons);
	ndr_print_ptr(ndr, "LogonServer", r->LogonServer);
	ndr->depth++;
	if (r->LogonServer) {
		ndr_print_string(ndr, "LogonServer", r->LogonServer);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "LogonServerHigh", r->LogonServerHigh);
	ndr_print_uint16(ndr, "CountryCode", r->CountryCode);
	ndr_print_uint16(ndr, "CodePage", r->CodePage);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_NetUserInfo10(struct ndr_push *ndr, int ndr_flags, const struct rap_NetUserInfo10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, 21, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Pad));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->UsrComment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UsrCommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->FullName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->FullNameHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Comment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UsrComment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->UsrComment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->UsrComment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->FullName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->FullName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->FullName));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_NetUserInfo10(struct ndr_pull *ndr, int ndr_flags, struct rap_NetUserInfo10 *r)
{
	uint32_t size_Name_0 = 0;
	uint16_t _ptr_Comment;
	TALLOC_CTX *_mem_save_Comment_0;
	uint16_t _ptr_UsrComment;
	TALLOC_CTX *_mem_save_UsrComment_0;
	uint16_t _ptr_FullName;
	TALLOC_CTX *_mem_save_FullName_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_Name_0 = 21;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, size_Name_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Pad));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Comment));
			if (_ptr_Comment) {
				NDR_PULL_ALLOC(ndr, r->Comment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Comment, _ptr_Comment));
			} else {
				r->Comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_UsrComment));
			if (_ptr_UsrComment) {
				NDR_PULL_ALLOC(ndr, r->UsrComment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UsrComment, _ptr_UsrComment));
			} else {
				r->UsrComment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UsrCommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_FullName));
			if (_ptr_FullName) {
				NDR_PULL_ALLOC(ndr, r->FullName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->FullName, _ptr_FullName));
			} else {
				r->FullName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->FullNameHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Comment));
				_mem_save_Comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UsrComment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UsrComment));
				_mem_save_UsrComment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->UsrComment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->UsrComment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UsrComment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->FullName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->FullName));
				_mem_save_FullName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->FullName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->FullName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_FullName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserInfo10(struct ndr_print *ndr, const char *name, const struct rap_NetUserInfo10 *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserInfo10");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "Name", r->Name);
	ndr_print_uint8(ndr, "Pad", r->Pad);
	ndr_print_ptr(ndr, "Comment", r->Comment);
	ndr->depth++;
	if (r->Comment) {
		ndr_print_string(ndr, "Comment", r->Comment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CommentHigh", r->CommentHigh);
	ndr_print_ptr(ndr, "UsrComment", r->UsrComment);
	ndr->depth++;
	if (r->UsrComment) {
		ndr_print_string(ndr, "UsrComment", r->UsrComment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "UsrCommentHigh", r->UsrCommentHigh);
	ndr_print_ptr(ndr, "FullName", r->FullName);
	ndr->depth++;
	if (r->FullName) {
		ndr_print_string(ndr, "FullName", r->FullName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "FullNameHigh", r->FullNameHigh);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rap_NetUserInfo11(struct ndr_push *ndr, int ndr_flags, const struct rap_NetUserInfo11 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->Name, 21, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Pad));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Comment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->UsrComment));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UsrCommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->FullName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->FullNameHigh));
		NDR_CHECK(ndr_push_rap_UserPriv(ndr, NDR_SCALARS, r->Priv));
		NDR_CHECK(ndr_push_rap_AuthFlags(ndr, NDR_SCALARS, r->AuthFlags));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->PasswordAge));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->HomeDir));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->HomeDirHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->Parms));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ParmsHigh));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->LastLogon));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->LastLogOff));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->BadPWCount));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->NumLogons));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->LogonServer));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->LogonServerHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CountryCode));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->WorkStations));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->WorkStationsHigh));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MaxStorage));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UnitsPerWeek));
		NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->LogonHours));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->LogonHoursHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CodePage));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Comment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Comment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UsrComment) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->UsrComment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->UsrComment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->FullName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->FullName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->FullName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->HomeDir) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->HomeDir));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->HomeDir));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Parms) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->Parms));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->Parms));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->LogonServer) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->LogonServer));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->LogonServer));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->WorkStations) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->WorkStations));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->WorkStations));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->LogonHours) {
			NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->LogonHours));
			NDR_CHECK(ndr_push_rap_LogonHours(ndr, NDR_SCALARS, r->LogonHours));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_NetUserInfo11(struct ndr_pull *ndr, int ndr_flags, struct rap_NetUserInfo11 *r)
{
	uint32_t size_Name_0 = 0;
	uint16_t _ptr_Comment;
	TALLOC_CTX *_mem_save_Comment_0;
	uint16_t _ptr_UsrComment;
	TALLOC_CTX *_mem_save_UsrComment_0;
	uint16_t _ptr_FullName;
	TALLOC_CTX *_mem_save_FullName_0;
	uint16_t _ptr_HomeDir;
	TALLOC_CTX *_mem_save_HomeDir_0;
	uint16_t _ptr_Parms;
	TALLOC_CTX *_mem_save_Parms_0;
	uint16_t _ptr_LogonServer;
	TALLOC_CTX *_mem_save_LogonServer_0;
	uint16_t _ptr_WorkStations;
	TALLOC_CTX *_mem_save_WorkStations_0;
	uint16_t _ptr_LogonHours;
	TALLOC_CTX *_mem_save_LogonHours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_Name_0 = 21;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Name, size_Name_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Pad));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Comment));
			if (_ptr_Comment) {
				NDR_PULL_ALLOC(ndr, r->Comment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Comment, _ptr_Comment));
			} else {
				r->Comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_UsrComment));
			if (_ptr_UsrComment) {
				NDR_PULL_ALLOC(ndr, r->UsrComment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UsrComment, _ptr_UsrComment));
			} else {
				r->UsrComment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UsrCommentHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_FullName));
			if (_ptr_FullName) {
				NDR_PULL_ALLOC(ndr, r->FullName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->FullName, _ptr_FullName));
			} else {
				r->FullName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->FullNameHigh));
		NDR_CHECK(ndr_pull_rap_UserPriv(ndr, NDR_SCALARS, &r->Priv));
		NDR_CHECK(ndr_pull_rap_AuthFlags(ndr, NDR_SCALARS, &r->AuthFlags));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->PasswordAge));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_HomeDir));
			if (_ptr_HomeDir) {
				NDR_PULL_ALLOC(ndr, r->HomeDir);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->HomeDir, _ptr_HomeDir));
			} else {
				r->HomeDir = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->HomeDirHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_Parms));
			if (_ptr_Parms) {
				NDR_PULL_ALLOC(ndr, r->Parms);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Parms, _ptr_Parms));
			} else {
				r->Parms = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ParmsHigh));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->LastLogon));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->LastLogOff));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->BadPWCount));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->NumLogons));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_LogonServer));
			if (_ptr_LogonServer) {
				NDR_PULL_ALLOC(ndr, r->LogonServer);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->LogonServer, _ptr_LogonServer));
			} else {
				r->LogonServer = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->LogonServerHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CountryCode));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_WorkStations));
			if (_ptr_WorkStations) {
				NDR_PULL_ALLOC(ndr, r->WorkStations);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->WorkStations, _ptr_WorkStations));
			} else {
				r->WorkStations = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->WorkStationsHigh));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MaxStorage));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UnitsPerWeek));
		NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_LogonHours));
		if (_ptr_LogonHours) {
			NDR_PULL_ALLOC(ndr, r->LogonHours);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->LogonHours, _ptr_LogonHours));
		} else {
			r->LogonHours = NULL;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->LogonHoursHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CodePage));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Comment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Comment));
				_mem_save_Comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Comment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UsrComment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UsrComment));
				_mem_save_UsrComment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->UsrComment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->UsrComment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UsrComment_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->FullName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->FullName));
				_mem_save_FullName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->FullName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->FullName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_FullName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->HomeDir) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->HomeDir));
				_mem_save_HomeDir_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->HomeDir, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->HomeDir));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_HomeDir_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->Parms) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Parms));
				_mem_save_Parms_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Parms, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->Parms));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Parms_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->LogonServer) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->LogonServer));
				_mem_save_LogonServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->LogonServer, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->LogonServer));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LogonServer_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->WorkStations) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->WorkStations));
				_mem_save_WorkStations_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->WorkStations, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->WorkStations));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_WorkStations_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		if (r->LogonHours) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->LogonHours));
			_mem_save_LogonHours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->LogonHours, 0);
			NDR_CHECK(ndr_pull_rap_LogonHours(ndr, NDR_SCALARS, r->LogonHours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LogonHours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserInfo11(struct ndr_print *ndr, const char *name, const struct rap_NetUserInfo11 *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserInfo11");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "Name", r->Name);
	ndr_print_uint8(ndr, "Pad", r->Pad);
	ndr_print_ptr(ndr, "Comment", r->Comment);
	ndr->depth++;
	if (r->Comment) {
		ndr_print_string(ndr, "Comment", r->Comment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CommentHigh", r->CommentHigh);
	ndr_print_ptr(ndr, "UsrComment", r->UsrComment);
	ndr->depth++;
	if (r->UsrComment) {
		ndr_print_string(ndr, "UsrComment", r->UsrComment);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "UsrCommentHigh", r->UsrCommentHigh);
	ndr_print_ptr(ndr, "FullName", r->FullName);
	ndr->depth++;
	if (r->FullName) {
		ndr_print_string(ndr, "FullName", r->FullName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "FullNameHigh", r->FullNameHigh);
	ndr_print_rap_UserPriv(ndr, "Priv", r->Priv);
	ndr_print_rap_AuthFlags(ndr, "AuthFlags", r->AuthFlags);
	ndr_print_time_t(ndr, "PasswordAge", r->PasswordAge);
	ndr_print_ptr(ndr, "HomeDir", r->HomeDir);
	ndr->depth++;
	if (r->HomeDir) {
		ndr_print_string(ndr, "HomeDir", r->HomeDir);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "HomeDirHigh", r->HomeDirHigh);
	ndr_print_ptr(ndr, "Parms", r->Parms);
	ndr->depth++;
	if (r->Parms) {
		ndr_print_string(ndr, "Parms", r->Parms);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "ParmsHigh", r->ParmsHigh);
	ndr_print_time_t(ndr, "LastLogon", r->LastLogon);
	ndr_print_time_t(ndr, "LastLogOff", r->LastLogOff);
	ndr_print_uint16(ndr, "BadPWCount", r->BadPWCount);
	ndr_print_uint16(ndr, "NumLogons", r->NumLogons);
	ndr_print_ptr(ndr, "LogonServer", r->LogonServer);
	ndr->depth++;
	if (r->LogonServer) {
		ndr_print_string(ndr, "LogonServer", r->LogonServer);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "LogonServerHigh", r->LogonServerHigh);
	ndr_print_uint16(ndr, "CountryCode", r->CountryCode);
	ndr_print_ptr(ndr, "WorkStations", r->WorkStations);
	ndr->depth++;
	if (r->WorkStations) {
		ndr_print_string(ndr, "WorkStations", r->WorkStations);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "WorkStationsHigh", r->WorkStationsHigh);
	ndr_print_uint32(ndr, "MaxStorage", r->MaxStorage);
	ndr_print_uint16(ndr, "UnitsPerWeek", r->UnitsPerWeek);
	ndr_print_ptr(ndr, "LogonHours", r->LogonHours);
	ndr->depth++;
	if (r->LogonHours) {
		ndr_print_rap_LogonHours(ndr, "LogonHours", r->LogonHours);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "LogonHoursHigh", r->LogonHoursHigh);
	ndr_print_uint16(ndr, "CodePage", r->CodePage);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_netuser_info(struct ndr_push *ndr, int ndr_flags, const union rap_netuser_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_rap_NetUserInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_rap_NetUserInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_rap_NetUserInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 10: {
				NDR_CHECK(ndr_push_rap_NetUserInfo10(ndr, NDR_SCALARS, &r->info10));
			break; }

			case 11: {
				NDR_CHECK(ndr_push_rap_NetUserInfo11(ndr, NDR_SCALARS, &r->info11));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_push_rap_NetUserInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_rap_NetUserInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 10:
				NDR_CHECK(ndr_push_rap_NetUserInfo10(ndr, NDR_BUFFERS, &r->info10));
			break;

			case 11:
				NDR_CHECK(ndr_push_rap_NetUserInfo11(ndr, NDR_BUFFERS, &r->info11));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_netuser_info(struct ndr_pull *ndr, int ndr_flags, union rap_netuser_info *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_rap_NetUserInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_rap_NetUserInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_rap_NetUserInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 10: {
				NDR_CHECK(ndr_pull_rap_NetUserInfo10(ndr, NDR_SCALARS, &r->info10));
			break; }

			case 11: {
				NDR_CHECK(ndr_pull_rap_NetUserInfo11(ndr, NDR_SCALARS, &r->info11));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_pull_rap_NetUserInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_rap_NetUserInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 10:
				NDR_CHECK(ndr_pull_rap_NetUserInfo10(ndr, NDR_BUFFERS, &r->info10));
			break;

			case 11:
				NDR_CHECK(ndr_pull_rap_NetUserInfo11(ndr, NDR_BUFFERS, &r->info11));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_netuser_info(struct ndr_print *ndr, const char *name, const union rap_netuser_info *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_netuser_info");
	switch (level) {
		case 0:
			ndr_print_rap_NetUserInfo0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_rap_NetUserInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_rap_NetUserInfo2(ndr, "info2", &r->info2);
		break;

		case 10:
			ndr_print_rap_NetUserInfo10(ndr, "info10", &r->info10);
		break;

		case 11:
			ndr_print_rap_NetUserInfo11(ndr, "info11", &r->info11);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_rap_session_info_2(struct ndr_push *ndr, int ndr_flags, const struct rap_session_info_2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->ComputerName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ComputerNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->UserNameHigh));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_conns));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_opens));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sess_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->user_flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->CliTypeName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->CliTypeNameHigh));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->ComputerName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->ComputerName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->ComputerName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->UserName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->UserName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->CliTypeName) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->CliTypeName));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->CliTypeName));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rap_session_info_2(struct ndr_pull *ndr, int ndr_flags, struct rap_session_info_2 *r)
{
	uint16_t _ptr_ComputerName;
	TALLOC_CTX *_mem_save_ComputerName_0;
	uint16_t _ptr_UserName;
	TALLOC_CTX *_mem_save_UserName_0;
	uint16_t _ptr_CliTypeName;
	TALLOC_CTX *_mem_save_CliTypeName_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_ComputerName));
			if (_ptr_ComputerName) {
				NDR_PULL_ALLOC(ndr, r->ComputerName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->ComputerName, _ptr_ComputerName));
			} else {
				r->ComputerName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ComputerNameHigh));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_UserName));
			if (_ptr_UserName) {
				NDR_PULL_ALLOC(ndr, r->UserName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UserName, _ptr_UserName));
			} else {
				r->UserName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UserNameHigh));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_conns));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_opens));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sess_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->user_flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_CliTypeName));
			if (_ptr_CliTypeName) {
				NDR_PULL_ALLOC(ndr, r->CliTypeName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->CliTypeName, _ptr_CliTypeName));
			} else {
				r->CliTypeName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->CliTypeNameHigh));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->ComputerName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->ComputerName));
				_mem_save_ComputerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->ComputerName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->ComputerName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ComputerName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->UserName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UserName));
				_mem_save_UserName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->UserName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->UserName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UserName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->CliTypeName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->CliTypeName));
				_mem_save_CliTypeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->CliTypeName, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->CliTypeName));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_CliTypeName_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_session_info_2(struct ndr_print *ndr, const char *name, const struct rap_session_info_2 *r)
{
	ndr_print_struct(ndr, name, "rap_session_info_2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "ComputerName", r->ComputerName);
	ndr->depth++;
	if (r->ComputerName) {
		ndr_print_string(ndr, "ComputerName", r->ComputerName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "ComputerNameHigh", r->ComputerNameHigh);
	ndr_print_ptr(ndr, "UserName", r->UserName);
	ndr->depth++;
	if (r->UserName) {
		ndr_print_string(ndr, "UserName", r->UserName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "UserNameHigh", r->UserNameHigh);
	ndr_print_uint16(ndr, "num_conns", r->num_conns);
	ndr_print_uint16(ndr, "num_opens", r->num_opens);
	ndr_print_uint16(ndr, "num_users", r->num_users);
	ndr_print_uint32(ndr, "sess_time", r->sess_time);
	ndr_print_uint32(ndr, "idle_time", r->idle_time);
	ndr_print_uint32(ndr, "user_flags", r->user_flags);
	ndr_print_ptr(ndr, "CliTypeName", r->CliTypeName);
	ndr->depth++;
	if (r->CliTypeName) {
		ndr_print_string(ndr, "CliTypeName", r->CliTypeName);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "CliTypeNameHigh", r->CliTypeNameHigh);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_session_info(struct ndr_push *ndr, int ndr_flags, const union rap_session_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_push_rap_session_info_2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 2:
				NDR_CHECK(ndr_push_rap_session_info_2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_session_info(struct ndr_pull *ndr, int ndr_flags, union rap_session_info *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_pull_rap_session_info_2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 2:
				NDR_CHECK(ndr_pull_rap_session_info_2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_session_info(struct ndr_print *ndr, const char *name, const union rap_session_info *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "rap_session_info");
	switch (level) {
		case 2:
			ndr_print_rap_session_info_2(ndr, "info2", &r->info2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_TimeOfDayInfo(struct ndr_push *ndr, int ndr_flags, const struct rap_TimeOfDayInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->TimeSinceJan11970));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->TimeSinceBoot));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Hours));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Minutes));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Seconds));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Hundreds));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->TimeZone));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ClockFrequency));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Day));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Month));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Year));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Weekday));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_TimeOfDayInfo(struct ndr_pull *ndr, int ndr_flags, struct rap_TimeOfDayInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->TimeSinceJan11970));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->TimeSinceBoot));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Hours));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Minutes));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Seconds));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Hundreds));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->TimeZone));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ClockFrequency));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Day));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Month));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Year));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Weekday));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_TimeOfDayInfo(struct ndr_print *ndr, const char *name, const struct rap_TimeOfDayInfo *r)
{
	ndr_print_struct(ndr, name, "rap_TimeOfDayInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "TimeSinceJan11970", r->TimeSinceJan11970);
	ndr_print_uint32(ndr, "TimeSinceBoot", r->TimeSinceBoot);
	ndr_print_uint8(ndr, "Hours", r->Hours);
	ndr_print_uint8(ndr, "Minutes", r->Minutes);
	ndr_print_uint8(ndr, "Seconds", r->Seconds);
	ndr_print_uint8(ndr, "Hundreds", r->Hundreds);
	ndr_print_uint16(ndr, "TimeZone", r->TimeZone);
	ndr_print_uint16(ndr, "ClockFrequency", r->ClockFrequency);
	ndr_print_uint8(ndr, "Day", r->Day);
	ndr_print_uint8(ndr, "Month", r->Month);
	ndr_print_uint16(ndr, "Year", r->Year);
	ndr_print_uint8(ndr, "Weekday", r->Weekday);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetShareEnum(struct ndr_push *ndr, int flags, const struct rap_NetShareEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_rap_share_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetShareEnum(struct ndr_pull *ndr, int flags, struct rap_NetShareEnum *r)
{
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_share_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetShareEnum(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetShareEnum *r)
{
	ndr_print_struct(ndr, name, "rap_NetShareEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetShareEnum");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetShareEnum");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "count", r->out.count);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_rap_share_info(ndr, "info", r->out.info);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetShareAdd(struct ndr_push *ndr, int flags, const struct rap_NetShareAdd *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_rap_share_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetShareAdd(struct ndr_pull *ndr, int flags, struct rap_NetShareAdd *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_share_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetShareAdd(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetShareAdd *r)
{
	ndr_print_struct(ndr, name, "rap_NetShareAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetShareAdd");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_rap_share_info(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetShareAdd");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetServerEnum2(struct ndr_push *ndr, int flags, const struct rap_NetServerEnum2 *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.servertype));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->in.domain == NULL) {
				return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
			}
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.domain));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_rap_server_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_rap_server_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetServerEnum2(struct ndr_pull *ndr, int flags, struct rap_NetServerEnum2 *r)
{
	uint32_t size_info_0 = 0;
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.servertype));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.domain));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		size_info_0 = r->out.count;
		NDR_PULL_ALLOC_N(ndr, r->out.info, size_info_0);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_rap_server_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_rap_server_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetServerEnum2(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetServerEnum2 *r)
{
	uint32_t cntr_info_0;
	ndr_print_struct(ndr, name, "rap_NetServerEnum2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetServerEnum2");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr_print_uint32(ndr, "servertype", r->in.servertype);
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetServerEnum2");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "count", r->out.count);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)r->out.count);
		ndr->depth++;
		for (cntr_info_0=0;cntr_info_0<r->out.count;cntr_info_0++) {
			ndr_print_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level);
			ndr_print_rap_server_info(ndr, "info", &r->out.info[cntr_info_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_WserverGetInfo(struct ndr_push *ndr, int flags, const struct rap_WserverGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_rap_server_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_WserverGetInfo(struct ndr_pull *ndr, int flags, struct rap_WserverGetInfo *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_server_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_WserverGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct rap_WserverGetInfo *r)
{
	ndr_print_struct(ndr, name, "rap_WserverGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_WserverGetInfo");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_WserverGetInfo");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_rap_server_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintQEnum(struct ndr_push *ndr, int flags, const struct rap_NetPrintQEnum *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_rap_printq_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_rap_printq_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintQEnum(struct ndr_pull *ndr, int flags, struct rap_NetPrintQEnum *r)
{
	uint32_t size_info_0 = 0;
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		size_info_0 = r->out.count;
		NDR_PULL_ALLOC_N(ndr, r->out.info, size_info_0);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_rap_printq_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_rap_printq_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintQEnum(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintQEnum *r)
{
	uint32_t cntr_info_0;
	ndr_print_struct(ndr, name, "rap_NetPrintQEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintQEnum");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintQEnum");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "count", r->out.count);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)r->out.count);
		ndr->depth++;
		for (cntr_info_0=0;cntr_info_0<r->out.count;cntr_info_0++) {
			ndr_print_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level);
			ndr_print_rap_printq_info(ndr, "info", &r->out.info[cntr_info_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintQGetInfo(struct ndr_push *ndr, int flags, const struct rap_NetPrintQGetInfo *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_rap_printq_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintQGetInfo(struct ndr_pull *ndr, int flags, struct rap_NetPrintQGetInfo *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_printq_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintQGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintQGetInfo *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintQGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintQGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "PrintQueueName", r->in.PrintQueueName);
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintQGetInfo");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_rap_printq_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintJobPause(struct ndr_push *ndr, int flags, const struct rap_NetPrintJobPause *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.JobID));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintJobPause(struct ndr_pull *ndr, int flags, struct rap_NetPrintJobPause *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.JobID));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintJobPause(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintJobPause *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintJobPause");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintJobPause");
		ndr->depth++;
		ndr_print_uint16(ndr, "JobID", r->in.JobID);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintJobPause");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintJobContinue(struct ndr_push *ndr, int flags, const struct rap_NetPrintJobContinue *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.JobID));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintJobContinue(struct ndr_pull *ndr, int flags, struct rap_NetPrintJobContinue *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.JobID));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintJobContinue(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintJobContinue *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintJobContinue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintJobContinue");
		ndr->depth++;
		ndr_print_uint16(ndr, "JobID", r->in.JobID);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintJobContinue");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintJobDelete(struct ndr_push *ndr, int flags, const struct rap_NetPrintJobDelete *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.JobID));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintJobDelete(struct ndr_pull *ndr, int flags, struct rap_NetPrintJobDelete *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.JobID));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintJobDelete(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintJobDelete *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintJobDelete");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintJobDelete");
		ndr->depth++;
		ndr_print_uint16(ndr, "JobID", r->in.JobID);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintJobDelete");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintQueuePause(struct ndr_push *ndr, int flags, const struct rap_NetPrintQueuePause *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintQueuePause(struct ndr_pull *ndr, int flags, struct rap_NetPrintQueuePause *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintQueuePause(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintQueuePause *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintQueuePause");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintQueuePause");
		ndr->depth++;
		ndr_print_string(ndr, "PrintQueueName", r->in.PrintQueueName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintQueuePause");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintQueueResume(struct ndr_push *ndr, int flags, const struct rap_NetPrintQueueResume *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintQueueResume(struct ndr_pull *ndr, int flags, struct rap_NetPrintQueueResume *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintQueueResume(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintQueueResume *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintQueueResume");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintQueueResume");
		ndr->depth++;
		ndr_print_string(ndr, "PrintQueueName", r->in.PrintQueueName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintQueueResume");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintQueuePurge(struct ndr_push *ndr, int flags, const struct rap_NetPrintQueuePurge *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintQueuePurge(struct ndr_pull *ndr, int flags, struct rap_NetPrintQueuePurge *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintQueuePurge(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintQueuePurge *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintQueuePurge");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintQueuePurge");
		ndr->depth++;
		ndr_print_string(ndr, "PrintQueueName", r->in.PrintQueueName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintQueuePurge");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintJobEnum(struct ndr_push *ndr, int flags, const struct rap_NetPrintJobEnum *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_rap_printj_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_rap_printj_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintJobEnum(struct ndr_pull *ndr, int flags, struct rap_NetPrintJobEnum *r)
{
	uint32_t size_info_0 = 0;
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.PrintQueueName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		size_info_0 = r->out.count;
		NDR_PULL_ALLOC_N(ndr, r->out.info, size_info_0);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_rap_printj_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_rap_printj_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintJobEnum(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintJobEnum *r)
{
	uint32_t cntr_info_0;
	ndr_print_struct(ndr, name, "rap_NetPrintJobEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintJobEnum");
		ndr->depth++;
		ndr_print_string(ndr, "PrintQueueName", r->in.PrintQueueName);
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintJobEnum");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "count", r->out.count);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)r->out.count);
		ndr->depth++;
		for (cntr_info_0=0;cntr_info_0<r->out.count;cntr_info_0++) {
			ndr_print_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level);
			ndr_print_rap_printj_info(ndr, "info", &r->out.info[cntr_info_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintJobGetInfo(struct ndr_push *ndr, int flags, const struct rap_NetPrintJobGetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.JobID));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_rap_printj_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintJobGetInfo(struct ndr_pull *ndr, int flags, struct rap_NetPrintJobGetInfo *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.JobID));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_printj_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintJobGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintJobGetInfo *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintJobGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintJobGetInfo");
		ndr->depth++;
		ndr_print_uint16(ndr, "JobID", r->in.JobID);
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintJobGetInfo");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_rap_printj_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintJobSetInfo(struct ndr_push *ndr, int flags, const struct rap_NetPrintJobSetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.JobID));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_rap_JobInfoParamNum(ndr, NDR_SCALARS, r->in.ParamNum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.Param, r->in.ParamNum));
		NDR_CHECK(ndr_push_rap_JobInfoParam(ndr, NDR_SCALARS, &r->in.Param));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintJobSetInfo(struct ndr_pull *ndr, int flags, struct rap_NetPrintJobSetInfo *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.JobID));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
		NDR_CHECK(ndr_pull_rap_JobInfoParamNum(ndr, NDR_SCALARS, &r->in.ParamNum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.Param, r->in.ParamNum));
		NDR_CHECK(ndr_pull_rap_JobInfoParam(ndr, NDR_SCALARS, &r->in.Param));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintJobSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintJobSetInfo *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintJobSetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintJobSetInfo");
		ndr->depth++;
		ndr_print_uint16(ndr, "JobID", r->in.JobID);
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr_print_rap_JobInfoParamNum(ndr, "ParamNum", r->in.ParamNum);
		ndr_print_set_switch_value(ndr, &r->in.Param, r->in.ParamNum);
		ndr_print_rap_JobInfoParam(ndr, "Param", &r->in.Param);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintJobSetInfo");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintDestEnum(struct ndr_push *ndr, int flags, const struct rap_NetPrintDestEnum *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_rap_printdest_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_rap_printdest_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintDestEnum(struct ndr_pull *ndr, int flags, struct rap_NetPrintDestEnum *r)
{
	uint32_t size_info_0 = 0;
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		size_info_0 = r->out.count;
		NDR_PULL_ALLOC_N(ndr, r->out.info, size_info_0);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_rap_printdest_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_rap_printdest_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintDestEnum(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintDestEnum *r)
{
	uint32_t cntr_info_0;
	ndr_print_struct(ndr, name, "rap_NetPrintDestEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintDestEnum");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintDestEnum");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "count", r->out.count);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)r->out.count);
		ndr->depth++;
		for (cntr_info_0=0;cntr_info_0<r->out.count;cntr_info_0++) {
			ndr_print_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level);
			ndr_print_rap_printdest_info(ndr, "info", &r->out.info[cntr_info_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetPrintDestGetInfo(struct ndr_push *ndr, int flags, const struct rap_NetPrintDestGetInfo *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.PrintDestName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_rap_printdest_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetPrintDestGetInfo(struct ndr_pull *ndr, int flags, struct rap_NetPrintDestGetInfo *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.PrintDestName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_printdest_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetPrintDestGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetPrintDestGetInfo *r)
{
	ndr_print_struct(ndr, name, "rap_NetPrintDestGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetPrintDestGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "PrintDestName", r->in.PrintDestName);
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetPrintDestGetInfo");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_rap_printdest_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetUserPasswordSet2(struct ndr_push *ndr, int flags, const struct rap_NetUserPasswordSet2 *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.OldPassword, 16));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.NewPassword, 16));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.EncryptedPassword));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.RealPasswordLength));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetUserPasswordSet2(struct ndr_pull *ndr, int flags, struct rap_NetUserPasswordSet2 *r)
{
	uint32_t size_OldPassword_0 = 0;
	uint32_t size_NewPassword_0 = 0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.UserName));
			ndr->flags = _flags_save_string;
		}
		size_OldPassword_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.OldPassword, size_OldPassword_0));
		size_NewPassword_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.NewPassword, size_NewPassword_0));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.EncryptedPassword));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.RealPasswordLength));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserPasswordSet2(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetUserPasswordSet2 *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserPasswordSet2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetUserPasswordSet2");
		ndr->depth++;
		ndr_print_string(ndr, "UserName", r->in.UserName);
		ndr_print_array_uint8(ndr, "OldPassword", r->in.OldPassword, 16);
		ndr_print_array_uint8(ndr, "NewPassword", r->in.NewPassword, 16);
		ndr_print_uint16(ndr, "EncryptedPassword", r->in.EncryptedPassword);
		ndr_print_uint16(ndr, "RealPasswordLength", r->in.RealPasswordLength);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetUserPasswordSet2");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetOEMChangePassword(struct ndr_push *ndr, int flags, const struct rap_NetOEMChangePassword *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.crypt_password, 516));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.password_hash, 16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetOEMChangePassword(struct ndr_pull *ndr, int flags, struct rap_NetOEMChangePassword *r)
{
	uint32_t size_crypt_password_0 = 0;
	uint32_t size_password_hash_0 = 0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.UserName));
			ndr->flags = _flags_save_string;
		}
		size_crypt_password_0 = 516;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.crypt_password, size_crypt_password_0));
		size_password_hash_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.password_hash, size_password_hash_0));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetOEMChangePassword(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetOEMChangePassword *r)
{
	ndr_print_struct(ndr, name, "rap_NetOEMChangePassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetOEMChangePassword");
		ndr->depth++;
		ndr_print_string(ndr, "UserName", r->in.UserName);
		ndr_print_array_uint8(ndr, "crypt_password", r->in.crypt_password, 516);
		ndr_print_array_uint8(ndr, "password_hash", r->in.password_hash, 16);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetOEMChangePassword");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetUserGetInfo(struct ndr_push *ndr, int flags, const struct rap_NetUserGetInfo *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_rap_netuser_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetUserGetInfo(struct ndr_pull *ndr, int flags, struct rap_NetUserGetInfo *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.UserName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_netuser_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetUserGetInfo *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetUserGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "UserName", r->in.UserName);
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetUserGetInfo");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_rap_netuser_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetSessionEnum(struct ndr_push *ndr, int flags, const struct rap_NetSessionEnum *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_rap_session_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->out.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_rap_session_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetSessionEnum(struct ndr_pull *ndr, int flags, struct rap_NetSessionEnum *r)
{
	uint32_t size_info_0 = 0;
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		size_info_0 = r->out.count;
		NDR_PULL_ALLOC_N(ndr, r->out.info, size_info_0);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_rap_session_info(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < size_info_0; cntr_info_0++) {
			NDR_CHECK(ndr_pull_rap_session_info(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetSessionEnum(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetSessionEnum *r)
{
	uint32_t cntr_info_0;
	ndr_print_struct(ndr, name, "rap_NetSessionEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetSessionEnum");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetSessionEnum");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "count", r->out.count);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)r->out.count);
		ndr->depth++;
		for (cntr_info_0=0;cntr_info_0<r->out.count;cntr_info_0++) {
			ndr_print_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level);
			ndr_print_rap_session_info(ndr, "info", &r->out.info[cntr_info_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetSessionGetInfo(struct ndr_push *ndr, int flags, const struct rap_NetSessionGetInfo *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.SessionName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.available));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_rap_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetSessionGetInfo(struct ndr_pull *ndr, int flags, struct rap_NetSessionGetInfo *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.SessionName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.available));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetSessionGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetSessionGetInfo *r)
{
	ndr_print_struct(ndr, name, "rap_NetSessionGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetSessionGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "SessionName", r->in.SessionName);
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetSessionGetInfo");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_uint16(ndr, "available", r->out.available);
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_rap_session_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetUserAdd(struct ndr_push *ndr, int flags, const struct rap_NetUserAdd *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.pwdlength));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.unknown));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_rap_netuser_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetUserAdd(struct ndr_pull *ndr, int flags, struct rap_NetUserAdd *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.pwdlength));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_rap_netuser_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserAdd(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetUserAdd *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetUserAdd");
		ndr->depth++;
		ndr_print_uint16(ndr, "level", r->in.level);
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr_print_uint16(ndr, "pwdlength", r->in.pwdlength);
		ndr_print_uint16(ndr, "unknown", r->in.unknown);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_rap_netuser_info(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetUserAdd");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetUserDelete(struct ndr_push *ndr, int flags, const struct rap_NetUserDelete *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.UserName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetUserDelete(struct ndr_pull *ndr, int flags, struct rap_NetUserDelete *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.UserName));
			ndr->flags = _flags_save_string;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetUserDelete(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetUserDelete *r)
{
	ndr_print_struct(ndr, name, "rap_NetUserDelete");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetUserDelete");
		ndr->depth++;
		ndr_print_string(ndr, "UserName", r->in.UserName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetUserDelete");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_rap_NetRemoteTOD(struct ndr_push *ndr, int flags, const struct rap_NetRemoteTOD *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_rap_status(ndr, NDR_SCALARS, r->out.status));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.convert));
		NDR_CHECK(ndr_push_rap_TimeOfDayInfo(ndr, NDR_SCALARS, &r->out.tod));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_rap_NetRemoteTOD(struct ndr_pull *ndr, int flags, struct rap_NetRemoteTOD *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.bufsize));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_rap_status(ndr, NDR_SCALARS, &r->out.status));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.convert));
		NDR_CHECK(ndr_pull_rap_TimeOfDayInfo(ndr, NDR_SCALARS, &r->out.tod));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rap_NetRemoteTOD(struct ndr_print *ndr, const char *name, int flags, const struct rap_NetRemoteTOD *r)
{
	ndr_print_struct(ndr, name, "rap_NetRemoteTOD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "rap_NetRemoteTOD");
		ndr->depth++;
		ndr_print_uint16(ndr, "bufsize", r->in.bufsize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "rap_NetRemoteTOD");
		ndr->depth++;
		ndr_print_rap_status(ndr, "status", r->out.status);
		ndr_print_uint16(ndr, "convert", r->out.convert);
		ndr_print_rap_TimeOfDayInfo(ndr, "tod", &r->out.tod);
		ndr->depth--;
	}
	ndr->depth--;
}

