#!/bin/sh

[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - 3rd party scanner routine plugin interface
  - the #!before and #!after config-file hacks

tac

PERL5LIB=../bin/ perl -MAnomy::Sanitizer -MAnomy::Log -e '
    sub scan 
    {
         my $self = shift;
         my $log = shift;
	 my $fh = shift;
         $log->entry("bogus", SLOG_WARNING|SLOG_INFO, undef, "Bogus scan routine invoked, args: ".join(", ", @_));
	 return 2;
    }
    
    my $san = new Anomy::Sanitizer;
    $san->register_scanner("bogus", \&scan);
    $san->configure("feat_log_inline = 1", 
                    "feat_log_stderr = 1",
		    "file_name_tpl = ./tmp.plugin-test", 
		    "msg_usage = foo",
		    "msg_signature = foo",
		    "feat_log_xml = 1",
		    "before ". time() ." feat_testing = 0",
		    "after ". time() ." feat_testing = 1",
		    "file_list_rules = 1",
		    "header_rev = 0",
		    "feat_files = 1",
		    "file_list_1_scanner = 0:1:2:builtin/bogus %FILENAME %REPLY_TO %ERRORS_TO %HEADER(subject)",
		    "file_list_1_policy = drop:drop:drop:drop",
		    "file_list_1 = .*")
     && die $san->error(); 
    
    print grep(!/tnef/, split(/^/m, $san->get_config_text())), "\n\n";
    
    exit($san->sanitize(*STDIN, *STDOUT));
' <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Subject: Plugin test case.
Content-Type: text/plain;

This is a harmless attachment which will get killed.

EOF
echo "*** Exit code was $? ***" >>test.out
rm -f ./tmp.plugin-test
