// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __box_h__
#define __box_h__

#include "basebox.h"

class Box : public BaseBox {
public:
  Box(const Box&);
  Box(Base* p, const Vector& ctr, 
      const Vector& seg,
      double ang,
      const char* clr, int* dsh,
      int wth, const char* fnt, const char* txt,
      unsigned short prop, const char* cmt, 
      const List<Tag>& tg, const List<CallBack>& cb);

  virtual Marker* dup() {return new Box(*this);}
  void editBegin(int);
  void edit(const Vector&, int);
  void editEnd();

  void analysis(AnalysisMethod, int);
  void analysisPlot3d(char*, char*);

  void list(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, int, int);
  void listXML(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat);
  virtual void listCiao(ostream&, Coord::CoordSystem, int);
  virtual void listSAOtng(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, int);
  virtual void listPros(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, int);
  virtual void listSAOimage(ostream&, int);
};

#endif
