#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

# used to access ProcessSend*Cmd via tcl
proc CommReturn {id rr} {
    return "$id $rr"
}

proc CommSet {fn paramlist} {
    global debug
    if {$debug(tcl,hv) || $debug(tcl,samp)} {
	puts stderr "CommSet:$fn:$paramlist"
    }

    set cmd [lindex $paramlist 0]
    set param [lrange $paramlist 1 end]
    set len 0

    set i 0

    catch {
    switch -- $cmd {
	2mass {Process2MASSCmd param i}
	3d {Process3DCmd param i}
	about {}
	align {ProcessAlignCmd param i}
	analysis {ProcessAnalysisCmd param i {} $fn}
	array {ProcessArrayCmd param i {} $fn}
	bg -
	background {ProcessBgCmd param i}
	backup {ProcessBackupCmd param i}
	blink {ProcessBlinkCmd param i}
	bin {ProcessBinCmd param i}
	catalog {ProcessCatalogCmd param i}
	cd {ProcessCDCmd param i}
	cmap {ProcessCmapCmd param i}
	colorbar {ProcessColorbarCmd param i}
	console {ProcessConsoleCmd param i}
	contour {ProcessContourCmd param i}
	crop {ProcessCropCmd param i}
	crosshair {ProcessCrosshairCmd param i}
	cursor {ProcessCursorCmd param i}
	data {}
	slice -
	cube -
	datacube {ProcessCubeCmd param i}
	dss -
	dsssao {ProcessSAOCmd param i}
	dsseso {ProcessESOCmd param i}
	dssstsci {ProcessSTSCICmd param i}
	exit {ProcessQuitCmd param i}
	export {ProcessExportCmd param i}
	file {ProcessFileCmd param i {} {}}
	first {ProcessFIRSTCmd param i}
	fits {ProcessFitsCmd param i {} $fn}
	frame {ProcessFrameCmd param i}
	grid {ProcessGridCmd param i}
	header {ProcessHeaderCmd param i}
	height {ProcessHeightCmd param i}
	iconify {ProcessIconifyCmd param i}
	iis {ProcessIISCmd param i}
	imexam {}
	photo {ProcessPhotoCmd param i {} $fn}
	lock {ProcessLockCmd param i}
	lower {ProcessLowerCmd param i}
	magnifier {ProcessMagnifierCmd param i}
	mask {ProcessMaskCmd param i}
	match {ProcessMatchCmd param i}
	minmax {ProcessMinMaxCmd param i}
	mode {ProcessModeCmd param i}
	movie -
	savempeg {ProcessMovieCmd param i}
	nameserver {ProcessNRESCmd param i}
	nan {ProcessNanCmd param i}
	nvss {ProcessNVSSCmd param i}
	orient {ProcessOrientCmd param i}
	{page setup} -
	pagesetup {ProcessPageSetupCmd param i}
	pspagesetup {ProcessPSPageSetupCmd param i}
	pan {ProcessPanCmd param i}
	pixeltable {ProcessPixelTableCmd param i}
	plot {ProcessPlotCmd param i {} $fn}
	prefs {ProcessPrefsCmd param i}
	preserve {ProcessPreserveCmd param i}
	print {ProcessPrintCmd param i}
	psprint {ProcessPSPrintCmd param i}
	quit {ProcessQuitCmd param i}
	raise {ProcessRaiseCmd param i}
	restore {ProcessRestoreCmd param i}
	region -
	regions {ProcessRegionsCmd param i {} $fn}
	rgb {ProcessRGBCmd param i}
	rotate {ProcessRotateCmd param i}
	save -
	savefits {ProcessSaveCmd param i}
	saveimage {ProcessSaveImageCmd param i}
	scale {ProcessScaleCmd param i}
	single {ProcessSingleCmd param i}
	shm {ProcessShmCmd param i 0}
	skyview {ProcessSkyViewCmd param i}
	sleep {ProcessSleepCmd param i}
	smooth {ProcessSmoothCmd param i}
	source {ProcessSourceCmd param i}
	tcl {ProcessTclCmd param i {} $fn}
	theme {ProcessThemeCmd param i}
	threads -
	thread {ProcessThreadsCmd param i}
	tile {ProcessTileCmd param i}
	update {ProcessUpdateCmd param i}
	version {}
	view {ProcessViewCmd param i}
	vo {ProcessVOCmd param i}
	wcs {ProcessWCSCmd param i {} $fn}
	web {ProcessWebCmd param i}
	width {ProcessWidthCmd param i}
	zoom {ProcessZoomCmd param i}
	zscale {ProcessZScaleCmd param i}
	default {Error "[msgcat::mc {Unknown command}]: $cmd"}
    }
    }
}

proc CommGet {proc id paramlist fn} {
    global debug
    if {$debug(tcl,samp)} {
	puts stderr "CommGet:$proc:$id:$paramlist:$fn"
    }

    set cmd [lindex $paramlist 0]
    set param [lrange $paramlist 1 end]

    catch {
    switch -- $cmd {
	2mass {ProcessSend2MASSCmd $proc $id $param}
	3d {ProcessSend3DCmd $proc $id $param}
	about {ProcessSendAboutCmd $proc $id $param {} $fn}
	align {ProcessSendAlignCmd $proc $id $param}
	analysis {ProcessSendAnalysisCmd $proc $id $param {} $fn}
	array {ProcessSendArrayCmd $proc $id $param {} $fn}
	bg -
	background {ProcessSendBgCmd $proc $id $param}
	blink {ProcessSendBlinkCmd $proc $id $param}
	bin {ProcessSendBinCmd $proc $id $param}
	catalog {ProcessSendCatalogCmd $proc $id $param {} $fn}
	cd {ProcessSendCDCmd $proc $id $param}
	cmap {ProcessSendCmapCmd $proc $id $param}
	colorbar {ProcessSendColorbarCmd $proc $id $param}
	console {}
	contour {ProcessSendContourCmd $proc $id $param {} $fn}
	crop {ProcessSendCropCmd $proc $id $param}
	crosshair {ProcessSendCrosshairCmd $proc $id $param}
	cursor {}
	data {ProcessSendDataCmd $proc $id $param {} $fn}
	slice -
	cube -
	datacube {ProcessSendCubeCmd $proc $id $param}
	dss -
	dsssao {ProcessSendSAOCmd $proc $id $param}
	dsseso {ProcessSendESOCmd $proc $id $param}
	dssstsci {ProcessSendSTSCICmd $proc $id $param}
	exit {}
	export {}
	file {ProcessSendFileCmd $proc $id $param}
	first {ProcessSendFIRSTCmd $proc $id $param}
	fits {ProcessSendFitsCmd $proc $id $param {} $fn}
	frame {ProcessSendFrameCmd $proc $id $param}
	grid {ProcessSendGridCmd $proc $id $param}
	header {}
	height {ProcessSendHeightCmd $proc $id $param}
	iconify {ProcessSendIconifyCmd $proc $id $param}
	iis {ProcessSendIISCmd $proc $id $param}
	imexam {ProcessSendImexamCmd $proc $id $param}
	photo {ProcessSendPhotoCmd $proc $id $param {} $fn}
	lock {ProcessSendLockCmd $proc $id $param}
	lower {}
	magnifier {ProcessSendMagnifierCmd $proc $id $param}
	mask {ProcessSendMaskCmd $proc $id $param}
	match {}
	minmax {ProcessSendMinMaxCmd $proc $id $param}
	mode {ProcessSendModeCmd $proc $id $param}
	movie -
	savempeg {}
	nameserver {ProcessSendNRESCmd $proc $id $param}
	nan {ProcessSendNanCmd $proc $id $param}
	nvss {ProcessSendNVSSCmd $proc $id $param}
	orient {ProcessSendOrientCmd $proc $id $param}
	{page setup} -
	pagesetup {ProcessSendPageSetupCmd $proc $id $param}
	pspagesetup {ProcessSendPSPageSetupCmd $proc $id $param}
	pan {ProcessSendPanCmd $proc $id $param}
	pixeltable {ProcessSendPixelTableCmd $proc $id $param {} $fn}
	plot {ProcessSendPlotCmd $proc $id $param}
	prefs {ProcessSendPrefsCmd $proc $id $param}
	preserve {ProcessSendPreserveCmd $proc $id $param}
	{postscript print} {ProcessSendPrintCmd $proc $id $param}
	print {ProcessSendPrintCmd $proc $id $param}
	psprint {ProcessSendPSPrintCmd $proc $id $param}
	quit {}
	raise {}
	region -
	regions {ProcessSendRegionsCmd $proc $id $param {} $fn}
	rgb {ProcessSendRGBCmd $proc $id $param}
	rotate {ProcessSendRotateCmd $proc $id $param}
	save -
	savefits {}
	saveimage {}
	scale {ProcessSendScaleCmd $proc $id $param}
	single {ProcessSendSingleCmd $proc $id $param}
	shm {ProcessSendShmCmd $proc $id $param}
	skyview {ProcessSendSkyViewCmd $proc $id $param}
	smooth {ProcessSendSmoothCmd $proc $id $param}
	source {}
	tcl {}
	theme {ProcessSendThemeCmd $proc $id $param}
	threads -
	thread {ProcessSendThreadCmd $proc $id $param}
	tile {ProcessSendTileCmd $proc $id $param}
	update {}
	version {ProcessSendVersionCmd $proc $id $param}
	view {ProcessSendViewCmd $proc $id $param}
	vo {ProcessSendVOCmd $proc $id $param}
	wcs {ProcessSendWCSCmd $proc $id $param}
	web {ProcessSendWebCmd $proc $id $param}
	width {ProcessSendWidthCmd $proc $id $param}
	zscale {ProcessSendZScaleCmd $proc $id $param}
	zoom {ProcessSendZoomCmd $proc $id $param} 
	default {
	    Error "[msgcat::mc {Unknown command}]: $cmd"
	    $proc $id {}
	}
    }
    }
}


