// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fvcontour_h__
#define __fvcontour_h__

#include "vector.h"
#include "contour.h"
#include "frscale.h"
#include "inversescale.h"

static char *methodName_[] = { 
  "smooth",
  "block"
};

class FVContour : public Contour {
 public:
  enum Method {SMOOTH, BLOCK};

 private:
  enum {top, right, bottom, left, none};

  Method method_;
  char* level_;
  int numLevel_;
  int smooth_;
  FrScale::ColorScaleType colorScaleType_;
  float expo_;
  float clipMode_;
  Vector limits_;

  InverseScale* scale;

  void unity(FitsImage*);
  void bin(FitsImage*);
  void nobin(FitsImage*);
  void convolve(FitsImage*, double*, double*, int);
  double* tophat(int);
  double* gaussian(int);
  int build(long xdim, long ydim, double *image, Matrix&);
  int trace(long xdim, long ydim, double cntr,
	    long xCell, long yCell, int side,
	    double** rows, char* useGrid, Matrix&);

public:
  FVContour(Base*, FitsImage*, const char*, int, int, 
	    Method, int, int, const char*, FrScale::ColorScaleType, float,
	    float, Vector, InverseScale*);
  ~FVContour();

  void append(FitsImage*);
  void update(FitsImage*);

  int method() {return method_;}
  const char* methodName() {return methodName_[method_];}
  char* level() {return level_;}
  int numLevel() {return numLevel_;}
  int smooth() {return smooth_;}
  int colorScaleType() {return colorScaleType_;}
  float expo() {return expo_;}
  float clipMode() {return clipMode_;}
  Vector limits() {return limits_;}
};

#endif
