// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "raytrace.h"

RayTrace::RayTrace()
{
  az_ =0;
  el_ =0;
  zbuf_ =NULL;
  mkzbuf_ =NULL;

  next_ =NULL;
  previous_ =NULL;
}

RayTrace::RayTrace(double az, double el)
{
  az_ = az;
  el_ = el;
  zbuf_ = NULL;
  mkzbuf_ = NULL;

  next_ =NULL;
  previous_ =NULL;
}

RayTrace::~RayTrace()
{
  if (zbuf_)
    delete [] zbuf_;
  if (mkzbuf_)
    delete [] mkzbuf_;
}

