#  Copyright (C) 1999-2014
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CrosshairDef {} {
    global crosshair

    set crosshair(lock) none
}

proc ButtonCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair canvas $x $y
    LockCrosshair $which
}

proc ArrowKeyCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair warp $x $y
    LockCrosshair $which

    set coord [$which get crosshair canvas]
    set X [lindex $coord 0]
    set Y [lindex $coord 1]

    UpdateColormapLevelMosaic $which $X $Y canvas
    UpdateInfoBox $which $X $Y canvas
    UpdatePixelTableDialog $which $X $Y canvas
    UpdateGraph $which $X $Y canvas
}

proc MatchCrosshairCurrent {sys} {
    global current

    if {$current(frame) != {}} {
	MatchCrosshair $current(frame) $sys
    }
}

proc MatchCrosshair {which sys} {
    global crosshair
    global ds9
    global current

    if {$current(mode) != {crosshair}} {
	return
    }

    switch -- $sys {
	image -
	physical -
	amplifier -
	detector {
	    set coord [$which get crosshair $sys scientific]
	    foreach ff $ds9(frames) {
		if {$ff != $which} {
		    $ff crosshair $sys $coord 
		}
	    }
	}
	wcs {
	    set ss [lindex [$which get wcs] 0]
	    if {[$which has wcs $ss]} {
		set coord [$which get crosshair $ss scientific]
		foreach ff $ds9(frames) {
		    if {$ff != $which} {
			if {[$ff has wcs $ss]} {
			    $ff crosshair $ss $coord 
			}
		    }
		}
	    }
	}
    }
}

proc LockCrosshairCurrent {} {
    global current
    
    if {$current(frame) != {}} {
	LockCrosshair $current(frame)
    }
}

proc LockCrosshair {which} {
    global crosshair

    switch -- $crosshair(lock) {
	none {}
	default {MatchCrosshair $which $crosshair(lock)}
    }
}

proc ProcessCrosshairCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global current
    global ds9
    global crosshair

    # we need to be realized
    ProcessRealizeDS9

    switch -- [string tolower [lindex $var $i]] {
	match {
	    incr i
	    MatchCrosshairCurrent [lindex $var $i]
	}
	lock {
	    incr i
	    set crosshair(lock) [lindex $var $i]
	    LockCrosshairCurrent
	}
	default {
	    set x [lindex $var [expr $i+0]]
	    set y [lindex $var [expr $i+1]]
	    set sys [lindex $var [expr $i+2]]
	    set sky [lindex $var [expr $i+3]]
	    set format {}

	    incr i 1
	    incr i [FixSpec sys sky format physical fk5 degrees]

	    set current(mode) crosshair
	    ChangeMode

	    if {$current(frame) != {}} {
		$current(frame) crosshair $sys $sky $x $y
		set coord [$current(frame) get crosshair canvas]
		UpdateColormapLevelMosaic $current(frame) \
		    [lindex $coord 0] [lindex $coord 1] canvas
		UpdateInfoBox $current(frame) \
		    [lindex $coord 0] [lindex $coord 1] canvas

		if {$crosshair(lock) != "none"} {
		    set coord [$current(frame) get crosshair $crosshair(lock) scientific]
		    foreach f $ds9(frames) {
			if {$f != $current(frame) && [$f has system $crosshair(lock)]} {
			    $f crosshair $crosshair(lock) $coord
			}
		    }
		}
	    }
	}
    }
}

proc ProcessSendCrosshairCmd {proc id param} {
    global crosshair
    global current

    switch -- [string tolower $param] {
	lock {$proc $id "$crosshair(lock)\n"}
	default {
	    set sys [lindex $param 0]
	    set sky [lindex $param 1]
	    set format [lindex $param 2]
	    FixSpec sys sky format physical fk5 degrees

	    if {$current(frame) != {}} {
		$proc $id "[$current(frame) get crosshair $sys $sky $format]\n"
	    }
	}
    }
}

