/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.List;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.AbstractFetchCommand;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_updateRemoteRefsFromAnotherRepository")
class Fetch
extends AbstractFetchCommand {
    @Option(name="--timeout", metaVar="metaVar_seconds", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Option(name="--fsck", usage="usage_performFsckStyleChecksOnReceive")
    private Boolean fsck;
    @Option(name="--prune", usage="usage_pruneStaleTrackingRefs")
    private Boolean prune;
    @Option(name="--dry-run")
    private boolean dryRun;
    @Option(name="--thin", usage="usage_fetchThinPack")
    private Boolean thin;
    @Argument(index=0, metaVar="metaVar_uriish")
    private String remote = "origin";
    @Argument(index=1, metaVar="metaVar_refspec")
    private List<RefSpec> toget;

    Fetch() {
    }

    @Option(name="--no-fsck")
    void nofsck(boolean ignored) {
        this.fsck = Boolean.FALSE;
    }

    @Option(name="--no-thin")
    void nothin(boolean ignored) {
        this.thin = Boolean.FALSE;
    }

    protected void run() throws Exception {
        Git git = new Git(this.db);
        FetchCommand fetch = git.fetch();
        if (this.fsck != null) {
            fetch.setCheckFetchedObjects(this.fsck.booleanValue());
        }
        if (this.prune != null) {
            fetch.setRemoveDeletedRefs(this.prune.booleanValue());
        }
        if (this.toget != null) {
            fetch.setRefSpecs(this.toget);
        }
        if (0 <= this.timeout) {
            fetch.setTimeout(this.timeout);
        }
        fetch.setDryRun(this.dryRun);
        fetch.setRemote(this.remote);
        if (this.thin != null) {
            fetch.setThin(this.thin.booleanValue());
        }
        fetch.setProgressMonitor((ProgressMonitor)new TextProgressMonitor());
        FetchResult result = fetch.call();
        if (result.getTrackingRefUpdates().isEmpty()) {
            return;
        }
        this.showFetchResult(result);
    }
}

