/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(usage="usage_Status", common=true)
class Status
extends TextBuiltin {
    protected final String lineFormat;
    protected final String statusFileListFormat;
    protected final String statusFileListFormatWithPrefix;

    Status() {
        this.lineFormat = CLIText.get().lineFormat;
        this.statusFileListFormat = CLIText.get().statusFileListFormat;
        this.statusFileListFormatWithPrefix = CLIText.get().statusFileListFormatWithPrefix;
    }

    @Override
    protected void run() throws Exception {
        int nbUntracked;
        int nbUnmerged;
        Ref head = this.db.getRef("HEAD");
        boolean firstHeader = true;
        if (head != null && head.isSymbolic()) {
            String branch = Repository.shortenRefName((String)head.getLeaf().getName());
            this.outw.println(CLIText.formatLine(MessageFormat.format(CLIText.get().onBranch, branch)));
        } else {
            this.outw.println(CLIText.formatLine(CLIText.get().notOnAnyBranch));
        }
        org.eclipse.jgit.api.Status status = new Git(this.db).status().call();
        Set added = status.getAdded();
        Set changed = status.getChanged();
        Set removed = status.getRemoved();
        Set modified = status.getModified();
        Set missing = status.getMissing();
        Set untracked = status.getUntracked();
        Set unmerged = status.getConflicting();
        ArrayList<String> toBeCommitted = new ArrayList<String>(added);
        toBeCommitted.addAll(changed);
        toBeCommitted.addAll(removed);
        int nbToBeCommitted = toBeCommitted.size();
        if (nbToBeCommitted > 0) {
            this.printSectionHeader(CLIText.get().changesToBeCommitted, new Object[0]);
            this.printList(CLIText.get().statusNewFile, CLIText.get().statusModified, CLIText.get().statusRemoved, toBeCommitted, added, changed, removed);
            firstHeader = false;
        }
        ArrayList<String> notStagedForCommit = new ArrayList<String>(modified);
        notStagedForCommit.addAll(missing);
        int nbNotStagedForCommit = notStagedForCommit.size();
        if (nbNotStagedForCommit > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().changesNotStagedForCommit, new Object[0]);
            this.printList(CLIText.get().statusModified, CLIText.get().statusRemoved, null, notStagedForCommit, modified, missing, null);
            firstHeader = false;
        }
        if ((nbUnmerged = unmerged.size()) > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().unmergedPaths, new Object[0]);
            this.printList(unmerged);
            firstHeader = false;
        }
        if ((nbUntracked = untracked.size()) > 0) {
            if (!firstHeader) {
                this.printSectionHeader("", new Object[0]);
            }
            this.printSectionHeader(CLIText.get().untrackedFiles, new Object[0]);
            this.printList(untracked);
        }
    }

    protected void printSectionHeader(String pattern, Object ... arguments) throws IOException {
        this.outw.println(CLIText.formatLine(MessageFormat.format(pattern, arguments)));
        if (!pattern.equals("")) {
            this.outw.println(CLIText.formatLine(""));
        }
        this.outw.flush();
    }

    protected int printList(Collection<String> list) throws IOException {
        if (!list.isEmpty()) {
            ArrayList<String> sortedList = new ArrayList<String>(list);
            Collections.sort(sortedList);
            for (String filename : sortedList) {
                this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormat, filename)));
            }
            this.outw.flush();
            return list.size();
        }
        return 0;
    }

    protected int printList(String status1, String status2, String status3, Collection<String> list, Collection<String> set1, Collection<String> set2, Collection<String> set3) throws IOException {
        ArrayList<String> sortedList = new ArrayList<String>(list);
        Collections.sort(sortedList);
        for (String filename : sortedList) {
            String prefix = set1.contains(filename) ? status1 : (set2.contains(filename) ? status2 : status3);
            this.outw.println(CLIText.formatLine(String.format(this.statusFileListFormatWithPrefix, prefix, filename)));
            this.outw.flush();
        }
        return list.size();
    }
}

