/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.iplog.IpLogText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CSV {
    private final BufferedReader in;
    private List<String> columns;

    CSV(BufferedReader br) throws IOException {
        this.in = br;
        this.columns = this.readLine();
    }

    Map<String, String> next() throws IOException {
        List<String> row = this.readLine();
        if (this.columns == null || row == null) {
            return null;
        }
        LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
        for (int col = 0; col < this.columns.size(); ++col) {
            r.put(this.columns.get(col), row.get(col));
        }
        return r;
    }

    private List<String> readLine() throws IOException {
        String line = this.in.readLine();
        if (line == null || line.length() == 0) {
            return null;
        }
        ArrayList<String> row = this.columns != null ? new ArrayList(this.columns.size()) : new ArrayList<String>();
        int p = 0;
        while (p < line.length()) {
            if (line.charAt(p) == '\"') {
                ++p;
                StringBuilder b = new StringBuilder();
                block5: while (p < line.length()) {
                    char c = line.charAt(p);
                    switch (c) {
                        case '\"': {
                            ++p;
                            break block5;
                        }
                        case '\\': {
                            b.append(line.charAt(p + 1));
                            p += 2;
                            continue block5;
                        }
                        default: {
                            b.append(c);
                            ++p;
                            continue block5;
                        }
                    }
                }
                if (p < line.length() && line.charAt(p) != ',') {
                    throw new IOException(MessageFormat.format(IpLogText.get().CSVParsingError, line));
                }
                row.add(b.toString());
                ++p;
                continue;
            }
            if (line.charAt(p) == ',') {
                row.add("");
                if (++p != line.length()) continue;
                row.add("");
                continue;
            }
            int comma = line.indexOf(44, p);
            row.add(line.substring(p, comma));
            p = comma + 1;
        }
        return row;
    }
}

