(define (iota l h)
  (letrec
    ((j (lambda (x r)
          (cond ((= x l) (cons l r))
                (else (j (- x 1) (cons x r)))))))
    (cond ((> l h) (error "iota: bad range" (list l h)))
          (else (j h '())))))

(define (unsort a seed)
  (letrec
    ((remove-nth
       (lambda (a n r)
         (cond ((zero? n) 
                 (cond ((null? a) (reverse r))
                       (else (append (cdr a) (reverse r)))))
               (else (remove-nth (cdr a)
                                 (- n 1)
                                 (cons (car a) r))))))
     (unsort4
       (lambda (a n k r)
         (cond ((zero? k) (cons (car a) r))
               (else (unsort4 (remove-nth a n '())
                              (remainder (car a) k)
                              (- k 1)
                              (cons (list-ref a n) r)))))))
    (unsort4 a seed (- (length a) 1) '())))

(define (mergesort p a)
  (letrec
    ((split
       (lambda (a r1 r2)
         (cond
           ((or (null? a) (null? (cdr a)))
             (list (reverse r2) r1))
           (else (split (cddr a)
                        (cdr r1)
                        (cons (car r1) r2))))))
     (merge
       (lambda (a b r)
         (cond
           ((null? a)
             (if (null? b)
                 r
                 (merge a (cdr b) (cons (car b) r))))
           ((null? b)
             (merge (cdr a) b (cons (car a) r)))
           ((p (car a) (car b))
             (merge a (cdr b) (cons (car b) r)))
           (else (merge (cdr a) b (cons (car a) r))))))
     (sort
       (lambda (a)
         (cond
           ((or (null? a) (null? (cdr a)))
             a)
           (else (let ((p* (split a a '())))
                   (merge (reverse (sort (car p*)))
                          (reverse (sort (cadr p*)))
                          '())))))))
    (sort a)))

(define set1 (iota 1 1000))
(define set2 (reverse set1))
(define set3 (unsort set1 0))

(if (not (apply < (mergesort < set1))) (error "mergesort of set1 failed"))
(if (not (apply < (mergesort < set2))) (error "mergesort of set2 failed"))
(if (not (apply < (mergesort < set3))) (error "mergesort of set3 failed"))

