module Schleuder
  class Archiver
    def archive(mail)
      Schleuder.log.info "Archiving email"
      mail2archive = mail.individualize_member(_receiver)

      # TODO: wrap that duplicated code out into it's dedicated method
      begin
        encrypted, errmsg = mail2archive.encrypt!(_receiver)
      rescue GPGME::Error::UnusablePublicKey => e
        # This exception is thrown, if the public key of a certain list
        # member is not usable (because it is revoked, expired, disabled or
        # invalid).
        k = e.keys.first
        key = mail2archive.crypt.get_key(k.fpr).first
        errmsg = "#{e.message}: (#{k.class})\n#{key.to_s}"
        encrypted = false
      rescue GPGME::Error::General => e
        errmsg = e.message
        encrypted = false
      end

      if encrypted
        _dump(mail2archive)
      else
        Schleuder.log.error("Could not encrypt message with list's key to archive it. Skipping archiving of message...\n\nError Message: #{errmsg}")
      end
    end

    private

    def _dump(mail)
      now = Time.now
      dump_dir = File.join(Schleuder.list.listdir,'archive',[:year,:month,:day].collect{|m| now.send(m).to_s })
      require 'fileutils'
      FileUtils.mkdir_p dump_dir unless File.directory? dump_dir
      msg_file = File.join(dump_dir,"#{Time.now.strftime('%H%M%S')}-#{mail.message_id[1..-2]}")
      Schleuder.log.info("Archiving message to #{msg_file}")
      File.open(msg_file,"w") { |f| f << mail.to_s }
    end

    def _receiver
      @receiver ||= Member.new('email' => Schleuder.list.config.myaddr)
    end
  end
end
