module Schleuder
  class Member < Storage
    schleuder_attr :email, nil
    schleuder_attr :mime, 'MIME'
    # only send encrypted mail to this member 
    schleuder_attr :encrypted_only, false
    schleuder_attr :key_fingerprint, nil

    def initialize(config_file, fromfile=true)
      super(config_file, fromfile)

      # compress fingerprint
      self.key_fingerprint = self.key_fingerprint
    end

    def to_hash
      Hash[*self.class.default_schleuder_attributes.keys.collect { |key|
        unless (val = send(key)).to_s.empty?
          [ key, val ]
        else
          nil
        end
      }.flatten.compact]
    end

    def key_fingerprint=(fpr)
      schleuder_attributes['key_fingerprint'] = Schleuder::Utils.compress_fingerprint(fpr)
    end

    def to_s
      email
    end

    def key(only_valid_keys=true)
      if @key.nil? || !only_valid_keys # by default we want only valid keys. If
                                       # we ask also for invalid keys we want
                                       # to redo the keylookup
        lookup_str = self.key_fingerprint.nil? ? self.email : self.key_fingerprint
        key_result = crypt.get_key(lookup_str,only_valid_keys)
        if k = key_result.first
          @key = k
          self.key_fingerprint = @key.subkeys.first.fingerprint
        else
          @key = nil
          self.key_fingerprint = nil
          return key_result
        end
      end
      @key
    end

    def uses_key?(other_key)
      key # initialize @key
      !@key.nil? && @key.subkeys.first.fingerprint == other_key.subkeys.first.fingerprint
    end

    def key_descr
      k, msg = key
      k ? crypt.key_descr(k) : "*Warning:* #{msg}"
    end

    private
    def crypt
      # No simple way to get hands on mail.crypt, so we create another here.
      # But on class side as it does not need to be per member
      @@crypt ||= Crypt.new(nil)
    end
  end
end
