module Schleuder
  class ManageMembersPlugin < Plugin
    def initialize
      @plugin_type = :request
    end

    def get_members(mail, value)
      # TODO: deprecation-notice
      Schleuder.log.debug 'GET-MEMBERS requested'
      get_membersfile
    end

    def save_members(mail, value)
      # TODO: deprecation-notice
      Schleuder.log.debug 'SAVE-MEMBERS requested'
      if mail.body.strip.empty?
        "Error, empty input. You need to write the members list yaml-formatted into the body."
      else
        Schleuder.list.members = YAML.load(mail.body)
        "Saving was successful.\n\nCurrent members.conf:\n\n#{get_membersfile}\n"
      end
    end

    def add_member(mail, value)
      Schleuder.log.debug 'ADD-MEMBER requested'
      addmember(mail, value, mail.body)
    end

    def delete_member(mail, value)
      Schleuder.log.debug 'DELETE-MEMBER requested'
      deletemember(mail, value)
    end

    def list_members(mail, value)
      Schleuder.log.debug 'LIST-MEMBERS requested'
      listmembers(mail)
    end

    def get_member(mail, value)
      Schleuder.log.debug 'GET-MEMBER requested'
      getmember(mail, value)
    end

    def listmembers(mail)
      msg = ''
      msg << "Default mime-setting for this list: #{Schleuder.list.config.default_mime.downcase}.\n"
      msg << "\nAdmins for this list:\n\n#{_list_members(Schleuder.list.config.admins)}"
      msg << "\n\nMembers:\n\n#{_list_members(Schleuder.list.members)}"
      msg
    end

    def _list_members(members)
      members.collect { |member|
        res = member.email.dup
        res << " (mime: #{member.mime.downcase})" if member.mime && !member.mime.downcase.eql?(Schleuder.list.config.default_mime.downcase)
        res << " :: #{_list_keys(member)}\n\n"
      }.join('')
    end

    def _list_keys(member)
      result = ''
      key, msg = member.key(false) # also get a potentially expired key -> will
                                   # also inform about multiple keys on the list
                                   # that might not me the case otherwise
      if key
        if key.trust.eql?(:expired)
          result << "*Warning*: Key expired! "
        elsif key.trust.eql?(:revoked)
          result << "*Warning*: Key revoked! "
        end
        result << member.key_descr
      else
        result << "*Warning*: #{msg}"
      end
      result
    end

    def addmember(mail, string, key)
      email, mime = string.split(' ')
      mem = Member.new({:email => email})
      mem.mime = mime if mime
      # TODO: test if address already subscribed
      Schleuder.list.members = Schleuder.list.members << mem
      msg = "#{mem}\n--> Member saved.\n\n"
      if key
        mail.crypt.add_key(key).imports.each do |i|
          msg << "#{mail.crypt.key_descr(mail.crypt.get_key(i.fpr))}\n"
          if i.status.eql? 1
            msg << "--> Key imported.\n\n"
          else
            msg << "--> Key *not* imported (no error, maybe already present?).\n\n"
          end
        end
        msg << "\n"
      end
      msg << "Updated members-list:\n\n#{_list_members(mail)}"
      msg
    end

    def deletemember(mail, string)
      msg = ''
      members = Schleuder.list.members.dup
      members.delete_if {|mem| mem.email.eql?(string)}
      if members.eql? Schleuder.list.members
        msg << "Member #{string} not found"
      else
        if Schleuder.list.members = members
          msg << "Member #{string} deleted.\n"
        else
          msg = "Something failed. Please ask the maintainer of this list to figure out what\nhappened (e.g. by mailing to #{Schleuder.list.owner_addr}).\n"
        end
      end
      msg << "\nUpdated members-list:\n\n#{_list_members(mail)}\n"
      msg
    end

    def getmember(mail, string)
      Schleuder.log.debug "string: #{string.inspect}"
      msg = ''
      member = Schleuder.list.find_member_by_email string
      unless member
        return "Member #{string} not found.\n"
      end
      msg << "Email: #{member.email}\nMime: "
      if member.mime
        msg << member.mime.downcase
      else
        msg << "#{Schleuder.list.config.default_mime.downcase} (list-default)"
      end
      msg << "\n\n"
      keys = mail.crypt.list_keys(member.email)
      if keys.empty?
        msg << "*Warning*: No key!\n\n"
      else
        if keys.size > 1
          msg << "*Warning*: Multiple keys!\n\n"
        end
        msg << "Key(s):\n\n"
        keys.each do |key|
          msg << "#{key.to_s}Fingerprint: #{key.subkeys.first.fpr}\n\n"
        end
      end
      msg
    end

    private
    def get_membersfile
        File.read(Schleuder.list.members_file)
    end
  end
end

