/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_field_seek(char * fname)
{
  int * sql_res_pointer_in = NULL;
  int * offset_in = NULL;
  MYSQL_RES * mysql_res_ptr = NULL;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double result, doffset_in;

  CheckRhs(2,2);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_res_pointer_in);
  getPointer(pvApiCtx, sql_res_pointer_in, &ptr_in);
  mysql_res_ptr = (MYSQL_RES *)ptr_in;

  if (mysql_res_ptr==NULL)
    {
      Scierror(999,"%s: problem with the mysql_res pointer\n", fname);
      return 0;
    }

  _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &offset_in);
  getScalarDouble(pvApiCtx, offset_in, &doffset_in);

  result = (double)mysql_field_seek(mysql_res_ptr, (MYSQL_FIELD_OFFSET)doffset_in);

  createScalarDouble(pvApiCtx, Rhs+1, doffset_in);

  LhsVar(1) = Rhs+1;

  return 0;
}
