/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_hex_string(char * fname)
{
  int * from_in = NULL;
  char * to = NULL, * cfrom_in = NULL;
  int res_out = 0;
  SciErr _SciErr;

  CheckRhs(2,2);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &from_in);
  getAllocatedSingleString(pvApiCtx, from_in, &cfrom_in);

  to = (char *)MALLOC((2*strlen(cfrom_in)+1)*sizeof(char));

  res_out = mysql_hex_string(to, cfrom_in, strlen(cfrom_in));

  createSingleString(pvApiCtx, Rhs+1, to);

  FREE(to);
  freeAllocatedSingleString(cfrom_in);

  LhsVar(1) = Rhs+1;

  return 0;
}
