/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009 - DIGITEO - Allan SIMON
 * Copyright (C) 2009 - DIGITEO - Vincent COUVERT
 * Copyright (C) 2010 - DIGITEO - Clément DAVID
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

package org.scilab.modules.xcos.actions;

import java.awt.event.ActionEvent;

import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.utils.ScilabAboutBox;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.utils.XcosMessages;


/**
 * Display about box for Xcos
 */
public class AboutXcosAction extends DefaultAction {
	/** Name of the action */
	public static final String NAME = XcosMessages.ABOUT_XCOS;
	/** Icon name of the action */
	public static final String SMALL_ICON = "";
	/** Mnemonic key of the action */
	public static final int MNEMONIC_KEY = 0;
	/** Accelerator key for the action */
	public static final int ACCELERATOR_KEY = 0;

	/**
	 * Constructor
	 * @param scilabGraph associated Scilab graph
	 */
	public AboutXcosAction(ScilabGraph scilabGraph) {
		super(scilabGraph);
	}

	/**
	 * Menu created for "Help menu"
	 * @param scilabGraph associated Scilab graph
	 * @return the menu
	 */
	public static MenuItem createMenu(ScilabGraph scilabGraph) {
		return createMenu(scilabGraph, AboutXcosAction.class);
	}
	
	/**
	 * @param e parameter
	 * @see org.scilab.modules.graph.actions.base.DefaultAction#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		String[] contents = {
				Xcos.TRADENAME,
				"",
				XcosMessages.DIGITEO,
				XcosMessages.COPYRIGHT_INRIA,
				"",
				XcosMessages.SCICOS_BASED};
		
		ScilabAboutBox.createAboutBox(XcosMessages.ABOUT_XCOS, contents, null, null);
    	
    }
}
