/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_archive")
class Archive
extends TextBuiltin {
    @Argument(index=0, metaVar="metaVar_treeish")
    private AbstractTreeIterator tree;
    @Option(name="--format", metaVar="metaVar_archiveFormat", usage="usage_archiveFormat")
    private Format format = Format.ZIP;
    private static final Map<Format, Archiver> formats;

    Archive() {
    }

    protected void run() throws Exception {
        TreeWalk walk = new TreeWalk(this.db);
        ObjectReader reader = walk.getObjectReader();
        MutableObjectId idBuf = new MutableObjectId();
        Archiver fmt = formats.get((Object)this.format);
        ArchiveOutputStream outa = fmt.createArchiveOutputStream(this.outs);
        if (this.tree == null) {
            throw Archive.die(CLIText.get().treeIsRequired);
        }
        walk.reset();
        walk.addTree(this.tree);
        walk.setRecursive(true);
        while (walk.next()) {
            String name = walk.getPathString();
            FileMode mode = walk.getFileMode(0);
            if (mode == FileMode.TREE) continue;
            walk.getObjectId(idBuf, 0);
            fmt.putEntry(name, mode, reader.open((AnyObjectId)idBuf), outa);
        }
        outa.close();
    }

    private static void warnArchiveEntryModeIgnored(String name) {
        System.err.println(MessageFormat.format(CLIText.get().archiveEntryModeIgnored, name));
    }

    static {
        EnumMap<Format, Archiver> fmts = new EnumMap<Format, Archiver>(Format.class);
        fmts.put(Format.ZIP, new Archiver(){

            public ArchiveOutputStream createArchiveOutputStream(OutputStream s) {
                return new ZipArchiveOutputStream(s);
            }

            public void putEntry(String path, FileMode mode, ObjectLoader loader, ArchiveOutputStream out) throws IOException {
                ZipArchiveEntry entry = new ZipArchiveEntry(path);
                if (mode != FileMode.REGULAR_FILE) {
                    if (mode == FileMode.EXECUTABLE_FILE || mode == FileMode.SYMLINK) {
                        entry.setUnixMode(mode.getBits());
                    } else {
                        Archive.warnArchiveEntryModeIgnored(path);
                    }
                }
                entry.setSize(loader.getSize());
                out.putArchiveEntry((ArchiveEntry)entry);
                loader.copyTo((OutputStream)out);
                out.closeArchiveEntry();
            }
        });
        fmts.put(Format.TAR, new Archiver(){

            public ArchiveOutputStream createArchiveOutputStream(OutputStream s) {
                return new TarArchiveOutputStream(s);
            }

            public void putEntry(String path, FileMode mode, ObjectLoader loader, ArchiveOutputStream out) throws IOException {
                if (mode == FileMode.SYMLINK) {
                    TarArchiveEntry entry = new TarArchiveEntry(path, 50);
                    entry.setLinkName(new String(loader.getCachedBytes(100), "UTF-8"));
                    out.putArchiveEntry((ArchiveEntry)entry);
                    out.closeArchiveEntry();
                    return;
                }
                TarArchiveEntry entry = new TarArchiveEntry(path);
                if (mode == FileMode.REGULAR_FILE || mode == FileMode.EXECUTABLE_FILE) {
                    entry.setMode(mode.getBits());
                } else {
                    Archive.warnArchiveEntryModeIgnored(path);
                }
                entry.setSize(loader.getSize());
                out.putArchiveEntry((ArchiveEntry)entry);
                loader.copyTo((OutputStream)out);
                out.closeArchiveEntry();
            }
        });
        formats = fmts;
    }

    private static interface Archiver {
        public ArchiveOutputStream createArchiveOutputStream(OutputStream var1);

        public void putEntry(String var1, FileMode var2, ObjectLoader var3, ArchiveOutputStream var4) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        ZIP,
        TAR;

    }
}

