/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.LockFile;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RebuildCommitGraph
extends TextBuiltin {
    private static final String REALLY = "--destroy-this-repository";
    @Option(name="--destroy-this-repository", usage="usage_approveDestructionOfRepository")
    boolean really;
    @Argument(index=0, required=true, metaVar="metaVar_refs", usage="usage_forEachRefOutput")
    File refList;
    @Argument(index=1, required=true, metaVar="metaVar_refs", usage="usage_logAllPretty")
    File graph;
    private final ProgressMonitor pm = new TextProgressMonitor();
    private Map<ObjectId, ObjectId> rewrites = new HashMap<ObjectId, ObjectId>();

    RebuildCommitGraph() {
    }

    @Override
    protected void run() throws Exception {
        if (!this.really && !this.db.getAllRefs().isEmpty()) {
            System.err.println(MessageFormat.format(CLIText.get().fatalThisProgramWillDestroyTheRepository, this.db.getDirectory().getAbsolutePath(), REALLY));
            throw RebuildCommitGraph.die(CLIText.get().needApprovalToDestroyCurrentRepository);
        }
        if (!this.refList.isFile()) {
            throw RebuildCommitGraph.die(MessageFormat.format(CLIText.get().noSuchFile, this.refList.getPath()));
        }
        if (!this.graph.isFile()) {
            throw RebuildCommitGraph.die(MessageFormat.format(CLIText.get().noSuchFile, this.graph.getPath()));
        }
        this.recreateCommitGraph();
        this.detachHead();
        this.deleteAllRefs();
        this.recreateRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateCommitGraph() throws IOException {
        RevWalk rw = new RevWalk(this.db);
        HashMap<ObjectId, ToRewrite> toRewrite = new HashMap<ObjectId, ToRewrite>();
        ArrayList<ToRewrite> queue = new ArrayList<ToRewrite>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.graph), Constants.CHARSET));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("[ \t]{1,}");
                ObjectId oldId = ObjectId.fromString((String)parts[0]);
                try {
                    rw.parseCommit((AnyObjectId)oldId);
                }
                catch (MissingObjectException mue) {
                    long time = Long.parseLong(parts[1]) * 1000L;
                    ObjectId[] parents = new ObjectId[parts.length - 2];
                    for (int i = 0; i < parents.length; ++i) {
                        parents[i] = ObjectId.fromString((String)parts[2 + i]);
                    }
                    ToRewrite t = new ToRewrite(oldId, time, parents);
                    toRewrite.put(oldId, t);
                    queue.add(t);
                }
            }
        }
        finally {
            br.close();
        }
        this.pm.beginTask("Rewriting commits", queue.size());
        ObjectInserter oi = this.db.newObjectInserter();
        ObjectId emptyTree = oi.insert(2, new byte[0]);
        PersonIdent me = new PersonIdent("jgit rebuild-commitgraph", "rebuild-commitgraph@localhost");
        while (!queue.isEmpty()) {
            ListIterator itr = queue.listIterator(queue.size());
            queue = new ArrayList();
            block8: while (itr.hasPrevious()) {
                ToRewrite t = (ToRewrite)itr.previous();
                ObjectId[] newParents = new ObjectId[t.oldParents.length];
                for (int k = 0; k < t.oldParents.length; ++k) {
                    ToRewrite p = (ToRewrite)toRewrite.get(t.oldParents[k]);
                    if (p != null) {
                        if (p.newId == null) {
                            queue.add(t);
                            continue block8;
                        }
                        newParents[k] = p.newId;
                        continue;
                    }
                    newParents[k] = t.oldParents[k];
                }
                CommitBuilder newc = new CommitBuilder();
                newc.setTreeId((AnyObjectId)emptyTree);
                newc.setAuthor(new PersonIdent(me, new Date(t.commitTime)));
                newc.setCommitter(newc.getAuthor());
                newc.setParentIds(newParents);
                newc.setMessage("ORIGINAL " + t.oldId.name() + "\n");
                t.newId = oi.insert(newc);
                this.rewrites.put(t.oldId, t.newId);
                this.pm.update(1);
            }
        }
        oi.flush();
        oi.release();
        this.pm.endTask();
    }

    private void detachHead() throws IOException {
        String head = this.db.getFullBranch();
        ObjectId id = this.db.resolve("HEAD");
        if (!ObjectId.isId((String)head) && id != null) {
            LockFile lf = new LockFile(new File(this.db.getDirectory(), "HEAD"), this.db.getFS());
            if (!lf.lock()) {
                throw new IOException(MessageFormat.format(CLIText.get().cannotLock, "HEAD"));
            }
            lf.write(id);
            if (!lf.commit()) {
                throw new IOException(CLIText.get().cannotDeatchHEAD);
            }
        }
    }

    private void deleteAllRefs() throws Exception {
        RevWalk rw = new RevWalk(this.db);
        for (Ref r : this.db.getAllRefs().values()) {
            if ("HEAD".equals(r.getName())) continue;
            RefUpdate u = this.db.updateRef(r.getName());
            u.setForceUpdate(true);
            u.delete(rw);
        }
    }

    private void recreateRefs() throws Exception {
        Map<String, Ref> refs = this.computeNewRefs();
        new RefWriter(refs.values()){

            protected void writeFile(String name, byte[] content) throws IOException {
                File file = new File(RebuildCommitGraph.this.db.getDirectory(), name);
                LockFile lck = new LockFile(file, RebuildCommitGraph.this.db.getFS());
                if (!lck.lock()) {
                    throw new ObjectWritingException(MessageFormat.format(CLIText.get().cantWrite, file));
                }
                try {
                    lck.write(content);
                }
                catch (IOException ioe) {
                    throw new ObjectWritingException(MessageFormat.format(CLIText.get().cantWrite, file));
                }
                if (!lck.commit()) {
                    throw new ObjectWritingException(MessageFormat.format(CLIText.get().cantWrite, file));
                }
            }
        }.writePackedRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Ref> computeNewRefs() throws IOException {
        RevWalk rw = new RevWalk(this.db);
        HashMap<String, Ref> refs = new HashMap<String, Ref>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.refList), Constants.CHARSET));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("[ \t]{1,}");
                ObjectId origId = ObjectId.fromString((String)parts[0]);
                String type = parts[1];
                String name = parts[2];
                ObjectId id = this.rewrites.get(origId);
                if (id == null) {
                    id = origId;
                }
                try {
                    rw.parseAny((AnyObjectId)id);
                }
                catch (MissingObjectException mue) {
                    if (!"commit".equals(type)) {
                        System.err.println(MessageFormat.format(CLIText.get().skippingObject, type, name));
                        continue;
                    }
                    throw new MissingObjectException(id, type);
                }
                refs.put(name, (Ref)new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name, id));
            }
        }
        finally {
            rw.release();
            br.close();
        }
        return refs;
    }

    private static class ToRewrite {
        final ObjectId oldId;
        final long commitTime;
        final ObjectId[] oldParents;
        ObjectId newId;

        ToRewrite(ObjectId o, long t, ObjectId[] p) {
            this.oldId = o;
            this.commitTime = t;
            this.oldParents = p;
        }
    }
}

