/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.net.URL;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.CommandCatalog;
import org.eclipse.jgit.pgm.CommandRef;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Option;

@Command(usage="usage_displayAListOfAllRegisteredJgitCommands")
class ShowCommands
extends TextBuiltin {
    @Option(name="--pretty", metaVar="metaVar_commandDetail", usage="usage_alterTheDetailShown")
    private Format pretty = Format.USAGE;

    ShowCommands() {
    }

    protected void run() throws Exception {
        CommandRef[] list = CommandCatalog.all();
        int width = 0;
        for (CommandRef c : list) {
            width = Math.max(width, c.getName().length());
        }
        width += 2;
        for (CommandRef c : list) {
            System.err.print(c.isCommon() ? (char)'*' : ' ');
            System.err.print(' ');
            System.err.print(c.getName());
            for (int i = c.getName().length(); i < width; ++i) {
                System.err.print(' ');
            }
            this.pretty.print(c);
            System.err.println();
        }
        System.err.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Format {
        USAGE{

            void print(CommandRef c) {
                String usage = c.getUsage();
                if (usage != null && usage.length() > 0) {
                    System.err.print(CLIText.get().resourceBundle().getString(usage));
                }
            }
        }
        ,
        CLASSES{

            void print(CommandRef c) {
                System.err.print(c.getImplementationClassName());
            }
        }
        ,
        URLS{

            void print(CommandRef c) {
                ClassLoader ldr = c.getImplementationClassLoader();
                String cn = c.getImplementationClassName();
                URL url = ldr.getResource(cn = cn.replace('.', '/') + ".class");
                if (url == null) {
                    System.err.print(CLIText.get().notFound);
                    return;
                }
                String rn = url.toExternalForm();
                if (rn.endsWith(cn)) {
                    rn = rn.substring(0, rn.length() - cn.length());
                }
                System.err.print(rn);
            }
        };


        abstract void print(CommandRef var1);
    }
}

