/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.ClassAttributes;
import classycle.UnresolvedNode;
import classycle.graph.AtomicVertex;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class GraphBuilder {
    GraphBuilder() {
    }

    static AtomicVertex[] createGraph(UnresolvedNode[] unresolvedNodes, boolean mergeInnerClasses) {
        Arrays.sort(unresolvedNodes);
        Map vertices = GraphBuilder.createVertices(unresolvedNodes, mergeInnerClasses);
        AtomicVertex[] result = vertices.values().toArray(new AtomicVertex[0]);
        for (int i = 0; i < unresolvedNodes.length; ++i) {
            UnresolvedNode node = unresolvedNodes[i];
            String name = GraphBuilder.normalize(node.getAttributes().getName(), mergeInnerClasses);
            AtomicVertex vertex = (AtomicVertex)vertices.get(name);
            Iterator iterator = node.linkIterator();
            while (iterator.hasNext()) {
                name = GraphBuilder.normalize((String)iterator.next(), mergeInnerClasses);
                AtomicVertex head = (AtomicVertex)vertices.get(name);
                if (head == null) {
                    head = new AtomicVertex(ClassAttributes.createUnknownClass(name, 0));
                    vertices.put(name, head);
                }
                if (vertex == head) continue;
                vertex.addOutgoingArcTo(head);
            }
        }
        return result;
    }

    private static Map createVertices(UnresolvedNode[] unresolvedNodes, boolean mergeInnerClasses) {
        HashMap<String, AtomicVertex> vertices = new HashMap<String, AtomicVertex>();
        for (int i = 0; i < unresolvedNodes.length; ++i) {
            ClassAttributes attributes = unresolvedNodes[i].getAttributes();
            String type = attributes.getType();
            String originalName = attributes.getName();
            int size = attributes.getSize();
            String name = GraphBuilder.normalize(originalName, mergeInnerClasses);
            AtomicVertex vertex = (AtomicVertex)vertices.get(name);
            if (vertex != null) {
                ClassAttributes vertexAttributes = (ClassAttributes)vertex.getAttributes();
                size += vertexAttributes.getSize();
                if (!name.equals(originalName)) {
                    type = vertexAttributes.getType();
                }
                attributes.addSourcesOf(vertexAttributes);
            }
            ClassAttributes newAttributes = new ClassAttributes(name, null, type, size);
            newAttributes.addSourcesOf(attributes);
            vertex = new AtomicVertex(newAttributes);
            vertices.put(name, vertex);
        }
        return vertices;
    }

    private static String normalize(String name, boolean mergeInnerClasses) {
        int index;
        if (mergeInnerClasses && (index = name.indexOf(36)) >= 0) {
            name = name.substring(0, index);
        }
        return name;
    }
}

