/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import org.parboiled.Node;
import org.parboiled.common.ImmutableLinkedList;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.Matcher;
import org.parboiled.trees.ImmutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeImpl<V>
extends ImmutableTreeNode<Node<V>>
implements Node<V> {
    private final Matcher matcher;
    private final int startIndex;
    private final int endIndex;
    private final V value;
    private final boolean hasError;

    public NodeImpl(Matcher matcher, ImmutableLinkedList<Node<V>> immutableLinkedList, int n, int n2, V v, boolean bl) {
        super(immutableLinkedList);
        this.matcher = Preconditions.checkArgNotNull(matcher, "matcher");
        this.startIndex = n;
        this.endIndex = n2;
        this.value = v;
        this.hasError = bl;
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public String getLabel() {
        return this.matcher.getLabel();
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.getLabel());
        if (this.value != null) {
            stringBuilder.append(", {").append(this.value).append('}');
        }
        stringBuilder.append(']');
        if (this.hasError) {
            stringBuilder.append('E');
        }
        return StringUtils.escape(stringBuilder.toString());
    }
}

