/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import org.parboiled.common.Preconditions;
import org.parboiled.matchers.Matcher;

public class MatcherPath {
    public final Element element;
    public final MatcherPath parent;

    public MatcherPath(Element element, MatcherPath matcherPath) {
        this.element = Preconditions.checkArgNotNull(element, "element");
        this.parent = matcherPath;
    }

    public int length() {
        return this.element.level + 1;
    }

    public boolean isPrefixOf(MatcherPath matcherPath) {
        Preconditions.checkArgNotNull(matcherPath, "that");
        return this.element.level <= matcherPath.element.level && (this == matcherPath || matcherPath.parent != null && this.isPrefixOf(matcherPath.parent));
    }

    public Element getElementAtLevel(int n) {
        Preconditions.checkArgument(n >= 0);
        if (n > this.element.level) {
            return null;
        }
        if (n < this.element.level) {
            return this.parent.getElementAtLevel(n);
        }
        return this.element;
    }

    public MatcherPath commonPrefix(MatcherPath matcherPath) {
        Preconditions.checkArgNotNull(matcherPath, "that");
        if (this.element.level > matcherPath.element.level) {
            return this.parent.commonPrefix(matcherPath);
        }
        if (this.element.level < matcherPath.element.level) {
            return this.commonPrefix(matcherPath.parent);
        }
        if (this == matcherPath) {
            return this;
        }
        return this.parent != null && matcherPath.parent != null ? this.parent.commonPrefix(matcherPath.parent) : null;
    }

    public boolean contains(Matcher matcher) {
        return this.element.matcher == matcher || this.parent != null && this.parent.contains(matcher);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(MatcherPath matcherPath) {
        return this.print(new StringBuilder(), matcherPath).toString();
    }

    private StringBuilder print(StringBuilder stringBuilder, MatcherPath matcherPath) {
        return (this.parent == matcherPath ? stringBuilder : this.parent.print(stringBuilder, matcherPath).append('/')).append(this.element.matcher);
    }

    public static class Element {
        public final Matcher matcher;
        public final int startIndex;
        public final int level;

        public Element(Matcher matcher, int n, int n2) {
            this.matcher = matcher;
            this.startIndex = n;
            this.level = n2;
        }
    }
}

