/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.iplog.IpLogText;

class Committer {
    static final Comparator<Committer> COMPARATOR = new Comparator<Committer>(){

        @Override
        public int compare(Committer a, Committer b) {
            int cmp = a.firstName.compareTo(b.firstName);
            if (cmp == 0) {
                cmp = a.lastName.compareTo(b.lastName);
            }
            return cmp;
        }
    };
    private final String id;
    private String firstName;
    private String lastName;
    private String affiliation;
    private boolean hasCommits;
    private String comments;
    private final Set<String> emailAddresses = new HashSet<String>();
    private final List<ActiveRange> active = new ArrayList<ActiveRange>(2);

    Committer(String id) {
        this.id = id;
    }

    String getID() {
        return this.id;
    }

    String getFirstName() {
        return this.firstName;
    }

    void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    String getLastName() {
        return this.lastName;
    }

    void setLastName(String lastName) {
        this.lastName = lastName;
    }

    String getAffiliation() {
        return this.affiliation;
    }

    void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    boolean isActive() {
        if (this.active.isEmpty()) {
            return false;
        }
        ActiveRange last = this.active.get(this.active.size() - 1);
        return last.end == null;
    }

    boolean hasCommits() {
        return this.hasCommits;
    }

    void setHasCommits(boolean hasCommits) {
        this.hasCommits = hasCommits;
    }

    String getComments() {
        return this.comments;
    }

    void setComments(String comments) {
        this.comments = comments;
    }

    void addEmailAddress(String email) {
        this.emailAddresses.add(email);
    }

    void addActiveRange(ActiveRange r) {
        this.active.add(r);
        Collections.sort(this.active, new Comparator<ActiveRange>(){

            @Override
            public int compare(ActiveRange a, ActiveRange b) {
                return a.begin.compareTo(b.begin);
            }
        });
    }

    boolean inRange(Date when) {
        for (ActiveRange ar : this.active) {
            if (!ar.contains(when)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return MessageFormat.format(IpLogText.get().committerString, this.getFirstName(), this.getLastName());
    }

    static class ActiveRange {
        private final Date begin;
        private final Date end;

        ActiveRange(Date begin, Date end) {
            this.begin = begin;
            this.end = end;
        }

        boolean contains(Date when) {
            if (when.compareTo(this.begin) < 0) {
                return false;
            }
            if (this.end == null) {
                return true;
            }
            return when.compareTo(this.end) < 0;
        }
    }
}

