/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.iplog.CQ;
import org.eclipse.jgit.iplog.Committer;
import org.eclipse.jgit.iplog.Contributor;
import org.eclipse.jgit.iplog.IpLogMeta;
import org.eclipse.jgit.iplog.IpLogText;
import org.eclipse.jgit.iplog.Project;
import org.eclipse.jgit.iplog.SingleContribution;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.RawParseUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpLogGenerator {
    private static final String IPLOG_NS = "http://www.eclipse.org/projects/xml/iplog";
    private static final String IPLOG_PFX = "iplog:";
    private static final String INDENT = "{http://xml.apache.org/xslt}indent-amount";
    private final Map<String, Project> projects = new TreeMap<String, Project>();
    private final Map<String, Project> consumedProjects = new TreeMap<String, Project>();
    private final Map<String, Committer> committersById = new HashMap<String, Committer>();
    private final Map<String, Committer> committersByEmail = new HashMap<String, Committer>();
    private final Map<String, Contributor> contributorsByName = new HashMap<String, Contributor>();
    private final Set<CQ> cqs = new HashSet<CQ>();
    private final Set<RevCommit> commits = new HashSet<RevCommit>();
    private IpLogMeta meta;
    private String reviewUrl;
    private String characterEncoding = "UTF-8";
    private Repository db;
    private RevWalk rw;
    private NameConflictTreeWalk tw;
    private ObjectReader curs;
    private final MutableObjectId idbuf = new MutableObjectId();
    private Document doc;

    public void setCharacterEncoding(String encodingName) {
        this.characterEncoding = encodingName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Repository repo, RevCommit startCommit, String version) throws IOException, ConfigInvalidException {
        try {
            this.db = repo;
            this.curs = this.db.newObjectReader();
            this.rw = new RevWalk(this.curs);
            this.tw = new NameConflictTreeWalk(this.curs);
            RevCommit c = this.rw.parseCommit((AnyObjectId)startCommit);
            this.loadEclipseIpLog(version, c);
            this.loadCommitters(repo);
            this.scanProjectCommits(this.meta.getProjects().get(0), c);
            this.commits.add(c);
        }
        finally {
            this.curs.release();
            this.db = null;
            this.rw = null;
            this.tw = null;
        }
    }

    private void loadEclipseIpLog(String version, RevCommit commit) throws IOException, ConfigInvalidException {
        TreeWalk log = TreeWalk.forPath((Repository)this.db, (String)".eclipse_iplog", (RevTree)commit.getTree());
        if (log == null) {
            return;
        }
        this.meta = new IpLogMeta();
        try {
            this.meta.loadFrom((Config)new BlobBasedConfig(null, this.db, (AnyObjectId)log.getObjectId(0)));
        }
        catch (ConfigInvalidException e) {
            throw new ConfigInvalidException(MessageFormat.format(IpLogText.get().configurationFileInCommitIsInvalid, log.getPathString(), commit.name()), (Throwable)e);
        }
        if (this.meta.getProjects().isEmpty()) {
            throw new ConfigInvalidException(MessageFormat.format(IpLogText.get().configurationFileInCommitHasNoProjectsDeclared, log.getPathString(), commit.name()));
        }
        for (Project p : this.meta.getProjects()) {
            p.setVersion(version);
            this.projects.put(p.getName(), p);
        }
        for (Project p : this.meta.getConsumedProjects()) {
            this.consumedProjects.put(p.getName(), p);
        }
        this.cqs.addAll(this.meta.getCQs());
        this.reviewUrl = this.meta.getReviewUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCommitters(Repository repo) throws IOException {
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        File list = new File(repo.getDirectory(), "gerrit_committers");
        BufferedReader br = new BufferedReader(new FileReader(list));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                Committer who;
                String[] field = line.trim().split(" *\\| *");
                String user = field[1];
                String name = field[2];
                String email = field[3];
                Date begin = this.parseDate(dt, field[4]);
                Date end = this.parseDate(dt, field[5]);
                if (user.startsWith("username:")) {
                    user = user.substring("username:".length());
                }
                if ((who = this.committersById.get(user)) == null) {
                    who = new Committer(user);
                    int sp = name.indexOf(32);
                    if (0 < sp) {
                        who.setFirstName(name.substring(0, sp).trim());
                        who.setLastName(name.substring(sp + 1).trim());
                    } else {
                        who.setFirstName(name);
                        who.setLastName(null);
                    }
                    this.committersById.put(who.getID(), who);
                }
                who.addEmailAddress(email);
                who.addActiveRange(new Committer.ActiveRange(begin, end));
                this.committersByEmail.put(email, who);
            }
        }
        finally {
            br.close();
        }
    }

    private Date parseDate(SimpleDateFormat dt, String value) throws IOException {
        if ("NULL".equals(value) || "".equals(value) || value == null) {
            return null;
        }
        int dot = value.indexOf(46);
        if (0 < dot) {
            value = value.substring(0, dot);
        }
        try {
            return dt.parse(value);
        }
        catch (ParseException e) {
            IOException err = new IOException(MessageFormat.format(IpLogText.get().invalidDate, value));
            err.initCause(e);
            throw err;
        }
    }

    private void scanProjectCommits(Project proj, RevCommit start) throws IOException {
        RevCommit commit;
        this.rw.reset();
        this.rw.markStart(start);
        while ((commit = this.rw.next()) != null) {
            Contributor contributor;
            if (proj.isSkippedCommit((AnyObjectId)commit)) continue;
            PersonIdent author = commit.getAuthorIdent();
            Date when = author.getWhen();
            Committer who = this.committersByEmail.get(author.getEmailAddress());
            if (who != null && who.inRange(when)) {
                who.setHasCommits(true);
                continue;
            }
            int cnt = commit.getParentCount();
            if (2 <= cnt) {
                this.tw.setFilter(TreeFilter.ANY_DIFF);
                this.tw.setRecursive(true);
                RevTree[] trees = new RevTree[1 + cnt];
                trees[0] = commit.getTree();
                for (int i = 0; i < cnt; ++i) {
                    trees[i + 1] = commit.getParent(i).getTree();
                }
                this.tw.reset((AnyObjectId[])trees);
                boolean matchAll = true;
                while (this.tw.next()) {
                    boolean matchOne = false;
                    for (int i = 1; i <= cnt; ++i) {
                        if (this.tw.getRawMode(0) != this.tw.getRawMode(i) || !this.tw.idEqual(0, i)) continue;
                        matchOne = true;
                        break;
                    }
                    if (matchOne) continue;
                    matchAll = false;
                    break;
                }
                if (matchAll) continue;
            }
            if ((contributor = this.contributorsByName.get(author.getName())) == null) {
                String id = author.getEmailAddress();
                String name = author.getName();
                contributor = new Contributor(id, name);
                this.contributorsByName.put(name, contributor);
            }
            String id = commit.name();
            String subj = commit.getShortMessage();
            SingleContribution item = new SingleContribution(id, when, subj);
            if (2 <= cnt) {
                item.setSize("(merge)");
                contributor.add(item);
                continue;
            }
            int addedLines = 0;
            if (1 == cnt) {
                RevCommit parent = commit.getParent(0);
                this.tw.setFilter(TreeFilter.ANY_DIFF);
                this.tw.setRecursive(true);
                this.tw.reset((AnyObjectId[])new RevTree[]{parent.getTree(), commit.getTree()});
                while (this.tw.next()) {
                    if (this.tw.getFileMode(1).getObjectType() != 3) continue;
                    byte[] oldImage = this.tw.getFileMode(0).getObjectType() == 3 ? this.openBlob(0) : new byte[]{};
                    EditList edits = MyersDiff.INSTANCE.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)new RawText(oldImage), (Sequence)new RawText(this.openBlob(1)));
                    for (Edit e : edits) {
                        addedLines += e.getEndB() - e.getBeginB();
                    }
                }
            } else {
                this.tw.setFilter(TreeFilter.ALL);
                this.tw.setRecursive(true);
                this.tw.reset((AnyObjectId)commit.getTree());
                while (this.tw.next()) {
                    if (this.tw.getFileMode(0).getObjectType() != 3) continue;
                    byte[] buf = this.openBlob(0);
                    int ptr = 0;
                    while (ptr < buf.length) {
                        ptr = RawParseUtils.nextLF((byte[])buf, (int)ptr);
                        ++addedLines;
                    }
                }
            }
            if (addedLines < 0) {
                throw new IOException(MessageFormat.format(IpLogText.get().incorrectlyScanned, commit.name()));
            }
            if (1 == addedLines) {
                item.setSize("+1 line");
            } else {
                item.setSize("+" + addedLines + " lines");
            }
            contributor.add(item);
        }
    }

    private byte[] openBlob(int side) throws IOException {
        this.tw.getObjectId(this.idbuf, side);
        return this.curs.open((AnyObjectId)this.idbuf, 3).getCachedBytes();
    }

    public void writeTo(OutputStream out) throws IOException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer s = factory.newTransformer();
            s.setOutputProperty("encoding", this.characterEncoding);
            s.setOutputProperty("method", "xml");
            s.setOutputProperty("indent", "yes");
            s.setOutputProperty(INDENT, "2");
            s.transform(new DOMSource(this.toXML()), new StreamResult(out));
        }
        catch (ParserConfigurationException e) {
            IOException err = new IOException(IpLogText.get().cannotSerializeXML);
            err.initCause(e);
            throw err;
        }
        catch (TransformerConfigurationException e) {
            IOException err = new IOException(IpLogText.get().cannotSerializeXML);
            err.initCause(e);
            throw err;
        }
        catch (TransformerException e) {
            IOException err = new IOException(IpLogText.get().cannotSerializeXML);
            err.initCause(e);
            throw err;
        }
    }

    private Document toXML() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.doc = factory.newDocumentBuilder().newDocument();
        Element root = this.createElement("iplog");
        this.doc.appendChild(root);
        if (this.projects.size() == 1) {
            Project soleProject = this.projects.values().iterator().next();
            root.setAttribute("name", soleProject.getID());
        }
        TreeSet<String> licenses = new TreeSet<String>();
        for (Project project : IpLogGenerator.sort(this.projects, Project.COMPARATOR)) {
            root.appendChild(this.createProject(project));
            licenses.addAll(project.getLicenses());
        }
        if (!this.consumedProjects.isEmpty()) {
            this.appendBlankLine(root);
        }
        for (Project project : IpLogGenerator.sort(this.consumedProjects, Project.COMPARATOR)) {
            root.appendChild(this.createConsumes(project));
            licenses.addAll(project.getLicenses());
        }
        for (RevCommit revCommit : IpLogGenerator.sort(this.commits)) {
            root.appendChild(this.createCommitMeta(revCommit));
        }
        if (licenses.size() > 1) {
            this.appendBlankLine(root);
        }
        for (String string : IpLogGenerator.sort(licenses)) {
            root.appendChild(this.createLicense(string));
        }
        if (!this.cqs.isEmpty()) {
            this.appendBlankLine(root);
        }
        for (CQ cQ : IpLogGenerator.sort(this.cqs, CQ.COMPARATOR)) {
            root.appendChild(this.createCQ(cQ));
        }
        if (!this.committersByEmail.isEmpty()) {
            this.appendBlankLine(root);
        }
        for (Committer committer : IpLogGenerator.sort(this.committersById, Committer.COMPARATOR)) {
            root.appendChild(this.createCommitter(committer));
        }
        for (Contributor contributor : IpLogGenerator.sort(this.contributorsByName, Contributor.COMPARATOR)) {
            this.appendBlankLine(root);
            root.appendChild(this.createContributor(contributor));
        }
        return this.doc;
    }

    private void appendBlankLine(Element root) {
        root.appendChild(this.doc.createTextNode("\n\n  "));
    }

    private Element createProject(Project p) {
        Element project = this.createElement("project");
        this.populateProjectType(p, project);
        return project;
    }

    private Element createConsumes(Project p) {
        Element project = this.createElement("consumes");
        this.populateProjectType(p, project);
        return project;
    }

    private void populateProjectType(Project p, Element project) {
        this.required(project, "id", p.getID());
        this.required(project, "name", p.getName());
        this.optional(project, "comments", p.getComments());
        this.optional(project, "version", p.getVersion());
    }

    private Element createCommitMeta(RevCommit c) {
        Element meta = this.createElement("meta");
        this.required(meta, "key", "git-commit");
        this.required(meta, "value", c.name());
        return meta;
    }

    private Element createLicense(String name) {
        Element license = this.createElement("license");
        this.required(license, "id", name);
        this.optional(license, "description", null);
        this.optional(license, "comments", null);
        return license;
    }

    private Element createCQ(CQ cq) {
        Element r = this.createElement("cq");
        this.required(r, "id", Long.toString(cq.getID()));
        this.required(r, "description", cq.getDescription());
        this.optional(r, "license", cq.getLicense());
        this.optional(r, "use", cq.getUse());
        this.optional(r, "state", this.mapCQState(cq.getState()));
        this.optional(r, "comments", cq.getComments());
        return r;
    }

    private String mapCQState(String state) {
        if (state.equals("approved")) {
            return "active";
        }
        return state;
    }

    private Element createCommitter(Committer who) {
        Element r = this.createElement("committer");
        this.required(r, "id", who.getID());
        this.required(r, "firstName", who.getFirstName());
        this.required(r, "lastName", who.getLastName());
        this.optional(r, "affiliation", who.getAffiliation());
        this.required(r, "active", Boolean.toString(who.isActive()));
        this.required(r, "hasCommits", Boolean.toString(who.hasCommits()));
        this.optional(r, "comments", who.getComments());
        return r;
    }

    private Element createContributor(Contributor c) {
        Element r = this.createElement("contributor");
        this.required(r, "id", c.getID());
        this.required(r, "name", c.getName());
        for (SingleContribution s : IpLogGenerator.sort(c.getContributions(), SingleContribution.COMPARATOR)) {
            r.appendChild(this.createContribution(s));
        }
        return r;
    }

    private Element createContribution(SingleContribution s) {
        Element r = this.createElement("contribution");
        this.required(r, "id", s.getID());
        this.required(r, "description", s.getSummary());
        this.required(r, "size", s.getSize());
        if (this.reviewUrl != null) {
            this.optional(r, "url", this.reviewUrl + s.getID());
        }
        return r;
    }

    private Element createElement(String name) {
        return this.doc.createElementNS(IPLOG_NS, IPLOG_PFX + name);
    }

    private void required(Element r, String name, String value) {
        if (value == null) {
            value = "";
        }
        r.setAttribute(name, value);
    }

    private void optional(Element r, String name, String value) {
        if (value != null && value.length() > 0) {
            r.setAttribute(name, value);
        }
    }

    private static <T, Q extends Comparator<T>> Iterable<T> sort(Collection<T> objs, Q cmp) {
        ArrayList<T> sorted = new ArrayList<T>(objs);
        Collections.sort(sorted, cmp);
        return sorted;
    }

    private static <T, Q extends Comparator<T>> Iterable<T> sort(Map<?, T> objs, Q cmp) {
        return IpLogGenerator.sort(objs.values(), cmp);
    }

    private static <T extends Comparable> Iterable<T> sort(Collection<T> objs) {
        ArrayList<T> sorted = new ArrayList<T>(objs);
        Collections.sort(sorted);
        return sorted;
    }
}

