var searchPane = {
	//clear
	delayedClearLabel: null,
	delayedClearInput: null,
	delayedClearUnits: null,
	cancelClearCbox: null,
	//reset
	engineMenu: null,
	enginePopup: null,
	delayedResetLabel: null,
	delayedResetInput: null,
	delayedResetUnits: null,
	cancelResetCbox: null,
	//tabs
	detectionLabel: null,
	blankTabCbox: null,
	homeTabCbox: null,

	buildEngineList: function()
	{
		const kXULNS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
		var defaultEnginePref = document.getElementById("extensions.searchload.defaultengine");
		var enginesExist = false;
		var engineWasFound = false;

		var searchService = Components.classes["@mozilla.org/browser/search-service;1"]
							.getService(Components.interfaces.nsIBrowserSearchService);
		var engines = searchService.getVisibleEngines({ });

		if(engines.length > 0)
		{
			enginesExist = true;
			for(var i=0; i < engines.length; i++)
			{
				var menuitem = document.createElementNS(kXULNS, "menuitem");
				menuitem.setAttribute("label", engines[i].name);
				menuitem.setAttribute("value", engines[i].name);
				menuitem.setAttribute("class", "menuitem-iconic engine-icon");
				menuitem.setAttribute("image", engines[i].iconURI.spec);
				this.enginePopup.appendChild(menuitem);
				if(engines[i].name == defaultEnginePref.value)
				{
					this.engineMenu.selectedIndex = i;
					engineWasFound = true;
				}
			}
		}

		if(enginesExist && !engineWasFound)
			defaultEnginePref.valueFromPreferences = engines[0].name;
	},//buildEngineList

	init: function()
	{
		this.delayedClearLabel = document.getElementById("delayedclear-label");
		this.delayedClearInput = document.getElementById("delayedclear-input");
		this.delayedClearUnits = document.getElementById("delayedclear-units");
		this.cancelClearCbox = document.getElementById("cancelclear-checkbox");

		this.engineMenu  = document.getElementById("engine-menu");
		this.enginePopup = document.getElementById("engine-popup");
		this.delayedResetLabel = document.getElementById("delayedreset-label");
		this.delayedResetInput = document.getElementById("delayedreset-input");
		this.delayedResetUnits = document.getElementById("delayedreset-units");
		this.cancelResetCbox = document.getElementById("cancelreset-checkbox");

		this.detectionLabel = document.getElementById("detection-label");
		this.blankTabCbox = document.getElementById("detectblank-checkbox");
		this.homeTabCbox  = document.getElementById("detecthome-checkbox");

		this.buildEngineList();

		var clearSearchBarPref = document.getElementById("extensions.searchload.clearonsearch");
		var resetSearchBarPref = document.getElementById("extensions.searchload.resetonsearch");
		var tabcontrolPref     = document.getElementById("extensions.searchload.newtab");

		this.updateDetect(tabcontrolPref.value);
		this.updateClearStatus(clearSearchBarPref.value);
		this.updateResetStatus(resetSearchBarPref.value);
	},//init

	updateClearStatus: function(boolVal)
	{
		var clearDelayPref = document.getElementById("extensions.searchload.cleardelay");
		this.delayedClearLabel.disabled = !boolVal;
		this.delayedClearInput.disabled = !boolVal;
		this.delayedClearUnits.disabled = !boolVal;
		this.updateCancelClear( clearDelayPref.value===0 || !boolVal);
	},

	updateCancelClear: function(disable)
	{
		if(disable)
			this.cancelClearCbox.disabled = true;
		else
			this.cancelClearCbox.disabled = false;
	},

	updateResetStatus: function(boolVal)
	{
		var resetDelayPref = document.getElementById("extensions.searchload.resetdelay");
		this.engineMenu.disabled = !boolVal;
		this.delayedResetLabel.disabled = !boolVal;
		this.delayedResetInput.disabled = !boolVal;
		this.delayedResetUnits.disabled = !boolVal;
		this.updateCancelReset( resetDelayPref.value===0 || !boolVal);
	},

	updateCancelReset: function(disable)
	{
		if(disable)
			this.cancelResetCbox.disabled = true;
		else
			this.cancelResetCbox.disabled = false;
	},

	updateDetect: function(index)
	{
		if(index===0)
		{	this.detectionLabel.disabled = true;
			this.blankTabCbox.disabled = true;
			this.homeTabCbox.disabled = true;
		}
		else
		{	this.detectionLabel.disabled = false;
			this.blankTabCbox.disabled = false;
			this.homeTabCbox.disabled = false;
		}
	}
};
