#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: snp_store
class: CommandLineTool
cwlVersion: v1.0
doc: "SNP and Indel Calling in Mapped Read Data.\n\n\n\nFor more information, visit\
  \ http://www.seqan.de"
inputs:
- doc: Filename for output output file
  id: param_output_filename
  inputBinding:
    prefix: -output
  label: Filename for output output file
  type: string
- default: 'false'
  doc: 'Output only successfully called SNP candidates. Default: Output all candidates.'
  id: param_only-successful-candidates
  inputBinding:
    prefix: -only-successful-candidates
  label: 'Output only successfully called SNP candidates. Default: Output all candidates.'
  type:
  - 'null'
  - string
- default: 'false'
  doc: 'Ignore clip tags in gff. Default: off.'
  id: param_dont-clip
  inputBinding:
    prefix: -dont-clip
  label: 'Ignore clip tags in gff. Default: off.'
  type:
  - 'null'
  - string
- default: 'false'
  doc: 'Keep non-unique fragmentStore.alignedReadStore. Default: off.'
  id: param_multi
  inputBinding:
    prefix: -multi
  label: 'Keep non-unique fragmentStore.alignedReadStore. Default: off.'
  type:
  - 'null'
  - string
- default: 'false'
  doc: 'Only show coverage (no qualities) in SNP output file. Default: off.'
  id: param_hide-qualities
  inputBinding:
    prefix: -hide-qualities
  label: 'Only show coverage (no qualities) in SNP output file. Default: off.'
  type:
  - 'null'
  - string
- default: 'false'
  doc: Base qualities are encoded as char value - 64 (instead of char - 33).
  id: param_solexa-qual-offset
  inputBinding:
    prefix: -solexa-qual-offset
  label: Base qualities are encoded as char value - 64 (instead of char - 33).
  type:
  - 'null'
  - string
- doc: Filename for indel-file output file
  id: param_indel-file_filename
  inputBinding:
    prefix: -indel-file
  label: Filename for indel-file output file
  type:
  - 'null'
  - string
- default: maq
  doc: Set method used for SNP calling either threshold based or Maq method.
  id: param_method
  inputBinding:
    prefix: -method
  label: Set method used for SNP calling either threshold based or Maq method.
  type:
  - 'null'
  - string
- default: '1'
  doc: Maximal number of matches allowed to pile up at the same genome position.
  id: param_max-pile
  inputBinding:
    prefix: -max-pile
  label: Maximal number of matches allowed to pile up at the same genome position.
  type:
  - 'null'
  - int
- default: 'false'
  doc: 'Do pile up correction on merged lanes. Default: off.'
  id: param_merged-max-pile
  inputBinding:
    prefix: -merged-max-pile
  label: 'Do pile up correction on merged lanes. Default: off.'
  type:
  - 'null'
  - string
- default: '5'
  doc: Minimal required number of reads covering a candidate position.
  id: param_min-coverage
  inputBinding:
    prefix: -min-coverage
  label: Minimal required number of reads covering a candidate position.
  type:
  - 'null'
  - int
- default: '10'
  doc: 'Always call base if count is >= fc, ignore other parameters. Default: off.'
  id: param_force-call
  inputBinding:
    prefix: -force-call
  label: 'Always call base if count is >= fc, ignore other parameters. Default: off.'
  type:
  - 'null'
  - int
- default: 'false'
  doc: 'Distinguish between forward and reverse reads. Default: off.'
  id: param_orientation-aware
  inputBinding:
    prefix: -orientation-aware
  label: 'Distinguish between forward and reverse reads. Default: off.'
  type:
  - 'null'
  - string
- default: '100'
  doc: Discard indels in homopolymer runs longer than mpr.
  id: param_max-polymer-run
  inputBinding:
    prefix: -max-polymer-run
  label: Discard indels in homopolymer runs longer than mpr.
  type:
  - 'null'
  - int
- default: '0'
  doc: Minimal number of different read positions supporting the mutation.
  id: param_diff-pos
  inputBinding:
    prefix: -diff-pos
  label: Minimal number of different read positions supporting the mutation.
  type:
  - 'null'
  - int
- default: '0'
  doc: 'Exclude read positions within eb base pairs of read borders for SNV calling.
    Default: off.'
  id: param_exclude-border
  inputBinding:
    prefix: -exclude-border
  label: 'Exclude read positions within eb base pairs of read borders for SNV calling.
    Default: off.'
  type:
  - 'null'
  - int
- default: 'false'
  doc: 'Keep suboptimal reads. Default: off'
  id: param_suboptimal
  inputBinding:
    prefix: -suboptimal
  label: 'Keep suboptimal reads. Default: off'
  type:
  - 'null'
  - string
- default: 'false'
  doc: 'Realign reads around indel candidates. Default: off'
  id: param_realign
  inputBinding:
    prefix: -realign
  label: 'Realign reads around indel candidates. Default: off'
  type:
  - 'null'
  - string
- default: '1000000'
  doc: Genomic window size for parsing reads (concerns memory consumption, choose
    smaller windows for higher coverage).
  id: param_parse-window-size
  inputBinding:
    prefix: -parse-window-size
  label: Genomic window size for parsing reads (concerns memory consumption, choose
    smaller windows for higher coverage).
  type:
  - 'null'
  - int
- default: '3'
  doc: Minimal number of observed mutations for mutation to be called.
  id: param_min-mutations
  inputBinding:
    prefix: -min-mutations
  label: Minimal number of observed mutations for mutation to be called.
  type:
  - 'null'
  - int
- default: '0.25'
  doc: Minimal percentage of mutational base for mutation to be called.
  id: param_perc-threshold
  inputBinding:
    prefix: -perc-threshold
  label: Minimal percentage of mutational base for mutation to be called.
  type:
  - 'null'
  - double
- default: '10.0'
  doc: Minimal average quality of mutational base for mutation to be called.
  id: param_min-quality
  inputBinding:
    prefix: -min-quality
  label: Minimal average quality of mutational base for mutation to be called.
  type:
  - 'null'
  - double
- default: '0.85'
  doc: Dependency coefficient.
  id: param_theta
  inputBinding:
    prefix: -theta
  label: Dependency coefficient.
  type:
  - 'null'
  - double
- default: '0.001'
  doc: Heterozygote rate.
  id: param_hetero-rate
  inputBinding:
    prefix: -hetero-rate
  label: Heterozygote rate.
  type:
  - 'null'
  - double
- default: '1'
  doc: Minimum base call (mapping) quality for a match to be considered.
  id: param_min-map-quality
  inputBinding:
    prefix: -min-map-quality
  label: Minimum base call (mapping) quality for a match to be considered.
  type:
  - 'null'
  - int
- default: 'false'
  doc: 'Use amplification bias corrected distribution for heterozygotes. Default:
    off.'
  id: param_corrected-het
  inputBinding:
    prefix: -corrected-het
  label: 'Use amplification bias corrected distribution for heterozygotes. Default:
    off.'
  type:
  - 'null'
  - string
- default: '0.51'
  doc: Mean ref allele frequency in heterozygotes.
  id: param_mean-alleleFreq
  inputBinding:
    prefix: -mean-alleleFreq
  label: Mean ref allele frequency in heterozygotes.
  type:
  - 'null'
  - double
- default: '18'
  doc: Number of amplification cycles.
  id: param_amp-cycles
  inputBinding:
    prefix: -amp-cycles
  label: Number of amplification cycles.
  type:
  - 'null'
  - int
- default: '0.3'
  doc: Polymerase efficiency, probability of amplification.
  id: param_amp-efficiency
  inputBinding:
    prefix: -amp-efficiency
  label: Polymerase efficiency, probability of amplification.
  type:
  - 'null'
  - double
- default: '10'
  doc: Initial allele population size.
  id: param_initial-N
  inputBinding:
    prefix: -initial-N
  label: Initial allele population size.
  type:
  - 'null'
  - int
- default: '0.8'
  doc: Minimum fraction of alignment column reads explained by genotype call.
  id: param_min-explained-column
  inputBinding:
    prefix: -min-explained-column
  label: Minimum fraction of alignment column reads explained by genotype call.
  type:
  - 'null'
  - double
- default: '3'
  doc: Minimal number of indel-supporting reads required for indel calling.
  id: param_indel-threshold
  inputBinding:
    prefix: -indel-threshold
  label: Minimal number of indel-supporting reads required for indel calling.
  type:
  - 'null'
  - int
- default: '0.25'
  doc: Minimal ratio of indel-supporting/covering reads for indel to be called.
  id: param_indel-perc-threshold
  inputBinding:
    prefix: -indel-perc-threshold
  label: Minimal ratio of indel-supporting/covering reads for indel to be called.
  type:
  - 'null'
  - double
- default: '1'
  doc: Minimal average quality of inserted base/deletion-neighboring bases for indel
    to be called.
  id: param_indel-quality-thresh
  inputBinding:
    prefix: -indel-quality-thresh
  label: Minimal average quality of inserted base/deletion-neighboring bases for indel
    to be called.
  type:
  - 'null'
  - int
- default: 'false'
  doc: 'Both strands need to be observed for indel to be called. Default: off.'
  id: param_both-strands-indel
  inputBinding:
    prefix: -both-strands-indel
  label: 'Both strands need to be observed for indel to be called. Default: off.'
  type:
  - 'null'
  - string
- default: '0'
  doc: Same as option -eb but for indel candidates.
  id: param_exclude-border-indel
  inputBinding:
    prefix: -exclude-border-indel
  label: Same as option -eb but for indel candidates.
  type:
  - 'null'
  - int
- doc: Write log to FILE.
  id: param_log-file
  inputBinding:
    prefix: -log-file
  label: Write log to FILE.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- doc: A reference genome file.
  id: param_argument-0
  inputBinding:
    prefix: -argument-0
  label: A reference genome file.
  type: File
- doc: Read alignment file(s) sorted by genomic position.
  id: param_argument-1
  inputBinding:
    prefix: -argument-1
  label: Read alignment file(s) sorted by genomic position.
  type: File
label: SnpStore
outputs:
- doc: SNP output file (mandatory).
  id: param_output
  label: SNP output file (mandatory).
  outputBinding:
    glob: $(inputs.param_output_filename)
  type: File
- doc: 'Output file for called indels in gff format. Default: off.'
  id: param_indel-file
  label: 'Output file for called indels in gff format. Default: off.'
  outputBinding:
    glob: $(inputs.param_indel-file_filename)
  type:
  - 'null'
  - File
