/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * sttk.h - definitions for ShapeTools toolkit library
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 *  $Header: sttk.h[4.0] Fri Nov  5 14:11:15 1993 andy@cs.tu-berlin.de frozen $
 */

#ifndef _STTKHDR_
#define _STTKHDR_

/*====================
 * general constants 
 *====================*/

#ifndef TRUE
#define TRUE            1
#endif
#ifndef FALSE
#define FALSE           0
#endif

#ifndef ERROR
#define ERROR           -1
#endif
#ifndef LOCAL
#define LOCAL           static
#endif
#ifndef EXPORT
#define EXPORT
#endif
#ifndef bool
#define bool            short
#endif

/*==============
 * constants
 *==============*/

#define ST_ENV		"SHAPETOOLS" /* ShapeTools shell environment variable */
#define ST_ENV_DEFAULT	"/usr/local"
#define ST_ENV_INCLUDE	"/include"
#define ST_ENV_LIB	"/lib"
#define ST_ENV_SHAPELIB	"/lib/shape"
#define ST_DEFAULT_PATH "/bin:/usr/bin:/usr/ucb:"

#define ST_HASHSIZE 501	/* size of hash list for string table */
#define ST_MSGLEN	PATH_MAX+128
#define ST_MAX_TMPFILES	16

#define ST_LOG_MSG	001
#define ST_LOG_MSGERR	002
#define ST_LOG_WARNING	004
#define ST_LOG_ERROR	010
#define ST_LOG_NONL	0100


/*=======================
 * callCmd stuff
 *=======================*/

/* return values (zero or positive number is exit status of child process)
 */
#define OK              0       /* this is not exactly an error */
#define CMDPROC_EMPTY  -1       /* empty string for command processor */
#define NO_MORE_CORE   -3       /* calloc(3) failed */
#define FORK_FAILED    -4       /* [v]fork(2) failed */
#define PIPE_FAILED    -5       /* pipe(2) failed */
#define WAIT_ERROR     -6       /* waitpid(2) failed */
#define EXEC_FAILED    -7       /* execvp(3) failed */
#define CHILD_KILLED   -8       /* child process did not terminate normally */
#define WRITE_FAILED   -9       /* write(2) to pipe failed */
#define NO_PROGRAM    -10       /* command processor program not found */

/*=======================
 * Parseargs stuff
 *=======================*/

#define PSWITCH 0		/* argument is a switch (default) */
#define PARG 01			/* argument has argument */
#define POARG 02		/* argument hat optional argument */
#define PKIND 07

/* option attribute */
#define PHIDDEN (01 << 4)	/* not used */
#define PATTRS (07 << 4)

/* action to be performed */
#define PCALL	0		/* call function (default) */
#define PSET (01 << 8)		/* set variable to 1 */
#define PCLEAR	(02 << 8)	/* set variable to 0 */
#define PTOGGLE (04 << 8)	/* toggle variable */
#define PUSAGE (010 << 8)	/* call usage */
#define PFAIL (020 << 8)	/* call usage and return 1 */
#define PACTION (077 << 8)

typedef struct {
  char *OptName;
  int OptKind;
  int (*OptFunc)();
  int *OptVar;
  char *OptStr;
} StOptDesc;

/*=======================
 * Sighand stuff
 *=======================*/

#include <setjmp.h>

struct stTransaction {
  char tr_fname[PATH_MAX+1];
  int tr_done;
  int tr_seqno;
  int tr_rc;
  jmp_buf tr_env;
};

/*=====================================
 * exported functions
 *=====================================*/

#ifdef __STDC__
#define A(alist) alist
#else
#define A(alist) ()
#endif

/*** call.c */
int	   stCallEditor	A((char *ed, char *file, char *cnt, char **newcnt));
int	   stCallCmd	A((char *commandProc, char *commandStr));
extern int stCallCmdErrno ;

/*** files.c ***/
char*	stTmpFile	A((char *path));
void	stRmRegisteredFiles A((void));
void	stRegisterFile	A((char *fileName));
void	stUnRegisterFile A((char *fileName));
char*	stFindProgram	A((char *fileName));

/*** kbdio.c ***/
extern int   stQuietFlag;
extern int   stShutupFlag;
extern char* stProgramName;
extern char  stMessage[];
void	stLog		A((char *logMsg, int logType));
char*	stGetFromStdin	A((int termChar));
int	stAskConfirm	A((char *message, char *defaultAnswer));
int	stGetTermWidth	A((int fdes));

/*** mktime.c ***/
time_t	stMktime	A((char *string));
char*	stWriteTime	A((time_t date));

/*** parseargs.c ***/
int	stParseArgs	A((int ac, char **av, int *nac, char *(*nav[]), StOptDesc od[]));
void	stShortUsage	A((char *progname, StOptDesc od[], char *extra_text));

/*** ststring.c ***/
char*	stConvertPattern A((char *pattern));
char*   stSubstituteString A((char *original, char *oldStr, char *newStr));
char*   stStrtok        A((char *string));

/***sighand.c ***/
extern Sigret_t (*stInterruptAction)();
extern Sigret_t (*stQuitAction)();
extern Sigret_t (*stTermAction)();
extern struct stTransaction stThisTransaction;
void	stCatchSigs	A((void));
void	stAbortThis	A((int domsg));
void	stCleanup	A((void));
void	stExit		A((int exitCode));

/*** strtab.c ***/
char*	stStrEnter	A((char *string));

/*** sttk_version.c ***/
char*	stVersion	A((void));

#endif /* _STTKHDR_ */
