/* ConfigurationInterfaces.c generated by valac 0.36.6, the Vala compiler
 * generated from ConfigurationInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define TYPE_FUZZY_PROPERTY_STATE (fuzzy_property_state_get_type ())

#define TYPE_CONFIGURABLE_PROPERTY (configurable_property_get_type ())

#define TYPE_CONFIGURATION_ENGINE (configuration_engine_get_type ())
#define CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngine))
#define IS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_ENGINE))
#define CONFIGURATION_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngineIface))

typedef struct _ConfigurationEngine ConfigurationEngine;
typedef struct _ConfigurationEngineIface ConfigurationEngineIface;
enum  {
	CONFIGURATION_ENGINE_PROPERTY_CHANGED_SIGNAL,
	CONFIGURATION_ENGINE_LAST_SIGNAL
};
static guint configuration_engine_signals[CONFIGURATION_ENGINE_LAST_SIGNAL] = {0};

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;
typedef struct _ConfigurationFacadePrivate ConfigurationFacadePrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())
enum  {
	CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_LAST_SIGNAL
};
static guint configuration_facade_signals[CONFIGURATION_FACADE_LAST_SIGNAL] = {0};

typedef enum  {
	CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE,
	CONFIGURATION_ERROR_ENGINE_ERROR
} ConfigurationError;
#define CONFIGURATION_ERROR configuration_error_quark ()
typedef enum  {
	FUZZY_PROPERTY_STATE_ENABLED,
	FUZZY_PROPERTY_STATE_DISABLED,
	FUZZY_PROPERTY_STATE_UNKNOWN
} FuzzyPropertyState;

typedef enum  {
	CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY = 0,
	CONFIGURABLE_PROPERTY_BG_COLOR_NAME,
	CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_FILE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_MODE,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS,
	CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA,
	CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT,
	CONFIGURABLE_PROPERTY_EXPORT_QUALITY,
	CONFIGURABLE_PROPERTY_EXPORT_SCALE,
	CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP,
	CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP,
	CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED,
	CONFIGURABLE_PROPERTY_IMPORT_DIR,
	CONFIGURABLE_PROPERTY_KEEP_RELATIVITY,
	CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT,
	CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE,
	CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH,
	CONFIGURABLE_PROPERTY_LAST_USED_SERVICE,
	CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS,
	CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE,
	CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH,
	CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE,
	CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO,
	CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES,
	CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION,
	CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT,
	CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT,
	CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG,
	CONFIGURABLE_PROPERTY_SIDEBAR_POSITION,
	CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID,
	CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE,
	CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME,
	CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES,
	CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE,
	CONFIGURABLE_PROPERTY_NUM_PROPERTIES
} ConfigurableProperty;

struct _ConfigurationEngineIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (ConfigurationEngine* self);
	gint (*get_int_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_int_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gint (*get_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gchar* (*get_string_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_string_property) (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
	gboolean (*get_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
	gdouble (*get_double_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_double_property) (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
	gboolean (*get_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationEngine* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationEngine* self, const gchar* id, gboolean enabled);
};

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _ConfigurationFacade {
	GObject parent_instance;
	ConfigurationFacadePrivate * priv;
};

struct _ConfigurationFacadeClass {
	GObjectClass parent_class;
	gboolean (*get_auto_import_from_library) (ConfigurationFacade* self);
	void (*set_auto_import_from_library) (ConfigurationFacade* self, gboolean auto_import);
	gchar* (*get_bg_color_name) (ConfigurationFacade* self);
	void (*set_bg_color_name) (ConfigurationFacade* self, const gchar* color_name);
	gboolean (*get_commit_metadata_to_masters) (ConfigurationFacade* self);
	void (*set_commit_metadata_to_masters) (ConfigurationFacade* self, gboolean commit_metadata);
	gchar* (*get_desktop_background) (ConfigurationFacade* self);
	void (*set_desktop_background) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_screensaver) (ConfigurationFacade* self);
	void (*set_screensaver) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_directory_pattern) (ConfigurationFacade* self);
	void (*set_directory_pattern) (ConfigurationFacade* self, const gchar* s);
	gchar* (*get_directory_pattern_custom) (ConfigurationFacade* self);
	void (*set_directory_pattern_custom) (ConfigurationFacade* self, const gchar* s);
	void (*get_direct_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_direct_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_display_basic_properties) (ConfigurationFacade* self);
	void (*set_display_basic_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_extended_properties) (ConfigurationFacade* self);
	void (*set_display_extended_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_sidebar) (ConfigurationFacade* self);
	void (*set_display_sidebar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_toolbar) (ConfigurationFacade* self);
	void (*set_display_toolbar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_search_bar) (ConfigurationFacade* self);
	void (*set_display_search_bar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_ratings) (ConfigurationFacade* self);
	void (*set_display_photo_ratings) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_tags) (ConfigurationFacade* self);
	void (*set_display_photo_tags) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_titles) (ConfigurationFacade* self);
	void (*set_display_photo_titles) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_comments) (ConfigurationFacade* self);
	void (*set_display_photo_comments) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_event_comments) (ConfigurationFacade* self);
	void (*set_display_event_comments) (ConfigurationFacade* self, gboolean display);
	void (*get_event_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_event_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	gboolean (*get_events_sort_ascending) (ConfigurationFacade* self);
	void (*set_events_sort_ascending) (ConfigurationFacade* self, gboolean sort);
	gchar* (*get_external_photo_app) (ConfigurationFacade* self);
	void (*set_external_photo_app) (ConfigurationFacade* self, const gchar* external_photo_app);
	gchar* (*get_external_raw_app) (ConfigurationFacade* self);
	void (*set_external_raw_app) (ConfigurationFacade* self, const gchar* external_raw_app);
	ScaleConstraint (*get_export_constraint) (ConfigurationFacade* self);
	void (*set_export_constraint) (ConfigurationFacade* self, ScaleConstraint constraint);
	ExportFormatMode (*get_export_export_format_mode) (ConfigurationFacade* self);
	void (*set_export_export_format_mode) (ConfigurationFacade* self, ExportFormatMode export_format_mode);
	gboolean (*get_export_export_metadata) (ConfigurationFacade* self);
	void (*set_export_export_metadata) (ConfigurationFacade* self, gboolean export_metadata);
	PhotoFileFormat (*get_export_photo_file_format) (ConfigurationFacade* self);
	void (*set_export_photo_file_format) (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
	JpegQuality (*get_export_quality) (ConfigurationFacade* self);
	void (*set_export_quality) (ConfigurationFacade* self, JpegQuality quality);
	gint (*get_export_scale) (ConfigurationFacade* self);
	void (*set_export_scale) (ConfigurationFacade* self, gint scale);
	RawDeveloper (*get_default_raw_developer) (ConfigurationFacade* self);
	void (*set_default_raw_developer) (ConfigurationFacade* self, RawDeveloper d);
	gboolean (*get_hide_photos_already_imported) (ConfigurationFacade* self);
	void (*set_hide_photos_already_imported) (ConfigurationFacade* self, gboolean hide_imported);
	gchar* (*get_import_dir) (ConfigurationFacade* self);
	void (*set_import_dir) (ConfigurationFacade* self, const gchar* import_dir);
	gboolean (*get_keep_relativity) (ConfigurationFacade* self);
	void (*set_keep_relativity) (ConfigurationFacade* self, gboolean keep_relativity);
	gboolean (*get_pin_toolbar_state) (ConfigurationFacade* self);
	void (*set_pin_toolbar_state) (ConfigurationFacade* self, gboolean state);
	gint (*get_last_crop_height) (ConfigurationFacade* self);
	void (*set_last_crop_height) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_menu_choice) (ConfigurationFacade* self);
	void (*set_last_crop_menu_choice) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_width) (ConfigurationFacade* self);
	void (*set_last_crop_width) (ConfigurationFacade* self, gint choice);
	gchar* (*get_last_used_service) (ConfigurationFacade* self);
	void (*set_last_used_service) (ConfigurationFacade* self, const gchar* service_name);
	gchar* (*get_last_used_dataimports_service) (ConfigurationFacade* self);
	void (*set_last_used_dataimports_service) (ConfigurationFacade* self, const gchar* service_name);
	void (*get_library_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_library_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	void (*get_library_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_library_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_modify_originals) (ConfigurationFacade* self);
	void (*set_modify_originals) (ConfigurationFacade* self, gboolean modify_originals);
	gint (*get_photo_thumbnail_scale) (ConfigurationFacade* self);
	void (*set_photo_thumbnail_scale) (ConfigurationFacade* self, gint scale);
	gdouble (*get_printing_content_height) (ConfigurationFacade* self);
	void (*set_printing_content_height) (ConfigurationFacade* self, gdouble content_height);
	gint (*get_printing_content_layout) (ConfigurationFacade* self);
	void (*set_printing_content_layout) (ConfigurationFacade* self, gint layout_code);
	gint (*get_printing_content_ppi) (ConfigurationFacade* self);
	void (*set_printing_content_ppi) (ConfigurationFacade* self, gint content_ppi);
	gint (*get_printing_content_units) (ConfigurationFacade* self);
	void (*set_printing_content_units) (ConfigurationFacade* self, gint units_code);
	gdouble (*get_printing_content_width) (ConfigurationFacade* self);
	void (*set_printing_content_width) (ConfigurationFacade* self, gdouble content_width);
	gint (*get_printing_images_per_page) (ConfigurationFacade* self);
	void (*set_printing_images_per_page) (ConfigurationFacade* self, gint images_per_page_code);
	gboolean (*get_printing_match_aspect_ratio) (ConfigurationFacade* self);
	void (*set_printing_match_aspect_ratio) (ConfigurationFacade* self, gboolean match_aspect_ratio);
	gboolean (*get_printing_print_titles) (ConfigurationFacade* self);
	void (*set_printing_print_titles) (ConfigurationFacade* self, gboolean print_titles);
	gint (*get_printing_size_selection) (ConfigurationFacade* self);
	void (*set_printing_size_selection) (ConfigurationFacade* self, gint size_code);
	gchar* (*get_printing_titles_font) (ConfigurationFacade* self);
	void (*set_printing_titles_font) (ConfigurationFacade* self, const gchar* font_name);
	gboolean (*get_show_welcome_dialog) (ConfigurationFacade* self);
	void (*set_show_welcome_dialog) (ConfigurationFacade* self, gboolean show);
	gint (*get_sidebar_position) (ConfigurationFacade* self);
	void (*set_sidebar_position) (ConfigurationFacade* self, gint position);
	gdouble (*get_slideshow_delay) (ConfigurationFacade* self);
	void (*set_slideshow_delay) (ConfigurationFacade* self, gdouble delay);
	gdouble (*get_slideshow_transition_delay) (ConfigurationFacade* self);
	void (*set_slideshow_transition_delay) (ConfigurationFacade* self, gdouble delay);
	gchar* (*get_slideshow_transition_effect_id) (ConfigurationFacade* self);
	void (*set_slideshow_transition_effect_id) (ConfigurationFacade* self, const gchar* id);
	gboolean (*get_slideshow_show_title) (ConfigurationFacade* self);
	void (*set_slideshow_show_title) (ConfigurationFacade* self, gboolean show_title);
	gboolean (*get_use_24_hour_time) (ConfigurationFacade* self);
	void (*set_use_24_hour_time) (ConfigurationFacade* self, gboolean use_24_hour_time);
	gboolean (*get_use_lowercase_filenames) (ConfigurationFacade* self);
	void (*set_use_lowercase_filenames) (ConfigurationFacade* self, gboolean b);
	gint (*get_video_interpreter_state_cookie) (ConfigurationFacade* self);
	void (*set_video_interpreter_state_cookie) (ConfigurationFacade* self, gint state_cookie);
	gboolean (*get_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationFacade* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationFacade* self, const gchar* id, gboolean enabled);
};

struct _ConfigurationFacadePrivate {
	ConfigurationEngine* engine;
};

typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;


static gpointer configuration_facade_parent_class = NULL;

GQuark configuration_error_quark (void);
GType fuzzy_property_state_get_type (void) G_GNUC_CONST;
GType configurable_property_get_type (void) G_GNUC_CONST;
gchar* configurable_property_to_string (ConfigurableProperty self);
GType configuration_engine_get_type (void) G_GNUC_CONST;
gchar* configuration_engine_get_name (ConfigurationEngine* self);
gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
gint configuration_engine_get_enum_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_enum_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id);
void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
GType raw_developer_get_type (void) G_GNUC_CONST;
#define CONFIGURATION_FACADE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIGURATION_FACADE, ConfigurationFacadePrivate))
enum  {
	CONFIGURATION_FACADE_DUMMY_PROPERTY
};
ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine);
static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p);
static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self);
ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self);
void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err);
gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self);
void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self);
void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self);
void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self);
void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_screensaver (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self);
void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void dimensions_init (Dimensions *self, gint width, gint height);
void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self);
void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self);
void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self);
void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_toolbar (ConfigurationFacade* self);
void configuration_facade_set_display_toolbar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_toolbar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self);
void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self);
void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self);
void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self);
void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self);
void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self);
void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display);
void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self);
void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self);
void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self);
void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
ScaleConstraint configuration_facade_get_export_constraint (ConfigurationFacade* self);
static ScaleConstraint configuration_facade_real_get_export_constraint (ConfigurationFacade* self);
void configuration_facade_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint);
static void configuration_facade_real_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint);
ExportFormatMode configuration_facade_get_export_export_format_mode (ConfigurationFacade* self);
static ExportFormatMode configuration_facade_real_get_export_export_format_mode (ConfigurationFacade* self);
void configuration_facade_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode);
static void configuration_facade_real_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode);
gboolean configuration_facade_get_export_export_metadata (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_export_export_metadata (ConfigurationFacade* self);
void configuration_facade_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata);
static void configuration_facade_real_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata);
PhotoFileFormat configuration_facade_get_export_photo_file_format (ConfigurationFacade* self);
static PhotoFileFormat configuration_facade_real_get_export_photo_file_format (ConfigurationFacade* self);
PhotoFileFormat photo_file_format_unserialize (gint value);
void configuration_facade_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
static void configuration_facade_real_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
gint photo_file_format_serialize (PhotoFileFormat self);
JpegQuality configuration_facade_get_export_quality (ConfigurationFacade* self);
static JpegQuality configuration_facade_real_get_export_quality (ConfigurationFacade* self);
void configuration_facade_set_export_quality (ConfigurationFacade* self, JpegQuality quality);
static void configuration_facade_real_set_export_quality (ConfigurationFacade* self, JpegQuality quality);
gint configuration_facade_get_export_scale (ConfigurationFacade* self);
static gint configuration_facade_real_get_export_scale (ConfigurationFacade* self);
void configuration_facade_set_export_scale (ConfigurationFacade* self, gint scale);
static void configuration_facade_real_set_export_scale (ConfigurationFacade* self, gint scale);
RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self);
static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self);
RawDeveloper raw_developer_from_string (const gchar* value);
void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
gchar* raw_developer_to_string (RawDeveloper self);
gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self);
void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
gchar* configuration_facade_get_import_dir (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self);
void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self);
void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self);
void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
gint configuration_facade_get_last_crop_height (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self);
void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self);
void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_width (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self);
void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice);
gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self);
void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self);
static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self);
gint thumbnail_get_DEFAULT_SCALE (void);
void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self);
void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self);
void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self);
void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self);
void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code);
static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code);
gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self);
void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self);
void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self);
void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self);
void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self);
GType resources_unit_system_get_type (void) G_GNUC_CONST;
ResourcesUnitSystem resources_get_default_measurement_unit (void);
void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self);
void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self);
void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
gint configuration_facade_get_sidebar_position (ConfigurationFacade* self);
static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self);
void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position);
static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position);
gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self);
#define NULL_TRANSITION_DESCRIPTOR_EFFECT_ID "org.yorba.shotwell.transitions.null"
#define TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID NULL_TRANSITION_DESCRIPTOR_EFFECT_ID
void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self);
void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self);
gboolean is_string_empty (const gchar* s);
void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self);
void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self);
static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self);
void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_finalize (GObject * obj);


GQuark configuration_error_quark (void) {
	return g_quark_from_static_string ("configuration_error-quark");
}


GType fuzzy_property_state_get_type (void) {
	static volatile gsize fuzzy_property_state_type_id__volatile = 0;
	if (g_once_init_enter (&fuzzy_property_state_type_id__volatile)) {
		static const GEnumValue values[] = {{FUZZY_PROPERTY_STATE_ENABLED, "FUZZY_PROPERTY_STATE_ENABLED", "enabled"}, {FUZZY_PROPERTY_STATE_DISABLED, "FUZZY_PROPERTY_STATE_DISABLED", "disabled"}, {FUZZY_PROPERTY_STATE_UNKNOWN, "FUZZY_PROPERTY_STATE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType fuzzy_property_state_type_id;
		fuzzy_property_state_type_id = g_enum_register_static ("FuzzyPropertyState", values);
		g_once_init_leave (&fuzzy_property_state_type_id__volatile, fuzzy_property_state_type_id);
	}
	return fuzzy_property_state_type_id__volatile;
}


gchar* configurable_property_to_string (ConfigurableProperty self) {
	gchar* result = NULL;
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (self) {
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 731 "ConfigurationInterfaces.c"
		{
			gchar* _tmp0_;
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp0_ = g_strdup ("AUTO_IMPORT_FROM_LIBRARY");
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp0_;
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 740 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 744 "ConfigurationInterfaces.c"
		{
			gchar* _tmp1_;
#line 102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp1_ = g_strdup ("BG_COLOR_NAME");
#line 102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp1_;
#line 102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 753 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 757 "ConfigurationInterfaces.c"
		{
			gchar* _tmp2_;
#line 105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp2_ = g_strdup ("COMMIT_METADATA_TO_MASTERS");
#line 105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp2_;
#line 105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 766 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE:
#line 770 "ConfigurationInterfaces.c"
		{
			gchar* _tmp3_;
#line 108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp3_ = g_strdup ("DESKTOP_BACKGROUND_FILE");
#line 108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp3_;
#line 108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 779 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE:
#line 783 "ConfigurationInterfaces.c"
		{
			gchar* _tmp4_;
#line 111 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = g_strdup ("DESKTOP_BACKGROUND_MODE");
#line 111 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp4_;
#line 111 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 792 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_FILE:
#line 796 "ConfigurationInterfaces.c"
		{
			gchar* _tmp5_;
#line 114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp5_ = g_strdup ("SCREENSAVER_FILE");
#line 114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp5_;
#line 114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 805 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_MODE:
#line 809 "ConfigurationInterfaces.c"
		{
			gchar* _tmp6_;
#line 117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp6_ = g_strdup ("SCREENSAVER_MODE");
#line 117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp6_;
#line 117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 818 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN:
#line 822 "ConfigurationInterfaces.c"
		{
			gchar* _tmp7_;
#line 120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = g_strdup ("DIRECTORY_PATTERN");
#line 120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp7_;
#line 120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 831 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM:
#line 835 "ConfigurationInterfaces.c"
		{
			gchar* _tmp8_;
#line 123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = g_strdup ("DIRECTORY_PATTERN_CUSTOM");
#line 123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp8_;
#line 123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 844 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT:
#line 848 "ConfigurationInterfaces.c"
		{
			gchar* _tmp9_;
#line 126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = g_strdup ("DIRECT_WINDOW_HEIGHT");
#line 126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp9_;
#line 126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 857 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE:
#line 861 "ConfigurationInterfaces.c"
		{
			gchar* _tmp10_;
#line 129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = g_strdup ("DIRECT_WINDOW_MAXIMIZE");
#line 129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp10_;
#line 129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 870 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH:
#line 874 "ConfigurationInterfaces.c"
		{
			gchar* _tmp11_;
#line 132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = g_strdup ("DIRECT_WINDOW_WIDTH");
#line 132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp11_;
#line 132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 883 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES:
#line 887 "ConfigurationInterfaces.c"
		{
			gchar* _tmp12_;
#line 135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = g_strdup ("DISPLAY_BASIC_PROPERTIES");
#line 135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp12_;
#line 135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 896 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES:
#line 900 "ConfigurationInterfaces.c"
		{
			gchar* _tmp13_;
#line 138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = g_strdup ("DISPLAY_EXTENDED_PROPERTIES");
#line 138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp13_;
#line 138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 909 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR:
#line 913 "ConfigurationInterfaces.c"
		{
			gchar* _tmp14_;
#line 141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = g_strdup ("DISPLAY_SIDEBAR");
#line 141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp14_;
#line 141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 922 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR:
#line 926 "ConfigurationInterfaces.c"
		{
			gchar* _tmp15_;
#line 144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = g_strdup ("DISPLAY_TOOLBAR");
#line 144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp15_;
#line 144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 935 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR:
#line 939 "ConfigurationInterfaces.c"
		{
			gchar* _tmp16_;
#line 147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = g_strdup ("DISPLAY_SEARCH_BAR");
#line 147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp16_;
#line 147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 948 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS:
#line 952 "ConfigurationInterfaces.c"
		{
			gchar* _tmp17_;
#line 150 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp17_ = g_strdup ("DISPLAY_PHOTO_RATINGS");
#line 150 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp17_;
#line 150 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 961 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS:
#line 965 "ConfigurationInterfaces.c"
		{
			gchar* _tmp18_;
#line 153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp18_ = g_strdup ("DISPLAY_PHOTO_TAGS");
#line 153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp18_;
#line 153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 974 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES:
#line 978 "ConfigurationInterfaces.c"
		{
			gchar* _tmp19_;
#line 156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp19_ = g_strdup ("DISPLAY_PHOTO_TITLES");
#line 156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp19_;
#line 156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 987 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS:
#line 991 "ConfigurationInterfaces.c"
		{
			gchar* _tmp20_;
#line 159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp20_ = g_strdup ("DISPLAY_PHOTO_COMMENTS");
#line 159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp20_;
#line 159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1000 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS:
#line 1004 "ConfigurationInterfaces.c"
		{
			gchar* _tmp21_;
#line 162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp21_ = g_strdup ("DISPLAY_EVENT_COMMENTS");
#line 162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp21_;
#line 162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1013 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING:
#line 1017 "ConfigurationInterfaces.c"
		{
			gchar* _tmp22_;
#line 165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp22_ = g_strdup ("EVENT_PHOTOS_SORT_ASCENDING");
#line 165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp22_;
#line 165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1026 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY:
#line 1030 "ConfigurationInterfaces.c"
		{
			gchar* _tmp23_;
#line 168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp23_ = g_strdup ("EVENT_PHOTOS_SORT_BY");
#line 168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp23_;
#line 168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1039 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 1043 "ConfigurationInterfaces.c"
		{
			gchar* _tmp24_;
#line 171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp24_ = g_strdup ("EVENTS_SORT_ASCENDING");
#line 171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp24_;
#line 171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1052 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT:
#line 1056 "ConfigurationInterfaces.c"
		{
			gchar* _tmp25_;
#line 174 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp25_ = g_strdup ("EXPORT_CONSTRAINT");
#line 174 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp25_;
#line 174 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1065 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE:
#line 1069 "ConfigurationInterfaces.c"
		{
			gchar* _tmp26_;
#line 177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp26_ = g_strdup ("EXPORT_EXPORT_FORMAT_MODE");
#line 177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp26_;
#line 177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1078 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA:
#line 1082 "ConfigurationInterfaces.c"
		{
			gchar* _tmp27_;
#line 180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp27_ = g_strdup ("EXPORT_EXPORT_METADATA");
#line 180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp27_;
#line 180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1091 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT:
#line 1095 "ConfigurationInterfaces.c"
		{
			gchar* _tmp28_;
#line 183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp28_ = g_strdup ("EXPORT_PHOTO_FILE_FORMAT");
#line 183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp28_;
#line 183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1104 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_QUALITY:
#line 1108 "ConfigurationInterfaces.c"
		{
			gchar* _tmp29_;
#line 186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp29_ = g_strdup ("EXPORT_QUALITY");
#line 186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp29_;
#line 186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1117 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_SCALE:
#line 1121 "ConfigurationInterfaces.c"
		{
			gchar* _tmp30_;
#line 189 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp30_ = g_strdup ("EXPORT_SCALE");
#line 189 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp30_;
#line 189 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1130 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 1134 "ConfigurationInterfaces.c"
		{
			gchar* _tmp31_;
#line 192 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp31_ = g_strdup ("EXTERNAL_PHOTO_APP");
#line 192 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp31_;
#line 192 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1143 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 1147 "ConfigurationInterfaces.c"
		{
			gchar* _tmp32_;
#line 195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp32_ = g_strdup ("EXTERNAL_RAW_APP");
#line 195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp32_;
#line 195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1156 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED:
#line 1160 "ConfigurationInterfaces.c"
		{
			gchar* _tmp33_;
#line 198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp33_ = g_strdup ("HIDE_PHOTOS_ALREADY_IMPORTED");
#line 198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp33_;
#line 198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1169 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 1173 "ConfigurationInterfaces.c"
		{
			gchar* _tmp34_;
#line 201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp34_ = g_strdup ("IMPORT_DIR");
#line 201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp34_;
#line 201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1182 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_KEEP_RELATIVITY:
#line 1186 "ConfigurationInterfaces.c"
		{
			gchar* _tmp35_;
#line 204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp35_ = g_strdup ("KEEP_RELATIVITY");
#line 204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp35_;
#line 204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1195 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT:
#line 1199 "ConfigurationInterfaces.c"
		{
			gchar* _tmp36_;
#line 207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp36_ = g_strdup ("LAST_CROP_HEIGHT");
#line 207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp36_;
#line 207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1208 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE:
#line 1212 "ConfigurationInterfaces.c"
		{
			gchar* _tmp37_;
#line 210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp37_ = g_strdup ("LAST_CROP_MENU_CHOICE");
#line 210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp37_;
#line 210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1221 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH:
#line 1225 "ConfigurationInterfaces.c"
		{
			gchar* _tmp38_;
#line 213 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp38_ = g_strdup ("LAST_CROP_WIDTH");
#line 213 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp38_;
#line 213 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1234 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_SERVICE:
#line 1238 "ConfigurationInterfaces.c"
		{
			gchar* _tmp39_;
#line 216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp39_ = g_strdup ("LAST_USED_SERVICE");
#line 216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp39_;
#line 216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1247 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE:
#line 1251 "ConfigurationInterfaces.c"
		{
			gchar* _tmp40_;
#line 219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp40_ = g_strdup ("LAST_USED_DATAIMPORTS_SERVICE");
#line 219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp40_;
#line 219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1260 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING:
#line 1264 "ConfigurationInterfaces.c"
		{
			gchar* _tmp41_;
#line 222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp41_ = g_strdup ("LIBRARY_PHOTOS_SORT_ASCENDING");
#line 222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp41_;
#line 222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1273 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY:
#line 1277 "ConfigurationInterfaces.c"
		{
			gchar* _tmp42_;
#line 225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp42_ = g_strdup ("LIBRARY_PHOTOS_SORT_BY");
#line 225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp42_;
#line 225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1286 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT:
#line 1290 "ConfigurationInterfaces.c"
		{
			gchar* _tmp43_;
#line 228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp43_ = g_strdup ("LIBRARY_WINDOW_HEIGHT");
#line 228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp43_;
#line 228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1299 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE:
#line 1303 "ConfigurationInterfaces.c"
		{
			gchar* _tmp44_;
#line 231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp44_ = g_strdup ("LIBRARY_WINDOW_MAXIMIZE");
#line 231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp44_;
#line 231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1312 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH:
#line 1316 "ConfigurationInterfaces.c"
		{
			gchar* _tmp45_;
#line 234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp45_ = g_strdup ("LIBRARY_WINDOW_WIDTH");
#line 234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp45_;
#line 234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1325 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS:
#line 1329 "ConfigurationInterfaces.c"
		{
			gchar* _tmp46_;
#line 237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp46_ = g_strdup ("MODIFY_ORIGINALS");
#line 237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp46_;
#line 237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1338 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE:
#line 1342 "ConfigurationInterfaces.c"
		{
			gchar* _tmp47_;
#line 240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp47_ = g_strdup ("PHOTO_THUMBNAIL_SCALE");
#line 240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp47_;
#line 240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1351 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE:
#line 1355 "ConfigurationInterfaces.c"
		{
			gchar* _tmp48_;
#line 243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp48_ = g_strdup ("PIN_TOOLBAR_STATE");
#line 243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp48_;
#line 243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1364 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT:
#line 1368 "ConfigurationInterfaces.c"
		{
			gchar* _tmp49_;
#line 246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp49_ = g_strdup ("PRINTING_CONTENT_HEIGHT");
#line 246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp49_;
#line 246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1377 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT:
#line 1381 "ConfigurationInterfaces.c"
		{
			gchar* _tmp50_;
#line 249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp50_ = g_strdup ("PRINTING_CONTENT_LAYOUT");
#line 249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp50_;
#line 249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1390 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI:
#line 1394 "ConfigurationInterfaces.c"
		{
			gchar* _tmp51_;
#line 252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp51_ = g_strdup ("PRINTING_CONTENT_PPI");
#line 252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp51_;
#line 252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1403 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS:
#line 1407 "ConfigurationInterfaces.c"
		{
			gchar* _tmp52_;
#line 255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp52_ = g_strdup ("PRINTING_CONTENT_UNITS");
#line 255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp52_;
#line 255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1416 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH:
#line 1420 "ConfigurationInterfaces.c"
		{
			gchar* _tmp53_;
#line 258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp53_ = g_strdup ("PRINTING_CONTENT_WIDTH");
#line 258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp53_;
#line 258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1429 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE:
#line 1433 "ConfigurationInterfaces.c"
		{
			gchar* _tmp54_;
#line 261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp54_ = g_strdup ("PRINTING_IMAGES_PER_PAGE");
#line 261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp54_;
#line 261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1442 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO:
#line 1446 "ConfigurationInterfaces.c"
		{
			gchar* _tmp55_;
#line 264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp55_ = g_strdup ("PRINTING_MATCH_ASPECT_RATIO");
#line 264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp55_;
#line 264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1455 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES:
#line 1459 "ConfigurationInterfaces.c"
		{
			gchar* _tmp56_;
#line 267 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp56_ = g_strdup ("PRINTING_PRINT_TITLES");
#line 267 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp56_;
#line 267 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1468 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION:
#line 1472 "ConfigurationInterfaces.c"
		{
			gchar* _tmp57_;
#line 270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp57_ = g_strdup ("PRINTING_SIZE_SELECTION");
#line 270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp57_;
#line 270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1481 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT:
#line 1485 "ConfigurationInterfaces.c"
		{
			gchar* _tmp58_;
#line 273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp58_ = g_strdup ("PRINTING_TITLES_FONT");
#line 273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp58_;
#line 273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1494 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT:
#line 1498 "ConfigurationInterfaces.c"
		{
			gchar* _tmp59_;
#line 276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp59_ = g_strdup ("RAW_DEVELOPER_DEFAULT");
#line 276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp59_;
#line 276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1507 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG:
#line 1511 "ConfigurationInterfaces.c"
		{
			gchar* _tmp60_;
#line 279 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp60_ = g_strdup ("SHOW_WELCOME_DIALOG");
#line 279 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp60_;
#line 279 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1520 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SIDEBAR_POSITION:
#line 1524 "ConfigurationInterfaces.c"
		{
			gchar* _tmp61_;
#line 282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp61_ = g_strdup ("SIDEBAR_POSITION");
#line 282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp61_;
#line 282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1533 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY:
#line 1537 "ConfigurationInterfaces.c"
		{
			gchar* _tmp62_;
#line 285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp62_ = g_strdup ("SLIDESHOW_DELAY");
#line 285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp62_;
#line 285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1546 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY:
#line 1550 "ConfigurationInterfaces.c"
		{
			gchar* _tmp63_;
#line 288 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp63_ = g_strdup ("SLIDESHOW_TRANSITION_DELAY");
#line 288 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp63_;
#line 288 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1559 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID:
#line 1563 "ConfigurationInterfaces.c"
		{
			gchar* _tmp64_;
#line 291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp64_ = g_strdup ("SLIDESHOW_TRANSITION_EFFECT_ID");
#line 291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp64_;
#line 291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1572 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE:
#line 1576 "ConfigurationInterfaces.c"
		{
			gchar* _tmp65_;
#line 294 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp65_ = g_strdup ("SLIDESHOW_SHOW_TITLE");
#line 294 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp65_;
#line 294 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1585 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME:
#line 1589 "ConfigurationInterfaces.c"
		{
			gchar* _tmp66_;
#line 297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp66_ = g_strdup ("USE_24_HOUR_TIME");
#line 297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp66_;
#line 297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1598 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES:
#line 1602 "ConfigurationInterfaces.c"
		{
			gchar* _tmp67_;
#line 300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp67_ = g_strdup ("USE_LOWERCASE_FILENAMES");
#line 300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp67_;
#line 300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1611 "ConfigurationInterfaces.c"
		}
#line 97 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE:
#line 1615 "ConfigurationInterfaces.c"
		{
			gchar* _tmp68_;
#line 303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp68_ = g_strdup ("VIDEO_INTERPRETER_STATE_COOKIE");
#line 303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp68_;
#line 303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1624 "ConfigurationInterfaces.c"
		}
		default:
		{
#line 306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_error ("ConfigurationInterfaces.vala:306: unknown ConfigurableProperty enumera" \
"tion value");
#line 1630 "ConfigurationInterfaces.c"
		}
	}
}


GType configurable_property_get_type (void) {
	static volatile gsize configurable_property_type_id__volatile = 0;
	if (g_once_init_enter (&configurable_property_type_id__volatile)) {
		static const GEnumValue values[] = {{CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, "CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY", "auto-import-from-library"}, {CONFIGURABLE_PROPERTY_BG_COLOR_NAME, "CONFIGURABLE_PROPERTY_BG_COLOR_NAME", "bg-color-name"}, {CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, "CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS", "commit-metadata-to-masters"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE", "desktop-background-file"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE", "desktop-background-mode"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, "CONFIGURABLE_PROPERTY_SCREENSAVER_FILE", "screensaver-file"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "CONFIGURABLE_PROPERTY_SCREENSAVER_MODE", "screensaver-mode"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN", "directory-pattern"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM", "directory-pattern-custom"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT", "direct-window-height"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE", "direct-window-maximize"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH", "direct-window-width"}, {CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES", "display-basic-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS", "display-event-comments"}, {CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES", "display-extended-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, "CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR", "display-sidebar"}, {CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, "CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR", "display-toolbar"}, {CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, "CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR", "display-search-bar"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS", "display-photo-ratings"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS", "display-photo-tags"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES", "display-photo-titles"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS", "display-photo-comments"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING", "event-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY", "event-photos-sort-by"}, {CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING", "events-sort-ascending"}, {CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, "CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT", "export-constraint"}, {CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, "CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE", "export-export-format-mode"}, {CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, "CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA", "export-export-metadata"}, {CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, "CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT", "export-photo-file-format"}, {CONFIGURABLE_PROPERTY_EXPORT_QUALITY, "CONFIGURABLE_PROPERTY_EXPORT_QUALITY", "export-quality"}, {CONFIGURABLE_PROPERTY_EXPORT_SCALE, "CONFIGURABLE_PROPERTY_EXPORT_SCALE", "export-scale"}, {CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP", "external-photo-app"}, {CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP", "external-raw-app"}, {CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, "CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED", "hide-photos-already-imported"}, {CONFIGURABLE_PROPERTY_IMPORT_DIR, "CONFIGURABLE_PROPERTY_IMPORT_DIR", "import-dir"}, {CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, "CONFIGURABLE_PROPERTY_KEEP_RELATIVITY", "keep-relativity"}, {CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, "CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT", "last-crop-height"}, {CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, "CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE", "last-crop-menu-choice"}, {CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, "CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH", "last-crop-width"}, {CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_SERVICE", "last-used-service"}, {CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE", "last-used-dataimports-service"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING", "library-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY", "library-photos-sort-by"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT", "library-window-height"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE", "library-window-maximize"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH", "library-window-width"}, {CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, "CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS", "modify-originals"}, {CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, "CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE", "photo-thumbnail-scale"}, {CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, "CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE", "pin-toolbar-state"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT", "printing-content-height"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT", "printing-content-layout"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI", "printing-content-ppi"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS", "printing-content-units"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH", "printing-content-width"}, {CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, "CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE", "printing-images-per-page"}, {CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, "CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO", "printing-match-aspect-ratio"}, {CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, "CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES", "printing-print-titles"}, {CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, "CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION", "printing-size-selection"}, {CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, "CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT", "printing-titles-font"}, {CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, "CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT", "raw-developer-default"}, {CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, "CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG", "show-welcome-dialog"}, {CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, "CONFIGURABLE_PROPERTY_SIDEBAR_POSITION", "sidebar-position"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY", "slideshow-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY", "slideshow-transition-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID", "slideshow-transition-effect-id"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, "CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE", "slideshow-show-title"}, {CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, "CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME", "use-24-hour-time"}, {CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, "CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES", "use-lowercase-filenames"}, {CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, "CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE", "video-interpreter-state-cookie"}, {CONFIGURABLE_PROPERTY_NUM_PROPERTIES, "CONFIGURABLE_PROPERTY_NUM_PROPERTIES", "num-properties"}, {0, NULL, NULL}};
		GType configurable_property_type_id;
		configurable_property_type_id = g_enum_register_static ("ConfigurableProperty", values);
		g_once_init_leave (&configurable_property_type_id__volatile, configurable_property_type_id);
	}
	return configurable_property_type_id__volatile;
}


gchar* configuration_engine_get_name (ConfigurationEngine* self) {
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_name (self);
#line 1653 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 316 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 316 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_int_property (self, p, error);
#line 1662 "ConfigurationInterfaces.c"
}


void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error) {
#line 317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_int_property (self, p, val, error);
#line 1671 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_enum_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_enum_property (self, p, error);
#line 1680 "ConfigurationInterfaces.c"
}


void configuration_engine_set_enum_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error) {
#line 320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_enum_property (self, p, val, error);
#line 1689 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_string_property (self, p, error);
#line 1698 "ConfigurationInterfaces.c"
}


void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error) {
#line 323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_string_property (self, p, val, error);
#line 1707 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_bool_property (self, p, error);
#line 1716 "ConfigurationInterfaces.c"
}


void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error) {
#line 326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_bool_property (self, p, val, error);
#line 1725 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_double_property (self, p, error);
#line 1734 "ConfigurationInterfaces.c"
}


void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error) {
#line 329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_double_property (self, p, val, error);
#line 1743 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_bool (self, domain, id, key, def);
#line 1752 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_bool (self, domain, id, key, val);
#line 1761 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_double (self, domain, id, key, def);
#line 1770 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_double (self, domain, id, key, val);
#line 1779 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_int (self, domain, id, key, def);
#line 1788 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_int (self, domain, id, key, val);
#line 1797 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_string (self, domain, id, key, def);
#line 1806 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_string (self, domain, id, key, val);
#line 1815 "ConfigurationInterfaces.c"
}


void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->unset_plugin_key (self, domain, id, key);
#line 1824 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id) {
#line 341 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 341 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->is_plugin_enabled (self, id);
#line 1833 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled) {
#line 342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_enabled (self, id, enabled);
#line 1842 "ConfigurationInterfaces.c"
}


static void configuration_engine_base_init (ConfigurationEngineIface * iface) {
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	static gboolean initialized = FALSE;
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (!initialized) {
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		initialized = TRUE;
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_signals[CONFIGURATION_ENGINE_PROPERTY_CHANGED_SIGNAL] = g_signal_new ("property-changed", TYPE_CONFIGURATION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_CONFIGURABLE_PROPERTY);
#line 1855 "ConfigurationInterfaces.c"
	}
}


GType configuration_engine_get_type (void) {
	static volatile gsize configuration_engine_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationEngineIface), (GBaseInitFunc) configuration_engine_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType configuration_engine_type_id;
		configuration_engine_type_id = g_type_register_static (G_TYPE_INTERFACE, "ConfigurationEngine", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (configuration_engine_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&configuration_engine_type_id__volatile, configuration_engine_type_id);
	}
	return configuration_engine_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self ? g_object_ref (self) : NULL;
#line 1876 "ConfigurationInterfaces.c"
}


static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self) {
#line 358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_on_property_changed ((ConfigurationFacade*) self, p);
#line 1883 "ConfigurationInterfaces.c"
}


ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine) {
	ConfigurationFacade * self = NULL;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	ConfigurationEngine* _tmp2_;
#line 355 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (engine), NULL);
#line 355 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = (ConfigurationFacade*) g_object_new (object_type, NULL);
#line 356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = engine;
#line 356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv->engine = _tmp1_;
#line 358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = engine;
#line 358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_connect_object (_tmp2_, "property-changed", (GCallback) _configuration_facade_on_property_changed_configuration_engine_property_changed, self, 0);
#line 355 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self;
#line 1910 "ConfigurationInterfaces.c"
}


static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p) {
	ConfigurableProperty _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ConfigurableProperty _tmp3_;
#line 361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = p;
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configurable_property_to_string (_tmp0_);
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_debug ("ConfigurationInterfaces.vala:362: ConfigurationFacade: engine reports " \
"property '%s' changed.", _tmp2_);
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_tmp2_);
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = p;
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (_tmp3_) {
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 1937 "ConfigurationInterfaces.c"
		{
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL], 0);
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1943 "ConfigurationInterfaces.c"
		}
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 1947 "ConfigurationInterfaces.c"
		{
#line 370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL], 0);
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1953 "ConfigurationInterfaces.c"
		}
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 1957 "ConfigurationInterfaces.c"
		{
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL], 0);
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1963 "ConfigurationInterfaces.c"
		}
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 1967 "ConfigurationInterfaces.c"
		{
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL], 0);
#line 379 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1973 "ConfigurationInterfaces.c"
		}
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 1979 "ConfigurationInterfaces.c"
		{
#line 383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL], 0);
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1985 "ConfigurationInterfaces.c"
		}
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 1989 "ConfigurationInterfaces.c"
		{
#line 387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL], 0);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1995 "ConfigurationInterfaces.c"
		}
		default:
#line 364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		break;
#line 2000 "ConfigurationInterfaces.c"
	}
}


ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self) {
	ConfigurationEngine* result = NULL;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
#line 392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = self->priv->engine;
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp1_;
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 2019 "ConfigurationInterfaces.c"
}


void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err) {
	GError* _tmp0_;
#line 396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = err;
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_error_matches (_tmp0_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE)) {
#line 2031 "ConfigurationInterfaces.c"
		ConfigurationEngine* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = self->priv->engine;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_name (_tmp1_);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp4_->message;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_message ("ConfigurationInterfaces.vala:398: configuration engine '%s' reports PR" \
"OPERTY_HAS_NO_VALUE error: %s", _tmp3_, _tmp5_);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp3_);
#line 2051 "ConfigurationInterfaces.c"
	} else {
		GError* _tmp6_;
#line 401 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 401 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_error_matches (_tmp6_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_ENGINE_ERROR)) {
#line 2058 "ConfigurationInterfaces.c"
			ConfigurationEngine* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = self->priv->engine;
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = configuration_engine_get_name (_tmp7_);
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = _tmp8_;
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = err;
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = _tmp10_->message;
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:402: configuration engine '%s' reports EN" \
"GINE_ERROR: %s", _tmp9_, _tmp11_);
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp9_);
#line 2078 "ConfigurationInterfaces.c"
		} else {
			ConfigurationEngine* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = self->priv->engine;
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = configuration_engine_get_name (_tmp12_);
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = _tmp13_;
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = err;
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = _tmp15_->message;
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:405: configuration engine '%s' reports un" \
"known error: %s", _tmp14_, _tmp16_);
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp14_);
#line 2099 "ConfigurationInterfaces.c"
		}
	}
}


static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, &_inner_error_);
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2129 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2133 "ConfigurationInterfaces.c"
				goto __catch83_configuration_error;
			}
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 2142 "ConfigurationInterfaces.c"
		}
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2148 "ConfigurationInterfaces.c"
	}
	goto __finally83;
	__catch83_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2169 "ConfigurationInterfaces.c"
	}
	__finally83:
#line 414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 2178 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self) {
#line 413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_auto_import_from_library (self);
#line 2187 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = auto_import;
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, _tmp2_, &_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2211 "ConfigurationInterfaces.c"
				goto __catch84_configuration_error;
			}
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2220 "ConfigurationInterfaces.c"
		}
	}
	goto __finally84;
	__catch84_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2240 "ConfigurationInterfaces.c"
	}
	__finally84:
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2251 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_auto_import_from_library (self, auto_import);
#line 2261 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, &_inner_error_);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2291 "ConfigurationInterfaces.c"
				goto __catch85_configuration_error;
			}
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2300 "ConfigurationInterfaces.c"
		}
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2312 "ConfigurationInterfaces.c"
	}
	goto __finally85;
	__catch85_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2336 "ConfigurationInterfaces.c"
	}
	__finally85:
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2345 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self) {
#line 436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_bg_color_name (self);
#line 2354 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
	GError * _inner_error_ = NULL;
#line 446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (color_name != NULL);
#line 2362 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = color_name;
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, _tmp2_, &_inner_error_);
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2381 "ConfigurationInterfaces.c"
				goto __catch86_configuration_error;
			}
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2390 "ConfigurationInterfaces.c"
		}
	}
	goto __finally86;
	__catch86_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2410 "ConfigurationInterfaces.c"
	}
	__finally86:
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2421 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
#line 446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_bg_color_name (self, color_name);
#line 2431 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, &_inner_error_);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2459 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2463 "ConfigurationInterfaces.c"
				goto __catch87_configuration_error;
			}
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 2472 "ConfigurationInterfaces.c"
		}
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2478 "ConfigurationInterfaces.c"
	}
	goto __finally87;
	__catch87_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2499 "ConfigurationInterfaces.c"
	}
	__finally87:
#line 459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 2508 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self) {
#line 458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_commit_metadata_to_masters (self);
#line 2517 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = commit_metadata;
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, _tmp2_, &_inner_error_);
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2541 "ConfigurationInterfaces.c"
				goto __catch88_configuration_error;
			}
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2550 "ConfigurationInterfaces.c"
		}
	}
	goto __finally88;
	__catch88_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 473 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 473 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2570 "ConfigurationInterfaces.c"
	}
	__finally88:
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2581 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_commit_metadata_to_masters (self, commit_metadata);
#line 2591 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, &_inner_error_);
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2621 "ConfigurationInterfaces.c"
				goto __catch89_configuration_error;
			}
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2630 "ConfigurationInterfaces.c"
		}
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2642 "ConfigurationInterfaces.c"
	}
	goto __finally89;
	__catch89_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2666 "ConfigurationInterfaces.c"
	}
	__finally89:
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2675 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self) {
#line 481 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 481 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_desktop_background (self);
#line 2684 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 2692 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, _tmp2_, &_inner_error_);
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2713 "ConfigurationInterfaces.c"
				goto __catch90_configuration_error;
			}
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2722 "ConfigurationInterfaces.c"
		}
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "zoom", &_inner_error_);
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2736 "ConfigurationInterfaces.c"
				goto __catch90_configuration_error;
			}
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2745 "ConfigurationInterfaces.c"
		}
	}
	goto __finally90;
	__catch90_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2763 "ConfigurationInterfaces.c"
	}
	__finally90:
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2774 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
#line 491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_desktop_background (self, filename);
#line 2784 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, &_inner_error_);
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2814 "ConfigurationInterfaces.c"
				goto __catch91_configuration_error;
			}
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2823 "ConfigurationInterfaces.c"
		}
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2835 "ConfigurationInterfaces.c"
	}
	goto __finally91;
	__catch91_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 511 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 511 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 511 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 511 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2859 "ConfigurationInterfaces.c"
	}
	__finally91:
#line 506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2868 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_screensaver (ConfigurationFacade* self) {
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_screensaver (self);
#line 2877 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 2885 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, _tmp2_, &_inner_error_);
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2906 "ConfigurationInterfaces.c"
				goto __catch92_configuration_error;
			}
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2915 "ConfigurationInterfaces.c"
		}
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "zoom", &_inner_error_);
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2929 "ConfigurationInterfaces.c"
				goto __catch92_configuration_error;
			}
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2938 "ConfigurationInterfaces.c"
		}
	}
	goto __finally92;
	__catch92_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2956 "ConfigurationInterfaces.c"
	}
	__finally92:
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2967 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
#line 515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_screensaver (self, filename);
#line 2977 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* s = NULL;
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, &_inner_error_);
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		s = _tmp3_;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3008 "ConfigurationInterfaces.c"
				goto __catch93_configuration_error;
			}
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 3017 "ConfigurationInterfaces.c"
		}
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_strcmp0 (s, "") == 0) {
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = NULL;
#line 3023 "ConfigurationInterfaces.c"
		} else {
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = s;
#line 3027 "ConfigurationInterfaces.c"
		}
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (s);
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3037 "ConfigurationInterfaces.c"
	}
	goto __finally93;
	__catch93_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3061 "ConfigurationInterfaces.c"
	}
	__finally93:
#line 530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3070 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self) {
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern (self);
#line 3079 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
	{
		const gchar* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		const gchar* _tmp3_;
#line 542 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = s;
#line 542 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (_tmp0_ == NULL) {
#line 543 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			s = "";
#line 3096 "ConfigurationInterfaces.c"
		}
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = s;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, _tmp3_, &_inner_error_);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3112 "ConfigurationInterfaces.c"
				goto __catch94_configuration_error;
			}
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3121 "ConfigurationInterfaces.c"
		}
	}
	goto __finally94;
	__catch94_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp4_);
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3139 "ConfigurationInterfaces.c"
	}
	__finally94:
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3150 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
#line 540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern (self, s);
#line 3160 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, &_inner_error_);
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3190 "ConfigurationInterfaces.c"
				goto __catch95_configuration_error;
			}
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 3199 "ConfigurationInterfaces.c"
		}
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3211 "ConfigurationInterfaces.c"
	}
	goto __finally95;
	__catch95_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3235 "ConfigurationInterfaces.c"
	}
	__finally95:
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3244 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self) {
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern_custom (self);
#line 3253 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (s != NULL);
#line 3261 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = s;
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, _tmp2_, &_inner_error_);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3280 "ConfigurationInterfaces.c"
				goto __catch96_configuration_error;
			}
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3289 "ConfigurationInterfaces.c"
		}
	}
	goto __finally96;
	__catch96_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3307 "ConfigurationInterfaces.c"
	}
	__finally96:
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3318 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern_custom (self, s);
#line 3328 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 3340 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint w = 0;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint h = 0;
		ConfigurationEngine* _tmp9_;
		ConfigurationEngine* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, &_inner_error_);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3375 "ConfigurationInterfaces.c"
				goto __catch97_configuration_error;
			}
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3384 "ConfigurationInterfaces.c"
		}
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, &_inner_error_);
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3404 "ConfigurationInterfaces.c"
				goto __catch97_configuration_error;
			}
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3413 "ConfigurationInterfaces.c"
		}
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, &_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3431 "ConfigurationInterfaces.c"
				goto __catch97_configuration_error;
			}
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3440 "ConfigurationInterfaces.c"
		}
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 3448 "ConfigurationInterfaces.c"
	}
	goto __finally97;
	__catch97_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3465 "ConfigurationInterfaces.c"
	}
	__finally97:
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3476 "ConfigurationInterfaces.c"
	}
#line 575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 3482 "ConfigurationInterfaces.c"
	}
#line 575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 3488 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_direct_window_state (self, maximize, dimensions);
#line 3498 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 3506 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
		ConfigurationEngine* _tmp7_;
		ConfigurationEngine* _tmp8_;
		Dimensions _tmp9_;
		gint _tmp10_;
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3533 "ConfigurationInterfaces.c"
				goto __catch98_configuration_error;
			}
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3542 "ConfigurationInterfaces.c"
		}
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3560 "ConfigurationInterfaces.c"
				goto __catch98_configuration_error;
			}
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3569 "ConfigurationInterfaces.c"
		}
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3587 "ConfigurationInterfaces.c"
				goto __catch98_configuration_error;
			}
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3596 "ConfigurationInterfaces.c"
		}
	}
	goto __finally98;
	__catch98_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
#line 589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3614 "ConfigurationInterfaces.c"
	}
	__finally98:
#line 589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3625 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_direct_window_state (self, maximize, dimensions);
#line 3635 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, &_inner_error_);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3663 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3667 "ConfigurationInterfaces.c"
				goto __catch99_configuration_error;
			}
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 3676 "ConfigurationInterfaces.c"
		}
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3682 "ConfigurationInterfaces.c"
	}
	goto __finally99;
	__catch99_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3703 "ConfigurationInterfaces.c"
	}
	__finally99:
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 3712 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self) {
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_basic_properties (self);
#line 3721 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, _tmp2_, &_inner_error_);
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3745 "ConfigurationInterfaces.c"
				goto __catch100_configuration_error;
			}
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3754 "ConfigurationInterfaces.c"
		}
	}
	goto __finally100;
	__catch100_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3772 "ConfigurationInterfaces.c"
	}
	__finally100:
#line 614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3783 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
#line 613 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 613 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_basic_properties (self, display);
#line 3793 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, &_inner_error_);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3821 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3825 "ConfigurationInterfaces.c"
				goto __catch101_configuration_error;
			}
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 3834 "ConfigurationInterfaces.c"
		}
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3840 "ConfigurationInterfaces.c"
	}
	goto __finally101;
	__catch101_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3861 "ConfigurationInterfaces.c"
	}
	__finally101:
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 3870 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self) {
#line 624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_extended_properties (self);
#line 3879 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, _tmp2_, &_inner_error_);
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3903 "ConfigurationInterfaces.c"
				goto __catch102_configuration_error;
			}
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3912 "ConfigurationInterfaces.c"
		}
	}
	goto __finally102;
	__catch102_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3930 "ConfigurationInterfaces.c"
	}
	__finally102:
#line 635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3941 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
#line 634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_extended_properties (self, display);
#line 3951 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, &_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3979 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3983 "ConfigurationInterfaces.c"
				goto __catch103_configuration_error;
			}
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 3992 "ConfigurationInterfaces.c"
		}
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3998 "ConfigurationInterfaces.c"
	}
	goto __finally103;
	__catch103_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4019 "ConfigurationInterfaces.c"
	}
	__finally103:
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4028 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self) {
#line 646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_sidebar (self);
#line 4037 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, _tmp2_, &_inner_error_);
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4061 "ConfigurationInterfaces.c"
				goto __catch104_configuration_error;
			}
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4070 "ConfigurationInterfaces.c"
		}
	}
	goto __finally104;
	__catch104_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4088 "ConfigurationInterfaces.c"
	}
	__finally104:
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4099 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
#line 656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_sidebar (self, display);
#line 4109 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_toolbar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, &_inner_error_);
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4137 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4141 "ConfigurationInterfaces.c"
				goto __catch105_configuration_error;
			}
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4150 "ConfigurationInterfaces.c"
		}
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4156 "ConfigurationInterfaces.c"
	}
	goto __finally105;
	__catch105_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4177 "ConfigurationInterfaces.c"
	}
	__finally105:
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4186 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self) {
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_toolbar (self);
#line 4195 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_toolbar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, _tmp2_, &_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4219 "ConfigurationInterfaces.c"
				goto __catch106_configuration_error;
			}
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4228 "ConfigurationInterfaces.c"
		}
	}
	goto __finally106;
	__catch106_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 682 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4246 "ConfigurationInterfaces.c"
	}
	__finally106:
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4257 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_toolbar (ConfigurationFacade* self, gboolean display) {
#line 678 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 678 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_toolbar (self, display);
#line 4267 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, &_inner_error_);
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4295 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4299 "ConfigurationInterfaces.c"
				goto __catch107_configuration_error;
			}
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4308 "ConfigurationInterfaces.c"
		}
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 691 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4314 "ConfigurationInterfaces.c"
	}
	goto __finally107;
	__catch107_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4335 "ConfigurationInterfaces.c"
	}
	__finally107:
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4344 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self) {
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_search_bar (self);
#line 4353 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, _tmp2_, &_inner_error_);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4377 "ConfigurationInterfaces.c"
				goto __catch108_configuration_error;
			}
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4386 "ConfigurationInterfaces.c"
		}
	}
	goto __finally108;
	__catch108_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4404 "ConfigurationInterfaces.c"
	}
	__finally108:
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4415 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
#line 699 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 699 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_search_bar (self, display);
#line 4425 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, &_inner_error_);
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4453 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4457 "ConfigurationInterfaces.c"
				goto __catch109_configuration_error;
			}
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4466 "ConfigurationInterfaces.c"
		}
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4472 "ConfigurationInterfaces.c"
	}
	goto __finally109;
	__catch109_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 714 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 714 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4493 "ConfigurationInterfaces.c"
	}
	__finally109:
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4502 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self) {
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_ratings (self);
#line 4511 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, _tmp2_, &_inner_error_);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4535 "ConfigurationInterfaces.c"
				goto __catch110_configuration_error;
			}
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4544 "ConfigurationInterfaces.c"
		}
	}
	goto __finally110;
	__catch110_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 724 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 724 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4562 "ConfigurationInterfaces.c"
	}
	__finally110:
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4573 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_ratings (self, display);
#line 4583 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, &_inner_error_);
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4611 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4615 "ConfigurationInterfaces.c"
				goto __catch111_configuration_error;
			}
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4624 "ConfigurationInterfaces.c"
		}
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4630 "ConfigurationInterfaces.c"
	}
	goto __finally111;
	__catch111_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 735 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 735 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4651 "ConfigurationInterfaces.c"
	}
	__finally111:
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4660 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self) {
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_tags (self);
#line 4669 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, _tmp2_, &_inner_error_);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4693 "ConfigurationInterfaces.c"
				goto __catch112_configuration_error;
			}
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4702 "ConfigurationInterfaces.c"
		}
	}
	goto __finally112;
	__catch112_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4720 "ConfigurationInterfaces.c"
	}
	__finally112:
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4731 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_tags (self, display);
#line 4741 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, &_inner_error_);
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4769 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4773 "ConfigurationInterfaces.c"
				goto __catch113_configuration_error;
			}
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4782 "ConfigurationInterfaces.c"
		}
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4788 "ConfigurationInterfaces.c"
	}
	goto __finally113;
	__catch113_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4809 "ConfigurationInterfaces.c"
	}
	__finally113:
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4818 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self) {
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_titles (self);
#line 4827 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, _tmp2_, &_inner_error_);
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4851 "ConfigurationInterfaces.c"
				goto __catch114_configuration_error;
			}
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4860 "ConfigurationInterfaces.c"
		}
	}
	goto __finally114;
	__catch114_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4878 "ConfigurationInterfaces.c"
	}
	__finally114:
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4889 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_titles (self, display);
#line 4899 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, &_inner_error_);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4927 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4931 "ConfigurationInterfaces.c"
				goto __catch115_configuration_error;
			}
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4940 "ConfigurationInterfaces.c"
		}
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4946 "ConfigurationInterfaces.c"
	}
	goto __finally115;
	__catch115_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 777 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 777 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4967 "ConfigurationInterfaces.c"
	}
	__finally115:
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4976 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self) {
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_comments (self);
#line 4985 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, _tmp2_, &_inner_error_);
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5009 "ConfigurationInterfaces.c"
				goto __catch116_configuration_error;
			}
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 785 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5018 "ConfigurationInterfaces.c"
		}
	}
	goto __finally116;
	__catch116_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5036 "ConfigurationInterfaces.c"
	}
	__finally116:
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5047 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_comments (self, display);
#line 5057 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, &_inner_error_);
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5085 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5089 "ConfigurationInterfaces.c"
				goto __catch117_configuration_error;
			}
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 5098 "ConfigurationInterfaces.c"
		}
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5104 "ConfigurationInterfaces.c"
	}
	goto __finally117;
	__catch117_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 798 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 798 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5125 "ConfigurationInterfaces.c"
	}
	__finally117:
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 5134 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self) {
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_event_comments (self);
#line 5143 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, _tmp2_, &_inner_error_);
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5167 "ConfigurationInterfaces.c"
				goto __catch118_configuration_error;
			}
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5176 "ConfigurationInterfaces.c"
		}
	}
	goto __finally118;
	__catch118_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 808 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 808 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5194 "ConfigurationInterfaces.c"
	}
	__finally118:
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5205 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_event_comments (self, display);
#line 5215 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 817 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 5227 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_;
		ConfigurationEngine* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5255 "ConfigurationInterfaces.c"
				goto __catch119_configuration_error;
			}
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5264 "ConfigurationInterfaces.c"
		}
#line 819 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, &_inner_error_);
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5284 "ConfigurationInterfaces.c"
				goto __catch119_configuration_error;
			}
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5293 "ConfigurationInterfaces.c"
		}
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 5297 "ConfigurationInterfaces.c"
	}
	goto __finally119;
	__catch119_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 823 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 823 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5314 "ConfigurationInterfaces.c"
	}
	__finally119:
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5325 "ConfigurationInterfaces.c"
	}
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 5331 "ConfigurationInterfaces.c"
	}
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 5337 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_event_photos_sort (self, sort_order, sort_by);
#line 5347 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		gint _tmp5_;
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5374 "ConfigurationInterfaces.c"
				goto __catch120_configuration_error;
			}
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5383 "ConfigurationInterfaces.c"
		}
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5399 "ConfigurationInterfaces.c"
				goto __catch120_configuration_error;
			}
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 831 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5408 "ConfigurationInterfaces.c"
		}
	}
	goto __finally120;
	__catch120_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 834 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 834 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5426 "ConfigurationInterfaces.c"
	}
	__finally120:
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5437 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 827 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 827 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_event_photos_sort (self, sort_order, sort_by);
#line 5447 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, &_inner_error_);
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5475 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5479 "ConfigurationInterfaces.c"
				goto __catch121_configuration_error;
			}
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 5488 "ConfigurationInterfaces.c"
		}
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5494 "ConfigurationInterfaces.c"
	}
	goto __finally121;
	__catch121_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5515 "ConfigurationInterfaces.c"
	}
	__finally121:
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 5524 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self) {
#line 841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_events_sort_ascending (self);
#line 5533 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort;
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5557 "ConfigurationInterfaces.c"
				goto __catch122_configuration_error;
			}
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5566 "ConfigurationInterfaces.c"
		}
	}
	goto __finally122;
	__catch122_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 855 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 855 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5586 "ConfigurationInterfaces.c"
	}
	__finally122:
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5597 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
#line 851 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 851 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_events_sort_ascending (self, sort);
#line 5607 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, &_inner_error_);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5637 "ConfigurationInterfaces.c"
				goto __catch123_configuration_error;
			}
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 5646 "ConfigurationInterfaces.c"
		}
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5658 "ConfigurationInterfaces.c"
	}
	goto __finally123;
	__catch123_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 864 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 864 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5682 "ConfigurationInterfaces.c"
	}
	__finally123:
#line 864 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 864 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 864 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 5691 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self) {
#line 863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_photo_app (self);
#line 5700 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
	GError * _inner_error_ = NULL;
#line 873 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_photo_app != NULL);
#line 5708 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_photo_app;
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, _tmp2_, &_inner_error_);
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5727 "ConfigurationInterfaces.c"
				goto __catch124_configuration_error;
			}
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5736 "ConfigurationInterfaces.c"
		}
	}
	goto __finally124;
	__catch124_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 878 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 878 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 879 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 879 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5756 "ConfigurationInterfaces.c"
	}
	__finally124:
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5767 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
#line 873 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 873 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_photo_app (self, external_photo_app);
#line 5777 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, &_inner_error_);
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5807 "ConfigurationInterfaces.c"
				goto __catch125_configuration_error;
			}
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 5816 "ConfigurationInterfaces.c"
		}
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 888 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5828 "ConfigurationInterfaces.c"
	}
	goto __finally125;
	__catch125_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 887 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 887 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5852 "ConfigurationInterfaces.c"
	}
	__finally125:
#line 887 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 887 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 887 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 5861 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self) {
#line 886 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 886 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_raw_app (self);
#line 5870 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
	GError * _inner_error_ = NULL;
#line 896 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_raw_app != NULL);
#line 5878 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_raw_app;
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, _tmp2_, &_inner_error_);
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5897 "ConfigurationInterfaces.c"
				goto __catch126_configuration_error;
			}
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5906 "ConfigurationInterfaces.c"
		}
	}
	goto __finally126;
	__catch126_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 897 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 897 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 901 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 901 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 902 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 902 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5926 "ConfigurationInterfaces.c"
	}
	__finally126:
#line 897 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 897 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 897 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5937 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
#line 896 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 896 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_raw_app (self, external_raw_app);
#line 5947 "ConfigurationInterfaces.c"
}


static ScaleConstraint configuration_facade_real_get_export_constraint (ConfigurationFacade* self) {
	ScaleConstraint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, &_inner_error_);
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5976 "ConfigurationInterfaces.c"
				goto __catch127_configuration_error;
			}
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 5985 "ConfigurationInterfaces.c"
		}
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = (ScaleConstraint) _tmp0_;
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5991 "ConfigurationInterfaces.c"
	}
	goto __finally127;
	__catch127_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 910 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 910 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6012 "ConfigurationInterfaces.c"
	}
	__finally127:
#line 910 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 910 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 910 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6021 "ConfigurationInterfaces.c"
}


ScaleConstraint configuration_facade_get_export_constraint (ConfigurationFacade* self) {
#line 909 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 909 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_constraint (self);
#line 6030 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ScaleConstraint _tmp2_;
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = constraint;
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, (gint) _tmp2_, &_inner_error_);
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6054 "ConfigurationInterfaces.c"
				goto __catch128_configuration_error;
			}
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 921 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6063 "ConfigurationInterfaces.c"
		}
	}
	goto __finally128;
	__catch128_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 923 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 923 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6083 "ConfigurationInterfaces.c"
	}
	__finally128:
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6094 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint) {
#line 919 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 919 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_constraint (self, constraint);
#line 6104 "ConfigurationInterfaces.c"
}


static ExportFormatMode configuration_facade_real_get_export_export_format_mode (ConfigurationFacade* self) {
	ExportFormatMode result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, &_inner_error_);
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6133 "ConfigurationInterfaces.c"
				goto __catch129_configuration_error;
			}
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6142 "ConfigurationInterfaces.c"
		}
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = (ExportFormatMode) _tmp0_;
#line 930 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6148 "ConfigurationInterfaces.c"
	}
	goto __finally129;
	__catch129_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 932 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 932 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6169 "ConfigurationInterfaces.c"
	}
	__finally129:
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6178 "ConfigurationInterfaces.c"
}


ExportFormatMode configuration_facade_get_export_export_format_mode (ConfigurationFacade* self) {
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_export_format_mode (self);
#line 6187 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ExportFormatMode _tmp2_;
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = export_format_mode;
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, (gint) _tmp2_, &_inner_error_);
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6211 "ConfigurationInterfaces.c"
				goto __catch130_configuration_error;
			}
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6220 "ConfigurationInterfaces.c"
		}
	}
	goto __finally130;
	__catch130_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 942 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 942 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 943 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 943 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6240 "ConfigurationInterfaces.c"
	}
	__finally130:
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6251 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode) {
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_export_format_mode (self, export_format_mode);
#line 6261 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_export_export_metadata (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, &_inner_error_);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6289 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6293 "ConfigurationInterfaces.c"
				goto __catch131_configuration_error;
			}
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 6302 "ConfigurationInterfaces.c"
		}
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6308 "ConfigurationInterfaces.c"
	}
	goto __finally131;
	__catch131_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 951 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 951 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6329 "ConfigurationInterfaces.c"
	}
	__finally131:
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 6338 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_export_export_metadata (ConfigurationFacade* self) {
#line 947 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 947 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_export_metadata (self);
#line 6347 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = export_metadata;
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, _tmp2_, &_inner_error_);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6371 "ConfigurationInterfaces.c"
				goto __catch132_configuration_error;
			}
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6380 "ConfigurationInterfaces.c"
		}
	}
	goto __finally132;
	__catch132_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 961 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 961 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 962 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 962 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6400 "ConfigurationInterfaces.c"
	}
	__finally132:
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6411 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata) {
#line 957 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 957 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_export_metadata (self, export_metadata);
#line 6421 "ConfigurationInterfaces.c"
}


static PhotoFileFormat configuration_facade_real_get_export_photo_file_format (ConfigurationFacade* self) {
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		PhotoFileFormat _tmp5_;
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, &_inner_error_);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6451 "ConfigurationInterfaces.c"
				goto __catch133_configuration_error;
			}
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6460 "ConfigurationInterfaces.c"
		}
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = photo_file_format_unserialize (_tmp0_);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6468 "ConfigurationInterfaces.c"
	}
	goto __finally133;
	__catch133_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 967 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 967 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 970 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 970 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6489 "ConfigurationInterfaces.c"
	}
	__finally133:
#line 967 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 967 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 967 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6498 "ConfigurationInterfaces.c"
}


PhotoFileFormat configuration_facade_get_export_photo_file_format (ConfigurationFacade* self) {
#line 966 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 966 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_photo_file_format (self);
#line 6507 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		PhotoFileFormat _tmp2_;
		gint _tmp3_;
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = photo_file_format;
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = photo_file_format_serialize (_tmp2_);
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, _tmp3_, &_inner_error_);
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6534 "ConfigurationInterfaces.c"
				goto __catch134_configuration_error;
			}
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6543 "ConfigurationInterfaces.c"
		}
	}
	goto __finally134;
	__catch134_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp4_);
#line 981 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 981 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6563 "ConfigurationInterfaces.c"
	}
	__finally134:
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6574 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format) {
#line 976 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 976 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_photo_file_format (self, photo_file_format);
#line 6584 "ConfigurationInterfaces.c"
}


static JpegQuality configuration_facade_real_get_export_quality (ConfigurationFacade* self) {
	JpegQuality result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_QUALITY, &_inner_error_);
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6613 "ConfigurationInterfaces.c"
				goto __catch135_configuration_error;
			}
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6622 "ConfigurationInterfaces.c"
		}
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = (JpegQuality) _tmp0_;
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6628 "ConfigurationInterfaces.c"
	}
	goto __finally135;
	__catch135_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 986 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 986 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 989 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 989 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6649 "ConfigurationInterfaces.c"
	}
	__finally135:
#line 986 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 986 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 986 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6658 "ConfigurationInterfaces.c"
}


JpegQuality configuration_facade_get_export_quality (ConfigurationFacade* self) {
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_quality (self);
#line 6667 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_quality (ConfigurationFacade* self, JpegQuality quality) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		JpegQuality _tmp2_;
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = quality;
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_QUALITY, (gint) _tmp2_, &_inner_error_);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6691 "ConfigurationInterfaces.c"
				goto __catch136_configuration_error;
			}
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6700 "ConfigurationInterfaces.c"
		}
	}
	goto __finally136;
	__catch136_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6720 "ConfigurationInterfaces.c"
	}
	__finally136:
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6731 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_quality (ConfigurationFacade* self, JpegQuality quality) {
#line 995 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 995 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_quality (self, quality);
#line 6741 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_export_scale (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_SCALE, &_inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6769 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6773 "ConfigurationInterfaces.c"
				goto __catch137_configuration_error;
			}
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 6782 "ConfigurationInterfaces.c"
		}
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1006 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6788 "ConfigurationInterfaces.c"
	}
	goto __finally137;
	__catch137_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1005 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1005 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1008 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1008 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6809 "ConfigurationInterfaces.c"
	}
	__finally137:
#line 1005 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1005 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1005 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 6818 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_export_scale (ConfigurationFacade* self) {
#line 1004 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1004 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_scale (self);
#line 6827 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_scale (ConfigurationFacade* self, gint scale) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = scale;
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_SCALE, _tmp2_, &_inner_error_);
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6851 "ConfigurationInterfaces.c"
				goto __catch138_configuration_error;
			}
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6860 "ConfigurationInterfaces.c"
		}
	}
	goto __finally138;
	__catch138_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1019 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1019 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6880 "ConfigurationInterfaces.c"
	}
	__finally138:
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6891 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_scale (ConfigurationFacade* self, gint scale) {
#line 1014 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1014 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_scale (self, scale);
#line 6901 "ConfigurationInterfaces.c"
}


static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self) {
	RawDeveloper result = 0;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		RawDeveloper _tmp5_;
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, &_inner_error_);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6931 "ConfigurationInterfaces.c"
				goto __catch139_configuration_error;
			}
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6940 "ConfigurationInterfaces.c"
		}
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = raw_developer_from_string (_tmp0_);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6950 "ConfigurationInterfaces.c"
	}
	goto __finally139;
	__catch139_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1027 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1027 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1031 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1033 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = RAW_DEVELOPER_CAMERA;
#line 1033 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1033 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6971 "ConfigurationInterfaces.c"
	}
	__finally139:
#line 1027 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1027 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1027 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6980 "ConfigurationInterfaces.c"
}


RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self) {
#line 1026 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1026 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_default_raw_developer (self);
#line 6989 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		RawDeveloper _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = d;
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = raw_developer_to_string (_tmp2_);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, _tmp4_, &_inner_error_);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp4_);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7021 "ConfigurationInterfaces.c"
				goto __catch140_configuration_error;
			}
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7030 "ConfigurationInterfaces.c"
		}
	}
	goto __finally140;
	__catch140_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7050 "ConfigurationInterfaces.c"
	}
	__finally140:
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7061 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
#line 1037 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1037 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_default_raw_developer (self, d);
#line 7071 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, &_inner_error_);
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7099 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7103 "ConfigurationInterfaces.c"
				goto __catch141_configuration_error;
			}
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7112 "ConfigurationInterfaces.c"
		}
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7118 "ConfigurationInterfaces.c"
	}
	goto __finally141;
	__catch141_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1054 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1054 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1056 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1056 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1056 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7139 "ConfigurationInterfaces.c"
	}
	__finally141:
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7148 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self) {
#line 1050 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1050 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_hide_photos_already_imported (self);
#line 7157 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = hide_imported;
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, _tmp2_, &_inner_error_);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7181 "ConfigurationInterfaces.c"
				goto __catch142_configuration_error;
			}
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7190 "ConfigurationInterfaces.c"
		}
	}
	goto __finally142;
	__catch142_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1064 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1064 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7208 "ConfigurationInterfaces.c"
	}
	__finally142:
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7219 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
#line 1060 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1060 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_hide_photos_already_imported (self, hide_imported);
#line 7229 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_IMPORT_DIR, &_inner_error_);
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7259 "ConfigurationInterfaces.c"
				goto __catch143_configuration_error;
			}
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 7268 "ConfigurationInterfaces.c"
		}
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1073 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7280 "ConfigurationInterfaces.c"
	}
	goto __finally143;
	__catch143_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7304 "ConfigurationInterfaces.c"
	}
	__finally143:
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 7313 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_import_dir (ConfigurationFacade* self) {
#line 1071 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1071 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_import_dir (self);
#line 7322 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
	GError * _inner_error_ = NULL;
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (import_dir != NULL);
#line 7330 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = import_dir;
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_IMPORT_DIR, _tmp2_, &_inner_error_);
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7349 "ConfigurationInterfaces.c"
				goto __catch144_configuration_error;
			}
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7358 "ConfigurationInterfaces.c"
		}
	}
	goto __finally144;
	__catch144_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1082 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1082 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1085 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1085 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1082 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7376 "ConfigurationInterfaces.c"
	}
	__finally144:
#line 1082 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1082 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1082 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1082 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7387 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_import_dir (self, import_dir);
#line 7397 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, &_inner_error_);
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7425 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7429 "ConfigurationInterfaces.c"
				goto __catch145_configuration_error;
			}
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7438 "ConfigurationInterfaces.c"
		}
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7444 "ConfigurationInterfaces.c"
	}
	goto __finally145;
	__catch145_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1093 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1093 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1096 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1096 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1098 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1098 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1098 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7465 "ConfigurationInterfaces.c"
	}
	__finally145:
#line 1093 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1093 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1093 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7474 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self) {
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_keep_relativity (self);
#line 7483 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = keep_relativity;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, _tmp2_, &_inner_error_);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7507 "ConfigurationInterfaces.c"
				goto __catch146_configuration_error;
			}
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7516 "ConfigurationInterfaces.c"
		}
	}
	goto __finally146;
	__catch146_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7534 "ConfigurationInterfaces.c"
	}
	__finally146:
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7545 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
#line 1102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_keep_relativity (self, keep_relativity);
#line 7555 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, &_inner_error_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7583 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7587 "ConfigurationInterfaces.c"
				goto __catch147_configuration_error;
			}
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7596 "ConfigurationInterfaces.c"
		}
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7602 "ConfigurationInterfaces.c"
	}
	goto __finally147;
	__catch147_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1118 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1118 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1118 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7623 "ConfigurationInterfaces.c"
	}
	__finally147:
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7632 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self) {
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_pin_toolbar_state (self);
#line 7641 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state;
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, _tmp2_, &_inner_error_);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7665 "ConfigurationInterfaces.c"
				goto __catch148_configuration_error;
			}
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7674 "ConfigurationInterfaces.c"
		}
	}
	goto __finally148;
	__catch148_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7692 "ConfigurationInterfaces.c"
	}
	__finally148:
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7703 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
#line 1122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_pin_toolbar_state (self, state);
#line 7713 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, &_inner_error_);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7741 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7745 "ConfigurationInterfaces.c"
				goto __catch149_configuration_error;
			}
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7754 "ConfigurationInterfaces.c"
		}
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7760 "ConfigurationInterfaces.c"
	}
	goto __finally149;
	__catch149_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 1138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7781 "ConfigurationInterfaces.c"
	}
	__finally149:
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7790 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_height (ConfigurationFacade* self) {
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_height (self);
#line 7799 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, _tmp2_, &_inner_error_);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7823 "ConfigurationInterfaces.c"
				goto __catch150_configuration_error;
			}
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7832 "ConfigurationInterfaces.c"
		}
	}
	goto __finally150;
	__catch150_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7850 "ConfigurationInterfaces.c"
	}
	__finally150:
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7861 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice) {
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_height (self, choice);
#line 7871 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, &_inner_error_);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7899 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7903 "ConfigurationInterfaces.c"
				goto __catch151_configuration_error;
			}
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7912 "ConfigurationInterfaces.c"
		}
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7918 "ConfigurationInterfaces.c"
	}
	goto __finally151;
	__catch151_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1154 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1154 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7939 "ConfigurationInterfaces.c"
	}
	__finally151:
#line 1154 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1154 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1154 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7948 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self) {
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_menu_choice (self);
#line 7957 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, _tmp2_, &_inner_error_);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7981 "ConfigurationInterfaces.c"
				goto __catch152_configuration_error;
			}
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7990 "ConfigurationInterfaces.c"
		}
	}
	goto __finally152;
	__catch152_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8008 "ConfigurationInterfaces.c"
	}
	__finally152:
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8019 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_menu_choice (self, choice);
#line 8029 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, &_inner_error_);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8057 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8061 "ConfigurationInterfaces.c"
				goto __catch153_configuration_error;
			}
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 8070 "ConfigurationInterfaces.c"
		}
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8076 "ConfigurationInterfaces.c"
	}
	goto __finally153;
	__catch153_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1181 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1181 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8097 "ConfigurationInterfaces.c"
	}
	__finally153:
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 8106 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_width (ConfigurationFacade* self) {
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_width (self);
#line 8115 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, _tmp2_, &_inner_error_);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8139 "ConfigurationInterfaces.c"
				goto __catch154_configuration_error;
			}
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8148 "ConfigurationInterfaces.c"
		}
	}
	goto __finally154;
	__catch154_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1190 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1190 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8166 "ConfigurationInterfaces.c"
	}
	__finally154:
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8177 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice) {
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_width (self, choice);
#line 8187 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, &_inner_error_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8217 "ConfigurationInterfaces.c"
				goto __catch155_configuration_error;
			}
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 8226 "ConfigurationInterfaces.c"
		}
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8238 "ConfigurationInterfaces.c"
	}
	goto __finally155;
	__catch155_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8262 "ConfigurationInterfaces.c"
	}
	__finally155:
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 8271 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self) {
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_service (self);
#line 8280 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 8288 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, _tmp2_, &_inner_error_);
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8307 "ConfigurationInterfaces.c"
				goto __catch156_configuration_error;
			}
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8316 "ConfigurationInterfaces.c"
		}
	}
	goto __finally156;
	__catch156_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1211 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1211 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1214 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1214 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1211 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8334 "ConfigurationInterfaces.c"
	}
	__finally156:
#line 1211 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1211 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1211 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1211 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8345 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_service (self, service_name);
#line 8355 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, &_inner_error_);
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8385 "ConfigurationInterfaces.c"
				goto __catch157_configuration_error;
			}
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 8394 "ConfigurationInterfaces.c"
		}
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8406 "ConfigurationInterfaces.c"
	}
	goto __finally157;
	__catch157_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8430 "ConfigurationInterfaces.c"
	}
	__finally157:
#line 1222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 8439 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self) {
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_dataimports_service (self);
#line 8448 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 8456 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, _tmp2_, &_inner_error_);
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8475 "ConfigurationInterfaces.c"
				goto __catch158_configuration_error;
			}
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8484 "ConfigurationInterfaces.c"
		}
	}
	goto __finally158;
	__catch158_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1235 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1235 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1235 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8502 "ConfigurationInterfaces.c"
	}
	__finally158:
#line 1235 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1235 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1235 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1235 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8513 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_dataimports_service (self, service_name);
#line 8523 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 1246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 8535 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_;
		ConfigurationEngine* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8563 "ConfigurationInterfaces.c"
				goto __catch159_configuration_error;
			}
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8572 "ConfigurationInterfaces.c"
		}
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, &_inner_error_);
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8592 "ConfigurationInterfaces.c"
				goto __catch159_configuration_error;
			}
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8601 "ConfigurationInterfaces.c"
		}
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 8605 "ConfigurationInterfaces.c"
	}
	goto __finally159;
	__catch159_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8622 "ConfigurationInterfaces.c"
	}
	__finally159:
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8633 "ConfigurationInterfaces.c"
	}
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 8639 "ConfigurationInterfaces.c"
	}
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 8645 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_photos_sort (self, sort_order, sort_by);
#line 8655 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		gint _tmp5_;
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8682 "ConfigurationInterfaces.c"
				goto __catch160_configuration_error;
			}
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8691 "ConfigurationInterfaces.c"
		}
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8707 "ConfigurationInterfaces.c"
				goto __catch160_configuration_error;
			}
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8716 "ConfigurationInterfaces.c"
		}
	}
	goto __finally160;
	__catch160_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8734 "ConfigurationInterfaces.c"
	}
	__finally160:
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8745 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 1257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_photos_sort (self, sort_order, sort_by);
#line 8755 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 1272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 8767 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint w = 0;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint h = 0;
		ConfigurationEngine* _tmp9_;
		ConfigurationEngine* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, &_inner_error_);
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8802 "ConfigurationInterfaces.c"
				goto __catch161_configuration_error;
			}
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8811 "ConfigurationInterfaces.c"
		}
#line 1275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, &_inner_error_);
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8831 "ConfigurationInterfaces.c"
				goto __catch161_configuration_error;
			}
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8840 "ConfigurationInterfaces.c"
		}
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, &_inner_error_);
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8858 "ConfigurationInterfaces.c"
				goto __catch161_configuration_error;
			}
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8867 "ConfigurationInterfaces.c"
		}
#line 1278 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 1278 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 1278 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 8875 "ConfigurationInterfaces.c"
	}
	goto __finally161;
	__catch161_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1280 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 1280 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8892 "ConfigurationInterfaces.c"
	}
	__finally161:
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8903 "ConfigurationInterfaces.c"
	}
#line 1271 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 1271 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 8909 "ConfigurationInterfaces.c"
	}
#line 1271 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 1271 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 8915 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 1271 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1271 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_window_state (self, maximize, dimensions);
#line 8925 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 8933 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
		ConfigurationEngine* _tmp7_;
		ConfigurationEngine* _tmp8_;
		Dimensions _tmp9_;
		gint _tmp10_;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8960 "ConfigurationInterfaces.c"
				goto __catch162_configuration_error;
			}
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8969 "ConfigurationInterfaces.c"
		}
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8987 "ConfigurationInterfaces.c"
				goto __catch162_configuration_error;
			}
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8996 "ConfigurationInterfaces.c"
		}
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9014 "ConfigurationInterfaces.c"
				goto __catch162_configuration_error;
			}
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9023 "ConfigurationInterfaces.c"
		}
	}
	goto __finally162;
	__catch162_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9041 "ConfigurationInterfaces.c"
	}
	__finally162:
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9052 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_window_state (self, maximize, dimensions);
#line 9062 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, &_inner_error_);
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9090 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9094 "ConfigurationInterfaces.c"
				goto __catch163_configuration_error;
			}
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9103 "ConfigurationInterfaces.c"
		}
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9109 "ConfigurationInterfaces.c"
	}
	goto __finally163;
	__catch163_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9130 "ConfigurationInterfaces.c"
	}
	__finally163:
#line 1300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 9139 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self) {
#line 1299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_modify_originals (self);
#line 9148 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = modify_originals;
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, _tmp2_, &_inner_error_);
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9172 "ConfigurationInterfaces.c"
				goto __catch164_configuration_error;
			}
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9181 "ConfigurationInterfaces.c"
		}
	}
	goto __finally164;
	__catch164_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9199 "ConfigurationInterfaces.c"
	}
	__finally164:
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9210 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_modify_originals (self, modify_originals);
#line 9220 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, &_inner_error_);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9248 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9252 "ConfigurationInterfaces.c"
				goto __catch165_configuration_error;
			}
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9261 "ConfigurationInterfaces.c"
		}
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9267 "ConfigurationInterfaces.c"
	}
	goto __finally165;
	__catch165_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 1322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = thumbnail_get_DEFAULT_SCALE ();
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp8_;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9294 "ConfigurationInterfaces.c"
	}
	__finally165:
#line 1322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp9_;
#line 9303 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self) {
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_photo_thumbnail_scale (self);
#line 9312 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = scale;
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, _tmp2_, &_inner_error_);
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9336 "ConfigurationInterfaces.c"
				goto __catch166_configuration_error;
			}
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9345 "ConfigurationInterfaces.c"
		}
	}
	goto __finally166;
	__catch166_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9363 "ConfigurationInterfaces.c"
	}
	__finally166:
#line 1331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9374 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_photo_thumbnail_scale (self, scale);
#line 9384 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, &_inner_error_);
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9412 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9416 "ConfigurationInterfaces.c"
				goto __catch167_configuration_error;
			}
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9425 "ConfigurationInterfaces.c"
		}
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9431 "ConfigurationInterfaces.c"
	}
	goto __finally167;
	__catch167_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 5.0;
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9452 "ConfigurationInterfaces.c"
	}
	__finally167:
#line 1342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 9461 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self) {
#line 1341 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1341 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_height (self);
#line 9470 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_height;
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, _tmp2_, &_inner_error_);
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9494 "ConfigurationInterfaces.c"
				goto __catch168_configuration_error;
			}
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9503 "ConfigurationInterfaces.c"
		}
	}
	goto __finally168;
	__catch168_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9521 "ConfigurationInterfaces.c"
	}
	__finally168:
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9532 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_height (self, content_height);
#line 9542 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, &_inner_error_);
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9570 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9574 "ConfigurationInterfaces.c"
				goto __catch169_configuration_error;
			}
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9583 "ConfigurationInterfaces.c"
		}
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9589 "ConfigurationInterfaces.c"
	}
	goto __finally169;
	__catch169_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9610 "ConfigurationInterfaces.c"
	}
	__finally169:
#line 1364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1364 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 9619 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self) {
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_layout (self);
#line 9628 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = layout_code;
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, _tmp2_ + 1, &_inner_error_);
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9652 "ConfigurationInterfaces.c"
				goto __catch170_configuration_error;
			}
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9661 "ConfigurationInterfaces.c"
		}
	}
	goto __finally170;
	__catch170_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9679 "ConfigurationInterfaces.c"
	}
	__finally170:
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9690 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_layout (self, layout_code);
#line 9700 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, &_inner_error_);
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9728 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9732 "ConfigurationInterfaces.c"
				goto __catch171_configuration_error;
			}
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9741 "ConfigurationInterfaces.c"
		}
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9747 "ConfigurationInterfaces.c"
	}
	goto __finally171;
	__catch171_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1389 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1389 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1391 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 600;
#line 1391 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1391 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9768 "ConfigurationInterfaces.c"
	}
	__finally171:
#line 1386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 9777 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self) {
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_ppi (self);
#line 9786 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_ppi;
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, _tmp2_, &_inner_error_);
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9810 "ConfigurationInterfaces.c"
				goto __catch172_configuration_error;
			}
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9819 "ConfigurationInterfaces.c"
		}
	}
	goto __finally172;
	__catch172_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1399 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1399 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9837 "ConfigurationInterfaces.c"
	}
	__finally172:
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9848 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_ppi (self, content_ppi);
#line 9858 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, &_inner_error_);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9886 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9890 "ConfigurationInterfaces.c"
				goto __catch173_configuration_error;
			}
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9899 "ConfigurationInterfaces.c"
		}
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9905 "ConfigurationInterfaces.c"
	}
	goto __finally173;
	__catch173_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1412 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1412 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1412 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9926 "ConfigurationInterfaces.c"
	}
	__finally173:
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 9935 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_units (ConfigurationFacade* self) {
#line 1406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_units (self);
#line 9944 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = units_code;
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, _tmp2_ + 1, &_inner_error_);
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9968 "ConfigurationInterfaces.c"
				goto __catch174_configuration_error;
			}
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9977 "ConfigurationInterfaces.c"
		}
	}
	goto __finally174;
	__catch174_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9995 "ConfigurationInterfaces.c"
	}
	__finally174:
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10006 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
#line 1416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_units (self, units_code);
#line 10016 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, &_inner_error_);
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10044 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10048 "ConfigurationInterfaces.c"
				goto __catch175_configuration_error;
			}
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10057 "ConfigurationInterfaces.c"
		}
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1430 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10063 "ConfigurationInterfaces.c"
	}
	goto __finally175;
	__catch175_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1434 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 7.0;
#line 1434 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1434 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10084 "ConfigurationInterfaces.c"
	}
	__finally175:
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10093 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self) {
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_width (self);
#line 10102 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_width;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, _tmp2_, &_inner_error_);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10126 "ConfigurationInterfaces.c"
				goto __catch176_configuration_error;
			}
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10135 "ConfigurationInterfaces.c"
		}
	}
	goto __finally176;
	__catch176_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10153 "ConfigurationInterfaces.c"
	}
	__finally176:
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10164 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
#line 1438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_width (self, content_width);
#line 10174 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, &_inner_error_);
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10202 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10206 "ConfigurationInterfaces.c"
				goto __catch177_configuration_error;
			}
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10215 "ConfigurationInterfaces.c"
		}
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10221 "ConfigurationInterfaces.c"
	}
	goto __finally177;
	__catch177_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10242 "ConfigurationInterfaces.c"
	}
	__finally177:
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10251 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self) {
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_images_per_page (self);
#line 10260 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = images_per_page_code;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, _tmp2_ + 1, &_inner_error_);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10284 "ConfigurationInterfaces.c"
				goto __catch178_configuration_error;
			}
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10293 "ConfigurationInterfaces.c"
		}
	}
	goto __finally178;
	__catch178_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10311 "ConfigurationInterfaces.c"
	}
	__finally178:
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10322 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
#line 1460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_images_per_page (self, images_per_page_code);
#line 10332 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, &_inner_error_);
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10360 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10364 "ConfigurationInterfaces.c"
				goto __catch179_configuration_error;
			}
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10373 "ConfigurationInterfaces.c"
		}
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10379 "ConfigurationInterfaces.c"
	}
	goto __finally179;
	__catch179_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1473 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1473 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10400 "ConfigurationInterfaces.c"
	}
	__finally179:
#line 1473 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1473 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1473 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10409 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_match_aspect_ratio (self);
#line 10418 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = match_aspect_ratio;
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, _tmp2_, &_inner_error_);
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10442 "ConfigurationInterfaces.c"
				goto __catch180_configuration_error;
			}
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10451 "ConfigurationInterfaces.c"
		}
	}
	goto __finally180;
	__catch180_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10469 "ConfigurationInterfaces.c"
	}
	__finally180:
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10480 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
#line 1482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_match_aspect_ratio (self, match_aspect_ratio);
#line 10490 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, &_inner_error_);
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10518 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10522 "ConfigurationInterfaces.c"
				goto __catch181_configuration_error;
			}
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10531 "ConfigurationInterfaces.c"
		}
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10537 "ConfigurationInterfaces.c"
	}
	goto __finally181;
	__catch181_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10558 "ConfigurationInterfaces.c"
	}
	__finally181:
#line 1495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10567 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self) {
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_print_titles (self);
#line 10576 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = print_titles;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, _tmp2_, &_inner_error_);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10600 "ConfigurationInterfaces.c"
				goto __catch182_configuration_error;
			}
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10609 "ConfigurationInterfaces.c"
		}
	}
	goto __finally182;
	__catch182_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10627 "ConfigurationInterfaces.c"
	}
	__finally182:
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10638 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_print_titles (self, print_titles);
#line 10648 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint val = 0;
		gint _tmp6_;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, &_inner_error_);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10678 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10682 "ConfigurationInterfaces.c"
				goto __catch183_configuration_error;
			}
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10691 "ConfigurationInterfaces.c"
		}
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		val = _tmp0_ - 1;
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = val;
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (_tmp6_ == -2) {
#line 10699 "ConfigurationInterfaces.c"
			ResourcesUnitSystem _tmp7_;
#line 1520 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = resources_get_default_measurement_unit ();
#line 1520 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_tmp7_ == RESOURCES_UNIT_SYSTEM_IMPERIAL) {
#line 1521 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
				val = 2;
#line 10707 "ConfigurationInterfaces.c"
			} else {
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
				val = 10;
#line 10711 "ConfigurationInterfaces.c"
			}
		}
#line 1527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = val;
#line 1527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10718 "ConfigurationInterfaces.c"
	}
	goto __finally183;
	__catch183_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = err;
#line 1529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp8_);
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10739 "ConfigurationInterfaces.c"
	}
	__finally183:
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp9_;
#line 10748 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self) {
#line 1516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_size_selection (self);
#line 10757 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = size_code;
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, _tmp2_ + 1, &_inner_error_);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10781 "ConfigurationInterfaces.c"
				goto __catch184_configuration_error;
			}
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10790 "ConfigurationInterfaces.c"
		}
	}
	goto __finally184;
	__catch184_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10808 "ConfigurationInterfaces.c"
	}
	__finally184:
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10819 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_size_selection (self, size_code);
#line 10829 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, &_inner_error_);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10859 "ConfigurationInterfaces.c"
				goto __catch185_configuration_error;
			}
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 10868 "ConfigurationInterfaces.c"
		}
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10880 "ConfigurationInterfaces.c"
	}
	goto __finally185;
	__catch185_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("Sans Bold 12");
#line 1555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10904 "ConfigurationInterfaces.c"
	}
	__finally185:
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 10913 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self) {
#line 1547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_titles_font (self);
#line 10922 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
	GError * _inner_error_ = NULL;
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (font_name != NULL);
#line 10930 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = font_name;
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, _tmp2_, &_inner_error_);
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10949 "ConfigurationInterfaces.c"
				goto __catch186_configuration_error;
			}
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10958 "ConfigurationInterfaces.c"
		}
	}
	goto __finally186;
	__catch186_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10976 "ConfigurationInterfaces.c"
	}
	__finally186:
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10987 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_titles_font (self, font_name);
#line 10997 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, &_inner_error_);
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11025 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11029 "ConfigurationInterfaces.c"
				goto __catch187_configuration_error;
			}
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11038 "ConfigurationInterfaces.c"
		}
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11044 "ConfigurationInterfaces.c"
	}
	goto __finally187;
	__catch187_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11065 "ConfigurationInterfaces.c"
	}
	__finally187:
#line 1571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11074 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self) {
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_show_welcome_dialog (self);
#line 11083 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show;
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, _tmp2_, &_inner_error_);
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11107 "ConfigurationInterfaces.c"
				goto __catch188_configuration_error;
			}
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11116 "ConfigurationInterfaces.c"
		}
	}
	goto __finally188;
	__catch188_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11134 "ConfigurationInterfaces.c"
	}
	__finally188:
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11145 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_show_welcome_dialog (self, show);
#line 11155 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, &_inner_error_);
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11183 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11187 "ConfigurationInterfaces.c"
				goto __catch189_configuration_error;
			}
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11196 "ConfigurationInterfaces.c"
		}
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11202 "ConfigurationInterfaces.c"
	}
	goto __finally189;
	__catch189_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 180;
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11223 "ConfigurationInterfaces.c"
	}
	__finally189:
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11232 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_sidebar_position (ConfigurationFacade* self) {
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_sidebar_position (self);
#line 11241 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = position;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, _tmp2_, &_inner_error_);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11265 "ConfigurationInterfaces.c"
				goto __catch190_configuration_error;
			}
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11274 "ConfigurationInterfaces.c"
		}
	}
	goto __finally190;
	__catch190_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11292 "ConfigurationInterfaces.c"
	}
	__finally190:
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11303 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position) {
#line 1602 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1602 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_sidebar_position (self, position);
#line 11313 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, &_inner_error_);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11341 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11345 "ConfigurationInterfaces.c"
				goto __catch191_configuration_error;
			}
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11354 "ConfigurationInterfaces.c"
		}
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11360 "ConfigurationInterfaces.c"
	}
	goto __finally191;
	__catch191_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1619 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 3.0;
#line 1619 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1619 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11381 "ConfigurationInterfaces.c"
	}
	__finally191:
#line 1614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1614 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11390 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self) {
#line 1613 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1613 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_delay (self);
#line 11399 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, _tmp2_, &_inner_error_);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11423 "ConfigurationInterfaces.c"
				goto __catch192_configuration_error;
			}
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11432 "ConfigurationInterfaces.c"
		}
	}
	goto __finally192;
	__catch192_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11450 "ConfigurationInterfaces.c"
	}
	__finally192:
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11461 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_delay (self, delay);
#line 11471 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, &_inner_error_);
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11499 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11503 "ConfigurationInterfaces.c"
				goto __catch193_configuration_error;
			}
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11512 "ConfigurationInterfaces.c"
		}
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11518 "ConfigurationInterfaces.c"
	}
	goto __finally193;
	__catch193_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0.3;
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11539 "ConfigurationInterfaces.c"
	}
	__finally193:
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11548 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self) {
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_delay (self);
#line 11557 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, _tmp2_, &_inner_error_);
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11581 "ConfigurationInterfaces.c"
				goto __catch194_configuration_error;
			}
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11590 "ConfigurationInterfaces.c"
		}
	}
	goto __finally194;
	__catch194_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11608 "ConfigurationInterfaces.c"
	}
	__finally194:
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11619 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
#line 1645 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1645 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_delay (self, delay);
#line 11629 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, &_inner_error_);
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11659 "ConfigurationInterfaces.c"
				goto __catch195_configuration_error;
			}
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 11668 "ConfigurationInterfaces.c"
		}
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11680 "ConfigurationInterfaces.c"
	}
	goto __finally195;
	__catch195_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1662 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1662 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup (TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11704 "ConfigurationInterfaces.c"
	}
	__finally195:
#line 1658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 11713 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
#line 1657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_effect_id (self);
#line 11722 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
	GError * _inner_error_ = NULL;
#line 1670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 11730 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = id;
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, _tmp2_, &_inner_error_);
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11749 "ConfigurationInterfaces.c"
				goto __catch196_configuration_error;
			}
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11758 "ConfigurationInterfaces.c"
		}
	}
	goto __finally196;
	__catch196_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1675 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1675 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11776 "ConfigurationInterfaces.c"
	}
	__finally196:
#line 1671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11787 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
#line 1670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1670 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_effect_id (self, id);
#line 11797 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, &_inner_error_);
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11825 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11829 "ConfigurationInterfaces.c"
				goto __catch197_configuration_error;
			}
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11838 "ConfigurationInterfaces.c"
		}
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11844 "ConfigurationInterfaces.c"
	}
	goto __finally197;
	__catch197_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1683 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1683 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11865 "ConfigurationInterfaces.c"
	}
	__finally197:
#line 1683 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1683 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1683 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11874 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self) {
#line 1682 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1682 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_show_title (self);
#line 11883 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show_title;
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, _tmp2_, &_inner_error_);
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11907 "ConfigurationInterfaces.c"
				goto __catch198_configuration_error;
			}
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11916 "ConfigurationInterfaces.c"
		}
	}
	goto __finally198;
	__catch198_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1696 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1696 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11934 "ConfigurationInterfaces.c"
	}
	__finally198:
#line 1693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11945 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
#line 1692 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1692 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_show_title (self, show_title);
#line 11955 "ConfigurationInterfaces.c"
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2846 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2846 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2847 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2847 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return;
#line 11970 "ConfigurationInterfaces.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
#line 2854 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 12016 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, &_inner_error_);
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12044 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12048 "ConfigurationInterfaces.c"
				goto __catch199_configuration_error;
			}
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 12057 "ConfigurationInterfaces.c"
		}
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12063 "ConfigurationInterfaces.c"
	}
	goto __finally199;
	__catch199_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		struct tm _tmp7_ = {0};
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
#line 1704 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1704 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1707 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1707 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_time_local ((time_t) 0, &_tmp7_);
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = g_time_format (&_tmp7_, "%p");
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = is_string_empty (_tmp9_);
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = _tmp10_;
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp9_);
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp11_;
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12101 "ConfigurationInterfaces.c"
	}
	__finally199:
#line 1704 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1704 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1704 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp12_;
#line 12110 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self) {
#line 1703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_24_hour_time (self);
#line 12119 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = use_24_hour_time;
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, _tmp2_, &_inner_error_);
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12143 "ConfigurationInterfaces.c"
				goto __catch200_configuration_error;
			}
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1717 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12152 "ConfigurationInterfaces.c"
		}
	}
	goto __finally200;
	__catch200_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12170 "ConfigurationInterfaces.c"
	}
	__finally200:
#line 1716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12181 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
#line 1715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_24_hour_time (self, use_24_hour_time);
#line 12191 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, &_inner_error_);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12219 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12223 "ConfigurationInterfaces.c"
				goto __catch201_configuration_error;
			}
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 12232 "ConfigurationInterfaces.c"
		}
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12238 "ConfigurationInterfaces.c"
	}
	goto __finally201;
	__catch201_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1730 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1730 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12259 "ConfigurationInterfaces.c"
	}
	__finally201:
#line 1727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 12268 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self) {
#line 1726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_lowercase_filenames (self);
#line 12277 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = b;
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, _tmp2_, &_inner_error_);
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12301 "ConfigurationInterfaces.c"
				goto __catch202_configuration_error;
			}
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1738 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12310 "ConfigurationInterfaces.c"
		}
	}
	goto __finally202;
	__catch202_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1740 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1740 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12328 "ConfigurationInterfaces.c"
	}
	__finally202:
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12339 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
#line 1736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_lowercase_filenames (self, b);
#line 12349 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, &_inner_error_);
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12377 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12381 "ConfigurationInterfaces.c"
				goto __catch203_configuration_error;
			}
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 12390 "ConfigurationInterfaces.c"
		}
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1749 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12396 "ConfigurationInterfaces.c"
	}
	goto __finally203;
	__catch203_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = -1;
#line 1754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12417 "ConfigurationInterfaces.c"
	}
	__finally203:
#line 1748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 12426 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
#line 1747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_video_interpreter_state_cookie (self);
#line 12435 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state_cookie;
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, _tmp2_, &_inner_error_);
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12459 "ConfigurationInterfaces.c"
				goto __catch204_configuration_error;
			}
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12468 "ConfigurationInterfaces.c"
		}
	}
	goto __finally204;
	__catch204_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1759 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1759 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1759 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12486 "ConfigurationInterfaces.c"
	}
	__finally204:
#line 1759 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1759 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1759 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1759 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12497 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
#line 1758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_video_interpreter_state_cookie (self, state_cookie);
#line 12507 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
	gboolean result = FALSE;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
#line 1770 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 1770 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 1770 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 12549 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 1770 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1770 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_bool (self, domain, id, key, def);
#line 12558 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
#line 1774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 12591 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 1774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_bool (self, domain, id, key, val);
#line 12600 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
	gdouble result = 0.0;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0.0);
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0.0);
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0.0);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 12642 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_double (self, domain, id, key, def);
#line 12651 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_;
#line 1782 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1782 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1782 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 12684 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 1782 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1782 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_double (self, domain, id, key, val);
#line 12693 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
	gint result = 0;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
#line 1786 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0);
#line 1786 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1786 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1787 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 12735 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 1786 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1786 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_int (self, domain, id, key, def);
#line 12744 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 12777 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_int (self, domain, id, key, val);
#line 12786 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	gchar* _tmp11_;
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_string (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_result_ = _tmp7_;
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp9_ = _result_;
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_strcmp0 (_tmp9_, "") == 0) {
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = NULL;
#line 12836 "ConfigurationInterfaces.c"
	} else {
		const gchar* _tmp10_;
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _result_;
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp10_;
#line 12843 "ConfigurationInterfaces.c"
	}
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp11_ = g_strdup (_tmp8_);
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp11_;
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_result_);
#line 1796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 12853 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_string (self, domain, id, key, def);
#line 12862 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
	const gchar* _tmp0_;
	ConfigurationEngine* _tmp1_;
	ConfigurationEngine* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = val;
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (_tmp0_ == NULL) {
#line 1801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		val = "";
#line 12886 "ConfigurationInterfaces.c"
	}
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configuration_facade_get_engine (self);
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = domain;
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = id;
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = key;
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = val;
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_string (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 1803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp2_);
#line 12904 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_string (self, domain, id, key, val);
#line 12913 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 1806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_unset_plugin_key (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 12943 "ConfigurationInterfaces.c"
}


void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 1806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1806 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->unset_plugin_key (self, domain, id, key);
#line 12952 "ConfigurationInterfaces.c"
}


static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
	FuzzyPropertyState result = 0;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	FuzzyPropertyState _tmp3_;
	FuzzyPropertyState _tmp4_;
#line 1813 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = configuration_engine_is_plugin_enabled (_tmp1_, _tmp2_);
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = _tmp3_;
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp4_;
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 12981 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
#line 1813 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1813 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->is_plugin_enabled (self, id);
#line 12990 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
#line 1817 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = enabled;
#line 1818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_enabled (_tmp1_, _tmp2_, _tmp3_);
#line 1818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 13013 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
#line 1817 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1817 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_enabled (self, id, enabled);
#line 13022 "ConfigurationInterfaces.c"
}


static void configuration_facade_class_init (ConfigurationFacadeClass * klass) {
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_parent_class = g_type_class_peek_parent (klass);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_type_class_add_private (klass, sizeof (ConfigurationFacadePrivate));
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_auto_import_from_library = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_auto_import_from_library;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_auto_import_from_library = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_auto_import_from_library;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_bg_color_name = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_bg_color_name;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_bg_color_name = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_bg_color_name;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_commit_metadata_to_masters = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_commit_metadata_to_masters;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_commit_metadata_to_masters = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_commit_metadata_to_masters;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_desktop_background = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_desktop_background;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_desktop_background = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_desktop_background;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_screensaver = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_screensaver;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_screensaver = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_screensaver;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_directory_pattern;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_directory_pattern;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern_custom = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_directory_pattern_custom;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern_custom = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_directory_pattern_custom;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_direct_window_state = (void (*) (ConfigurationFacade *, gboolean*, Dimensions*)) configuration_facade_real_get_direct_window_state;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_direct_window_state = (void (*) (ConfigurationFacade *, gboolean, Dimensions*)) configuration_facade_real_set_direct_window_state;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_basic_properties = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_basic_properties;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_basic_properties = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_basic_properties;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_extended_properties = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_extended_properties;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_extended_properties = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_extended_properties;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_sidebar = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_sidebar;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_sidebar = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_sidebar;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_toolbar = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_toolbar;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_toolbar = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_toolbar;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_search_bar = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_search_bar;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_search_bar = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_search_bar;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_ratings = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_ratings;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_ratings = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_ratings;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_tags = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_tags;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_tags = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_tags;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_titles = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_titles;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_titles = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_titles;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_comments = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_comments;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_comments = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_comments;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_event_comments = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_event_comments;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_event_comments = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_event_comments;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_event_photos_sort = (void (*) (ConfigurationFacade *, gboolean*, gint*)) configuration_facade_real_get_event_photos_sort;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_event_photos_sort = (void (*) (ConfigurationFacade *, gboolean, gint)) configuration_facade_real_set_event_photos_sort;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_events_sort_ascending = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_events_sort_ascending;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_events_sort_ascending = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_events_sort_ascending;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_photo_app = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_external_photo_app;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_photo_app = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_external_photo_app;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_raw_app = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_external_raw_app;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_raw_app = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_external_raw_app;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_constraint = (ScaleConstraint (*) (ConfigurationFacade *)) configuration_facade_real_get_export_constraint;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_constraint = (void (*) (ConfigurationFacade *, ScaleConstraint)) configuration_facade_real_set_export_constraint;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_export_format_mode = (ExportFormatMode (*) (ConfigurationFacade *)) configuration_facade_real_get_export_export_format_mode;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_export_format_mode = (void (*) (ConfigurationFacade *, ExportFormatMode)) configuration_facade_real_set_export_export_format_mode;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_export_metadata = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_export_export_metadata;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_export_metadata = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_export_export_metadata;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_photo_file_format = (PhotoFileFormat (*) (ConfigurationFacade *)) configuration_facade_real_get_export_photo_file_format;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_photo_file_format = (void (*) (ConfigurationFacade *, PhotoFileFormat)) configuration_facade_real_set_export_photo_file_format;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_quality = (JpegQuality (*) (ConfigurationFacade *)) configuration_facade_real_get_export_quality;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_quality = (void (*) (ConfigurationFacade *, JpegQuality)) configuration_facade_real_set_export_quality;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_scale = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_export_scale;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_scale = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_export_scale;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_default_raw_developer = (RawDeveloper (*) (ConfigurationFacade *)) configuration_facade_real_get_default_raw_developer;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_default_raw_developer = (void (*) (ConfigurationFacade *, RawDeveloper)) configuration_facade_real_set_default_raw_developer;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_hide_photos_already_imported = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_hide_photos_already_imported;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_hide_photos_already_imported = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_hide_photos_already_imported;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_import_dir = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_import_dir;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_import_dir = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_import_dir;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_keep_relativity = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_keep_relativity;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_keep_relativity = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_keep_relativity;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_pin_toolbar_state = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_pin_toolbar_state;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_pin_toolbar_state = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_pin_toolbar_state;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_height = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_last_crop_height;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_height = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_last_crop_height;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_menu_choice = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_last_crop_menu_choice;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_menu_choice = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_last_crop_menu_choice;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_width = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_last_crop_width;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_width = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_last_crop_width;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_service = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_last_used_service;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_service = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_last_used_service;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_dataimports_service = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_last_used_dataimports_service;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_dataimports_service = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_last_used_dataimports_service;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_photos_sort = (void (*) (ConfigurationFacade *, gboolean*, gint*)) configuration_facade_real_get_library_photos_sort;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_photos_sort = (void (*) (ConfigurationFacade *, gboolean, gint)) configuration_facade_real_set_library_photos_sort;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_window_state = (void (*) (ConfigurationFacade *, gboolean*, Dimensions*)) configuration_facade_real_get_library_window_state;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_window_state = (void (*) (ConfigurationFacade *, gboolean, Dimensions*)) configuration_facade_real_set_library_window_state;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_modify_originals = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_modify_originals;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_modify_originals = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_modify_originals;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_photo_thumbnail_scale = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_photo_thumbnail_scale;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_photo_thumbnail_scale = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_photo_thumbnail_scale;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_height = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_height;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_height = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_printing_content_height;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_layout = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_layout;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_layout = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_content_layout;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_ppi = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_ppi;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_ppi = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_content_ppi;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_units = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_units;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_units = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_content_units;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_width = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_width;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_width = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_printing_content_width;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_images_per_page = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_images_per_page;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_images_per_page = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_images_per_page;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_match_aspect_ratio = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_match_aspect_ratio;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_match_aspect_ratio = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_printing_match_aspect_ratio;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_print_titles = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_print_titles;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_print_titles = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_printing_print_titles;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_size_selection = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_size_selection;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_size_selection = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_size_selection;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_titles_font = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_titles_font;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_titles_font = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_printing_titles_font;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_show_welcome_dialog = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_show_welcome_dialog;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_show_welcome_dialog = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_show_welcome_dialog;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_sidebar_position = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_sidebar_position;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_sidebar_position = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_sidebar_position;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_delay = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_delay;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_delay = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_slideshow_delay;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_delay = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_transition_delay;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_delay = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_slideshow_transition_delay;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_effect_id = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_transition_effect_id;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_effect_id = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_slideshow_transition_effect_id;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_show_title = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_show_title;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_show_title = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_slideshow_show_title;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_24_hour_time = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_use_24_hour_time;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_24_hour_time = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_use_24_hour_time;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_lowercase_filenames = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_use_lowercase_filenames;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_lowercase_filenames = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_use_lowercase_filenames;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_video_interpreter_state_cookie = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_video_interpreter_state_cookie;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_video_interpreter_state_cookie = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_video_interpreter_state_cookie;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_bool = (gboolean (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gboolean)) configuration_facade_real_get_plugin_bool;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_bool = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gboolean)) configuration_facade_real_set_plugin_bool;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_double = (gdouble (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gdouble)) configuration_facade_real_get_plugin_double;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_double = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gdouble)) configuration_facade_real_set_plugin_double;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_int = (gint (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gint)) configuration_facade_real_get_plugin_int;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_int = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gint)) configuration_facade_real_set_plugin_int;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_string = (gchar* (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, const gchar*)) configuration_facade_real_get_plugin_string;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_string = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, const gchar*)) configuration_facade_real_set_plugin_string;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->unset_plugin_key = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*)) configuration_facade_real_unset_plugin_key;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->is_plugin_enabled = (FuzzyPropertyState (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_is_plugin_enabled;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_enabled = (void (*) (ConfigurationFacade *, const gchar*, gboolean)) configuration_facade_real_set_plugin_enabled;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (klass)->finalize = configuration_facade_finalize;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL] = g_signal_new ("auto-import-from-library-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL] = g_signal_new ("bg-color-name-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL] = g_signal_new ("commit-metadata-to-masters-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL] = g_signal_new ("events-sort-ascending-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL] = g_signal_new ("external-app-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL] = g_signal_new ("import-directory-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13311 "ConfigurationInterfaces.c"
}


static void configuration_facade_instance_init (ConfigurationFacade * self) {
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv = CONFIGURATION_FACADE_GET_PRIVATE (self);
#line 13318 "ConfigurationInterfaces.c"
}


static void configuration_facade_finalize (GObject * obj) {
	ConfigurationFacade * self;
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIGURATION_FACADE, ConfigurationFacade);
#line 346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (configuration_facade_parent_class)->finalize (obj);
#line 13330 "ConfigurationInterfaces.c"
}


GType configuration_facade_get_type (void) {
	static volatile gsize configuration_facade_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_facade_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationFacadeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) configuration_facade_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigurationFacade), 0, (GInstanceInitFunc) configuration_facade_instance_init, NULL };
		GType configuration_facade_type_id;
		configuration_facade_type_id = g_type_register_static (G_TYPE_OBJECT, "ConfigurationFacade", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&configuration_facade_type_id__volatile, configuration_facade_type_id);
	}
	return configuration_facade_type_id__volatile;
}



