/* HierarchicalTagUtilities.c generated by valac 0.36.6, the Vala compiler
 * generated from HierarchicalTagUtilities.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_HIERARCHICAL_TAG_UTILITIES (hierarchical_tag_utilities_get_type ())
#define HIERARCHICAL_TAG_UTILITIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilities))
#define HIERARCHICAL_TAG_UTILITIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilitiesClass))
#define IS_HIERARCHICAL_TAG_UTILITIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES))
#define IS_HIERARCHICAL_TAG_UTILITIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_UTILITIES))
#define HIERARCHICAL_TAG_UTILITIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilitiesClass))

typedef struct _HierarchicalTagUtilities HierarchicalTagUtilities;
typedef struct _HierarchicalTagUtilitiesClass HierarchicalTagUtilitiesClass;
typedef struct _HierarchicalTagUtilitiesPrivate HierarchicalTagUtilitiesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
typedef struct _ParamSpecHierarchicalTagUtilities ParamSpecHierarchicalTagUtilities;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _HierarchicalTagUtilities {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HierarchicalTagUtilitiesPrivate * priv;
};

struct _HierarchicalTagUtilitiesClass {
	GTypeClass parent_class;
	void (*finalize) (HierarchicalTagUtilities *self);
};

struct _ParamSpecHierarchicalTagUtilities {
	GParamSpec parent_instance;
};


static gpointer hierarchical_tag_utilities_parent_class = NULL;
extern TagSourceCollection* tag_global;

gpointer hierarchical_tag_utilities_ref (gpointer instance);
void hierarchical_tag_utilities_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_utilities (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_tag_utilities (GValue* value, gpointer v_object);
void value_take_hierarchical_tag_utilities (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_tag_utilities (const GValue* value);
GType hierarchical_tag_utilities_get_type (void) G_GNUC_CONST;
enum  {
	HIERARCHICAL_TAG_UTILITIES_DUMMY_PROPERTY
};
gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
#define TAG_PATH_SEPARATOR_STRING "/"
gchar* hierarchical_tag_utilities_hierarchical_to_flat (const gchar* path);
GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
GeeList* hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path);
gchar* hierarchical_tag_utilities_join_path_components (gchar** path_components, int path_components_length1);
gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
gchar* hierarchical_tag_utilities_canonicalize (const gchar* in_tag, const gchar* foreign_separator);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value, gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
HierarchicalTagIndex* hierarchical_tag_index_new (void);
HierarchicalTagIndex* hierarchical_tag_index_construct (GType object_type);
gboolean hierarchical_tag_index_is_path_known (HierarchicalTagIndex* self, const gchar* path);
void hierarchical_tag_index_add_path (HierarchicalTagIndex* self, const gchar* tag, const gchar* path);
gchar* hierarchical_tag_utilities_get_root_path_form (const gchar* client_path);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
gboolean tag_source_collection_exists (TagSourceCollection* self, const gchar* name, gboolean treat_htags_as_root);
void hierarchical_tag_utilities_cleanup_root_path (const gchar* path);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType tag_get_type (void) G_GNUC_CONST;
Tag* tag_for_path (const gchar* name);
GeeList* tag_get_hierarchical_children (Tag* self);
void tag_flatten (Tag* self);
HierarchicalTagUtilities* hierarchical_tag_utilities_new (void);
HierarchicalTagUtilities* hierarchical_tag_utilities_construct (GType object_type);
static void hierarchical_tag_utilities_finalize (HierarchicalTagUtilities * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/** 
     * converts a flat tag name 'name' (e.g., "Animals") to a tag path compatible with the
     * hierarchical tag data model (e.g., "/Animals"). if 'name' is already a path compatible with
     * the hierarchical data model, 'name' is returned untouched
     */
gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
#line 14 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 15 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = name;
#line 15 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, TAG_PATH_SEPARATOR_STRING);
#line 15 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!_tmp1_) {
#line 225 "HierarchicalTagUtilities.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 16 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp2_ = name;
#line 16 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp3_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp2_, NULL);
#line 16 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp3_;
#line 16 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 236 "HierarchicalTagUtilities.c"
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 18 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp4_ = name;
#line 18 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 18 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp5_;
#line 18 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 248 "HierarchicalTagUtilities.c"
	}
}


/**
     * converts a hierarchical tag path 'path' (e.g., "/Animals") to a flat tag name
     * (e.g., "Animals"); if 'path' is already a flat tag name, 'path' is returned untouched; note
     * that 'path' must be a top-level path (i.e., "/Animals" not "/Animals/Mammals/…") with
     * only one path component; invoking this method with a 'path' argument other than a top-level
     * path will cause an assertion failure.
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 279 "HierarchicalTagUtilities.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 287 "HierarchicalTagUtilities.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 299 "HierarchicalTagUtilities.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 323 "HierarchicalTagUtilities.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 329 "HierarchicalTagUtilities.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 333 "HierarchicalTagUtilities.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 337 "HierarchicalTagUtilities.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 349 "HierarchicalTagUtilities.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 359 "HierarchicalTagUtilities.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 365 "HierarchicalTagUtilities.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 379 "HierarchicalTagUtilities.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 389 "HierarchicalTagUtilities.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 395 "HierarchicalTagUtilities.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 404 "HierarchicalTagUtilities.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 424 "HierarchicalTagUtilities.c"
}


gchar* hierarchical_tag_utilities_hierarchical_to_flat (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
#line 28 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 29 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = path;
#line 29 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, TAG_PATH_SEPARATOR_STRING);
#line 29 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp1_) {
#line 440 "HierarchicalTagUtilities.c"
		const gchar* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp2_ = path;
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp3_ = hierarchical_tag_utilities_enumerate_path_components (_tmp2_);
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp4_ = _tmp3_;
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp6_ = _tmp5_;
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_vala_assert (_tmp6_ == 1, "enumerate_path_components(path).size == 1");
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (_tmp4_);
#line 32 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp7_ = path;
#line 32 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp8_ = string_substring (_tmp7_, (glong) 1, (glong) -1);
#line 32 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp8_;
#line 32 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 470 "HierarchicalTagUtilities.c"
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
#line 34 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp9_ = path;
#line 34 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 34 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp10_;
#line 34 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 482 "HierarchicalTagUtilities.c"
	}
}


/**
     * given a path 'path', generate all parent paths of 'path' and return them in sorted order,
     * from most basic to most derived. For example, if 'path' == "/Animals/Mammals/Elephant",
     * the list { "/Animals", "/Animals/Mammals" } is returned
     */
GeeList* hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path) {
	GeeList* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeList* _result_ = NULL;
	GeeArrayList* _tmp2_;
	gchar* accumulator = NULL;
	gchar* _tmp3_;
#line 43 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 44 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = in_path;
#line 44 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp0_);
#line 44 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp1_;
#line 46 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 46 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_result_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList);
#line 48 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = g_strdup ("");
#line 48 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	accumulator = _tmp3_;
#line 517 "HierarchicalTagUtilities.c"
	{
		GeeList* _component_list = NULL;
		const gchar* _tmp4_;
		GeeList* _tmp5_;
		gint _component_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _component_index = 0;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp4_ = path;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = hierarchical_tag_utilities_enumerate_path_components (_tmp4_);
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_component_list = _tmp5_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp6_ = _component_list;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp8_ = _tmp7_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_component_size = _tmp8_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_component_index = -1;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		while (TRUE) {
#line 545 "HierarchicalTagUtilities.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gchar* component = NULL;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp9_ = _component_index;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_component_index = _tmp9_ + 1;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp10_ = _component_index;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp11_ = _component_size;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				break;
#line 572 "HierarchicalTagUtilities.c"
			}
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp12_ = _component_list;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = _component_index;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			component = (gchar*) _tmp14_;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp15_ = accumulator;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp16_ = component;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp17_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp16_, NULL);
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp18_ = _tmp17_;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (accumulator);
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			accumulator = _tmp19_;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (_tmp18_);
#line 51 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp20_ = accumulator;
#line 51 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp21_ = path;
#line 51 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			if (g_strcmp0 (_tmp20_, _tmp21_) != 0) {
#line 604 "HierarchicalTagUtilities.c"
				GeeList* _tmp22_;
				const gchar* _tmp23_;
#line 52 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp22_ = _result_;
#line 52 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp23_ = accumulator;
#line 52 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), _tmp23_);
#line 613 "HierarchicalTagUtilities.c"
			}
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (component);
#line 617 "HierarchicalTagUtilities.c"
		}
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (_component_list);
#line 621 "HierarchicalTagUtilities.c"
	}
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _result_;
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (accumulator);
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 631 "HierarchicalTagUtilities.c"
}


/**
     * given a path 'path', enumerate all of the components of 'path' and return them in
     * order, excluding the path component separator. For example if
     * 'path' == "/Animals/Mammals/Elephant" the list { "Animals",  "Mammals", "Elephant" } will
     * be returned
     */
GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path) {
	GeeList* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* components = NULL;
	GeeArrayList* _tmp2_;
	gchar** raw_components = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint raw_components_length1;
	gint _raw_components_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
#line 64 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 65 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = in_path;
#line 65 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp0_);
#line 65 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp1_;
#line 67 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 67 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	components = _tmp2_;
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = path;
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, TAG_PATH_SEPARATOR_STRING, 0);
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	raw_components = _tmp5_;
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	raw_components_length1 = _vala_array_length (_tmp4_);
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_raw_components_size_ = raw_components_length1;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6_ = raw_components;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6__length1 = raw_components_length1;
#line 685 "HierarchicalTagUtilities.c"
	{
		gchar** component_collection = NULL;
		gint component_collection_length1 = 0;
		gint _component_collection_size_ = 0;
		gint component_it = 0;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		component_collection = _tmp6_;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		component_collection_length1 = _tmp6__length1;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		for (component_it = 0; component_it < _tmp6__length1; component_it = component_it + 1) {
#line 697 "HierarchicalTagUtilities.c"
			gchar* _tmp7_;
			gchar* component = NULL;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp7_ = g_strdup (component_collection[component_it]);
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			component = _tmp7_;
#line 704 "HierarchicalTagUtilities.c"
			{
				const gchar* _tmp8_;
#line 72 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp8_ = component;
#line 72 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (g_strcmp0 (_tmp8_, "") != 0) {
#line 711 "HierarchicalTagUtilities.c"
					GeeArrayList* _tmp9_;
					const gchar* _tmp10_;
#line 73 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp9_ = components;
#line 73 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp10_ = component;
#line 73 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
#line 720 "HierarchicalTagUtilities.c"
				}
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_g_free0 (component);
#line 724 "HierarchicalTagUtilities.c"
			}
		}
	}
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp11_ = components;
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp12_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp13_ = _tmp12_;
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_vala_assert (_tmp13_ > 0, "components.size > 0");
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (components, GEE_TYPE_LIST, GeeList);
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	raw_components = (_vala_array_free (raw_components, raw_components_length1, (GDestroyNotify) g_free), NULL);
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 744 "HierarchicalTagUtilities.c"
}


/**
     * given a list of path elements, create a fully qualified path string.
     * For example if 'path_elements' is the list { "Animals",  "Mammals", "Elephant" }
     * the path "/Animals/Mammals/Elephant" will be returned
     */
static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 1079 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		separator = "";
#line 766 "HierarchicalTagUtilities.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 776 "HierarchicalTagUtilities.c"
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 786 "HierarchicalTagUtilities.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 792 "HierarchicalTagUtilities.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 803 "HierarchicalTagUtilities.c"
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 815 "HierarchicalTagUtilities.c"
		} else {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 819 "HierarchicalTagUtilities.c"
		}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 823 "HierarchicalTagUtilities.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 827 "HierarchicalTagUtilities.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
#line 1083 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 850 "HierarchicalTagUtilities.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 0;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 859 "HierarchicalTagUtilities.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 872 "HierarchicalTagUtilities.c"
					gint _tmp10_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 878 "HierarchicalTagUtilities.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 888 "HierarchicalTagUtilities.c"
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 900 "HierarchicalTagUtilities.c"
				} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 904 "HierarchicalTagUtilities.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 910 "HierarchicalTagUtilities.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 921 "HierarchicalTagUtilities.c"
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 936 "HierarchicalTagUtilities.c"
					} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 940 "HierarchicalTagUtilities.c"
					}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 944 "HierarchicalTagUtilities.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 950 "HierarchicalTagUtilities.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 962 "HierarchicalTagUtilities.c"
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 983 "HierarchicalTagUtilities.c"
				} else {
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 987 "HierarchicalTagUtilities.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 993 "HierarchicalTagUtilities.c"
			}
		}
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 1000 "HierarchicalTagUtilities.c"
			gchar* _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return result;
#line 1008 "HierarchicalTagUtilities.c"
		}
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1046 "HierarchicalTagUtilities.c"
		{
			gboolean _tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1055 "HierarchicalTagUtilities.c"
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1071 "HierarchicalTagUtilities.c"
					gint _tmp47_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1077 "HierarchicalTagUtilities.c"
				}
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 1091 "HierarchicalTagUtilities.c"
				}
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1111 "HierarchicalTagUtilities.c"
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1126 "HierarchicalTagUtilities.c"
				} else {
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1130 "HierarchicalTagUtilities.c"
				}
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1138 "HierarchicalTagUtilities.c"
			}
		}
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = NULL;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 1149 "HierarchicalTagUtilities.c"
	} else {
		gchar* _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 1158 "HierarchicalTagUtilities.c"
	}
}


gchar* hierarchical_tag_utilities_join_path_components (gchar** path_components, int path_components_length1) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* tmp = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 87 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = path_components;
#line 87 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0__length1 = path_components_length1;
#line 87 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp0__length1 <= 0) {
#line 88 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = NULL;
#line 88 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 1189 "HierarchicalTagUtilities.c"
	}
#line 89 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = path_components;
#line 89 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1__length1 = path_components_length1;
#line 89 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = _vala_g_strjoinv (TAG_PATH_SEPARATOR_STRING, _tmp1_, _tmp1__length1);
#line 89 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	tmp = _tmp2_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = g_strdup ("");
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = tmp;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6_ = g_new0 (gchar*, 2 + 1);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6_[0] = _tmp3_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6_[1] = _tmp5_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp7_ = _tmp6_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp7__length1 = 2;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp8_ = _vala_g_strjoinv (TAG_PATH_SEPARATOR_STRING, _tmp7_, 2);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp9_ = _tmp8_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp9_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (tmp);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1227 "HierarchicalTagUtilities.c"
}


gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path) {
	gchar* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeList* components = NULL;
	GeeList* _tmp2_;
	gchar* basename = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
#line 93 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 94 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = in_path;
#line 94 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp0_);
#line 94 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp1_;
#line 96 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = hierarchical_tag_utilities_enumerate_path_components (path);
#line 96 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	components = _tmp2_;
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (components, GEE_TYPE_COLLECTION, GeeCollection));
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = _tmp3_;
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5_ = gee_list_get (components, _tmp4_ - 1);
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	basename = (gchar*) _tmp5_;
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = basename;
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_object_unref0 (components);
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1270 "HierarchicalTagUtilities.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1407 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1407 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1407 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1289 "HierarchicalTagUtilities.c"
	} else {
		const gchar* _tmp2_;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = old;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
#line 1296 "HierarchicalTagUtilities.c"
	}
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1302 "HierarchicalTagUtilities.c"
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = old;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = replacement;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
#line 1312 "HierarchicalTagUtilities.c"
	}
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1316 "HierarchicalTagUtilities.c"
		gchar* _tmp5_;
#line 1409 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = g_strdup (self);
#line 1409 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1409 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 1324 "HierarchicalTagUtilities.c"
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = old;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp9_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_free0 (_tmp8_);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		regex = _tmp10_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1356 "HierarchicalTagUtilities.c"
				goto __catch57_g_regex_error;
			}
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return NULL;
#line 1365 "HierarchicalTagUtilities.c"
		}
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = regex;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = replacement;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = _tmp14_;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1381 "HierarchicalTagUtilities.c"
				goto __catch57_g_regex_error;
			}
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return NULL;
#line 1392 "HierarchicalTagUtilities.c"
		}
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = _tmp11_;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = NULL;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp15_;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_free0 (_tmp11_);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 1406 "HierarchicalTagUtilities.c"
	}
	goto __finally57;
	__catch57_g_regex_error:
	{
		GError* e = NULL;
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1415 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1420 "HierarchicalTagUtilities.c"
	}
	__finally57:
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return NULL;
#line 1431 "HierarchicalTagUtilities.c"
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1110 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1450 "HierarchicalTagUtilities.c"
}


gchar* hierarchical_tag_utilities_canonicalize (const gchar* in_tag, const gchar* foreign_separator) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean is_valid = FALSE;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_;
	gchar* _tmp20_;
#line 103 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_tag != NULL, NULL);
#line 103 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (foreign_separator != NULL, NULL);
#line 104 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = in_tag;
#line 104 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = foreign_separator;
#line 104 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = string_replace (_tmp0_, _tmp1_, TAG_PATH_SEPARATOR_STRING);
#line 104 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_result_ = _tmp2_;
#line 106 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = _result_;
#line 106 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = g_str_has_prefix (_tmp3_, TAG_PATH_SEPARATOR_STRING);
#line 106 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!_tmp4_) {
#line 1484 "HierarchicalTagUtilities.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = _result_;
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp6_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp5_, NULL);
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_free0 (_result_);
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_result_ = _tmp6_;
#line 1495 "HierarchicalTagUtilities.c"
	}
#line 110 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	is_valid = FALSE;
#line 1499 "HierarchicalTagUtilities.c"
	{
		gint i = 0;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		i = 0;
#line 1504 "HierarchicalTagUtilities.c"
		{
			gboolean _tmp7_ = FALSE;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp7_ = TRUE;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			while (TRUE) {
#line 1511 "HierarchicalTagUtilities.c"
				gint _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar _tmp15_;
				gchar _tmp16_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (!_tmp7_) {
#line 1522 "HierarchicalTagUtilities.c"
					gint _tmp8_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp8_ = i;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					i = _tmp8_ + 1;
#line 1528 "HierarchicalTagUtilities.c"
				}
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp7_ = FALSE;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp9_ = i;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp10_ = _result_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp11_ = strlen (_tmp10_);
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp12_ = _tmp11_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (!(_tmp9_ < _tmp12_)) {
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					break;
#line 1544 "HierarchicalTagUtilities.c"
				}
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp13_ = _result_;
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp14_ = i;
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp16_ = string_get (TAG_PATH_SEPARATOR_STRING, (glong) 0);
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (_tmp15_ != _tmp16_) {
#line 113 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					is_valid = TRUE;
#line 114 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					break;
#line 1560 "HierarchicalTagUtilities.c"
				}
			}
		}
	}
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp18_ = is_valid;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp18_) {
#line 1569 "HierarchicalTagUtilities.c"
		const gchar* _tmp19_;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp19_ = _result_;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp17_ = _tmp19_;
#line 1575 "HierarchicalTagUtilities.c"
	} else {
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp17_ = NULL;
#line 1579 "HierarchicalTagUtilities.c"
	}
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp20_ = g_strdup (_tmp17_);
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp20_;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (_result_);
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1589 "HierarchicalTagUtilities.c"
}


gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 121 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_tag != NULL, NULL);
#line 122 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = in_tag;
#line 122 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = string_replace (_tmp0_, TAG_PATH_SEPARATOR_STRING, "-");
#line 122 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp1_;
#line 122 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1607 "HierarchicalTagUtilities.c"
}


HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords) {
	HierarchicalTagIndex* result = NULL;
	HierarchicalTagIndex* index = NULL;
	HierarchicalTagIndex* _tmp0_;
#line 125 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (h_keywords), NULL);
#line 126 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = hierarchical_tag_index_new ();
#line 126 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	index = _tmp0_;
#line 1621 "HierarchicalTagUtilities.c"
	{
		GeeIterator* _keyword_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp1_ = h_keywords;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_keyword_it = _tmp2_;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		while (TRUE) {
#line 1634 "HierarchicalTagUtilities.c"
			GeeIterator* _tmp3_;
			gboolean _tmp4_;
			gchar* keyword = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeList* parent_paths = NULL;
			const gchar* _tmp7_;
			GeeList* _tmp8_;
			GeeList* path_components = NULL;
			const gchar* _tmp9_;
			GeeList* _tmp10_;
			GeeList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			HierarchicalTagIndex* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			const gchar* _tmp43_;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp3_ = _keyword_it;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			if (!_tmp4_) {
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				break;
#line 1665 "HierarchicalTagUtilities.c"
			}
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp5_ = _keyword_it;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			keyword = (gchar*) _tmp6_;
#line 129 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp7_ = keyword;
#line 129 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp8_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp7_);
#line 129 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			parent_paths = _tmp8_;
#line 131 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp9_ = keyword;
#line 131 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp10_ = hierarchical_tag_utilities_enumerate_path_components (_tmp9_);
#line 131 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			path_components = _tmp10_;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp11_ = parent_paths;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = _tmp12_;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp14_ = path_components;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp16_ = _tmp15_;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_vala_assert (_tmp13_ <= _tmp16_, "parent_paths.size <= path_components.size");
#line 1699 "HierarchicalTagUtilities.c"
			{
				gint i = 0;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				i = 0;
#line 1704 "HierarchicalTagUtilities.c"
				{
					gboolean _tmp17_ = FALSE;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp17_ = TRUE;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					while (TRUE) {
#line 1711 "HierarchicalTagUtilities.c"
						gint _tmp19_;
						GeeList* _tmp20_;
						gint _tmp21_;
						gint _tmp22_;
						HierarchicalTagIndex* _tmp23_;
						GeeList* _tmp24_;
						gint _tmp25_;
						gpointer _tmp26_;
						gchar* _tmp27_;
						gboolean _tmp28_;
						gboolean _tmp29_;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						if (!_tmp17_) {
#line 1725 "HierarchicalTagUtilities.c"
							gint _tmp18_;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp18_ = i;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							i = _tmp18_ + 1;
#line 1731 "HierarchicalTagUtilities.c"
						}
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp17_ = FALSE;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp19_ = i;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp20_ = parent_paths;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp22_ = _tmp21_;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						if (!(_tmp19_ < _tmp22_)) {
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							break;
#line 1747 "HierarchicalTagUtilities.c"
						}
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp23_ = index;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp24_ = path_components;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp25_ = i;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp27_ = (gchar*) _tmp26_;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp28_ = hierarchical_tag_index_is_path_known (_tmp23_, _tmp27_);
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp29_ = !_tmp28_;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_g_free0 (_tmp27_);
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						if (_tmp29_) {
#line 1767 "HierarchicalTagUtilities.c"
							HierarchicalTagIndex* _tmp30_;
							GeeList* _tmp31_;
							gint _tmp32_;
							gpointer _tmp33_;
							gchar* _tmp34_;
							GeeList* _tmp35_;
							gint _tmp36_;
							gpointer _tmp37_;
							gchar* _tmp38_;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp30_ = index;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp31_ = path_components;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp32_ = i;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp33_ = gee_list_get (_tmp31_, _tmp32_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp34_ = (gchar*) _tmp33_;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp35_ = parent_paths;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp36_ = i;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp37_ = gee_list_get (_tmp35_, _tmp36_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp38_ = (gchar*) _tmp37_;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							hierarchical_tag_index_add_path (_tmp30_, _tmp34_, _tmp38_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_g_free0 (_tmp38_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_g_free0 (_tmp34_);
#line 1801 "HierarchicalTagUtilities.c"
						}
					}
				}
			}
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp39_ = index;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp40_ = keyword;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp41_ = hierarchical_tag_utilities_get_basename (_tmp40_);
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp42_ = _tmp41_;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp43_ = keyword;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			hierarchical_tag_index_add_path (_tmp39_, _tmp42_, _tmp43_);
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (_tmp42_);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (path_components);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (parent_paths);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (keyword);
#line 1826 "HierarchicalTagUtilities.c"
		}
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (_keyword_it);
#line 1830 "HierarchicalTagUtilities.c"
	}
#line 144 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = index;
#line 144 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1836 "HierarchicalTagUtilities.c"
}


gchar* hierarchical_tag_utilities_get_root_path_form (const gchar* client_path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	gchar* path = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TagSourceCollection* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp20_ = NULL;
	TagSourceCollection* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	gchar* _tmp25_;
#line 148 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = client_path;
#line 148 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp0_ == NULL) {
#line 149 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = NULL;
#line 149 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 1868 "HierarchicalTagUtilities.c"
	}
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = client_path;
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp1_);
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = _tmp2_;
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5_ = _tmp4_;
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6_ = _tmp5_ != 0;
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_object_unref0 (_tmp3_);
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp6_) {
#line 1886 "HierarchicalTagUtilities.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 152 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp7_ = client_path;
#line 152 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 152 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp8_;
#line 152 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 1897 "HierarchicalTagUtilities.c"
	}
#line 154 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp9_ = client_path;
#line 154 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 154 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp10_;
#line 156 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp11_ = tag_global;
#line 156 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp12_ = path;
#line 156 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp13_ = tag_source_collection_exists (_tmp11_, _tmp12_, FALSE);
#line 156 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!_tmp13_) {
#line 1913 "HierarchicalTagUtilities.c"
		const gchar* _tmp14_;
		gboolean _tmp15_;
#line 157 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp14_ = path;
#line 157 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp15_ = g_str_has_prefix (_tmp14_, TAG_PATH_SEPARATOR_STRING);
#line 157 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp15_) {
#line 1922 "HierarchicalTagUtilities.c"
			const gchar* _tmp16_;
			gchar* _tmp17_;
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp16_ = path;
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp17_ = hierarchical_tag_utilities_hierarchical_to_flat (_tmp16_);
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (path);
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			path = _tmp17_;
#line 1933 "HierarchicalTagUtilities.c"
		} else {
			const gchar* _tmp18_;
			gchar* _tmp19_;
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp18_ = path;
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp19_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp18_);
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (path);
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			path = _tmp19_;
#line 1945 "HierarchicalTagUtilities.c"
		}
	}
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp21_ = tag_global;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp22_ = path;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp23_ = tag_source_collection_exists (_tmp21_, _tmp22_, FALSE);
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp23_) {
#line 1956 "HierarchicalTagUtilities.c"
		const gchar* _tmp24_;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp24_ = path;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp20_ = _tmp24_;
#line 1962 "HierarchicalTagUtilities.c"
	} else {
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp20_ = NULL;
#line 1966 "HierarchicalTagUtilities.c"
	}
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp25_ = g_strdup (_tmp20_);
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp25_;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1976 "HierarchicalTagUtilities.c"
}


void hierarchical_tag_utilities_cleanup_root_path (const gchar* path) {
	GeeList* paths = NULL;
	const gchar* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 166 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_if_fail (path != NULL);
#line 167 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = path;
#line 167 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp0_);
#line 167 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	paths = _tmp1_;
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = paths;
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = _tmp3_;
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp4_ == 0) {
#line 2003 "HierarchicalTagUtilities.c"
		gchar* actual_path = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		Tag* t = NULL;
		TagSourceCollection* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp13_ = FALSE;
		Tag* _tmp14_;
#line 170 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = path;
#line 170 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp6_ = hierarchical_tag_utilities_get_root_path_form (_tmp5_);
#line 170 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		actual_path = _tmp6_;
#line 172 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp7_ = actual_path;
#line 172 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp7_ == NULL) {
#line 173 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (actual_path);
#line 173 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (paths);
#line 173 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			return;
#line 2030 "HierarchicalTagUtilities.c"
		}
#line 175 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		t = NULL;
#line 176 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp8_ = tag_global;
#line 176 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp9_ = actual_path;
#line 176 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp10_ = tag_source_collection_exists (_tmp8_, _tmp9_, FALSE);
#line 176 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp10_) {
#line 2042 "HierarchicalTagUtilities.c"
			const gchar* _tmp11_;
			Tag* _tmp12_;
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp11_ = actual_path;
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp12_ = tag_for_path (_tmp11_);
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (t);
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			t = _tmp12_;
#line 2053 "HierarchicalTagUtilities.c"
		}
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp14_ = t;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp14_ != NULL) {
#line 2059 "HierarchicalTagUtilities.c"
			Tag* _tmp15_;
			GeeList* _tmp16_;
			GeeList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp15_ = t;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp16_ = tag_get_hierarchical_children (_tmp15_);
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp17_ = _tmp16_;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp18_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp19_ = _tmp18_;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = _tmp19_ == 0;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (_tmp17_);
#line 2079 "HierarchicalTagUtilities.c"
		} else {
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = FALSE;
#line 2083 "HierarchicalTagUtilities.c"
		}
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp13_) {
#line 2087 "HierarchicalTagUtilities.c"
			Tag* _tmp20_;
#line 180 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp20_ = t;
#line 180 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			tag_flatten (_tmp20_);
#line 2093 "HierarchicalTagUtilities.c"
		}
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (t);
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_free0 (actual_path);
#line 2099 "HierarchicalTagUtilities.c"
	}
#line 166 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_object_unref0 (paths);
#line 2103 "HierarchicalTagUtilities.c"
}


HierarchicalTagUtilities* hierarchical_tag_utilities_construct (GType object_type) {
	HierarchicalTagUtilities* self = NULL;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	self = (HierarchicalTagUtilities*) g_type_create_instance (object_type);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return self;
#line 2113 "HierarchicalTagUtilities.c"
}


HierarchicalTagUtilities* hierarchical_tag_utilities_new (void) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return hierarchical_tag_utilities_construct (TYPE_HIERARCHICAL_TAG_UTILITIES);
#line 2120 "HierarchicalTagUtilities.c"
}


static void value_hierarchical_tag_utilities_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	value->data[0].v_pointer = NULL;
#line 2127 "HierarchicalTagUtilities.c"
}


static void value_hierarchical_tag_utilities_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_unref (value->data[0].v_pointer);
#line 2136 "HierarchicalTagUtilities.c"
	}
}


static void value_hierarchical_tag_utilities_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		dest_value->data[0].v_pointer = hierarchical_tag_utilities_ref (src_value->data[0].v_pointer);
#line 2146 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2150 "HierarchicalTagUtilities.c"
	}
}


static gpointer value_hierarchical_tag_utilities_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return value->data[0].v_pointer;
#line 2158 "HierarchicalTagUtilities.c"
}


static gchar* value_hierarchical_tag_utilities_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (collect_values[0].v_pointer) {
#line 2165 "HierarchicalTagUtilities.c"
		HierarchicalTagUtilities * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2172 "HierarchicalTagUtilities.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2176 "HierarchicalTagUtilities.c"
		}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = hierarchical_tag_utilities_ref (object);
#line 2180 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = NULL;
#line 2184 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return NULL;
#line 2188 "HierarchicalTagUtilities.c"
}


static gchar* value_hierarchical_tag_utilities_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HierarchicalTagUtilities ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2199 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		*object_p = NULL;
#line 2205 "HierarchicalTagUtilities.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		*object_p = value->data[0].v_pointer;
#line 2209 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		*object_p = hierarchical_tag_utilities_ref (value->data[0].v_pointer);
#line 2213 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return NULL;
#line 2217 "HierarchicalTagUtilities.c"
}


GParamSpec* param_spec_hierarchical_tag_utilities (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHierarchicalTagUtilities* spec;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HIERARCHICAL_TAG_UTILITIES), NULL);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return G_PARAM_SPEC (spec);
#line 2231 "HierarchicalTagUtilities.c"
}


gpointer value_get_hierarchical_tag_utilities (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES), NULL);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return value->data[0].v_pointer;
#line 2240 "HierarchicalTagUtilities.c"
}


void value_set_hierarchical_tag_utilities (GValue* value, gpointer v_object) {
	HierarchicalTagUtilities * old;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_ref (value->data[0].v_pointer);
#line 2260 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = NULL;
#line 2264 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_unref (old);
#line 2270 "HierarchicalTagUtilities.c"
	}
}


void value_take_hierarchical_tag_utilities (GValue* value, gpointer v_object) {
	HierarchicalTagUtilities * old;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = v_object;
#line 2289 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = NULL;
#line 2293 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_unref (old);
#line 2299 "HierarchicalTagUtilities.c"
	}
}


static void hierarchical_tag_utilities_class_init (HierarchicalTagUtilitiesClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	hierarchical_tag_utilities_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	((HierarchicalTagUtilitiesClass *) klass)->finalize = hierarchical_tag_utilities_finalize;
#line 2309 "HierarchicalTagUtilities.c"
}


static void hierarchical_tag_utilities_instance_init (HierarchicalTagUtilities * self) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	self->ref_count = 1;
#line 2316 "HierarchicalTagUtilities.c"
}


static void hierarchical_tag_utilities_finalize (HierarchicalTagUtilities * obj) {
	HierarchicalTagUtilities * self;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilities);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_signal_handlers_destroy (self);
#line 2326 "HierarchicalTagUtilities.c"
}


GType hierarchical_tag_utilities_get_type (void) {
	static volatile gsize hierarchical_tag_utilities_type_id__volatile = 0;
	if (g_once_init_enter (&hierarchical_tag_utilities_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_hierarchical_tag_utilities_init, value_hierarchical_tag_utilities_free_value, value_hierarchical_tag_utilities_copy_value, value_hierarchical_tag_utilities_peek_pointer, "p", value_hierarchical_tag_utilities_collect_value, "p", value_hierarchical_tag_utilities_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HierarchicalTagUtilitiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hierarchical_tag_utilities_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HierarchicalTagUtilities), 0, (GInstanceInitFunc) hierarchical_tag_utilities_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType hierarchical_tag_utilities_type_id;
		hierarchical_tag_utilities_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HierarchicalTagUtilities", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&hierarchical_tag_utilities_type_id__volatile, hierarchical_tag_utilities_type_id);
	}
	return hierarchical_tag_utilities_type_id__volatile;
}


gpointer hierarchical_tag_utilities_ref (gpointer instance) {
	HierarchicalTagUtilities * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return instance;
#line 2351 "HierarchicalTagUtilities.c"
}


void hierarchical_tag_utilities_unref (gpointer instance) {
	HierarchicalTagUtilities * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		HIERARCHICAL_TAG_UTILITIES_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2364 "HierarchicalTagUtilities.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



