/* EventDirectoryItem.c generated by valac 0.36.6, the Vala compiler
 * generated from EventDirectoryItem.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_EVENT_DIRECTORY_ITEM (event_directory_item_get_type ())
#define EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem))
#define EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))
#define IS_EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_DIRECTORY_ITEM))
#define IS_EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_DIRECTORY_ITEM))
#define EVENT_DIRECTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))

typedef struct _EventDirectoryItem EventDirectoryItem;
typedef struct _EventDirectoryItemClass EventDirectoryItemClass;
typedef struct _EventDirectoryItemPrivate EventDirectoryItemPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_EVENT_SOURCE_COLLECTION (event_source_collection_get_type ())
#define EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollection))
#define EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))
#define IS_EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE_COLLECTION))
#define IS_EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE_COLLECTION))
#define EVENT_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))

typedef struct _EventSourceCollection EventSourceCollection;
typedef struct _EventSourceCollectionClass EventSourceCollectionClass;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _EventDirectoryItem {
	CheckerboardItem parent_instance;
	EventDirectoryItemPrivate * priv;
	Event* event;
};

struct _EventDirectoryItemClass {
	CheckerboardItemClass parent_class;
};

struct _EventDirectoryItemPrivate {
	GdkRectangle paul_lynde;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, void* user_data);
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;


static gpointer event_directory_item_parent_class = NULL;
extern EventSourceCollection* event_global;
extern Scaling event_directory_item_squared_scaling;
Scaling event_directory_item_squared_scaling = {0};

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType event_directory_item_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
#define EVENT_DIRECTORY_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemPrivate))
enum  {
	EVENT_DIRECTORY_ITEM_DUMMY_PROPERTY
};
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType event_source_collection_get_type (void) G_GNUC_CONST;
static void event_directory_item_on_events_altered (EventDirectoryItem* self, GeeMap* map);
static void _event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_to_fill_viewport (Dimensions* viewport, Scaling* result);
static gint event_directory_item_get_CROPPED_SCALE (void);
void dimensions_init (Dimensions *self, gint width, gint height);
EventDirectoryItem* event_directory_item_new (Event* event);
EventDirectoryItem* event_directory_item_construct (GType object_type, Event* event);
static gchar* event_directory_item_get_formatted_title (Event* event);
gchar* event_source_get_comment (EventSource* self);
CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
GType media_source_get_type (void) G_GNUC_CONST;
static void event_directory_item_get_paul_lynde_rect (MediaSource* source, GdkRectangle* result);
MediaSource* event_get_primary_source (Event* self);
void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim);
void dimensions_for_rectangle (GdkRectangle* rect, Dimensions* result);
void scaling_get_scaled_dimensions (Scaling *self, Dimensions* original, Dimensions* result);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
static GdkPixbuf* event_directory_item_get_paul_lynde (MediaSource* media, GdkRectangle* paul_lynde, GError** error);
GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self, Scaling* scaling, GError** error);
void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source, gint scale, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
#define THUMBNAIL_CACHE_DEFAULT_INTERP GDK_INTERP_HYPER
static void ___lambda17_ (void);
static void ____lambda17__thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void clamp_rectangle (GdkRectangle* original, Dimensions* max, GdkRectangle* result);
gboolean media_source_collection_has_photo (GeeCollection* media);
GeeCollection* event_source_get_media (EventSource* self);
gboolean media_source_collection_has_video (GeeCollection* media);
gint event_source_get_media_count (EventSource* self);
gchar* event_get_formatted_daterange (Event* self);
gchar* data_object_get_name (DataObject* self);
gchar* guarded_markup_escape_text (const gchar* plain);
static void event_directory_item_real_exposed (CheckerboardItem* base);
gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf);
gchar* data_object_to_string (DataObject* self);
static void event_directory_item_update_comment (EventDirectoryItem* self, gboolean init);
void checkerboard_item_exposed (CheckerboardItem* self);
static void event_directory_item_real_unexposed (CheckerboardItem* base);
void checkerboard_item_unexposed (CheckerboardItem* self);
void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void event_directory_item_real_thumbnail_altered (ThumbnailView* base);
static void event_directory_item_real_paint_shadow (CheckerboardItem* base, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
static void event_directory_item_real_paint_border (CheckerboardItem* base, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result);
void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result);
void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
static void event_directory_item_real_paint_image (CheckerboardItem* base, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
void context_rounded_corners (cairo_t* cx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
gboolean is_string_empty (const gchar* s);
void checkerboard_item_clear_comment (CheckerboardItem* self);
void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
static void event_directory_item_finalize (GObject * obj);
static void _vala_event_directory_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_on_events_altered ((EventDirectoryItem*) self, items);
#line 463 "EventDirectoryItem.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self ? g_object_ref (self) : NULL;
#line 470 "EventDirectoryItem.c"
}


EventDirectoryItem* event_directory_item_construct (GType object_type, Event* event) {
	EventDirectoryItem * self = NULL;
	Event* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_ = {0};
	Event* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	Event* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	Event* _tmp12_;
	Event* _tmp13_;
	Event* _tmp14_;
	MediaSource* _tmp15_;
	MediaSource* _tmp16_;
	GdkRectangle _tmp17_ = {0};
	GdkRectangle _tmp18_;
	Dimensions _tmp19_ = {0};
	EventSourceCollection* _tmp20_;
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_EVENT (event), NULL);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_directory_item_get_CROPPED_SCALE ();
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = _tmp1_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = event_directory_item_get_CROPPED_SCALE ();
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = _tmp3_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = event;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = event_directory_item_get_formatted_title (_tmp6_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = _tmp7_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = event;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_EVENT_SOURCE, EventSource));
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = _tmp10_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = (EventDirectoryItem*) checkerboard_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp5_, _tmp8_, _tmp11_, TRUE, PANGO_ALIGN_CENTER);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (_tmp11_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (_tmp8_);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = event;
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (self->event);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->event = _tmp13_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = event;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = event_get_primary_source (_tmp14_);
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = _tmp15_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_get_paul_lynde_rect (_tmp16_, &_tmp17_);
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv->paul_lynde = _tmp17_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp16_);
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp18_ = self->priv->paul_lynde;
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_rectangle (&_tmp18_, &_tmp19_);
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp19_);
#line 35 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp20_ = event_global;
#line 35 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self, 0);
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self;
#line 561 "EventDirectoryItem.c"
}


EventDirectoryItem* event_directory_item_new (Event* event) {
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return event_directory_item_construct (TYPE_EVENT_DIRECTORY_ITEM, event);
#line 568 "EventDirectoryItem.c"
}


static void event_directory_item_get_paul_lynde_rect (MediaSource* source, GdkRectangle* result) {
	Dimensions scaled = {0};
	MediaSource* _tmp0_;
	Dimensions _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
	GdkRectangle paul_lynde = {0};
	Dimensions _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	Dimensions _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Dimensions _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	Dimensions _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
#line 43 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (source));
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = source;
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	media_source_get_dimensions (_tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaling_get_scaled_dimensions (&event_directory_item_squared_scaling, &_tmp1_, &_tmp2_);
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaled = _tmp2_;
#line 46 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	memset (&paul_lynde, 0, sizeof (GdkRectangle));
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = scaled;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = _tmp3_.width;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = event_directory_item_get_CROPPED_SCALE ();
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = _tmp5_;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = scaled;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = _tmp7_.width;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = CLAMP (_tmp4_ - _tmp6_, 0, _tmp8_);
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.x = _tmp9_ / 2;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = scaled;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = _tmp10_.height;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = event_directory_item_get_CROPPED_SCALE ();
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = _tmp12_;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = scaled;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = _tmp14_.height;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = CLAMP (_tmp11_ - _tmp13_, 0, _tmp15_);
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.y = _tmp16_ / 2;
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp17_ = event_directory_item_get_CROPPED_SCALE ();
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp18_ = _tmp17_;
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.width = _tmp18_;
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp19_ = event_directory_item_get_CROPPED_SCALE ();
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp20_ = _tmp19_;
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.height = _tmp20_;
#line 52 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	*result = paul_lynde;
#line 52 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return;
#line 656 "EventDirectoryItem.c"
}


static void ___lambda17_ (void) {
}


static void ____lambda17__thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self) {
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	___lambda17_ ();
#line 667 "EventDirectoryItem.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self ? g_error_copy (self) : NULL;
#line 674 "EventDirectoryItem.c"
}


static GdkPixbuf* event_directory_item_get_paul_lynde (MediaSource* media, GdkRectangle* paul_lynde, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	Dimensions thumbnail_dimensions = {0};
	GdkPixbuf* _tmp17_;
	Dimensions _tmp18_ = {0};
	gboolean _tmp19_ = FALSE;
	Dimensions _tmp20_;
	gint _tmp21_;
	GdkRectangle _tmp22_;
	gint _tmp23_;
	GdkRectangle _tmp37_;
	Dimensions _tmp38_;
	GdkRectangle _tmp39_ = {0};
	GdkPixbuf* _tmp40_;
	GdkRectangle _tmp41_;
	gint _tmp42_;
	GdkRectangle _tmp43_;
	gint _tmp44_;
	GdkRectangle _tmp45_;
	gint _tmp46_;
	GdkRectangle _tmp47_;
	gint _tmp48_;
	GdkPixbuf* _tmp49_;
	GError * _inner_error_ = NULL;
#line 56 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
#line 56 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (paul_lynde != NULL, NULL);
#line 707 "EventDirectoryItem.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		MediaSource* _tmp1_;
		Scaling _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp1_ = media;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp2_ = event_directory_item_squared_scaling;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = media_source_get_preview_pixbuf (_tmp1_, &_tmp2_, &_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp0_ = _tmp3_;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 724 "EventDirectoryItem.c"
			goto __catch52_g_error;
		}
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp0_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (pixbuf);
#line 60 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		pixbuf = _tmp4_;
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp0_);
#line 737 "EventDirectoryItem.c"
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError* _error_ = NULL;
		MediaSource* _tmp5_;
		Dimensions _tmp6_ = {0};
		MediaSource* _tmp7_;
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_error_ = _inner_error_;
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_inner_error_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = media;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_init (&_tmp6_, (gint) THUMBNAIL_CACHE_SIZE_BIG, (gint) THUMBNAIL_CACHE_SIZE_BIG);
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_tmp6_, THUMBNAIL_CACHE_DEFAULT_INTERP, ____lambda17__thumbnail_cache_async_fetch_callback, NULL, NULL);
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp7_ = media;
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_LIBRARY_PHOTO)) {
#line 760 "EventDirectoryItem.c"
			LibraryPhoto* photo = NULL;
			MediaSource* _tmp8_;
			LibraryPhoto* _tmp9_;
			GdkPixbuf* _tmp10_ = NULL;
			LibraryPhoto* _tmp11_;
			Scaling _tmp12_;
			GdkPixbuf* _tmp13_;
			GdkPixbuf* _tmp14_;
#line 66 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp8_ = media;
#line 66 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 66 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			photo = _tmp9_;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp11_ = photo;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp12_ = event_directory_item_squared_scaling;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp13_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp12_, &_inner_error_);
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp10_ = _tmp13_;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
				_g_object_unref0 (photo);
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
				_g_error_free0 (_error_);
#line 789 "EventDirectoryItem.c"
				goto __finally52;
			}
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp14_ = _tmp10_;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp10_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (pixbuf);
#line 67 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			pixbuf = _tmp14_;
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (_tmp10_);
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (photo);
#line 804 "EventDirectoryItem.c"
		} else {
			GError* _tmp15_;
			GError* _tmp16_;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp15_ = _error_;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp16_ = _g_error_copy0 (_tmp15_);
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_inner_error_ = _tmp16_;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_error_free0 (_error_);
#line 816 "EventDirectoryItem.c"
			goto __finally52;
		}
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_error_free0 (_error_);
#line 821 "EventDirectoryItem.c"
	}
	__finally52:
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_propagate_error (error, _inner_error_);
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (pixbuf);
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return NULL;
#line 832 "EventDirectoryItem.c"
	}
#line 73 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp17_ = pixbuf;
#line 73 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_pixbuf (_tmp17_, &_tmp18_);
#line 73 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	thumbnail_dimensions = _tmp18_;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp20_ = thumbnail_dimensions;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp21_ = _tmp20_.width;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp22_ = *paul_lynde;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp23_ = _tmp22_.width;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp21_ > (2 * _tmp23_)) {
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp19_ = TRUE;
#line 852 "EventDirectoryItem.c"
	} else {
		Dimensions _tmp24_;
		gint _tmp25_;
		GdkRectangle _tmp26_;
		gint _tmp27_;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp24_ = thumbnail_dimensions;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp25_ = _tmp24_.height;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp26_ = *paul_lynde;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp27_ = _tmp26_.height;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp19_ = _tmp25_ > (_tmp27_ * 2);
#line 868 "EventDirectoryItem.c"
	}
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp19_) {
#line 872 "EventDirectoryItem.c"
		LibraryPhoto* photo = NULL;
		MediaSource* _tmp28_;
		LibraryPhoto* _tmp29_;
		GdkPixbuf* _tmp30_ = NULL;
		LibraryPhoto* _tmp31_;
		Scaling _tmp32_;
		GdkPixbuf* _tmp33_;
		GdkPixbuf* _tmp34_;
		GdkPixbuf* _tmp35_;
		Dimensions _tmp36_ = {0};
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp28_ = media;
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		photo = _tmp29_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp31_ = photo;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp32_ = event_directory_item_squared_scaling;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp33_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp32_, &_inner_error_);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp30_ = _tmp33_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_propagate_error (error, _inner_error_);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (photo);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (pixbuf);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			return NULL;
#line 907 "EventDirectoryItem.c"
		}
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp34_ = _tmp30_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp30_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (pixbuf);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		pixbuf = _tmp34_;
#line 79 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp35_ = pixbuf;
#line 79 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_for_pixbuf (_tmp35_, &_tmp36_);
#line 79 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		thumbnail_dimensions = _tmp36_;
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp30_);
#line 75 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (photo);
#line 927 "EventDirectoryItem.c"
	}
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp37_ = *paul_lynde;
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp38_ = thumbnail_dimensions;
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	clamp_rectangle (&_tmp37_, &_tmp38_, &_tmp39_);
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	*paul_lynde = _tmp39_;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp40_ = pixbuf;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp41_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp42_ = _tmp41_.x;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp43_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp44_ = _tmp43_.y;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp45_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp46_ = _tmp45_.width;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp47_ = *paul_lynde;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp48_ = _tmp47_.height;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp49_ = gdk_pixbuf_new_subpixbuf (_tmp40_, _tmp42_, _tmp44_, _tmp46_, _tmp48_);
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	result = _tmp49_;
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (pixbuf);
#line 86 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return result;
#line 963 "EventDirectoryItem.c"
}


static gchar* event_directory_item_get_formatted_title (Event* event) {
	gchar* result = NULL;
	gboolean has_photos = FALSE;
	Event* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean has_videos = FALSE;
	Event* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gint count = 0;
	Event* _tmp10_;
	gint _tmp11_;
	gchar* count_text = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gchar* daterange = NULL;
	Event* _tmp26_;
	gchar* _tmp27_;
	gchar* name = NULL;
	Event* _tmp28_;
	gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	const gchar* _tmp31_;
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_EVENT (event), NULL);
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event;
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT_SOURCE, EventSource));
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = _tmp1_;
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = media_source_collection_has_photo (_tmp2_);
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = _tmp3_;
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp2_);
#line 91 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	has_photos = _tmp4_;
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = event;
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_EVENT_SOURCE, EventSource));
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = _tmp6_;
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = media_source_collection_has_video (_tmp7_);
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = _tmp8_;
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp7_);
#line 92 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	has_videos = _tmp9_;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = event;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = event_source_get_media_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_EVENT_SOURCE, EventSource));
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	count = _tmp11_;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = g_strdup ("");
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	count_text = _tmp12_;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = has_photos;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp14_) {
#line 1040 "EventDirectoryItem.c"
		gboolean _tmp15_;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp15_ = has_videos;
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp13_ = _tmp15_;
#line 1046 "EventDirectoryItem.c"
	} else {
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp13_ = FALSE;
#line 1050 "EventDirectoryItem.c"
	}
#line 96 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp13_) {
#line 1054 "EventDirectoryItem.c"
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp16_ = count;
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp17_ = count;
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp18_ = g_strdup_printf (ngettext ("%d Photo/Video", "%d Photos/Videos", (gulong) _tmp16_), _tmp17_);
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 97 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		count_text = _tmp18_;
#line 1068 "EventDirectoryItem.c"
	} else {
		gboolean _tmp19_;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp19_ = has_videos;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (_tmp19_) {
#line 1075 "EventDirectoryItem.c"
			gint _tmp20_;
			gint _tmp21_;
			gchar* _tmp22_;
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp20_ = count;
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp21_ = count;
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp22_ = g_strdup_printf (ngettext ("%d Video", "%d Videos", (gulong) _tmp20_), _tmp21_);
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (count_text);
#line 99 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			count_text = _tmp22_;
#line 1089 "EventDirectoryItem.c"
		} else {
			gint _tmp23_;
			gint _tmp24_;
			gchar* _tmp25_;
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp23_ = count;
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp24_ = count;
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp25_ = g_strdup_printf (ngettext ("%d Photo", "%d Photos", (gulong) _tmp23_), _tmp24_);
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (count_text);
#line 101 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			count_text = _tmp25_;
#line 1104 "EventDirectoryItem.c"
		}
	}
#line 103 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp26_ = event;
#line 103 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp27_ = event_get_formatted_daterange (_tmp26_);
#line 103 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	daterange = _tmp27_;
#line 104 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp28_ = event;
#line 104 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp29_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_DATA_OBJECT, DataObject));
#line 104 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	name = _tmp29_;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp31_ = daterange;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp31_ == NULL) {
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp30_ = TRUE;
#line 1125 "EventDirectoryItem.c"
	} else {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp32_ = daterange;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp33_ = name;
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp30_ = g_strcmp0 (_tmp32_, _tmp33_) == 0;
#line 1135 "EventDirectoryItem.c"
	}
#line 108 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp30_) {
#line 1139 "EventDirectoryItem.c"
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp34_ = name;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp35_ = guarded_markup_escape_text (_tmp34_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp36_ = _tmp35_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp37_ = count_text;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp38_ = guarded_markup_escape_text (_tmp37_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp39_ = _tmp38_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp40_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp36_, _tmp39_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp41_ = _tmp40_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp39_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp36_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		result = _tmp41_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (name);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (daterange);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return result;
#line 1178 "EventDirectoryItem.c"
	} else {
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp42_ = name;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp43_ = guarded_markup_escape_text (_tmp42_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp44_ = _tmp43_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp45_ = count_text;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp46_ = guarded_markup_escape_text (_tmp45_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp47_ = _tmp46_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp48_ = daterange;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp49_ = guarded_markup_escape_text (_tmp48_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp50_ = _tmp49_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp51_ = g_strdup_printf ("<b>%s</b>\n%s\n%s", _tmp44_, _tmp47_, _tmp50_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp52_ = _tmp51_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp50_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp47_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp44_);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		result = _tmp52_;
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (name);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (daterange);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return result;
#line 1229 "EventDirectoryItem.c"
	}
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (name);
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (daterange);
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (count_text);
#line 1237 "EventDirectoryItem.c"
}


static void event_directory_item_real_exposed (CheckerboardItem* base) {
	EventDirectoryItem * self;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 117 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 117 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp0_) {
#line 118 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1253 "EventDirectoryItem.c"
	}
	{
		GdkPixbuf* _tmp1_ = NULL;
		Event* _tmp2_;
		MediaSource* _tmp3_;
		MediaSource* _tmp4_;
		GdkRectangle _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp2_ = self->event;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = event_get_primary_source (_tmp2_);
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = _tmp3_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = self->priv->paul_lynde;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp6_ = event_directory_item_get_paul_lynde (_tmp4_, &_tmp5_, &_inner_error_);
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp7_ = _tmp6_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp4_);
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp1_ = _tmp7_;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1281 "EventDirectoryItem.c"
			goto __catch53_g_error;
		}
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp1_);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp1_);
#line 1288 "EventDirectoryItem.c"
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* err = NULL;
		Event* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		err = _inner_error_;
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_inner_error_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp8_ = self->event;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_OBJECT, DataObject));
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp10_ = _tmp9_;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp11_ = err;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp12_ = _tmp11_->message;
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_critical ("EventDirectoryItem.vala:123: Unable to fetch preview for %s: %s", _tmp10_, _tmp12_);
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp10_);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_error_free0 (err);
#line 1319 "EventDirectoryItem.c"
	}
	__finally53:
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_clear_error (&_inner_error_);
#line 120 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1330 "EventDirectoryItem.c"
	}
#line 126 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_update_comment (self, FALSE);
#line 128 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1336 "EventDirectoryItem.c"
}


static void event_directory_item_real_unexposed (CheckerboardItem* base) {
	EventDirectoryItem * self;
	gboolean _tmp0_;
	GdkRectangle _tmp1_;
	Dimensions _tmp2_ = {0};
#line 131 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 132 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 132 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (!_tmp0_) {
#line 133 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1353 "EventDirectoryItem.c"
	}
#line 135 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = self->priv->paul_lynde;
#line 135 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_rectangle (&_tmp1_, &_tmp2_);
#line 135 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp2_);
#line 137 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1363 "EventDirectoryItem.c"
}


static void event_directory_item_on_events_altered (EventDirectoryItem* self, GeeMap* map) {
	GeeMap* _tmp0_;
	Event* _tmp1_;
	gboolean _tmp2_;
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 141 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_update_comment (self, FALSE);
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = map;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = self->event;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = gee_map_has_key (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp2_) {
#line 1385 "EventDirectoryItem.c"
		Event* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = self->event;
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = event_directory_item_get_formatted_title (_tmp3_);
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = _tmp4_;
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_, TRUE, PANGO_ALIGN_CENTER);
#line 143 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp5_);
#line 1399 "EventDirectoryItem.c"
	}
}


static void event_directory_item_real_thumbnail_altered (ThumbnailView* base) {
	EventDirectoryItem * self;
	MediaSource* media = NULL;
	Event* _tmp0_;
	MediaSource* _tmp1_;
	MediaSource* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 147 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->event;
#line 147 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_get_primary_source (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	media = _tmp1_;
#line 150 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = media;
#line 150 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_get_paul_lynde_rect (_tmp2_, &_tmp3_);
#line 150 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv->paul_lynde = _tmp3_;
#line 152 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 152 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp4_) {
#line 1431 "EventDirectoryItem.c"
		{
			GdkPixbuf* _tmp5_ = NULL;
			MediaSource* _tmp6_;
			GdkRectangle _tmp7_;
			GdkPixbuf* _tmp8_;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp6_ = media;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp7_ = self->priv->paul_lynde;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp8_ = event_directory_item_get_paul_lynde (_tmp6_, &_tmp7_, &_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp5_ = _tmp8_;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1447 "EventDirectoryItem.c"
				goto __catch54_g_error;
			}
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (_tmp5_);
#line 1454 "EventDirectoryItem.c"
		}
		goto __finally54;
		__catch54_g_error:
		{
			GError* err = NULL;
			Event* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			err = _inner_error_;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_inner_error_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp9_ = self->event;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp11_ = _tmp10_;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp12_ = err;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp13_ = _tmp12_->message;
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_critical ("EventDirectoryItem.vala:156: Unable to fetch preview for %s: %s", _tmp11_, _tmp13_);
#line 156 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (_tmp11_);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_error_free0 (err);
#line 1485 "EventDirectoryItem.c"
		}
		__finally54:
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (media);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_clear_error (&_inner_error_);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			return;
#line 1498 "EventDirectoryItem.c"
		}
	} else {
		GdkRectangle _tmp14_;
		Dimensions _tmp15_ = {0};
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp14_ = self->priv->paul_lynde;
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_for_rectangle (&_tmp14_, &_tmp15_);
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp15_);
#line 1509 "EventDirectoryItem.c"
	}
#line 162 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	THUMBNAIL_VIEW_CLASS (event_directory_item_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
#line 146 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (media);
#line 1515 "EventDirectoryItem.c"
}


static void event_directory_item_real_paint_shadow (CheckerboardItem* base, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
	EventDirectoryItem * self;
	Dimensions altered = {0};
	Dimensions _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	cairo_t* _tmp4_;
	Dimensions _tmp5_;
	GdkPoint _tmp6_;
	gfloat _tmp7_;
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (dimensions != NULL);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (origin != NULL);
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = *dimensions;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_.width;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = *dimensions;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_.height;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&altered, _tmp1_ - 25, _tmp3_ - 25);
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = ctx;
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = altered;
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = *origin;
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = initial_alpha;
#line 168 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->paint_shadow (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp4_, &_tmp5_, &_tmp6_, 36, _tmp7_);
#line 1558 "EventDirectoryItem.c"
}


static void event_directory_item_real_paint_border (CheckerboardItem* base, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	Dimensions _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_ = {0};
	GdkPoint origin = {0};
	GdkPoint _tmp3_;
	gint _tmp4_;
	GdkPoint _tmp5_ = {0};
	cairo_t* _tmp6_;
	Dimensions _tmp7_;
	GdkPoint _tmp8_;
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (object_dimensions != NULL);
#line 171 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (object_origin != NULL);
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = *object_dimensions;
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = border_width;
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_get_border_dimensions (&_tmp0_, _tmp1_, &_tmp2_);
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions = _tmp2_;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = *object_origin;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = border_width;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_get_border_origin (&_tmp3_, _tmp4_, &_tmp5_);
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	origin = _tmp5_;
#line 176 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = ctx;
#line 176 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = dimensions;
#line 176 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = origin;
#line 176 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	draw_rounded_corners_filled (_tmp6_, &_tmp7_, &_tmp8_, 6.0);
#line 1607 "EventDirectoryItem.c"
}


static void event_directory_item_real_paint_image (CheckerboardItem* base, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	GdkPixbuf* _tmp0_;
	Dimensions _tmp1_ = {0};
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_;
	cairo_t* _tmp7_;
	Dimensions _tmp8_;
	GdkPoint _tmp9_;
	cairo_t* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPoint _tmp12_;
	gint _tmp13_;
	GdkPoint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (origin != NULL);
#line 181 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = pixbuf;
#line 181 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_pixbuf (_tmp0_, &_tmp1_);
#line 181 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions = _tmp1_;
#line 183 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = pixbuf;
#line 183 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = gdk_pixbuf_get_has_alpha (_tmp2_);
#line 183 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp3_) {
#line 1648 "EventDirectoryItem.c"
		cairo_t* _tmp4_;
		Dimensions _tmp5_;
		GdkPoint _tmp6_;
#line 184 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = ctx;
#line 184 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = dimensions;
#line 184 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp6_ = *origin;
#line 184 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		draw_rounded_corners_filled (_tmp4_, &_tmp5_, &_tmp6_, 6.0);
#line 1660 "EventDirectoryItem.c"
	}
#line 187 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = ctx;
#line 187 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = dimensions;
#line 187 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = *origin;
#line 187 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	context_rounded_corners (_tmp7_, &_tmp8_, &_tmp9_, 6.0);
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = ctx;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = pixbuf;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = *origin;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = _tmp12_.x;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = *origin;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = _tmp14_.y;
#line 188 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	gdk_cairo_set_source_pixbuf (_tmp10_, _tmp11_, (gdouble) _tmp13_, (gdouble) _tmp15_);
#line 189 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = ctx;
#line 189 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	cairo_paint (_tmp16_);
#line 1688 "EventDirectoryItem.c"
}


static void event_directory_item_update_comment (EventDirectoryItem* self, gboolean init) {
	gchar* comment = NULL;
	Event* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
#line 192 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
#line 193 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->event;
#line 193 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT_SOURCE, EventSource));
#line 193 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	comment = _tmp1_;
#line 194 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = comment;
#line 194 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 194 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp3_) {
#line 195 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1714 "EventDirectoryItem.c"
	} else {
		gboolean _tmp4_;
#line 196 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = init;
#line 196 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (!_tmp4_) {
#line 1721 "EventDirectoryItem.c"
			const gchar* _tmp5_;
#line 197 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp5_ = comment;
#line 197 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_, FALSE, PANGO_ALIGN_LEFT);
#line 1727 "EventDirectoryItem.c"
		} else {
#line 199 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), "", FALSE, PANGO_ALIGN_LEFT);
#line 1731 "EventDirectoryItem.c"
		}
	}
#line 192 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (comment);
#line 1736 "EventDirectoryItem.c"
}


static gint event_directory_item_get_CROPPED_SCALE (void) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_BIG);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	result = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return result;
#line 1755 "EventDirectoryItem.c"
}


static void event_directory_item_class_init (EventDirectoryItemClass * klass) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	Scaling _tmp5_ = {0};
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_type_class_add_private (klass, sizeof (EventDirectoryItemPrivate));
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem *)) event_directory_item_real_exposed;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem *)) event_directory_item_real_unexposed;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView *)) event_directory_item_real_thumbnail_altered;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_shadow = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint, gfloat)) event_directory_item_real_paint_shadow;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_border = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint)) event_directory_item_real_paint_border;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_image = (void (*) (CheckerboardItem *, cairo_t*, GdkPixbuf*, GdkPoint*)) event_directory_item_real_paint_image;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_event_directory_item_get_property;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (klass)->finalize = event_directory_item_finalize;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaling_to_fill_viewport (&_tmp4_, &_tmp5_);
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_squared_scaling = _tmp5_;
#line 1800 "EventDirectoryItem.c"
}


static void event_directory_item_instance_init (EventDirectoryItem * self) {
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv = EVENT_DIRECTORY_ITEM_GET_PRIVATE (self);
#line 20 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	memset (&self->priv->paul_lynde, 0, sizeof (GdkRectangle));
#line 1809 "EventDirectoryItem.c"
}


static void event_directory_item_finalize (GObject * obj) {
	EventDirectoryItem * self;
	EventSourceCollection* _tmp0_;
	guint _tmp1_;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_global;
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self);
#line 18 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (self->event);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (event_directory_item_parent_class)->finalize (obj);
#line 1829 "EventDirectoryItem.c"
}


GType event_directory_item_get_type (void) {
	static volatile gsize event_directory_item_type_id__volatile = 0;
	if (g_once_init_enter (&event_directory_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EventDirectoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_directory_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventDirectoryItem), 0, (GInstanceInitFunc) event_directory_item_instance_init, NULL };
		GType event_directory_item_type_id;
		event_directory_item_type_id = g_type_register_static (TYPE_CHECKERBOARD_ITEM, "EventDirectoryItem", &g_define_type_info, 0);
		g_once_init_leave (&event_directory_item_type_id__volatile, event_directory_item_type_id);
	}
	return event_directory_item_type_id__volatile;
}


static void _vala_event_directory_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EventDirectoryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	switch (property_id) {
#line 1850 "EventDirectoryItem.c"
		default:
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		break;
#line 1856 "EventDirectoryItem.c"
	}
}



