/* $Id: port_unix.c,v 1.6 2003/05/30 00:42:39 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <termio.h>
#include <termios.h>

#include "libc.h"

static struct termio saved_tty;


unsigned char *lib_heap;
unsigned int lib_heap_size;

void set_tty_raw()
{
	struct termio tty;
	ioctl(0, TCGETA, &saved_tty);
	tty = saved_tty;
	tty.c_lflag  &= ~ICANON;
	tty.c_cc[VMIN]  = 1;
	tty.c_cc[VTIME] = 0;
	ioctl(0, TCSETA, &tty);
}

void restore_tty()
{
	ioctl(0, TCSETA, &saved_tty);	
}

void lib_port_init(void *unused)
{
	set_tty_raw();
	fcntl(0, F_SETFL, O_NONBLOCK);
	lib_heap_size = 128 * 1024;
	lib_heap = malloc(lib_heap_size);
}

void lib_port_uninit(void)
{
	free(lib_heap);
	restore_tty();
}

void lib_putc(char c)
{
	putchar(c);
	fflush(stdout);
}

void lib_port_exit(void)
{
	exit(0);
}

uint64_t lib_get_time(void)
{
	struct timeval tv;
	struct timezone tz;
	tz.tz_minuteswest = 0;
	tz.tz_dsttime = 0;
	gettimeofday(&tv, &tz);
	return (tv.tv_sec * 1000000) + tv.tv_usec;
}

int   lib_poll_input (char *targ)
{
	int retval;
	retval = read(0, targ, 1);
	if (retval == -1) {
		retval = 0;
	}
	return retval;
}
