#ifndef SimTK_SIMBODY_DOXYGEN_MAINPAGE_H_
#define SimTK_SIMBODY_DOXYGEN_MAINPAGE_H_


/** @file
This "header" file is actually just the source for Simbody's Doxygen
Mainpage, the first page that a user sees when entering the Doxygen-
generated API documentation. This is not actually included as part of the
Simbody source and it is not installed with Simbody. **/


// This is so Doxygen can locate the symbols we mention.
namespace SimTK {

/** @mainpage  Simbody&tm; API Reference Documentation

<h2>Getting started with Simbody</h2>
You are looking at the main page for the reference documentation of the Simbody
API. This documentation was generated by Doxygen directly from the Simbody
source code as annotated by the original programmers so it is both accurate and
comprehensive. As you will quickly realize if you look around, this is a large
system providing a great deal of functionality. It is, however, very easy to
use if you know where to begin -- and this reference documentation is most
definitely \e not the place to start if you want to learn how to use
Simbody. Instead, start with the tutorials in the Simbody User's Guide that
you can find at the Simbody project site https://simtk.org/home/simbody
"Documents" tab. There is also a collection of working example programs that
come with the Simbody installation (in the examples directory). Both source
and ready-to-execute binaries of the examples are installed. If you have
specific questions, use the Simbody help forum under the "Public Forums" tab.
You can also file bug reports and make feature requests using the tools
provided there.

@image html isaac.png "Our hero, Sir Isaac Newton"

<h2>What is Simbody?</h2>
Simbody is a high-performance, industrial-grade open source C++ library
providing sophisticated treatment of articulated multibody systems with special
attention to the needs of biomedical simulation. It is useful for predictive
dynamic simulations of diverse biological systems such as neuromuscular
biomechanical models (https://simtk.org/home/opensim) and coarse-grained
biomolecular modeling (https://simtk.org/home/rnatoolbox). It is also well
suited to related simulation domains such as robotic and avatar simulation and
control, and provides real time capabilities that make it useful for
interactive scientific simulations as well as virtual worlds and games.

Simbody uses a minimal coordinate recursive formulation of the equations of
motion, providing computation of system dynamics to machine precision with
O(N) computational complexity for N interconnected bodies. Arbitrary adjoined
constraints, contact modeling, and advanced numerical methods provide fast,
robust simulation for any mechanical or biomechanical system from machines and
vehicles to human skeletons and macromolecules.

Simbody is part of the %SimTK biosimulation toolkit originating from Simbios,
the NIH National Center for Physics-Based Simulation of Biological Structures
at Stanford, funded under the NIH Roadmap for Medical Research, grant
U54 GM072970. Related tools include
- OpenSim (http://opensim.stanford.edu and https://simtk.org/home/opensim),
a freely available software system for building, exchanging, and analyzing
musuloskeletal models and dynamic simulations of movement. Includes both a
graphical user interface and an API; automatically constructs Simbody
models from high-level description.
- Molmodel (https://simtk.org/home/molmodel), a C++ API for constructing
coarse-grained, Simbody-based internal coordinate models of macromolecules
like proteins and RNA, and
- OpenMM (https://simtk.org/home/openmm), a GPU-accelerated high-performance
numerical library for efficient calculation of molecular force fields.
OpenMM may be used standalone or through Molmodel.

Simbody is hosted on the simtk.org biosimulation community site,
at https://simtk.org/home/simbody and is a community resource available for
unrestricted academic, commercial, government, and personal use. The source
code is maintained on GitHub, at https://github.com/simbody.

Simbody was conceived and initially implemented by Michael Sherman (Sherm),
with substantial contributions from Peter Eastman, both of the Simbios Center
at Stanford. Many others have contributed to the software, support, and
documentation and we invite well-engineered community contributions.

<h2>How to use this documentation</h2>
If you know the name of the class, method, or other symbol for which you want
information, you can enter it into the search box above and click directly to
the documentation for that symbol. You can also enter words or partial symbols
and get a list of names that include your search key. Unfortunately Doxygen
does not currently provide a full-text search capability. Another approach is
to select the Classes tab to get an alphabetical listing of all the class
names, and there is a tab below that providing a class hierarchy view. Here is
an abbreviated list of important classes, all in the SimTK:: namespace:
- MobilizedBody: combination of a Body and the inboard joint
connecting it to the multibody tree, which we call a "mobilizer". Base class
for specific mobilizer types of which there are many predefined; extensible.
- Force: base class for a selection of built-in force types; easily
extensible to model your own force elements.
- Constraint: base class for a selection of built-in constraint types;
extensible.
- Motion: prescribed motions permitting mixed forward/inverse dynamics;
more efficient than the equivalent %Constraint. Built-ins plus
extendability.
- Measure: general state-dependent computational block.
- System, Subsystem, State: basic infrastructure objects.
- MultibodySystem, SimbodyMatterSubsystem, GeneralForceSubsystem,
ContactTrackerSubsystem, CompliantContactSubsystem: commonly used
components.
- Integrator, TimeStepper, Assembler, Optimizer: solvers.
- Many utility classes (see tutorials, example programs, Doxygen Modules tab),
including Rotation_, Transform_, Quaternion_,
Vector_, Vec, @ref SimTK::SpatialVec "SpatialVec", Xml, and many more.
- Matrix and vector classes and capabilities are discussed in the module 
@ref MatVecUtilities "Matrix and Vector Utilities".

For an overview of Simbody, read this paper:
<a href="https://simtk.org/docman/view.php/47/1589/Sherman-2011-SethDelp-Simbody-ProcediaIUTAM-v2-p241.pdf">
Michael A. Sherman, Ajay Seth, Scott L. Delp, "Simbody: multibody
dynamics for biomedical research," <i>Procedia IUTAM</i> 2:241-261 (2011)</a>

<h2>License</h2>
We encourage the broadest possible use of Simbody for any purpose by using
the extremely permissive Apache 2.0 License. We would appreciate some
acknowledgement if our work has been helpful in yours, but our license does not
require that. For more information see our
\ref simbody_license_page "license page". **/

} // namespace SimTK

/** @page simbody_license_page  Simbody&tm; Copyright and License
<h2>Copyright and license</h2>
This license, based on the maximally-permissive Apache 2.0 License, defines the 
terms under which we offer Simbody.
@verbatim
 * -------------------------------------------------------------------------- *
 *                                 Simbody(tm)                                *
 * -------------------------------------------------------------------------- *
 * This is part of the SimTK biosimulation toolkit originating from           *
 * Simbios, the NIH National Center for Physics-Based Simulation of           *
 * Biological Structures at Stanford, funded under the NIH Roadmap for        *
 * Medical Research, grant U54 GM072970. See https://simtk.org/home/simbody.  *
 *                                                                            *
 * Please cite:                                                               *
 *   Michael A. Sherman, Ajay Seth, Scott L. Delp, Simbody: multibody         *
 *   dynamics for biomedical research, Procedia IUTAM 2:241-261 (2011)        *
 *   http://dx.doi.org/10.1016/j.piutam.2011.04.023                          *
 *                                                                            *
 * Portions copyright (c) 2005-13 Stanford University and the Authors.        *
 * Authors: Michael Sherman, Peter Eastman                                    *
 * Contributors: Jack Middleton, Christopher Bruns, Paul Mitiguy, Matthew     *
 *   Millard, Charles Schwieters, Abhinandan Jain, Isaac Newton               *
 *                                                                            *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may    *
 * not use this file except in compliance with the License. You may obtain a  *
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0.         *
 *                                                                            *
 * Unless required by applicable law or agreed to in writing, software        *
 * distributed under the License is distributed on an "AS IS" BASIS,          *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   *
 * See the License for the specific language governing permissions and        *
 * limitations under the License.                                             *
 * -------------------------------------------------------------------------- *
@endverbatim

<h2>What's with that "TM" in Simbody&tm;?</h2>
That symbol is to let you know that we claim a trademark on the name "Simbody"
so you may not use that name except to refer to our software as we distribute
it. The license permits you to make any kind of derivative work, or to use
all or part of Simbody code in any way you like, but you can't call the
resulting work "Simbody" without our agreement. We make that restriction 
because we don't want any confusion to exist about what is, and what is not, 
the Simbody project that we are supporting. But ... if you want to make 
improvements to Simbody we would love to have your well-engineered, open source
contributions to put into the main Simbody source tree, in which case they 
\e would be included under the Simbody name.

<h2>How to acknowledge us</h2>
Our license does not \e require that you acknowledge us, but we and our 
sponsors would be grateful if you did anyway! If our hard work has helped you
with yours, please throw us a bone and mention on your "About" page and in
your documentation that you are using Simbody from 
https://simtk.org/home/simbody. Where appropriate, please cite this paper:

\par
Michael A. Sherman, Ajay Seth, Scott L. Delp, Simbody: multibody
dynamics for biomedical research, <i>Procedia IUTAM</i> 2:241-261 (2011)
http://dx.doi.org/10.1016/j.piutam.2011.04.023

We would be particularly grateful if you mention that Simbody is primarily
funded by NIH Roadmap grant U54 GM072970. We appreciate that support very
much, and the NIH appreciates knowing that its funds are having an impact,
particularly on medical research and human health.
**/

#endif // SimTK_SIMBODY_DOXYGEN_MAINPAGE_H_
