#ifndef _udpmessagereceiver_h
#define _udpmessagereceiver_h

#include <asio.hpp>
#include <boost/signal.hpp>
#include "message.h"
#include "messageioconst.h"


class UDPMessageReceiver
{
private:
  char data[maxMessageIOSize];
  asio::ip::udp::endpoint sender_endpoint;

  asio::io_service & ioservice;
  asio::ip::udp::socket sock;


  void handleReceiveFrom(const asio::error_code& err, size_t length);

public:
  UDPMessageReceiver(asio::io_service& io_service, const asio::ip::udp::endpoint & listenEndpoint,
                     const asio::ip::address& multicast_address);

  boost::signal<void (Message & message)> receiveMessageSignal;
};


#endif
