#include "protocoltimer.h"


ProtocolTimer::ProtocolTimer(ProtocolIO & protocolIO) : theTimerObjectBase(protocolIO.getTimer())
{
  myHandlerBase=0;
}


ProtocolTimer::~ProtocolTimer()
{
  if (myHandlerBase)
  {
    delete myHandlerBase;
    myHandlerBase=0;
  }
  delete theTimerObjectBase;
}


void ProtocolTimer::stop()
{
  theTimerObjectBase->stop();
  if (myHandlerBase)
  {
    delete myHandlerBase;
    myHandlerBase=0;
  }
}
