# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/se_css.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_CSS
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'se_info_env'                           # se_info_env.rb
  class CSS_Default
    def html
      'html.css'
    end
    def html_tables
      'html_tables.css'
    end
    def xhtml
      'xhtml.css'
    end
    def xml_sax
      'sax.css'
    end
    def xml_dom
      'dom.css'
    end
    def xml_docbook
      'docbook.css'
    end
    def homepage
      'homepage.css'
    end
    def harvest
      'harvest.css'
    end
  end
  class CSS_Select < SiSU_Info_Env::InfoEnv                # se_info_env.rb
    def initialize(md)
      @md=md
      @env=SiSU_Env::InfoEnv.new('',@md)
    end
    def html
      if @md.doc_css \
      and FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@md.doc_css}_html.css")
        @md.doc_css + '_html.css'
      elsif FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@env.path.base_markup_dir_stub}_html.css")
        @env.path.base_markup_dir_stub + '_html.css'
      else
        SiSU_Env::CSS_Default.new.html
      end
    end
    def html_tables
      if @md.doc_css \
      and FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@md.doc_css}_html_tables.css")
        @md.doc_css + '_html_tables.css'
      elsif FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@env.path.base_markup_dir_stub}_html_tables.css")
        @env.path.base_markup_dir_stub + '_html_tables.css'
      else SiSU_Env::CSS_Default.new.html_tables
      end
    end
    def xhtml
      if @md.doc_css \
      and FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@md.doc_css}_xhtml.css")
        @md.doc_css + '_xhtml.css'
      elsif FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@env.path.base_markup_dir_stub}_xhtml.css")
        @env.path.base_markup_dir_stub + '_xhtml.css'
      else SiSU_Env::CSS_Default.new.xhtml
      end
    end
    def xml_sax
      if @md.doc_css \
      and FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@md.doc_css}_xml_sax.css")
        @md.doc_css + '_xml_sax.css'
      elsif FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@env.path.base_markup_dir_stub}_xml_sax.css")
        @env.path.base_markup_dir_stub + '_xml_sax.css'
      else SiSU_Env::CSS_Default.new.xml_sax
      end
    end
    def xml_dom
      if @md.doc_css \
      and FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@md.doc_css}_xml_dom.css")
        @md.doc_css + '_xml_dom.css'
      elsif FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@env.path.base_markup_dir_stub}_xml_dom.css")
        @env.path.base_markup_dir_stub + '_xml_dom.css'
      else SiSU_Env::CSS_Default.new.xml_dom
      end
    end
    def xml_docbook
      if @md.doc_css \
      and FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@md.doc_css}_docbook.css")
        @md.doc_css + '_xml_dom.css'
      elsif FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@env.path.base_markup_dir_stub}_docbook.css")
        @env.path.base_markup_dir_stub + '_docbook.css'
      else SiSU_Env::CSS_Default.new.xml_docbook
      end
    end
    def homepage
      if @md.doc_css \
      and FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@md.doc_css}_homepage.css")
        @md.doc_css + '_homepage.css'
      elsif FileTest.file?("#{@env.path.output}/#{@env.path.style}/#{@env.path.base_markup_dir_stub}_homepage.css")
        @env.path.base_markup_dir_stub + '_homepage.css'
      else SiSU_Env::CSS_Default.new.homepage
      end
    end
  end
  class CSS_Stylesheet
    def initialize(md)
      @md=md
      @css=SiSU_Env::CSS_Select.new(@md)
      @env=SiSU_Env::InfoEnv.new('',@md)
      @file=SiSU_Env::FileOp.new(@md)
    end
    def html
      stylesheet=
        @file.path_rel_links.html_scroll_css \
        + @env.path.style + '/' \
        + @css.html
      %{  <link href="#{stylesheet}" rel="stylesheet">}
    end
    def html_seg
      stylesheet=
        @file.path_rel_links.html_seg_css \
        + @env.path.style + '/' \
        + @css.html
      %{  <link href="#{stylesheet}" rel="stylesheet">}
    end
    def html_tables
      stylesheet=
        @file.path_rel_links.html_seg_css \
        + @env.path.style + '/' \
        + @css.html
      %{  <link href="#{stylesheet}" rel="stylesheet">}
    end
    def xhtml_epub
      %{  <link rel="stylesheet" href="css/xhtml.css" type="text/css" />}
    end
    def epub
      xhtml_epub
    end
    def xhtml
      stylesheet=
        @file.path_rel_links.xhtml_css \
        + @env.path.style + '/' \
        + @css.xhtml
      %{<?xml-stylesheet type="text/css" href="#{stylesheet}"?>}
    end
    def xml_sax
      stylesheet=
        @file.path_rel_links.xml_css \
        + @env.path.style + '/' \
        + @css.xml_sax
      %{<?xml-stylesheet type="text/css" href="#{stylesheet}"?>}
    end
    def xml_dom
      stylesheet=
        @file.path_rel_links.xml_css \
        + @env.path.style + '/' \
        + @css.xml_dom
      %{<?xml-stylesheet type="text/css" href="#{stylesheet}"?>}
    end
    def xml_docbook
      stylesheet=
        @file.path_rel_links.xml_css \
        + @env.path.style + '/' \
        + @css.xml_docbook
      %{<?xml-stylesheet type="text/css" href="#{stylesheet}"?>}
    end
  end
end
__END__
