# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/html_parts.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: shared html parts

=end
module SiSU_Parts_XML
  require_relative 'generic_parts'                       # generic_parts.rb
  include SiSU_Parts_Generic
  def the_line_break
    '<br />'
  end
  def the_table_close
    '</td></tr>
</table>'
  end
  def the_url_decoration
    def xml_open                     #'&lt;'
      Dx[:url_o]
    end
    def xml_close                    #'&gt;'
      Dx[:url_c]
    end
    def txt_open
      '<'
    end
    def txt_close
      '>'
    end
    self
  end
  def the_color
    def white
      '#ffffff'
    end
    def black
      '#000000'
    end
    def grey_pale
      '#eeeeee'
    end
    def grey_medium
      '#cccccc'
    end
    def grey
      '#999999'
    end
    def blue_ink
      '#003399'
    end
    def blue_tinge
      '#e3ecef'
    end
    def yellow_light
      '#fff3b6'
    end
    def table1
      'ffffcc'
    end
    def table2
      'c0d0f0'
    end
    def band1
      %{"#{white}"}
    end
    def band2
      %{"#{white}"}
    end
    self
  end
  def the_png
    def _url_path_image_base #used for html image display
      "#{Xx[:html_relative2]}_sisu/image"
    end
    def ico
      %{  <link rel="shortcut icon" href="../_sisu/image/#{the_icon.i_ico}" />}
    end
    def png_home
      %{<img border="0" src="#{_url_path_image_base}/#{the_icon.home_button}" alt="#{the_text.home} --&gt;" />}
    end
    def png_home_button
      rel=@dir.path_rel_links.html_scroll_2
      %{<img border="0" src="#{rel}/#{the_icon.home_button}" alt="#{the_text.home} --&gt;" />}
    end
    self
  end
  def the_font
    def set_fonts
      'verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman'
     #'verdana, arial, georgia, tahoma, sans-serif, helvetica, "times new roman", times, roman'
    end
    def set_face
      %{face="#{set_fonts}"}
    end
    #def set_color
    #  'color="#000000"'
    #end
    #def set_size_endnote
    #  'size="3"'
    #end
    #def set_small
    #  'size="3"'
    #end
    #def set_tiny
    #  'size="2"'
    #end
    #def paragraph_font_tiny
    #  %{<font #{set_tiny} #{set_face}>}
    #end
    #def paragraph_font_small
    #  %{<font #{set_small} #{set_face}>}
    #end
    self
  end
  def the_banner
    def home_button_only
      %{<a href="#{url.site}/">
  #{the_png.png_home_button}
  </a>}
    end
    def banner_band
      %{<table summary="home button" width="100%" border="0" cellpadding="3" align="center">
<tr><td align="left" valign="middle">
  <a href="#{url.site}/" target="_top">
    #{the_png.png_home}
  </a>
</td>
<td width="90%">
#{the_table_close}}
    end
    self
  end
end
module SiSU_Proj_XML
  require_relative 'html_parts'                         # html_parts.rb
  require_relative 'se'                                 # se.rb
  include SiSU_Env
  class Bits < SiSU_Proj_HTML::Bits
  end
end
__END__
