# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/se_db.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Info_Db
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'se_info_env'                           # se_info_env.rb
  class InfoDb < SiSU_Info_Env::InfoEnv                    # se_info_env.rb
    @@rc=nil
    def initialize
      @@pwd=@pwd=SiSU_Utils::Path.new.base_markup
      @env=SiSU_Env::InfoEnv.new
      pt=Pathname.new(@pwd)
      r=Px[:lng_lst_rgx]
      u=/.+?\/([^\/]+)(?:\/(?:#{r})$|$)/
      @pwd_stub=pt.realpath.to_s[u,1]
      @rc=@@rc ||=SiSU_Env::GetInit.new.sisu_yaml.rc
      @defaults=SiSU_Env::InfoEnv.new.defaults
    end
    def share_source?
      ((defined? @rc['db']['share_source']) \
      && @rc['db']['share_source']==true) \
      ? @rc['db']['share_source']
      : false
    end
    def engine
      def default
        ((defined? @rc['db']['engine']['default']) \
        && @rc['db']['engine']['default']=~/postgresql|sqlite/) \
        ? @rc['db']['engine']['default']
        : 'sqlite'
      end
      self
    end
    def psql
      def user(opt=nil)
        if opt \
        and opt.selections.str =~/--db-user[=-]["']?(\S+)["']+/
          $1
        elsif opt \
        and opt.selections.str =~/--webserv[=-]webrick/
          @env.user
        else
          ((defined? @rc['db']['postgresql']['user']) \
          && @rc['db']['postgresql']['user']=~/\S+/) \
          ? @rc['db']['postgresql']['user']
          : @env.user
        end
      end
      def db #db_name
        "#{Db[:name_prefix]}#{@pwd_stub}"
      end
      def port #PGPORT
        ((defined? @rc['db']['postgresql']['port']) \
        && ( @rc['db']['postgresql']['port'] =~/\d+/ \
        || @rc['db']['postgresql']['port'].is_a?(Fixnum))) \
        ? @rc['db']['postgresql']['port']
        : (@defaults[:postgresql_port])
      end
      def password
        ((defined? @rc['db']['postgresql']['password']) \
        && @rc['db']['postgresql']['password']=~/\S+/) \
        ? @rc['db']['postgresql']['password']
        : ''
      end
      def host
        ((defined? @rc['db']['postgresql']['host']) \
        && @rc['db']['postgresql']['host']=~/(?:\S{1,3}\.){3}\S{1,3}|\S+?\.\S+/) \
        ? @rc['db']['postgresql']['host']
        : ''
      end
      def dbi
        PG::Connection.open(:dbname =>  psql.db)
      end
      def dbi_
        (psql.host =~/(?:\S{1,3}\.){3}\S{1,3}|\S+?\.\S+/) \
        ? "DBI:Pg:database=#{psql.db};host=#{psql.host};port=#{psql.port}"
        : "DBI:Pg:database=#{psql.db};port=#{psql.port}"
      end
      def conn_dbi
        DBI.connect(psql.dbi,psql.user,psql.db)
      end
      def conn_pg
        begin
          require 'pg'
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            error('pg NOT FOUND (LoadError)')
        end
        PG::Connection.new(dbname: psql.db, port: psql.port)
      end
     self
    end
    def sqlite
      def db
        "#{@env.path.webserv}/#{@pwd_stub}/sisu_sqlite.db"
      end
      def db_discrete(md)
        # "#{@env.path.webserv}/#{@pwd_stub}/sisu_sqlite.db"
      end
      def dbi
        "DBI:SQLite3:#{sqlite.db}" #sqlite3 ?
      end
      def sqlite3
        sqlite.db #sqlite3 ?
      end
      def conn_dbi
        DBI.connect(sqlite.dbi)
      end
      def conn_sqlite3
        SQLite3::Database.new(sqlite.sqlite3)
      end
      self
    end
  end
end
module SiSU_Db_Op
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  class DbOp < SiSU_Info_Db::InfoDb
    def initialize(md)
      begin
        @md=md
      rescue
        SiSU_Screen::Ansi.new(md.opt.selections.str,$!,$@).rescue do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def sqlite_discrete
      def db
        @md.file.output_path.sqlite_discrete.dir \
        + '/' \
        + @md.file.base_filename.sqlite_discrete
      end
      def dbi
        "DBI:SQLite3:#{sqlite_discrete.db}"
      end
      def sqlite3
        sqlite_discrete.db
      end
      def conn_dbi
        DBI.connect(sqlite_discrete.dbi)
      end
      def conn_sqlite3
        begin
          $sqlite3=:yes
          require 'sqlite3'
          SQLite3::Database.new(sqlite_discrete.sqlite3)
        rescue LoadError
          $sqlite3=:no
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
            error('sqlite3 NOT FOUND (LoadError)')
        end
      end
      self
    end
  end
end
__END__
