# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/db_remove.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DbRemove
  class Remove
    include SiSU_DbAction
    def initialize(opt,conn,file,sql_type)
      @opt,@conn,@file,@sql_type=opt,conn,file,sql_type
      @md=SiSU_Param::Parameters.new(@opt).get
      @fnb=@md.fnb
      @db=SiSU_Env::InfoDb.new
    end
    def remove
      driver_sqlite3=if @sql_type==:sqlite
        (@conn.inspect.match(/^(.{10})/)[1]==@db.sqlite.conn_sqlite3.inspect.match(/^(.{10})/)[1]) \
        ? true
        : false
      end
      del_id=if driver_sqlite3
        begin
          remove_selected=%{
            SELECT tid
            FROM metadata_and_text
            WHERE src_filename = '#{@md.fns}'
            AND metadata_and_text.language_document_char = '#{@opt.lng}'
          ;} # note, for .ssm: @md.fns (is set during runtime & is) != @opt.fns @md.opt.fns
          @conn.get_first_value(remove_selected).to_i
        rescue SQLite3::Exception => e
          #not tested
          puts "Exception occurred"
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).mark(e.inspect)
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).mark(
            "\n" \
            + 'Attempting to initialize db' + "\n" \
            + 'Creating db tables'
          )
          sdb={
            create: SiSU_DbDBI::Create.new(@opt,@conn,@file_maint,@sql_type),
            index: SiSU_DbDBI::Index.new(@opt,@conn,@file_maint,@sql_type),
          }
          db_action(sdb).create
        end
      else
        begin
          remove_selected=%{
            SELECT metadata_and_text.tid
            FROM metadata_and_text
            WHERE metadata_and_text.src_filename = '#{@md.fns}'
            AND metadata_and_text.language_document_char = '#{@opt.lng}'
          ;} # note, for .ssm: @md.fns (is set during runtime & is) != @opt.fns @md.opt.fns
          x=@conn.exec(remove_selected)
          x.field_values("tid")[0]
        rescue PG::Error => e
          err=[
            e.result.error_field( PG::Result::PG_DIAG_SEVERITY ),
            e.result.error_field( PG::Result::PG_DIAG_SQLSTATE ),
            e.result.error_field( PG::Result::PG_DIAG_MESSAGE_PRIMARY ),
            e.result.error_field( PG::Result::PG_DIAG_MESSAGE_DETAIL ),
            e.result.error_field( PG::Result::PG_DIAG_MESSAGE_HINT ),
            e.result.error_field( PG::Result::PG_DIAG_STATEMENT_POSITION ),
            e.result.error_field( PG::Result::PG_DIAG_INTERNAL_POSITION ),
            e.result.error_field( PG::Result::PG_DIAG_INTERNAL_QUERY ),
            e.result.error_field( PG::Result::PG_DIAG_CONTEXT ),
            e.result.error_field( PG::Result::PG_DIAG_SOURCE_FILE ),
            e.result.error_field( PG::Result::PG_DIAG_SOURCE_LINE ),
            e.result.error_field( PG::Result::PG_DIAG_SOURCE_FUNCTION ),
          ]
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).mark("\n" + err.inspect)
          if err[2] =~/relation "\S+?" does not exist/ \
          or err.inspect =~/relation "\S+?" does not exist/
            SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).mark(
              "\n" \
              + err[2] + "\n" \
              + 'Attempting to initialize db' + "\n" \
              + 'Creating db tables'
            )
            sdb={
              create: SiSU_DbDBI::Create.new(@opt,@conn,@file_maint,@sql_type),
              index: SiSU_DbDBI::Index.new(@opt,@conn,@file_maint,@sql_type),
            }
            db_action(sdb).create
          end
        end
      end
      if del_id
        sql_entry=[
          "DELETE FROM endnotes WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM endnotes_asterisk WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM endnotes_plus WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM doc_objects WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM urls WHERE metadata_tid = '#{del_id}';",
          "DELETE FROM metadata_and_text WHERE metadata_and_text.tid = '#{del_id}';",
        ]
        if driver_sqlite3
          @conn.transaction
          sql_entry.each do |s|
            begin
              @conn.execute(s)
            rescue
              next
            end
          end
          @conn.commit if driver_sqlite3
        else
          sql_entry.each do |s|
            begin
              @conn.exec_params(s)
            rescue
              next
            end
          end
        end
        if @opt.act[:maintenance][:set]==:on
          @file.puts sql_entry
        end
      else
        if (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            @opt.selections.str,
            "no such file in database #{@db.psql.db}::#{@opt.fns}"
          ).puts_grey
        end
      end
    end
  end
end
__END__
