# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/db_select.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DbAction
  def db_action(sdb)
    @sdb=sdb
    def createdb
      @sdb[:create].output_dir?
      begin
        @sdb[:create].create_db
      rescue
        @sdb[:create].output_dir?
      end
    end
    def drop
      @sdb[:drop].drop.tables
    end
    def create
      @sdb[:create].output_dir?
      begin
        @sdb[:create].create_table.metadata_and_text
        @sdb[:create].create_table.doc_objects
        @sdb[:create].create_table.endnotes
        @sdb[:create].create_table.endnotes_asterisk
        @sdb[:create].create_table.endnotes_plus
        @sdb[:create].create_table.urls
        @sdb[:index].create_indexes
      rescue
        SiSU_Errors::Rescued.new($!,$@,'--sqlite').location
        @sdb[:create].output_dir? do
          __LINE__.to_s + ':' + __FILE__
        end
      end
    end
    def import
      db_exist?
      @sdb[:import].marshal_load
      tell=case @sql_type
      when :sqlite
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "sqlite3 #{@db.sqlite.db} database?"
        )
      when :pg
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "pgaccess or psql #{@db.psql.db} database?"
        )
      else '???'
      end
      tell.puts_grey if @opt.act[:verbose][:set]==:on
    end
    def remove
      db_exist?
      @sdb[:remove_doc].remove
    end
    def update
      remove
      import
    end
    self
  end
end
module SiSU_DbSelect
  class Case
    include SiSU_DbAction
    def initialize(opt,conn='',sql_type=:pg)
      @opt,@conn,@sql_type=opt,conn,sql_type
      @db=SiSU_Env::InfoDb.new
      @file_maint=sql_maintenance_file
      @sdb={
        create: SiSU_DbDBI::Create.new(@opt,@conn,@file_maint,@sql_type),
        index: SiSU_DbDBI::Index.new(@opt,@conn,@file_maint,@sql_type),
        drop: SiSU_DbDBI::Drop.new(@opt,@conn,@db,@sql_type),
      }
      if (@opt.act[:psql_import][:set]==:on \
      || @opt.act[:psql_update][:set]==:on) \
      or (@opt.act[:sqlite_import][:set]==:on \
      || @opt.act[:sqlite_update][:set]==:on)
        @sdb[:import]=SiSU_DbDBI::Import.new(@opt,@conn,@file_maint,@sql_type)
        @sdb[:remove_doc]=SiSU_DbDBI::Remove.new(@opt,@conn,@file_maint,@sql_type)
      elsif (@opt.act[:psql_remove][:set]==:on \
      or @opt.act[:sqlite_remove][:set]==:on)
        @sdb[:remove_doc]=SiSU_DbDBI::Remove.new(@opt,@conn,@file_maint,@sql_type)
      end
    end
    def db_exist?
      if @sql_type==:sqlite \
      and (not (FileTest.file?(@db.sqlite.db)) \
      or FileTest.zero?(@db.sqlite.db))
        puts %{no connection with sqlite database established, you may need to run:\n} \
        + %{    sisu --sqlite --createall\n} \
        + %{  before attempting to populate the database}
        SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).mark(
          "\n" \
          + 'Attempting to initialize db' + "\n" \
          + 'Creating db tables'
        )
        db_action(@sdb).create
      end
      if @conn.is_a?(NilClass)
        if @sql_type==:sqlite
          puts %{no connection with sqlite database established, you may need to run:\n} \
          + %{    sisu --sqlite --createall\n} \
          + %{  before attempting to populate the database}
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).mark(
            "\n" \
            + 'Attempting to initialize db' + "\n" \
            + 'Creating db tables'
          )
          db_action(@sdb).create
          @db.sqlite.db
        else
          puts %{no connection with pg database established, you may need to run:\n} \
          + %{    createdb "#{@db.psql.db}"\n} \
          + %{  after that don't forget to run:\n} \
          + %{    sisu --pg --createall\n} \
          + %{  before attempting to populate the database}
          @db.psql.db
        end
        exit
      end
    end
    def sql_maintenance_file
      file=if @opt.act[:maintenance][:set]==:on
        if @opt.fns and not @opt.fns.empty?
          @env=SiSU_Env::InfoEnv.new(@opt.fns) if @opt.fns
          if @sql_type ==:sqlite
            puts "\n#{@env.processing_path.sqlite}/#{@opt.fns}.sql"
          end
          @db=SiSU_Env::InfoDb.new
          @job="sqlite3 #{@db.sqlite.db} < #{@env.processing_path.sqlite}/#{@opt.fns}.sql"
          if @sql_type ==:sqlite
            File.new("#{@env.processing_path.sqlite}/#{@opt.fns}.sql",'w+')
          else
            File.new("#{@env.processing_path.postgresql}/#{@opt.fns}.sql",'w+')
          end
        elsif @opt.fns \
        and (@opt.act[:sqlite_create][:set] ==:on \
        || @opt.act[:psql_create][:set] ==:on)
          nil #sort variations later
        else nil
        end
      else nil
      end
      file
    end
    def cases
      if @opt.act[:psql_drop][:set] ==:on \
      or @opt.act[:sqlite_drop][:set] ==:on
        db_action(@sdb).drop
      end
      if @opt.act[:psql_createdb][:set] ==:on \
      or @opt.act[:sqlite_createdb][:set] ==:on
        db_action(@sdb).createdb
      end
      if @opt.act[:psql_create][:set] ==:on \
      or @opt.act[:sqlite_create][:set] ==:on
        db_action(@sdb).create
      end
      if @opt.act[:psql_update][:set] ==:on \
      or @opt.act[:sqlite_update][:set] ==:on
        db_action(@sdb).update
      else
        if @opt.act[:psql_remove][:set] ==:on \
        or @opt.act[:sqlite_remove][:set] ==:on
          db_action(@sdb).remove
        end
        if @opt.act[:psql_import][:set] ==:on \
        or @opt.act[:sqlite_import][:set] ==:on
          db_action(@sdb).import
        end
      end
    end
  end
end
__END__
