# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** plaintext decoration

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/txt_markdown_decorate.rb;hb=HEAD]

=end

module SiSU_Decorate_Txt_Markdown
  def decorate
    def heading
      def inline                   #atx
        def l0
          '#'
        end
        def l1
          '##'
        end
        def l2
          '###'
        end
        def l3
          '####'
        end
        def l4
          '#####'
        end
        def l5
          '######'
        end
        self
      end
      def underscore               #Setext
        def l1
          '='
        end
        def l2
          '-'
        end
        def l3
          ''
        end
        def l4
          ''
        end
        def l5
          ''
        end
        def l6
          ''
        end
        self
      end
      self
    end
    def bold
      def open
        '**'
      end
      def close
        '**'
      end
      self
    end
    def italics
      def open
        '*'
      end
      def close
        '*'
      end
      self
    end
    def underscore
      def open
        '_'
      end
      def close
        '_'
      end
      self
    end
   #def emphasis
   #  def open
   #    ''
   #  end
   #  def close
   #    ''
   #  end
   #  self
   #end
    def cite
      def open
        '"'
      end
      def close
        '"'
      end
      self
    end
    def insert
      def open
        '+'
      end
      def close
        '+'
      end
      self
    end
    def strike
      def open
        '-'
      end
      def close
        '-'
      end
      self
    end
    def superscript
      def open
        '^'
      end
      def close
        '^'
      end
      self
    end
    def subscript
      def open
        '['
      end
      def close
        ']'
      end
      self
    end
    def hilite
      def open
        '**'
      end
      def close
        '**'
      end
      self
    end
    def monospace
      def open
        '`'
      end
      def close
        '`'
      end
      self
    end
    self
  end
end
__END__
