/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file implements classes SKGAdvice.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "skgadvice.h"

SKGAdvice::SKGAdvice()
    : QObject()
{
    m_priority = 1;
}

SKGAdvice::SKGAdvice(const SKGAdvice& iAdvice)
    : QObject()
{
    m_priority = iAdvice.m_priority;
    m_shortMessage = iAdvice.m_shortMessage;
    m_longMessage = iAdvice.m_longMessage;
    m_autoCorrections = iAdvice.m_autoCorrections;
    m_uuid = iAdvice.m_uuid;
}

SKGAdvice::~SKGAdvice()
{
}

SKGAdvice& SKGAdvice::operator= (const SKGAdvice& iAdvice)
{
    if (&iAdvice != this) {
        m_priority = iAdvice.m_priority;
        m_shortMessage = iAdvice.m_shortMessage;
        m_longMessage = iAdvice.m_longMessage;
        m_autoCorrections = iAdvice.m_autoCorrections;
        m_uuid = iAdvice.m_uuid;
    }
    return *this;
}

void SKGAdvice::setUUID(const QString& iUUID)
{
    m_uuid = iUUID;
}

QString SKGAdvice::getUUID() const
{
    return m_uuid;
}

void SKGAdvice::setPriority(int iPriority)
{
    m_priority = iPriority;
}

int SKGAdvice::getPriority() const
{
    return m_priority;
}

void SKGAdvice::setShortMessage(const QString& iMessage)
{
    m_shortMessage = iMessage;
}

QString SKGAdvice::getShortMessage() const
{
    return m_shortMessage;
}

void SKGAdvice::setLongMessage(const QString& iMessage)
{
    m_longMessage = iMessage;
}

QString SKGAdvice::getLongMessage() const
{
    return m_longMessage;
}

void SKGAdvice::setAutoCorrections(const QStringList& iCorrections)
{
    m_autoCorrections = iCorrections;
}

QStringList SKGAdvice::getAutoCorrections() const
{
    return m_autoCorrections;
}

#include "skgadvice.moc"
