#include "petscsys.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* setup.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetup_ EPSSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetup_ epssetup
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetoperators_ EPSSETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetoperators_ epssetoperators
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetoperators_ EPSGETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetoperators_ epsgetoperators
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetdeflationspace_ EPSSETDEFLATIONSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetdeflationspace_ epssetdeflationspace
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsremovedeflationspace_ EPSREMOVEDEFLATIONSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsremovedeflationspace_ epsremovedeflationspace
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetinitialspace_ EPSSETINITIALSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetinitialspace_ epssetinitialspace
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetinitialspaceleft_ EPSSETINITIALSPACELEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetinitialspaceleft_ epssetinitialspaceleft
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epssetup_(EPS *eps, int *__ierr ){
*__ierr = EPSSetUp(*eps);
}
void PETSC_STDCALL  epssetoperators_(EPS *eps,Mat A,Mat B, int *__ierr ){
*__ierr = EPSSetOperators(*eps,
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ));
}
void PETSC_STDCALL  epsgetoperators_(EPS *eps,Mat *A,Mat *B, int *__ierr ){
*__ierr = EPSGetOperators(*eps,A,B);
}
void PETSC_STDCALL  epssetdeflationspace_(EPS *eps,PetscInt *n,Vec *ds, int *__ierr ){
*__ierr = EPSSetDeflationSpace(*eps,*n,ds);
}
void PETSC_STDCALL  epsremovedeflationspace_(EPS *eps, int *__ierr ){
*__ierr = EPSRemoveDeflationSpace(*eps);
}
void PETSC_STDCALL  epssetinitialspace_(EPS *eps,PetscInt *n,Vec *is, int *__ierr ){
*__ierr = EPSSetInitialSpace(*eps,*n,is);
}
void PETSC_STDCALL  epssetinitialspaceleft_(EPS *eps,PetscInt *n,Vec *is, int *__ierr ){
*__ierr = EPSSetInitialSpaceLeft(*eps,*n,is);
}
#if defined(__cplusplus)
}
#endif
