from sndobj import SndObj, SndRTIO, HarmTable, Oscili, SND_OUTPUT
from scipy import zeros, pi, sin, float32
from pylab import plot, show
    
# ---------------------------------------------------------------------------
# Test PushIn

# Create 1 frame of a sine wave in a numpy array
sine = zeros(256, dtype=float32)
for i in range(sine.size):
    sine[i] = 0.5 * sin((2 * pi * i) / sine.size)
sine *= 32768

obj = SndObj()
obj.PushIn(sine)

outp = SndRTIO(1, SND_OUTPUT)
outp.SetOutput(1, obj)

# Repeatedly output the 1 frame of sine wave
duration = outp.GetSr() * 2  # 2 seconds
i = 0
vector_size = outp.GetVectorSize()
while i < duration:
    outp.Write()
    i += vector_size

# ---------------------------------------------------------------------------    
# Test PopOut

# copy a sine wave generated by a SndObj into a numpy array
output_size = 2048
harm = HarmTable(10000,1,1)
osc = Oscili(harm, 440, 10000)
output = zeros(output_size, dtype=float32)

duration = output_size  # output_size samples
i = 0
vector_size = osc.GetVectorSize()
while i < duration:
    osc.DoProcess()
    osc.PopOut(output[i:i+vector_size])
    i += vector_size

# plot the array
plot(output)
show()
