-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (ErrorHandler.Conversions.ToString)
procedure NoErr (Err_Num : in     Error_Types.NumericError;
                 E_Str   : in out E_Strings.T) is
begin
   E_Strings.Append_String (E_Str => E_Str,
                            Str   => "Flow analysis of");
   if Err_Num.Name1 = Error_Types.NoName then
      E_Strings.Append_String (E_Str => E_Str,
                               Str   => " package initialization");
   elsif Err_Num.Name1 = Error_Types.ThePartitionName then
      E_Strings.Append_String (E_Str => E_Str,
                               Str   => " the entire partition");
   else
      E_Strings.Append_String (E_Str => E_Str,
                               Str   => " subprogram ");
      Append_Name (E_Str => E_Str,
                   Name  => Err_Num.Name1,
                   Scope => Err_Num.Scope);
   end if;
   E_Strings.Append_String (E_Str => E_Str,
                            Str   => " performed");

   if Err_Num.ErrorNum = ErrorHandler.No_Error_Info_Flow then
      E_Strings.Append_String (E_Str => E_Str,
                               Str   => " (information-flow mode)");
   elsif Err_Num.ErrorNum = ErrorHandler.No_Error_Data_Flow then
      E_Strings.Append_String (E_Str => E_Str,
                               Str   => " (data-flow mode)");
   end if;

   E_Strings.Append_String (E_Str => E_Str,
                            Str   => ": no errors found");
   E_Strings.Append_String (E_Str => E_Str,
                            Str   => ".");
end NoErr;
