-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Platform dependent package supplying low level filing utilities. FindFiles  --
--is separate to prevent cyclic interpackage dependencies                     --
--                                                                            --
--------------------------------------------------------------------------------

with E_Strings;

--# inherit E_Strings,
--#         SPARK_IO;

package OSFiling
--# own File_Structure;
--# initializes File_Structure;
is
   -- Return the filename from the string given, without drive or directory
   -- designation.
   -- Not guaranteed to work correctly if soft links are in the path.
   function Base_Filename (Path : E_Strings.T) return E_Strings.T;

   -- Return the directory from the string given, without drive or full path
   -- designation. If a string such as "." or ".." is given then the actual
   -- directory name is returned.
   -- Not guaranteed to work correctly if soft links are in the path.
   function Base_Dir_Name (Path : E_Strings.T) return E_Strings.T;

   function Default_Report_Extn return  E_Strings.T;

   -- this function combines the inputs to produce the path to the
   -- subdirectory
   function Down_Directory (Path          : E_Strings.T;
                            Sub_Directory : E_Strings.T) return E_Strings.T;

   -- this function combines the inputs to produce a full file name
   function Full_Filename (Path     : E_Strings.T;
                           Filename : E_Strings.T) return E_Strings.T;

   function Get_Working_Directory return  E_Strings.T;
   --# global in File_Structure;

   -- true iff the specified name is a directory
   function Is_Directory (Name : E_Strings.T) return Boolean;
   --# global in File_Structure;

   -- true iff the specified name exists and is not a directory
   function Is_File (Name : E_Strings.T) return Boolean;
   --# global in File_Structure;

   -- return which name comes first in dictionary order
   -- with the quirk that on the VAX, the file [spark]pogs
   -- immediately preceeds the directory [spark.pogs]
   function Order (First_Name, Second_Name : E_Strings.T) return E_Strings.Order_Types;

   -- remove the file extension: on the VAX this includes removing the
   -- file version number, but the reverse scan for a '.' must not go
   -- past the ']' because there are '.'s in dir specifications
   procedure Remove_File_Extension (Filename : in out E_Strings.T);
   --# derives Filename from *;

   -- return the file extension for a simplified VC file
   function Simplified_VC_File_Extension return  E_Strings.T;

   -- return the file extension for a victor results file
   function Victored_VC_File_Extension return  E_Strings.T;

   -- return the file extension for a victor log file
   function Victor_Log_File_Extension return  E_Strings.T;

   -- this function removes the last directory name from the supplied string
   function Dir_Name (Path : E_Strings.T) return E_Strings.T;

   -- return the file extension for a VC file
   function VC_File_Extension return  E_Strings.T;

   -- return the file extension for a Proof Log file
   function Proof_Log_File_Extension return  E_Strings.T;

   -- return the file extension for a Review file
   function Review_File_Extension return  E_Strings.T;

   -- return the file extension for a Simplifier Log file
   function Simplifier_Log_File_Extension return  E_Strings.T;

   -- return the file extension for DPC file
   function DPC_File_Extension return  E_Strings.T;

   function Summary_DP_File_Extension return  E_Strings.T;

   -- return the platform specific directory separator
   function Directory_Separator return Character;

end OSFiling;
