% -----------------------------------------------------------------------------
%  (C) Altran Praxis Limited
% -----------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
% =============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% A HypList-free interface to various predicates such as infer(Formula,
% HypList).  (In the Proof Checker, infer(Formula) does not return a list
% of hypotheses used.  The Simplifier code was derived from the Checker
% code, but with the additional argument in a number of predicates, to aid
% construction of a simplification log recording its reasoning.  The
% HypList-free variants are still used by other bits of legacy code
% inherited from the Checker, however, hence this module.)
%###############################################################################

%###############################################################################
% DEPENDENCIES
%###############################################################################

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

%###############################################################################
% PREDICATES
%###############################################################################

deduce_formula(F, T, Hs) :-
        deduce(F, T, HL),
        sort(HL, Hs),
        !.

%-------------------------------------------------------------------------------

/* infer: interface to the inference engine for the expression simplifier.
   This checks to see if there is already an inference_depth_limit in place,
   and uses it if so, or imposes the default one if not. */
infer(Goal) :-
        inference_depth_limit(main, _), /* it exists */
        !,
        infer_subgoal(Goal, _).

infer(Goal) :-                          /* otherwise */
        infer(Goal, _).

%-------------------------------------------------------------------------------

simplification_is_on :-
        simplification(on),
        !,
        current_vc_number(N),
        !,
        \+ simplification(N, off),
        !.

%-------------------------------------------------------------------------------

standardisation_is_on :-
        standardisation(on),
        !,
        current_vc_number(N),
        !,
        \+ standardisation(N, off),
        !.

%-------------------------------------------------------------------------------

contradiction_hunt_is_on :-
        \+ contradiction_hunt(off),
        !,
        current_vc_number(N),
        !,
        \+ contradiction_hunt(N, off),
        !.

%-------------------------------------------------------------------------------

expression_reduction_is_on :-
        expression_reduction(on),
        !,
        current_vc_number(N),
        !,
        \+ expression_reduction(N, off),
        !.

%-------------------------------------------------------------------------------

substitution_elimination_is_on :-
        substitution_elimination(on),
        !,
        current_vc_number(N),
        !,
        \+ substitution_elimination(N, off),
        !.

%-------------------------------------------------------------------------------

rule_substitution_is_on :-
        rule_substitution(on),
        !,
        current_vc_number(N),
        !,
        \+ rule_substitution(N, off),
        !.

%###############################################################################
% END-OF-FILE
