-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
function Is_Enclosing_Package (Outer_Pack : Dictionary.Symbol;
                               Scope      : Dictionary.Scopes) return Boolean is
   Scope_Chain, Outer_Scope : Dictionary.Scopes;
   Result                   : Boolean;
begin
   if Outer_Pack = Dictionary.GetRegion (Scope) then
      Result := True;
   else
      Result      := False;
      Outer_Scope := Dictionary.Set_Visibility (The_Visibility => Dictionary.Local,
                                                The_Unit       => Outer_Pack);
      Scope_Chain := Scope;
      while not Dictionary.IsGlobalScope (Scope_Chain) loop
         Scope_Chain := Dictionary.GetEnclosingScope (Scope_Chain);
         if Scope_Chain = Outer_Scope then
            Result := True;
            exit;
         end if;
      end loop;
   end if;
   return Result;
end Is_Enclosing_Package;
