% -----------------------------------------------------------------------------
%  (C) Altran Praxis Limited
% -----------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
% =============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% It is possible to change the meaning of sicstus source code, by changing
% global properties, such as operator precedence or prolog settings.
%
% The sicstus library modules are typically available in both source
% code and pre-compiled units. Thus, in a standard sicstus install, the
% source code of library modules should not affect their behaviour, as the
% pre-compiled units will always take precedence.
%
% Thus, it is possible to load a library in a context where it should not
% work (due to bad global settings) but it actually does work (because the
% code is ignored due to a pre-compiled unit taking precedence). This
% behaviour is subtle and confusing.
%
% To mitigate against this subtle and confusing behaviour all library
% modules are deliberately declared up front, before changing any global
% settings. The intention is that, should the pre-compiled units be deleted
% for some reason, the system should build correctly.
%
% Note that the spxref code analysis tool only considers the source code of
% library modules. However, spxref must be executed with a fixed set of
% global settings. Thus, spxref must either consider the library modules
% with the wrong settings (as is done just now), or the whole system code
% with the wrong settings.
%###############################################################################

:- module(librarypredicates, [%file_systems.
                              close_all_streams/0,
                              file_exists/1,
                              rename_file/2,
			      
                              %lists.
                              last/2,
                              list_to_set/2,
                              reverse/2,

                              %process.
                              process_create/3,
                              process_wait/2,

                              %system.
                              datime/1]).

%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module(library(file_systems)).
:- use_module(library(lists)).
:- use_module(library(process)).
:- use_module(library(system)).


%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

%###############################################################################
% PREDICATES
%###############################################################################

%###############################################################################
% END-OF-FILE
